/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.propEditors;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import oracle.ldap.admin.client.AdminUtil;
import oracle.ldap.admin.client.common.AdminCheckboxGroup;
import oracle.ldap.admin.client.common.AdminLabel;
import oracle.ldap.admin.client.common.AdminPanel;
import oracle.ldap.admin.client.common.AdminRadioButton;
import oracle.ldap.admin.client.propEditors.IEditor;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.ClientLang;
import oracle.ldap.admin.common.IAdminProp;

class QueryResults
extends AdminPanel
implements IEditor,
ItemListener {
    String TABLE = ClientLang.getStrTable();
    String TREE = ClientLang.getStrTree();
    AdminCheckboxGroup m_checkGroup;
    AdminRadioButton m_viewTable;
    AdminRadioButton m_viewTree;
    CardLayout m_cardLayout;
    AdminPanel m_radioPanel;
    AdminPanel m_cardPanel;
    IEditor m_editor1;
    IEditor m_editor2;
    int m_level;

    public QueryResults(Component component, Component component2) {
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.m_radioPanel = new AdminPanel();
        ((Container)((Object)this.m_radioPanel)).setLayout(new FlowLayout(0));
        ((Container)((Object)this.m_radioPanel)).add((Component)((Object)new AdminLabel(ClientLang.getStrViewResultsAs())));
        this.m_checkGroup = new AdminCheckboxGroup();
        this.m_viewTable = new AdminRadioButton(ClientLang.getStrTable(), this.m_checkGroup, true);
        ((Container)((Object)this.m_radioPanel)).add((Component)((Object)this.m_viewTable));
        this.m_viewTree = new AdminRadioButton(ClientLang.getStrTree(), this.m_checkGroup, false);
        ((Container)((Object)this.m_radioPanel)).add((Component)((Object)this.m_viewTree));
        this.m_viewTable.addItemListener(this);
        this.m_viewTree.addItemListener(this);
        ((Container)((Object)this)).add("North", (Component)((Object)this.m_radioPanel));
        this.m_cardPanel = new AdminPanel();
        this.m_cardLayout = new CardLayout();
        ((Container)((Object)this.m_cardPanel)).setLayout(this.m_cardLayout);
        ((Container)((Object)this)).add("Center", (Component)((Object)this.m_cardPanel));
        ((Container)((Object)this.m_cardPanel)).add(this.TABLE, component);
        ((Container)((Object)this.m_cardPanel)).add(this.TREE, component2);
        this.m_editor1 = (IEditor)((Object)AdminUtil.removeScrollBox(component));
        this.m_editor2 = (IEditor)((Object)AdminUtil.removeScrollBox(component2));
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.m_checkGroup.getSelectedCheckbox() == this.m_viewTable) {
            this.m_cardLayout.show((Container)((Object)this.m_cardPanel), this.TABLE);
            this.m_editor1.setupToolbar(this.m_level);
            return;
        }
        this.m_cardLayout.show((Container)((Object)this.m_cardPanel), this.TREE);
        this.m_editor2.setupToolbar(this.m_level);
    }

    public boolean displayObject(Object object) {
        return this.getObject() == object;
    }

    public Object getHelpObject() {
        return this.getObject();
    }

    public Object getObject() {
        if (this.m_checkGroup.getSelectedCheckbox() == this.m_viewTable) {
            return this.m_editor1.getObject();
        }
        return this.m_editor2.getObject();
    }

    public boolean setObject(Object object) {
        return false;
    }

    public int getEditorType() {
        return 256;
    }

    public void setupToolbar(int n) {
        this.m_level = n;
        if (this.m_checkGroup.getSelectedCheckbox() == this.m_viewTable) {
            this.m_editor1.setupToolbar(this.m_level);
            return;
        }
        this.m_editor2.setupToolbar(this.m_level);
    }

    public boolean isModified(StringBuffer stringBuffer) {
        return this.m_editor1.isModified(stringBuffer) || this.m_editor2.isModified(stringBuffer);
    }

    public void revert() {
        try {
            this.m_editor1.revert();
            this.m_editor2.revert();
            return;
        }
        catch (Exception exception) {
            AdminProp.sUnexpectedException(exception);
            return;
        }
    }

    public boolean commit() {
        try {
            return this.m_editor1.commit() && this.m_editor2.commit();
        }
        catch (Exception exception) {
            AdminProp.sUnexpectedException(exception);
            return true;
        }
    }

    public void update() {
        try {
            this.m_editor1.update();
            this.m_editor2.update();
            return;
        }
        catch (Exception exception) {
            AdminProp.sUnexpectedException(exception);
            return;
        }
    }

    public void shutdown() {
        try {
            this.m_editor1.shutdown();
            this.m_editor2.shutdown();
            return;
        }
        catch (Exception exception) {
            AdminProp.sUnexpectedException(exception);
            return;
        }
    }

    public IAdminProp[] getCommandList() {
        try {
            IAdminProp[] iAdminPropArray = this.m_editor1.getCommandList();
            IAdminProp[] iAdminPropArray2 = this.m_editor2.getCommandList();
            return AdminUtil.mergeCmdList(iAdminPropArray, iAdminPropArray2);
        }
        catch (Exception exception) {
            AdminProp.sUnexpectedException(exception);
            return null;
        }
    }

    public IAdminProp properties() {
        return null;
    }
}

