/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.propEditors;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.ImageObserver;
import oracle.ldap.admin.client.propEditors.GraphNode;
import oracle.ldap.admin.client.propEditors.Rubberband;
import oracle.ldap.admin.client.propEditors.Shape;

class ShapeImage
implements Shape {
    int x;
    int y;
    int w;
    int h;
    Rubberband m_band;
    Image m_image;
    GraphNode m_parent;

    public ShapeImage(boolean bl, Rubberband rubberband, Image image, GraphNode graphNode) {
        this.m_parent = graphNode;
        this.m_band = rubberband;
        this.m_image = image;
    }

    public void paint(Graphics graphics) {
        this.initDimension();
        if (this.m_image != null) {
            graphics.drawImage(this.m_image, this.x, this.y, this.w, this.h, (ImageObserver)((Object)this.m_parent.getCanvas()));
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return true;
    }

    public Image getImage() {
        return this.m_image;
    }

    public Point getOrigin() {
        return new Point(this.x, this.y);
    }

    public void setOrigin(Point point) {
        this.x = point.x;
        this.y = point.y;
    }

    public void setOrigin(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public void setDimension(Dimension dimension) {
        this.setDimension(dimension.width, dimension.height);
    }

    public void setDimension(int n, int n2) {
        if (this.m_image == null) {
            this.h = n2;
            this.w = n;
            return;
        }
        this.h = this.m_image.getHeight((ImageObserver)((Object)this.m_parent.getCanvas()));
        this.w = this.m_image.getWidth((ImageObserver)((Object)this.m_parent.getCanvas()));
    }

    public void initDimension() {
        if ((this.w == 0 || this.h == 0) && this.m_image != null) {
            this.h = this.m_image.getHeight((ImageObserver)((Object)this.m_parent.getCanvas()));
            this.w = this.m_image.getWidth((ImageObserver)((Object)this.m_parent.getCanvas()));
        }
    }

    public Dimension getDimension() {
        this.initDimension();
        return new Dimension(this.w, this.h);
    }

    public boolean isMouseOn(int n, int n2) {
        this.initDimension();
        return this.x <= n && n <= this.x + this.w && this.y <= n2 && n2 <= this.y + this.h;
    }

    public boolean isDraggable() {
        return true;
    }

    public void drawLast(Graphics graphics) {
        Point point = this.m_band.lastBounds();
        this.initDimension();
        graphics.drawRect(point.x, point.y, this.w, this.h);
    }

    public void drawNext(Graphics graphics) {
        Point point = this.m_band.bounds();
        this.initDimension();
        graphics.drawRect(point.x, point.y, this.w, this.h);
    }
}

