/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.propEditors;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import oracle.ldap.admin.client.AdminUtil;
import oracle.ldap.admin.client.ErrorAlert;
import oracle.ldap.admin.client.common.AdminOneDDataSource;
import oracle.ldap.admin.client.propEditors.Table;
import oracle.ldap.admin.common.AdminPropertyChangeEvent;
import oracle.ldap.admin.common.AdminPropertyChangeListener;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;

class TableCols
extends AdminOneDDataSource
implements AdminPropertyChangeListener {
    IAdminProp m_ap;
    Table m_parent;
    String[] m_columns;
    int m_itemCount = 1;
    boolean m_gotColumnCount = false;
    int m_columnCount;

    public TableCols(IAdminProp iAdminProp) {
        this.m_ap = iAdminProp;
        AdminUtil.addAdminPropertyChangeListener(this.m_ap, this);
    }

    public void setItemPainters() {
        String[] stringArray = this.getColumns();
        if (stringArray == null || this.m_parent == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            Image image;
            if (stringArray[n] != null && stringArray[n].startsWith("images/") && (image = AdminUtil.loadImage(stringArray[n], (Component)((Object)this.m_parent))) != null) {
                this.m_parent.setColumnImagePainter(n + 1);
            }
            ++n;
        }
    }

    public void setParent(Table table) {
        this.m_parent = table;
        this.setItemPainters();
    }

    public void shutdown() {
        AdminUtil.removeAdminPropertyChangeListener(this.m_ap, this);
    }

    public void adminPropertyChange(AdminPropertyChangeEvent adminPropertyChangeEvent) {
        while (true) {
            if (adminPropertyChangeEvent.getSource() == this.m_ap) {
                this.m_gotColumnCount = false;
            }
            if (!adminPropertyChangeEvent.hasMoreElements()) {
                return;
            }
            adminPropertyChangeEvent = (AdminPropertyChangeEvent)adminPropertyChangeEvent.nextElement();
        }
    }

    String[] getColumns() {
        block3: {
            if (this.m_columns != null) break block3;
            try {
                this.m_columns = (String[])this.m_ap.getProp(0x10110021);
                if (this.m_columns != null) {
                    this.setItemPainters();
                    this.m_itemCount = this.m_columns.length;
                }
            }
            catch (PropertyException propertyException) {
                this.unexpectedException(propertyException);
            }
        }
        return this.m_columns;
    }

    public String[] getItemNames() {
        return this.getColumns();
    }

    public String getDataString(int n) {
        String[] stringArray = this.getColumns();
        if (n == 0) {
            return " ";
        }
        if (stringArray == null || --n >= stringArray.length || stringArray[n] == null) {
            return "No Column Data";
        }
        return stringArray[n];
    }

    public Object getData(int n) {
        Image image;
        String[] stringArray = this.getColumns();
        if (n == 0) {
            return " ";
        }
        if (stringArray == null || --n >= stringArray.length || stringArray[n] == null) {
            return "No Column Data";
        }
        if (stringArray[n].startsWith("images/") && (image = AdminUtil.loadImage(stringArray[n], (Component)((Object)this.m_parent))) != null) {
            return image;
        }
        return stringArray[n];
    }

    public void setData(int n, Object object) {
    }

    public int getItemCount() {
        if (!this.m_gotColumnCount) {
            try {
                Integer n = (Integer)this.m_ap.getProp(2686995);
                if (n == null) {
                    return 1;
                }
                this.m_gotColumnCount = true;
                this.m_columnCount = n;
                return this.m_columnCount + 1;
            }
            catch (PropertyException propertyException) {
                this.unexpectedException(propertyException);
            }
        }
        return this.m_columnCount + 1;
    }

    void unexpectedException(Exception exception) {
        new ErrorAlert((Frame)((Object)AdminUtil.getNavigator()), exception);
    }

    void reset() {
        this.m_columns = null;
        this.m_gotColumnCount = false;
        this.m_columnCount = 0;
        this.getItemCount();
    }
}

