/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.propEditors;

import java.text.DateFormat;
import java.util.Date;
import oracle.ldap.admin.client.propEditors.Table;
import oracle.ldap.admin.client.propEditors.TableCols;
import oracle.ldap.admin.client.propEditors.TableData;
import oracle.ldap.admin.client.propEditors.TableRows;
import oracle.ldap.admin.common.AdminDirectory;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.ClientLang;
import oracle.ldap.admin.common.CommandProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

class TableConfigFind
extends AdminDirectory {
    static final int CONTAINS = 1;
    static final int BEGINSWITH = 2;
    static final int ENDSWITH = 3;
    static final int EXACTMATCH = 4;
    static final int GREATEROREQUAL = 5;
    static final int LESSOREQUAL = 6;
    static final int PRESENT = 7;
    static final int APPROXMATCH = 8;
    static String[] SEARCH_OP_NAMES = new String[]{ClientLang.getStrBeginsWith(), ClientLang.getStrEndsWith(), ClientLang.getStrContains(), ClientLang.getStrExactMatch(), ClientLang.getStrGreaterOrEqual(), ClientLang.getStrLessOrEqual(), ClientLang.getStrNotNull()};
    static int[] SEARCH_OP_IDS = new int[]{2, 3, 1, 4, 5, 6, 7};
    String[] m_propNames;
    Object m_criteria;
    int[] m_props;
    Table m_table;
    TableData m_data;
    TableCols m_cols;
    TableRows m_rows;
    IAdminProp m_ap;

    public TableConfigFind(IAdminProp iAdminProp, Table table, TableData tableData, TableCols tableCols) {
        super(iAdminProp, "", SEARCH_OP_NAMES[0]);
        this.m_ap = iAdminProp;
        this.m_data = tableData;
        this.m_cols = tableCols;
        this.m_table = table;
        this.m_props = this.m_data.getColumns();
        this.m_propNames = this.m_cols.getColumns();
    }

    public void registerMessages() {
        super.registerMessages();
        this.unregisterProp(1061129);
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 1048745: {
                return this.m_ap.getProp(1639586);
            }
            case 1049370: {
                return this.m_ap.getProp(1639587);
            }
            case 0x110001: {
                return this.m_ap.getProp(n);
            }
            case 2031768: {
                return "Find";
            }
            case 282001424: {
                return this.m_props;
            }
            case 0x10110021: {
                return this.m_propNames;
            }
            case 2686995: {
                return new Integer(this.m_props.length);
            }
            case 270468175: {
                return this.m_propNames;
            }
            case 270468192: {
                return SEARCH_OP_NAMES;
            }
            case 276759696: {
                return TableConfigFind.getCriteriaAttrTypes(this.m_props);
            }
            case 273220108: {
                return this.m_ap.getProp(n);
            }
            case 2162725: {
                Integer n2 = (Integer)this.m_ap.getProp(n);
                if (n2 == null) break;
                return new Integer((int)(n2 & 0xFFFDFFFF));
            }
            case 8324195: {
                return this.m_criteria;
            }
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        switch (n) {
            case 8324195: {
                this.m_criteria = object;
                break;
            }
        }
        super.setProp(n, object);
    }

    public void saveChanges(int n) throws SaveChangeException {
        if (n != 0) {
            try {
                this.getSearchResults();
                return;
            }
            catch (Exception exception) {
                throw new SaveChangeException(exception);
            }
        }
        super.saveChanges(0);
    }

    public IAdminProp getSearchResults(IAdminProp iAdminProp) throws PropertyException {
        ((CommandProp)iAdminProp).sendAdminPropertyChangeEvents(0x1F000F, null);
        try {
            this.getSearchResults();
        }
        catch (PropertyException propertyException) {}
        ((CommandProp)iAdminProp).sendAdminPropertyChangeEvents(0x1F000F, "finish");
        return null;
    }

    public IAdminProp getSearchResults() throws PropertyException {
        Object[] objectArray = this.m_data.getRows();
        this.removeAllChildren();
        int n = 0;
        while (n < objectArray.length) {
            if (this.match(this.m_criteria, (IAdminProp)objectArray[n])) {
                super.addChild((IAdminProp)objectArray[n]);
            }
            ++n;
        }
        this.update();
        return null;
    }

    public boolean getUseCriteria() {
        return true;
    }

    public boolean match(int n, Object object, String string, int n2) {
        if (AdminProp.isPropArray(n2)) {
            if (object instanceof int[]) {
                int[] nArray = (int[])object;
                int n3 = 0;
                while (n3 < nArray.length) {
                    if (this.match(n, new Integer(nArray[n3]), string, 0x200000)) {
                        return true;
                    }
                    ++n3;
                }
            } else if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                int n4 = 0;
                while (n4 < objectArray.length) {
                    if (objectArray[n4] != null && this.match(n, objectArray[n4], string, n2 & 0xEFFFFFFF)) {
                        return true;
                    }
                    ++n4;
                }
            }
            return false;
        }
        String string2 = object == null ? "" : object.toString();
        switch (n2) {
            case 0xE00000: {
                Long l = (Long)object;
                if (l == null) {
                    return n != 7;
                }
                Long l2 = new Long(0L);
                try {
                    l2 = Long.valueOf(string);
                }
                catch (Exception exception) {}
                switch (n) {
                    case 4: {
                        return l.equals(l2);
                    }
                    case 2: {
                        return string2.startsWith(string);
                    }
                    case 3: {
                        return string2.endsWith(string);
                    }
                    case 7: {
                        return object != null;
                    }
                    case 1: {
                        return string2.toLowerCase().indexOf(string.toLowerCase()) >= 0;
                    }
                    case 5: {
                        return l >= l2;
                    }
                    case 6: {
                        return l <= l2;
                    }
                    case 8: {
                        return true;
                    }
                }
                return true;
            }
            case 0x200000: {
                Integer n5 = (Integer)object;
                if (n5 == null) {
                    return n != 7;
                }
                Integer n6 = new Integer(0);
                try {
                    n6 = Integer.valueOf(string);
                }
                catch (Exception exception) {}
                switch (n) {
                    case 4: {
                        return n5.equals(n6);
                    }
                    case 2: {
                        return string2.startsWith(string);
                    }
                    case 3: {
                        return string2.endsWith(string);
                    }
                    case 7: {
                        return object != null;
                    }
                    case 1: {
                        return string2.toLowerCase().indexOf(string.toLowerCase()) >= 0;
                    }
                    case 5: {
                        return n5 >= n6;
                    }
                    case 6: {
                        return n5 <= n6;
                    }
                    case 8: {
                        return true;
                    }
                }
                return true;
            }
            case 0x300000: {
                Date date = (Date)object;
                if (date == null) {
                    return n != 7;
                }
                Date date2 = null;
                try {
                    date2 = DateFormat.getDateTimeInstance().parse(string);
                }
                catch (Exception exception) {
                    return true;
                }
                switch (n) {
                    case 4: {
                        return date.equals(date2);
                    }
                    case 2: {
                        return string2.startsWith(string);
                    }
                    case 3: {
                        return string2.endsWith(string);
                    }
                    case 7: {
                        return object != null;
                    }
                    case 1: {
                        return string2.toLowerCase().indexOf(string.toLowerCase()) >= 0;
                    }
                    case 5: {
                        return date.after(date2) || date.equals(date2);
                    }
                    case 6: {
                        return date.before(date2) || date.equals(date2);
                    }
                    case 8: {
                        return true;
                    }
                }
                return true;
            }
        }
        if (string2 == null) {
            string2 = "";
        }
        switch (n) {
            case 4: {
                return string.equalsIgnoreCase(string2);
            }
            case 2: {
                return string2.toLowerCase().startsWith(string.toLowerCase());
            }
            case 3: {
                return string2.toLowerCase().endsWith(string.toLowerCase());
            }
            case 7: {
                return string2.length() > 0;
            }
            case 1: {
                return string2.toLowerCase().indexOf(string.toLowerCase()) >= 0;
            }
            case 5: {
                return string2.toLowerCase().compareTo(string.toLowerCase()) >= 0;
            }
            case 6: {
                return string2.toLowerCase().compareTo(string.toLowerCase()) <= 0;
            }
            case 8: {
                return true;
            }
        }
        return true;
    }

    public boolean match(Object object, IAdminProp iAdminProp) {
        String string = (String)AdminDirectory.criteriaGetOperator(object);
        if (string.startsWith("&")) {
            int n = AdminDirectory.criteriaGetArity(object);
            int n2 = 0;
            while (n2 < n) {
                if (!this.match(AdminDirectory.criteriaGetOperand(object, n2), iAdminProp)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        if (string.startsWith("|")) {
            int n = AdminDirectory.criteriaGetArity(object);
            int n3 = 0;
            while (n3 < n) {
                if (this.match(AdminDirectory.criteriaGetOperand(object, n3), iAdminProp)) {
                    return true;
                }
                ++n3;
            }
            return false;
        }
        if (string.startsWith("!")) {
            return !this.match(AdminDirectory.criteriaGetOperand(object, 0), iAdminProp);
        }
        int n = 0;
        int n4 = 0;
        while (n4 < SEARCH_OP_NAMES.length) {
            if (string.equalsIgnoreCase(SEARCH_OP_NAMES[n4])) {
                n = SEARCH_OP_IDS[n4];
                break;
            }
            ++n4;
        }
        if (n == 0) {
            return true;
        }
        String string2 = (String)AdminDirectory.criteriaGetOperand(object, 0);
        int n5 = 0;
        int n6 = 0;
        while (n6 < this.m_propNames.length) {
            if (string2.equalsIgnoreCase(this.m_propNames[n6])) {
                n5 = this.m_props[n6];
                break;
            }
            ++n6;
        }
        if (n5 == 0) {
            return true;
        }
        String string3 = (String)AdminDirectory.criteriaGetOperand(object, 1);
        Object object2 = null;
        try {
            object2 = iAdminProp.getProp(n5);
        }
        catch (Exception exception) {
            return true;
        }
        return this.match(n, object2, string3, AdminProp.getPropType(n5));
    }

    public static Object[] getCriteriaAttrTypes(int[] nArray) {
        Object[] objectArray = new Object[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            switch (AdminProp.getPropType(nArray[n])) {
                case 0x300000: 
                case 0x900000: {
                    objectArray[n] = AdminProp.class$java$util$Date != null ? AdminProp.class$java$util$Date : TableConfigFind.class$("java.util.Date");
                    break;
                }
                case 0x200000: 
                case 0xE00000: {
                    objectArray[n] = AdminProp.class$java$lang$Integer != null ? AdminProp.class$java$lang$Integer : TableConfigFind.class$("java.lang.Integer");
                    break;
                }
                default: {
                    objectArray[n] = AdminProp.class$java$lang$String != null ? AdminProp.class$java$lang$String : TableConfigFind.class$("java.lang.String");
                    break;
                }
            }
            ++n;
        }
        return objectArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

