/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.common;

import corbaException.ProxyPropertyException;
import java.util.Hashtable;
import oracle.ldap.admin.common.IProxy;
import oracle.ldap.admin.common.ProxyCacheStatistics;
import oracle.ldap.admin.common.ProxyLog;

class AdminClassCache {
    private String m_className;
    private Hashtable hPropNameTable = new Hashtable();
    private Hashtable hPropDescpTable = new Hashtable();
    private Hashtable hPropValueTable = new Hashtable();

    public AdminClassCache(String string) {
        this.m_className = string;
    }

    public boolean isTheCache(String string) {
        return this.m_className.equalsIgnoreCase(string);
    }

    public String getPropName(IProxy iProxy, int n, ProxyLog proxyLog, ProxyCacheStatistics proxyCacheStatistics, int n2) {
        Integer n3 = new Integer(n);
        if (n2 == 0 || (n2 & 8) == 0) {
            proxyLog.put(2, "AdminClassCache::getPropName: cacheLevel=" + Integer.toHexString(n2) + "iPropId = " + Integer.toHexString(n));
            proxyCacheStatistics.addNumGetPropName();
            return iProxy.getPropName(n);
        }
        if (this.hPropNameTable.containsKey(n3)) {
            proxyLog.put(2, "CLASS PROP NAME CACHE: found in cache : iPropId = " + Integer.toHexString(n));
            proxyCacheStatistics.addNumCacheClassPropName();
            return (String)this.hPropNameTable.get(n3);
        }
        proxyLog.put(2, "CLASS PROP NAME CACHE: put a new item to cache : iPropId = " + Integer.toHexString(n));
        proxyCacheStatistics.addNumGetPropName();
        String string = iProxy.getPropName(n);
        this.hPropNameTable.put(n3, string);
        return string;
    }

    public String[] getPropNames(IProxy iProxy, int[] nArray, ProxyLog proxyLog, ProxyCacheStatistics proxyCacheStatistics, int n) {
        if (n == 0 || (n & 8) == 0) {
            proxyLog.put(2, "AdminClassCache::getPropNames: cacheLevel=" + Integer.toHexString(n));
            proxyCacheStatistics.addNumGetPropName();
            return iProxy.getPropNames(nArray);
        }
        String[] stringArray = new String[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            stringArray[n2] = this.getPropName(iProxy, nArray[n2], proxyLog, proxyCacheStatistics, n);
            ++n2;
        }
        return stringArray;
    }

    public String getPropDescription(IProxy iProxy, int n, ProxyLog proxyLog, ProxyCacheStatistics proxyCacheStatistics, int n2) {
        Integer n3 = new Integer(n);
        if (n2 == 0 || (n2 & 8) == 0) {
            proxyLog.put(2, "CLASS PROP DESCRIPTION CACHE: iPropId = " + Integer.toHexString(n));
            proxyCacheStatistics.addNumGetPropDescp();
            return iProxy.getPropDescription(n);
        }
        if (this.hPropDescpTable.containsKey(n3)) {
            proxyLog.put(2, "CLASS PROP DESCRIPTION CACHE: found in cache : iPropId = " + Integer.toHexString(n));
            proxyCacheStatistics.addNumCacheClassPropDescp();
            return (String)this.hPropDescpTable.get(n3);
        }
        proxyLog.put(2, "CLASS PROP DESCRIPTION CACHE: put a new item to cache : iPropId = " + Integer.toHexString(n));
        proxyCacheStatistics.addNumGetPropDescp();
        String string = iProxy.getPropDescription(n);
        this.hPropDescpTable.put(n3, string);
        return string;
    }

    public String[] getPropDescriptions(IProxy iProxy, int[] nArray, ProxyLog proxyLog, ProxyCacheStatistics proxyCacheStatistics, int n) {
        if (n == 0 || (n & 8) == 0) {
            proxyLog.put(2, "AdminClassCache::getPropDescriptions: cacheLevel=" + Integer.toHexString(n));
            proxyCacheStatistics.addNumGetPropDescp();
            return iProxy.getPropDescriptions(nArray);
        }
        String[] stringArray = new String[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            stringArray[n2] = this.getPropDescription(iProxy, nArray[n2], proxyLog, proxyCacheStatistics, n);
            ++n2;
        }
        return stringArray;
    }

    public Object getProp(IProxy iProxy, int n, ProxyLog proxyLog, ProxyCacheStatistics proxyCacheStatistics, int n2) throws ProxyPropertyException {
        Integer n3 = new Integer(n);
        if (n2 == 0 || (n2 & 0x10) == 0) {
            proxyLog.put(2, "CLASS PROP VALUE CACHE: access server proxy : iPropId=" + Integer.toHexString(n));
            proxyCacheStatistics.addNumGetProp();
            return iProxy.getObjectProp(n);
        }
        if (this.hPropValueTable.containsKey(n3)) {
            proxyLog.put(2, "CLASS PROP VALUE CACHE: found in cache");
            proxyCacheStatistics.addNumCacheClassPropVal();
            return this.hPropValueTable.get(n3);
        }
        proxyLog.put(2, "CLASS PROP VALUE CACHE: access server proxy : iPropId" + Integer.toHexString(n));
        proxyCacheStatistics.addNumGetProp();
        Object object = iProxy.getObjectProp(n);
        this.hPropValueTable.put(n3, object);
        return object;
    }

    public void clearAll() {
        this.hPropNameTable.clear();
        this.hPropDescpTable.clear();
        this.hPropValueTable.clear();
    }
}

