/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.common;

import java.io.Serializable;
import java.util.Vector;
import oracle.ldap.admin.common.AdminListSampleChild;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;

public class AdminList
extends AdminProp
implements Serializable {
    public String m_displayName;
    public int m_displayNameProp;
    public Vector m_children;
    public IAdminProp[] m_childrenArr;
    public IAdminProp m_parent;
    public static IAdminProp m_defaultSampleChild = new AdminListSampleChild();
    public IAdminProp m_sampleChild;
    public IAdminProp[] m_cmdList;
    public String m_iconName;
    static final int PR_SAMPLE_CHILD = 0x403000;

    public AdminList() {
    }

    public AdminList(IAdminProp iAdminProp) {
        this.setParent(iAdminProp);
    }

    public AdminList(IAdminProp iAdminProp, Vector vector) {
        this(iAdminProp);
        this.m_children = vector;
    }

    public AdminList(Vector vector) {
        this.m_children = vector;
    }

    public AdminList(IAdminProp[] iAdminPropArray) {
        this.m_childrenArr = iAdminPropArray;
    }

    public AdminList(IAdminProp iAdminProp, IAdminProp[] iAdminPropArray) {
        this(iAdminProp);
        this.m_childrenArr = iAdminPropArray;
    }

    public AdminList(IAdminProp iAdminProp, String string, Vector vector) {
        this(iAdminProp, vector);
        this.setDisplayName(string);
    }

    public AdminList(IAdminProp iAdminProp, String string, Vector vector, IAdminProp iAdminProp2) {
        this(iAdminProp, string, vector);
        this.m_sampleChild = iAdminProp2;
    }

    public AdminList(IAdminProp iAdminProp, String string, Vector vector, IAdminProp iAdminProp2, IAdminProp[] iAdminPropArray) {
        this(iAdminProp, string, vector, iAdminProp2);
        this.m_cmdList = iAdminPropArray;
    }

    public void setIconName(String string) {
        this.m_iconName = string;
    }

    public void setSampleChild(IAdminProp iAdminProp) {
        this.m_sampleChild = iAdminProp;
    }

    public void setSampleChild() {
        this.m_sampleChild = m_defaultSampleChild;
    }

    public IAdminProp getSampleChild() {
        return this.m_sampleChild;
    }

    public void setCommandList(IAdminProp[] iAdminPropArray) {
        this.m_cmdList = iAdminPropArray;
    }

    public void setDisplayNameProp(int n) {
        this.m_displayNameProp = n;
    }

    public void setDisplayName(String string) {
        this.m_displayName = string;
    }

    public IAdminProp getParent() {
        return this.m_parent;
    }

    public void setParent(IAdminProp iAdminProp) {
        this.m_parent = iAdminProp;
    }

    public Vector getChildren() {
        return this.m_children;
    }

    public void setChildren(Vector vector) {
        this.m_children = vector;
        this.update();
    }

    public void setChildren(IAdminProp[] iAdminPropArray) {
        this.m_childrenArr = iAdminPropArray;
        this.update();
    }

    public int countChildren() {
        if (this.m_childrenArr != null) {
            return this.m_childrenArr.length;
        }
        if (this.m_children == null) {
            return 0;
        }
        return this.m_children.size();
    }

    public void addChild(Object object) {
        if (this.m_children == null) {
            this.m_children = new Vector();
        }
        this.m_children.addElement(object);
    }

    public boolean existChild(Object object) {
        return AdminProp.vectorContains(this.m_children, object);
    }

    public void addChildUnique(Object object) {
        if (this.m_children == null) {
            this.m_children = new Vector();
        }
        if (!AdminProp.vectorContains(this.m_children, object)) {
            this.m_children.addElement(object);
        }
    }

    public Object nthChild(int n) {
        if (this.m_children == null) {
            this.m_children = new Vector();
        }
        if (n >= this.m_children.size()) {
            return null;
        }
        return this.m_children.elementAt(n);
    }

    public void addChildSorted(IAdminProp iAdminProp) {
        if (this.m_children == null) {
            this.m_children = new Vector();
        }
        AdminProp.addSorted(this.m_children, iAdminProp);
    }

    public void update() {
        this.sendAdminPropertyChangeEvents(273612805, this.m_children);
        this.sendAdminPropertyChangeEvents(273219601, this.m_children);
    }

    public void removeChild(Object object) {
        if (this.m_children == null) {
            return;
        }
        this.m_children.removeElement(object);
        this.update();
    }

    public void removeAllChildren() {
        if (this.m_children == null) {
            return;
        }
        this.m_children.removeAllElements();
    }

    public void save(Object object) {
        if (!this.m_children.contains(object)) {
            this.addChild(object);
        }
    }

    public void remove(Object object) {
        this.m_children.removeElement(object);
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 0x110001: {
                if (this.m_displayNameProp != 0 && this.m_children != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    int n2 = this.m_children.size();
                    int n3 = 0;
                    while (n3 < n2) {
                        stringBuffer.append(((IAdminProp)this.m_children.elementAt(n3)).getProp(this.m_displayNameProp));
                        if (n3 + 1 < n2) {
                            stringBuffer.append(", ");
                        }
                        ++n3;
                    }
                    return stringBuffer.toString();
                }
                return this.m_displayName;
            }
            case 4784130: {
                return this.m_parent;
            }
            case 0x403000: {
                return this.m_sampleChild;
            }
            case 1638408: 
            case 7929864: {
                return this.m_iconName;
            }
            case 2686979: {
                return new Integer(3);
            }
            case 3080204: {
                if (this.m_childrenArr != null) {
                    return new Integer((this.m_childrenArr.length != 0 ? 0x100000 : 0) | 0x200000 | 0x40 | 4);
                }
                return new Integer((this.m_children != null && this.m_children.size() != 0 ? 0x100000 : 0) | 0x200000 | 0x40 | 4);
            }
            case 272695330: 
            case 273219601: 
            case 273612805: {
                if (!this.isConnected()) {
                    this.connect();
                }
                if (this.m_childrenArr != null) {
                    return this.m_childrenArr;
                }
                if (this.m_children == null) {
                    return null;
                }
                return AdminProp.vectorToObjectArray(this.m_children);
            }
            case 0x1F000F: {
                if (this.m_parent != null) {
                    return this.m_parent.getProp(0x1F000F);
                }
                return this.getMessage(1065995);
            }
            case 273220108: {
                return this.m_cmdList;
            }
        }
        return this.getTableProp(n, this.m_children, this.m_childrenArr, this.m_sampleChild);
    }

    public void setProp(int n, Object object) throws PropertyException {
        switch (n) {
            case 1638408: {
                this.m_iconName = (String)object;
                return;
            }
            case 4784130: {
                this.m_parent = (IAdminProp)object;
                return;
            }
            case 0x403000: {
                this.m_sampleChild = (IAdminProp)object;
                return;
            }
        }
        super.setProp(n, object);
    }

    public void removeChildren(IAdminProp iAdminProp) {
        IAdminProp[] iAdminPropArray = null;
        try {
            iAdminPropArray = (IAdminProp[])iAdminProp.getProp(273220105);
        }
        catch (Exception exception) {
            this.unexpectedException(exception);
            return;
        }
        if (iAdminPropArray != null && this.countChildren() != 0) {
            int n = 0;
            while (n < iAdminPropArray.length) {
                this.m_children.removeElement(iAdminPropArray[n]);
                ++n;
            }
            this.sendAdminPropertyChangeEvents(273219601, this.m_children);
            this.sendAdminPropertyChangeEvents(273612805, this.m_children);
        }
    }

    boolean isConnected() {
        return true;
    }

    void connect() {
    }
}

