/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.common;

import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.PropertyException;

public class AdminLog
extends Throwable {
    static final int DALOG_SRVR_LOG = 1;
    static final int DALOG_CONS_LOG = 2;
    static final int DALOG_SVCN_LOG = 3;
    static final int DALOG_AUDT_LOG = 4;
    static final int DALOG_NO_PFX = 0;
    static final int DALOG_DATE_PFX = 1;
    static final int DALOG_TIME_PFX = 2;
    static final int DALOG_DTME_PFX = 3;
    static final int DALOG_FUNC_PFX = 4;
    static final int DALOG_FULL_PFX = 5;
    static final int DALOG_FULL_LVL = 4096;
    static final int DALOG_ERR_LVL = 1;
    static final int DALOG_STAT_LVL = 2;
    static final int DALOG_DBG_LVL = 4;
    static final int DALOG_FUNC_LVL = 8;
    int m_logging;
    String m_logclass;
    String m_logmethod;

    public AdminLog(int n, String string, String string2) {
        this.setReportLevel(n, string, string2);
    }

    public AdminLog() {
        this.setReportLevel(3, null, null);
    }

    public void finalize() {
    }

    public void setReportLevel(int n, String string, String string2) {
        this.m_logging = n;
        this.m_logclass = string;
        this.m_logmethod = string2;
    }

    public int getReportLevel() {
        return this.m_logging;
    }

    public String getReportClass() {
        return this.m_logclass;
    }

    public String getReportMethod() {
        return this.m_logmethod;
    }

    private String prefixToString(int n) {
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = new StringBuffer(10);
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = null;
        switch (n) {
            case 0: {
                return " ";
            }
            case 1: {
                simpleDateFormat = new SimpleDateFormat("MM/dd");
                stringBuffer = simpleDateFormat.format(date, stringBuffer2, new FieldPosition(3));
                break;
            }
            case 2: {
                simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
                stringBuffer = simpleDateFormat.format(date, stringBuffer2, new FieldPosition(5));
                break;
            }
            case 3: {
                simpleDateFormat = new SimpleDateFormat("MM/dd HH:mm:ss");
                stringBuffer = simpleDateFormat.format(date, stringBuffer2, new FieldPosition(3));
                break;
            }
            case 4: {
                if (this.m_logclass != null && this.m_logmethod != null) {
                    return new String(String.valueOf(this.m_logclass) + "::" + this.m_logmethod + ": ");
                }
                return new String("<>::<>: ");
            }
            case 5: {
                simpleDateFormat = new SimpleDateFormat("MM/dd HH:mm:ss");
                stringBuffer = simpleDateFormat.format(date, stringBuffer2, new FieldPosition(3));
                break;
            }
        }
        return stringBuffer.toString();
    }

    public void enterMethod(String string, String string2, int n) {
        String string3 = new String(String.valueOf(this.prefixToString(5)) + " Entering: " + string + "::" + string2);
        this.writeLog(n, string3, 0);
    }

    public void exitMethod(String string, String string2, int n) {
        String string3 = new String(String.valueOf(this.prefixToString(5)) + " Exiting: " + string + "::" + string2);
        this.writeLog(n, string3, 0);
    }

    public void logError(int n, String string, int n2) {
        if ((this.m_logging & 1) == 1) {
            this.writeClientLog(string, n2);
            this.writeLog(n, string, n2);
        }
    }

    public void logDbgMsg(int n, String string, int n2) {
        if ((this.m_logging & 4) == 1) {
            this.writeClientLog(string, n2);
            this.writeLog(n, string, n2);
        }
    }

    public void logStatus(int n, String string, int n2) {
        if ((this.m_logging & 2) == 1) {
            this.writeClientLog(string, n2);
            this.writeLog(n, string, n2);
        }
    }

    public void logAction(AdminProp adminProp, String string) {
        String string2 = null;
        int n = 0x110001;
        try {
            string2 = new String(" " + adminProp.getProp(n).toString() + ": " + string);
        }
        catch (PropertyException propertyException) {
            string2 = new String(" Unable to retrieve username: " + string);
        }
        this.writeClientLog(string2, 3);
        this.writeLog(4, string2, 3);
    }

    public void writeClientLog(String string, int n) {
    }

    private native void writeJNILogs(int var1, String var2, int var3);

    private synchronized void writeLog(int n, String string, int n2) {
        System.out.println("AdminLog::writeLog: " + string);
    }

    private native void setServerLogLevel(int var1, String var2, String var3);

    private native void openLogs();

    private native void closLogs();

    public static void main(String[] stringArray) {
    }
}

