/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.common;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ldap.admin.common.AdminLang;
import oracle.ldap.admin.common.AdminLog;
import oracle.ldap.admin.common.AdminPropertyChangeEvent;
import oracle.ldap.admin.common.AdminPropertyChangeListener;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.IntHashtable;
import oracle.ldap.admin.common.PropValue;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;
import oracle.ldap.admin.common.Util;

public class AdminProp
implements IAdminProp {
    public static boolean DEBUG_NOTIFICATIONS;
    public static final int PR_STR_NOT_CONNECTED = 0x104400;
    public static final int PR_STR_CONNECTED = 0x104401;
    public static final int PR_STR_CONNECT_FAILED = 1065986;
    public static final int PR_STR_CONNECTING = 1065989;
    public static final int PR_STR_INITIALIZING = 1065987;
    public static final int PR_STR_INIT_FAILED = 0x104404;
    public static final int PR_STR_BINDING = 1065990;
    public static final int PR_STR_BINDING_FAILED = 1065991;
    public static final int PR_STR_SHUTING_DOWN = 1065992;
    public static final int PR_STR_SAVING = 1065993;
    public static final int PR_STR_SAVE_FAILED = 1065994;
    public static final int PR_STR_READY = 1065995;
    public static final int PR_STR_LOGGING_OFF = 1065996;
    public static final int PR_STR_SEARCHING = 1065997;
    public static final int PR_STR_LOGON_TITLE = 1066016;
    public static final int PR_STR_EDITOR_TITLE = 1066017;
    private static final NullValue m_null_value;
    protected IntHashtable m_Properties;
    protected AdminLang m_lang;
    public boolean m_bModified = false;
    public String m_errorMessage = "";
    public String m_statusMessage = "";
    private static long jniNLSctx;
    private static AdminLog loginfo;
    static final int[] initCachePropList;
    static final int[] initCacheTablePropList;
    protected Vector m_adminPropertyChangeListener;
    private int[] m_disabledProperties;
    private int[] m_groupTitleProperties;
    private int[] m_syncUpdatedProperties;
    private int[] m_propertiesWithHiddenLabel;
    private int[] m_propertiesHidden;
    private IntHashtable m_readAccessMethods;
    private IntHashtable m_writeAccessMethods;
    final Class[] m_readMethodParamTypes = new Class[0];
    IntHashtable m_dpyHeight;
    IntHashtable m_dpyLength;
    IntHashtable m_dpyWidth;
    IntHashtable m_propTabPages;
    Vector m_registerTabPages;
    IntHashtable m_propGroups;
    Hashtable m_groupLayout;
    IntHashtable m_units;
    String m_url;
    IntHashtable m_lovs;
    IntHashtable m_affectedPropList;
    private boolean lockAccessTo_toString = false;
    boolean m_bDebug = false;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$oracle$ldap$admin$common$IAdminProp;
    static /* synthetic */ Class class$java$lang$Boolean;

    public boolean isModified() {
        return this.m_bModified;
    }

    public void setModified(boolean bl) {
        this.m_bModified = bl;
    }

    public String getErrorMessage() {
        return this.m_errorMessage;
    }

    public void setErrorMessage(String string) {
        this.m_errorMessage = string;
        this.sendAdminPropertyChangeEvents(2031760, string);
    }

    public String getStatusMessage() {
        return this.m_statusMessage;
    }

    public void setStatusMessage(String string) {
        this.m_statusMessage = string;
        this.sendAdminPropertyChangeEvents(0x1F000F, string);
    }

    public AdminProp() {
        this.m_Properties = new IntHashtable();
        if (this instanceof AdminLang) {
            return;
        }
        try {
            AdminLang.db.setProp(4784141, (Object)this);
        }
        catch (PropertyException propertyException) {
            System.out.println("AdminProp::Constructor cannot set  admin language of an object");
        }
        this.registerMessages();
        try {
            this.initProps();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void initProps() throws PropertyException {
    }

    public void registerMessages() {
        this.registerProp(282001412, "PR_PROPERTY LIST", "List of properties available form this object");
        this.registerProp(282001422, "PR_VISIBLE_PROPERTY_LIST", "List of user visible properties available form this object");
        this.registerProp(4784134, "PR_ADMIN_LANG", "NLS string lookup object");
        this.registerProp(2686979, "PR_ACCESS", "The access bits for this object");
        this.registerProp(3080204, "PR_STATUS", "The status bits for this object");
        this.registerProp(0x110001, "Name", "The user visible names used of this object");
        this.registerProp(273612805, "PR_TREE_VIEW_CHILDREN_LIST", "The list of children which should be shown in tree view windows");
        this.registerProp(282001424, "PR_TABLE_COLUMN_PROP_LIST", "Maximun list of column property ids.");
        this.registerProp(281083944, "InitCachePropList", "The list of property initially to be cached in client end");
        this.registerProp(281083945, "InitCacheTablePropList", "The list of table property initially to be cached in client end");
        this.registerProp(282002580, "Configuration Properties", "The list of properties needed to configure an object.");
        this.registerProp(2032789, "URL", "The AdminProp URL component of an object.");
        this.registerMessage(0x104400, "Not connected");
        this.registerMessage(0x104401, "Connected");
        this.registerMessage(1065986, "Connect failed");
        this.registerMessage(1065989, "Connecting");
        this.registerMessage(1065987, "Initializing");
        this.registerMessage(0x104404, "Initialization failed");
        this.registerMessage(1065990, "Binding");
        this.registerMessage(1065991, "Bind failed");
        this.registerMessage(1065992, "Shutting down");
        this.registerMessage(1065993, "Saving");
        this.registerMessage(1065994, "Save failed");
        this.registerMessage(1065995, "Ready");
        this.registerMessage(1065996, "Logging off");
        this.registerMessage(1065997, "Searching");
    }

    private final Object ___getProp(int n) throws PropertyException {
        Object object;
        if (this.m_readAccessMethods != null) {
            object = this.m_readAccessMethods.get(n);
            if (object instanceof Method) {
                Method method = (Method)object;
                if (method != null) {
                    try {
                        return method.invoke((Object)this, null);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        throw new PropertyException(exception);
                    }
                }
            } else {
                Field field = (Field)object;
                if (field != null) {
                    try {
                        return field.get(this);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        throw new PropertyException(exception);
                    }
                }
            }
        }
        if ((object = this.m_Properties.get(n)) == m_null_value) {
            object = null;
        }
        if (object != null) {
            return object;
        }
        switch (n) {
            case 1114150: {
                return this.getClass().getName();
            }
            case 3080204: {
                return new Integer(4);
            }
            case 2686979: {
                return new Integer(3);
            }
            case 4784134: {
                return this.m_lang;
            }
            case 282001412: {
                return this.getPropList();
            }
            case 3082279: {
                return null;
            }
            case 3080231: {
                return new Integer(31);
            }
            case 281085993: {
                return null;
            }
            case 281083945: {
                return initCacheTablePropList;
            }
            case 281085992: {
                return null;
            }
            case 281083944: {
                return initCachePropList;
            }
            case 281609325: {
                return this.getPropertiesOnDisabledList();
            }
            case 281609326: {
                return this.getPropertiesWithHiddenLabel();
            }
            case 281609327: {
                return this.getPropertiesUpdatedSynchronously();
            }
            case 281610263: {
                return null;
            }
            case 281608215: {
                return this.getProp(282001422);
            }
            case 282001422: {
                return this.getPropListByType(65536, true);
            }
            case 276758675: {
                return this.getVisiblePropertyListOfValues();
            }
            case 270075001: {
                return this.getPropGroupTitleList();
            }
            case 282004628: {
                return null;
            }
            case 282002580: {
                return this.getAppServerConfigPropList();
            }
            case 2034837: {
                return null;
            }
            case 2032789: {
                return this.getAdmPropURL();
            }
            case 0x10110440: {
                return this.getTabNameList();
            }
            case 0x10110441: {
                return this.getPropTabPages();
            }
            case 281609329: {
                return this.getPropertiesHidden();
            }
            case 7406622: {
                return this.getGroupLayout();
            }
            case 269550621: {
                return this.getPropGroups();
            }
            case 270467219: {
                return this.getVisiblePropertyListOfUnits();
            }
            case 282001954: {
                return this.getVisiblePropertyListOfHeight();
            }
            case 282001953: {
                return this.getVisiblePropertyListOfWidth();
            }
            case 282001952: {
                return this.getVisiblePropertyListOfLength();
            }
            case 2031760: {
                return this.getErrorMessage();
            }
            case 0x1F000F: {
                return this.getStatusMessage();
            }
        }
        if (this instanceof AdminLang) {
            return object;
        }
        if (AdminProp.isCommandLineProp(n)) {
            return this.getProp(AdminProp.getNormalPropFromCmdLineProp(n));
        }
        if (AdminProp.isPersistenceProp(n)) {
            return this.getProp(AdminProp.getNormalPropFromPersistenceProp(n));
        }
        return object;
    }

    public Object getProp(String string) throws PropertyException {
        System.out.println("sPropId = " + string);
        int n = this.getPropIdFromName(string);
        if (n != 0) {
            return this.getProp(n);
        }
        return null;
    }

    public void setProp(String string, Object objectArray) throws PropertyException {
        int n = this.getPropIdFromName(string);
        if (n != 0) {
            switch (AdminProp.getPropType(n)) {
                case 0x10100000: {
                    if (objectArray instanceof String[] || !(objectArray instanceof Object[])) break;
                    Object[] objectArray2 = objectArray;
                    String[] stringArray = new String[objectArray2.length];
                    int n2 = 0;
                    while (n2 < objectArray2.length) {
                        stringArray[n2] = objectArray2[n2].toString();
                        ++n2;
                    }
                    objectArray = stringArray;
                    break;
                }
                case 0x10C00000: {
                    if (objectArray instanceof int[] || !(objectArray instanceof Object[])) break;
                    Object[] objectArray3 = objectArray;
                    int[] nArray = new int[objectArray3.length];
                    int n3 = 0;
                    while (n3 < objectArray3.length) {
                        nArray[n3] = (Integer)objectArray3[n3];
                        ++n3;
                    }
                    objectArray = nArray;
                    break;
                }
                case 0x10200000: {
                    if (objectArray instanceof Integer[] || !(objectArray instanceof Object[])) break;
                    Object[] objectArray4 = objectArray;
                    Integer[] integerArray = new Integer[objectArray4.length];
                    int n4 = 0;
                    while (n4 < objectArray4.length) {
                        integerArray[n4] = (Integer)objectArray4[n4];
                        ++n4;
                    }
                    objectArray = integerArray;
                    break;
                }
                case 0x10400000: {
                    if (objectArray instanceof IAdminProp[] || !(objectArray instanceof Object[])) break;
                    Object[] objectArray5 = objectArray;
                    IAdminProp[] iAdminPropArray = new IAdminProp[objectArray5.length];
                    int n5 = 0;
                    while (n5 < objectArray5.length) {
                        iAdminPropArray[n5] = (IAdminProp)objectArray5[n5];
                        ++n5;
                    }
                    objectArray = iAdminPropArray;
                    break;
                }
            }
            this.setProp(n, (Object)objectArray);
        }
    }

    public Object getProp(int n) throws PropertyException {
        return this.___getProp(n);
    }

    public Object getTableProp(int n, Vector vector) throws PropertyException {
        return this.getTableProp(n, vector, null);
    }

    public Object getTableProp(int n, IAdminProp[] iAdminPropArray, IAdminProp iAdminProp) throws PropertyException {
        return this.getTableProp(n, null, iAdminPropArray, iAdminProp);
    }

    public Object getTableProp(int n, Vector vector, IAdminProp iAdminProp) throws PropertyException {
        return this.getTableProp(n, vector, null, iAdminProp);
    }

    public Object getTableProp(int n, Vector vector, IAdminProp[] iAdminPropArray, IAdminProp iAdminProp) throws PropertyException {
        if (iAdminProp == null && vector != null && vector.size() != 0) {
            iAdminProp = (IAdminProp)vector.elementAt(0);
        }
        if (iAdminProp == null && iAdminPropArray != null && iAdminPropArray.length != 0) {
            iAdminProp = iAdminPropArray[0];
        }
        switch (n) {
            case 0x10110021: {
                int[] nArray = (int[])this.getProp(282001424);
                if (nArray == null) {
                    return null;
                }
                if (iAdminProp != null) {
                    return iAdminProp.getPropNames(nArray);
                }
                return this.getPropNames(nArray);
            }
            case 281083936: {
                Object[] objectArray;
                int[] nArray = null;
                if (iAdminProp != null && (objectArray = (Object[])(nArray = (int[])iAdminProp.getProp(282001953))) != null && objectArray.length != 0) {
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        if (objectArray[n2] == false) {
                            objectArray = null;
                            break;
                        }
                        ++n2;
                    }
                    if (objectArray != null) {
                        return objectArray;
                    }
                }
                if ((objectArray = (String[])this.getProp(0x10110021)) == null) {
                    return null;
                }
                if (nArray != null && objectArray.length != nArray.length) {
                    nArray = null;
                }
                int[] nArray2 = new int[objectArray.length];
                int n3 = 0;
                while (n3 < objectArray.length) {
                    nArray2[n3] = objectArray[n3] == null ? 4 : (objectArray[n3].startsWith("images/") ? 2 : (nArray != null && nArray[n3] != 0 ? nArray[n3] : objectArray[n3].length()));
                    ++n3;
                }
                Object[] objectArray2 = iAdminPropArray != null ? iAdminPropArray : (vector != null ? AdminProp.vectorToObjectArray(vector) : (Object[])this.getProp(273219601));
                int[] nArray3 = (int[])this.getProp(282001424);
                if (objectArray2 != null && objectArray2.length != 0 && nArray3 != null) {
                    int n4 = 0;
                    while (n4 < nArray3.length) {
                        int n5 = 0;
                        while (n5 < objectArray2.length) {
                            int n6 = 0;
                            Object object = ((IAdminProp)objectArray2[n5]).getProp(nArray3[n4]);
                            if (object != null) {
                                int n7;
                                Object object2;
                                if (AdminProp.getPropType(nArray3[n4]) == 0x800000) {
                                    n6 = 2;
                                } else if (AdminProp.getPropType(nArray3[n4]) == 0x10C00000) {
                                    object2 = (int[])object;
                                    n7 = 0;
                                    while (n7 < ((int[])object2).length) {
                                        n6 += Integer.toString((int)object2[n7]).length();
                                        if (n7 != ((Object)object2).length - 1) {
                                            n6 += 2;
                                        }
                                        ++n7;
                                    }
                                } else if (AdminProp.isPropArray(nArray3[n4])) {
                                    object2 = (Object[])object;
                                    n7 = 0;
                                    while (n7 < ((Object)object2).length) {
                                        if (object2[n7] != null) {
                                            n6 += object2[n7].toString().length();
                                            if (n7 != ((Object)object2).length - 1) {
                                                n6 += 2;
                                            }
                                        }
                                        ++n7;
                                    }
                                } else {
                                    object2 = object.toString();
                                    n7 = ((String)object2).indexOf(10);
                                    if (n7 > 0) {
                                        object2 = ((String)object2).substring(0, n7);
                                    }
                                    n6 = ((String)object2).length();
                                }
                                if (n6 > 50) {
                                    n6 = 40;
                                }
                                if (nArray2[n4] < n6) {
                                    nArray2[n4] = n6;
                                }
                            }
                            ++n5;
                        }
                        ++n4;
                    }
                }
                return nArray2;
            }
            case 282001424: {
                if (iAdminProp != null) {
                    int[] nArray = (int[])iAdminProp.getProp(282001422);
                    if (nArray != null) {
                        int n8 = 0;
                        int n9 = 0;
                        while (n9 < nArray.length) {
                            if (AdminProp.getPropType(nArray[n9]) == 0xD00000) {
                                ++n8;
                            }
                            ++n9;
                        }
                        if (n8 != 0) {
                            int[] nArray4 = new int[nArray.length - n8];
                            int n10 = 0;
                            int n11 = 0;
                            while (n10 < nArray.length) {
                                if (AdminProp.getPropType(nArray[n10]) != 0xD00000) {
                                    nArray4[n11++] = nArray[n10];
                                }
                                ++n10;
                            }
                            nArray = nArray4;
                        }
                    }
                    return nArray;
                }
                return this.getProp(282001422);
            }
            case 273219601: {
                return this.getProp(273612805);
            }
            case 2686995: {
                int[] nArray = (int[])this.getProp(282001424);
                if (nArray == null) {
                    return new Integer(0);
                }
                return new Integer(nArray.length);
            }
            case 2686994: {
                if (iAdminPropArray != null) {
                    return new Integer(iAdminPropArray.length);
                }
                return new Integer(vector != null ? vector.size() : 0);
            }
        }
        return this.___getProp(n);
    }

    public Object[] getProps(Object[] objectArray) throws PropertyException {
        int[] nArray = new int[objectArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this.getPropIdFromName(objectArray[n].toString());
            ++n;
        }
        return this.getProps(nArray);
    }

    public Object[] getProps(int[] nArray) throws PropertyException {
        Object[] objectArray = new Object[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            objectArray[n] = this.getProp(nArray[n]);
            ++n;
        }
        return objectArray;
    }

    private final void ___setProp(int n, Object object) throws PropertyException {
        switch (n) {
            case 4784134: {
                this.m_lang = (AdminLang)object;
                return;
            }
            case 2031760: {
                this.setErrorMessage((String)object);
                return;
            }
            case 0x1F000F: {
                this.setStatusMessage((String)object);
                return;
            }
        }
        if (this.m_writeAccessMethods != null) {
            Object object2 = this.m_writeAccessMethods.get(n);
            if (object2 instanceof Method) {
                Method method = (Method)object2;
                if (method != null) {
                    Object[] objectArray = new Object[]{object};
                    try {
                        method.invoke((Object)this, objectArray);
                        return;
                    }
                    catch (Exception exception) {
                        throw new PropertyException(exception);
                    }
                }
            } else {
                Field field = (Field)object2;
                if (field != null) {
                    try {
                        field.set(this, object);
                        return;
                    }
                    catch (Exception exception) {
                        throw new PropertyException(exception);
                    }
                }
            }
        }
        if (object == null) {
            object = m_null_value;
        }
        this.m_Properties.put(n, object);
    }

    public void setProp(int n, int n2) throws PropertyException {
        this.setProp(n, (Object)new Integer(n2));
    }

    public void setProp(int n, boolean bl) throws PropertyException {
        this.setProp(n, (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
    }

    public void setProp(int n, Object object) throws PropertyException {
        this.___setProp(n, object);
    }

    public void setProps(Object[] objectArray, Object[] objectArray2) throws PropertyException {
        int[] nArray = new int[objectArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this.getPropIdFromName(objectArray[n].toString());
            ++n;
        }
        this.setProps(nArray, objectArray2);
    }

    public void setProps(int[] nArray, Object[] objectArray) throws PropertyException {
        PropertyException propertyException = null;
        PropertyException propertyException2 = null;
        int n = 0;
        while (n < nArray.length) {
            try {
                this.setProp(nArray[n], objectArray[n]);
            }
            catch (PropertyException propertyException3) {
                if (propertyException == null) {
                    propertyException2 = propertyException = propertyException3;
                } else {
                    propertyException2.SetNext(propertyException3);
                    propertyException2 = propertyException3;
                }
            }
            catch (Exception exception) {
                PropertyException propertyException4 = new PropertyException(exception);
                if (propertyException == null) {
                    propertyException2 = propertyException = propertyException4;
                }
                propertyException2.SetNext(propertyException4);
                propertyException2 = propertyException4;
            }
            ++n;
        }
        if (propertyException != null) {
            throw propertyException;
        }
        this.sendAdminPropertyChangeEvents(nArray, objectArray);
        int[] nArray2 = this.getAffectedPropList(nArray);
        if (nArray2 != null) {
            this.sendAdminPropertyChangeEvents(nArray2, null);
        }
    }

    public PropValue getPropValue(int n) throws PropertyException {
        return new PropValue(n, this.getProp(n));
    }

    public PropValue[] getPropValues(int[] nArray) throws PropertyException {
        Object[] objectArray = this.getProps(nArray);
        if (objectArray == null) {
            return null;
        }
        PropValue[] propValueArray = new PropValue[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            propValueArray[n] = new PropValue(nArray[n], objectArray[n]);
            ++n;
        }
        return propValueArray;
    }

    public void setPropValue(PropValue propValue) throws PropertyException {
        this.setProp(propValue.getPropId(), propValue.getValue());
    }

    public void setPropValues(PropValue[] propValueArray) throws PropertyException {
        int[] nArray = new int[propValueArray.length];
        Object[] objectArray = new Object[propValueArray.length];
        int n = 0;
        while (n < propValueArray.length) {
            nArray[n] = propValueArray[n].getPropId();
            objectArray[n] = propValueArray[n].getValue();
            ++n;
        }
        this.setProps(nArray, objectArray);
    }

    public void deleteProp(int n) throws PropertyException {
        if ((n & 0x80000) != 0) {
            throw new PropertyException("AdminProp::deleteProp called on manditory property " + this.getClass().getName() + ".propID=" + Integer.toHexString(n), 3, n, null);
        }
        this.m_Properties.remove(n);
    }

    public void deleteProps(int[] nArray) throws PropertyException {
        int n = 0;
        while (n < nArray.length) {
            this.deleteProp(nArray[n]);
            ++n;
        }
    }

    public int[] getAppServerConfigPropList() {
        int n;
        int[] nArray = this.getPropListByType(983040, true);
        int n2 = 0;
        if (nArray != null) {
            n = 0;
            while (n < nArray.length) {
                switch (nArray[n]) {
                    case 282002580: {
                        ++n2;
                        break;
                    }
                }
                switch (nArray[n] & 0x10F00000) {
                    case 0x400000: 
                    case 0x10400000: {
                        ++n2;
                        break;
                    }
                }
                ++n;
            }
        }
        if (n2 == 0) {
            return nArray;
        }
        int[] nArray2 = new int[nArray.length - n2];
        n = 0;
        int n3 = 0;
        while (n < nArray.length) {
            switch (nArray[n]) {
                default: {
                    switch (nArray[n] & 0x10F00000) {
                        default: {
                            nArray2[n3++] = nArray[n];
                        }
                        case 0x400000: 
                        case 0x10400000: 
                    }
                }
                case 282002580: 
            }
            ++n;
        }
        return nArray2;
    }

    public int[] getPropList() {
        Enumeration enumeration = this.m_Properties.keys();
        int n = this.m_Properties.size();
        if (enumeration == null || n == 0) {
            return null;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            nArray[n2] = (Integer)enumeration.nextElement();
            ++n2;
        }
        return nArray;
    }

    public static int getPropType(int n) {
        return n & 0x10F00000;
    }

    public static int getPropNumber(int n) {
        return n & 0xFFFF;
    }

    public static boolean isPropArray(int n) {
        return (n & 0x10000000) != 0;
    }

    public static boolean isCommandLineProp(int n) {
        return (n & 0xF800) == 4096;
    }

    public static int getNormalPropFromCmdLineProp(int n) {
        return n & 0xFFFFEFFF;
    }

    public static boolean isPersistenceProp(int n) {
        return (n & 0xF800) == 2048;
    }

    public static int getNormalPropFromPersistenceProp(int n) {
        return n & 0xFFFFF7FF;
    }

    public static boolean isPropReadonly(int n) {
        return (n & 0x60000) == 393216;
    }

    public static boolean isPropReplacible(int n) {
        return (n & 0x20000) == 0;
    }

    public static boolean isPropEditable(int n) {
        return (n & 0x40000) == 0;
    }

    public static boolean isPropHidden(int n) {
        return (n & 0x10000) != 0;
    }

    public static boolean isEncripted(int n) {
        return false;
    }

    public static String getConnonicalPropName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.startsWith("PR_")) {
            string = string.substring(3);
        }
        int n = string.length();
        string = string.toLowerCase();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c != '_' && !Character.isSpaceChar(c)) {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public int getPropIdFromName(String string) {
        try {
            int n;
            Object[] objectArray;
            string = AdminProp.getConnonicalPropName(string);
            String string2 = null;
            if (this.m_lang != null && (objectArray = (Object[])((int[])this.getProp(282001422))) != null) {
                n = 0;
                while (n < objectArray.length) {
                    string2 = (String)this.m_lang.getProp((int)(objectArray[n] | 0x20000000));
                    if (string2 != null && (string2 = AdminProp.getConnonicalPropName(string2)).startsWith(string)) {
                        return (int)objectArray[n];
                    }
                    ++n;
                }
            }
            objectArray = this.getClass().getFields();
            n = 0;
            while (n < objectArray.length) {
                String string3 = objectArray[n].getName();
                if (string3.startsWith("PR_")) {
                    try {
                        string3 = AdminProp.getConnonicalPropName(string3);
                        if (string3.startsWith(string)) {
                            return objectArray[n].getInt(this);
                        }
                    }
                    catch (Exception exception) {}
                }
                ++n;
            }
        }
        catch (PropertyException propertyException) {}
        return 0;
    }

    public String getPropName(String string) {
        int n = this.getPropIdFromName(string);
        if (n != 0) {
            return this.getPropName(n);
        }
        return null;
    }

    public String getPropDescription(String string) {
        int n = this.getPropIdFromName(string);
        if (n != 0) {
            return this.getPropDescription(n);
        }
        return null;
    }

    public String getPropName(int n) {
        try {
            String string = null;
            if (this.m_lang != null) {
                string = (String)this.m_lang.getProp(n | 0x20000000);
            }
            if (string == null) {
                Field[] fieldArray = this.getClass().getFields();
                int n2 = 0;
                while (n2 < fieldArray.length) {
                    String string2 = fieldArray[n2].getName();
                    if (string2.startsWith("PR_")) {
                        try {
                            if (fieldArray[n2].getInt(this) == n) {
                                string = string2;
                                break;
                            }
                        }
                        catch (Exception exception) {}
                    }
                    ++n2;
                }
            }
            return string;
        }
        catch (PropertyException propertyException) {
            return null;
        }
    }

    public String[] getPropNames() {
        try {
            return this.getPropNames((int[])this.getProp(282001422));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String[] getPropNames(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        String[] stringArray = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            stringArray[n] = this.getPropName(nArray[n]);
            ++n;
        }
        return stringArray;
    }

    public String getPropDescription(int n) {
        try {
            return (String)this.m_lang.getProp(n | 0x40000000);
        }
        catch (PropertyException propertyException) {
            return null;
        }
    }

    public String[] getPropDescriptions(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return null;
        }
        String[] stringArray = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            stringArray[n] = this.getPropDescription(nArray[n]);
            ++n;
        }
        return stringArray;
    }

    public void saveChanges(int n) throws SaveChangeException {
        System.out.println(String.valueOf(this.getClass().getName()) + " has no 'public void saveChanges(int)' function.");
    }

    public void addAdminPropertyChangeListener(AdminPropertyChangeListener adminPropertyChangeListener) {
        if (this.m_adminPropertyChangeListener == null) {
            this.m_adminPropertyChangeListener = new Vector();
        }
        this.m_adminPropertyChangeListener.addElement(adminPropertyChangeListener);
    }

    public void removeAdminPropertyChangeListener(AdminPropertyChangeListener adminPropertyChangeListener) {
        if (this.m_adminPropertyChangeListener == null) {
            return;
        }
        this.m_adminPropertyChangeListener.removeElement(adminPropertyChangeListener);
    }

    public void printListeners() {
        if (this.m_adminPropertyChangeListener == null) {
            return;
        }
        int n = 0;
        while (n < this.m_adminPropertyChangeListener.size()) {
            AdminPropertyChangeListener adminPropertyChangeListener = (AdminPropertyChangeListener)this.m_adminPropertyChangeListener.elementAt(n);
            System.out.println("listener=" + adminPropertyChangeListener.getClass().getName());
            ++n;
        }
    }

    public synchronized void sendAdminPropertyChangeEvents(int[] nArray, Object[] objectArray) {
        int n;
        if (this.m_adminPropertyChangeListener == null || (n = this.m_adminPropertyChangeListener.size()) == 0) {
            return;
        }
        Vector vector = (Vector)this.m_adminPropertyChangeListener.clone();
        try {
            AdminPropertyChangeEvent adminPropertyChangeEvent = null;
            AdminPropertyChangeEvent adminPropertyChangeEvent2 = null;
            if (nArray == null && (nArray = (int[])this.getProp(282001422)) == null) {
                return;
            }
            int n2 = 0;
            while (n2 < nArray.length) {
                Object object = null;
                if (objectArray != null) {
                    switch (nArray[n2] & 0x10F00000) {
                        case 0x400000: 
                        case 0x10400000: {
                            object = null;
                            break;
                        }
                        default: {
                            object = objectArray[n2];
                        }
                    }
                }
                if (adminPropertyChangeEvent == null) {
                    adminPropertyChangeEvent = adminPropertyChangeEvent2 = new AdminPropertyChangeEvent((Object)this, nArray[n2], null, object);
                } else {
                    adminPropertyChangeEvent2.setNext(new AdminPropertyChangeEvent((Object)this, nArray[n2], null, object));
                    adminPropertyChangeEvent2 = adminPropertyChangeEvent2.getNext();
                }
                ++n2;
            }
            if (adminPropertyChangeEvent != null) {
                AdminPropertyChangeListener adminPropertyChangeListener;
                if (DEBUG_NOTIFICATIONS) {
                    System.out.println("AdminProp.sendAdminPropertyChangeEvents start count =" + vector.size());
                    int n3 = 0;
                    while (n3 < vector.size()) {
                        adminPropertyChangeListener = (AdminPropertyChangeListener)vector.elementAt(n3);
                        System.out.println("   Listener " + n3 + " " + adminPropertyChangeListener);
                        ++n3;
                    }
                }
                int n4 = 0;
                while (n4 < vector.size()) {
                    adminPropertyChangeListener = (AdminPropertyChangeListener)vector.elementAt(n4);
                    adminPropertyChangeListener.adminPropertyChange(adminPropertyChangeEvent);
                    ++n4;
                }
                if (DEBUG_NOTIFICATIONS) {
                    System.out.println("AdminProp.sendAdminPropertyChangeEvents end count =" + vector.size());
                    return;
                }
            }
        }
        catch (Exception exception) {
            this.unexpectedException(exception);
        }
    }

    public void sendAdminPropertyChangeEvents() {
        this.sendAdminPropertyChangeEvents(null, null);
    }

    public void sendAdminPropertyChangeEvents(int n, Object object) {
        int[] nArray = new int[1];
        Object[] objectArray = new Object[1];
        nArray[0] = n;
        objectArray[0] = object;
        this.sendAdminPropertyChangeEvents(nArray, objectArray);
    }

    public int[] getPropertiesOnDisabledList() {
        return this.m_disabledProperties;
    }

    public int[] manageListOfIntegers(int[] nArray, int n, boolean bl) {
        if (bl) {
            if (nArray == null) {
                int[] nArray2 = new int[]{n};
                nArray = nArray2;
            } else {
                int n2 = 0;
                while (n2 < nArray.length) {
                    if (nArray[n2] == n) {
                        return nArray;
                    }
                    ++n2;
                }
                int[] nArray3 = new int[nArray.length + 1];
                int n3 = 0;
                while (n3 < nArray.length) {
                    nArray3[n3] = nArray[n3];
                    ++n3;
                }
                nArray3[nArray3.length - 1] = n;
                nArray = nArray3;
            }
        } else {
            if (nArray == null) {
                return null;
            }
            int n4 = 0;
            while (n4 < nArray.length) {
                if (nArray[n4] == n) break;
                ++n4;
            }
            if (n4 == nArray.length) {
                return nArray;
            }
            if (nArray.length == 1) {
                return null;
            }
            int[] nArray4 = new int[nArray.length - 1];
            n4 = 0;
            int n5 = 0;
            while (n4 < nArray.length) {
                if (nArray[n4] != n) {
                    nArray4[n5++] = nArray[n4];
                }
                ++n4;
            }
            nArray = nArray4;
        }
        return nArray;
    }

    public int[] getPropGroupTitleList() {
        return this.m_groupTitleProperties;
    }

    public void setPropertyGroupTitle(int n, boolean bl, boolean bl2) {
        this.m_groupTitleProperties = this.manageListOfIntegers(this.m_groupTitleProperties, n, bl);
        if (bl2) {
            this.sendAdminPropertyChangeEvents(281609325, null);
        }
    }

    public void setPropertyGroupTitle(int n, boolean bl) {
        this.setPropertyGroupTitle(n, bl, true);
    }

    public int[] getPropertiesUpdatedSynchronously() {
        return this.m_syncUpdatedProperties;
    }

    public void setPropertyUpdatedSync(int n, boolean bl, boolean bl2) {
        this.m_syncUpdatedProperties = this.manageListOfIntegers(this.m_syncUpdatedProperties, n, bl);
        if (bl2) {
            this.sendAdminPropertyChangeEvents(281609325, null);
        }
    }

    public void setPropertyUpdatedSync(int n, boolean bl) {
        this.setPropertyUpdatedSync(n, bl, true);
    }

    public void setPropertyDisabled(int n, boolean bl, boolean bl2) {
        this.m_disabledProperties = this.manageListOfIntegers(this.m_disabledProperties, n, bl);
        if (bl2) {
            this.sendAdminPropertyChangeEvents(281609325, null);
        }
    }

    public void setPropertyDisabled(int n, boolean bl) {
        this.setPropertyDisabled(n, bl, true);
    }

    public int[] getPropertiesWithHiddenLabel() {
        return this.m_propertiesWithHiddenLabel;
    }

    public void setPropertyLabelHidden(int n, boolean bl, boolean bl2) {
        this.m_propertiesWithHiddenLabel = this.manageListOfIntegers(this.m_propertiesWithHiddenLabel, n, bl);
        if (bl2) {
            this.sendAdminPropertyChangeEvents(281609326, null);
        }
    }

    public void setPropertyLabelHidden(int n, boolean bl) {
        this.setPropertyLabelHidden(n, bl, true);
    }

    public int[] getPropertiesHidden() {
        return this.m_propertiesHidden;
    }

    public void setPropHidden(int n, boolean bl, boolean bl2) {
        this.m_propertiesHidden = this.manageListOfIntegers(this.m_propertiesHidden, n, bl);
        if (bl2) {
            this.sendAdminPropertyChangeEvents(281609329, null);
        }
    }

    public void setPropHidden(int n, boolean bl) {
        this.setPropHidden(n, bl, true);
    }

    public void registerPropField(int n, String string) {
        if (string == null) {
            return;
        }
        Field field = null;
        try {
            field = this.getClass().getField(string);
        }
        catch (Exception exception) {
            System.out.println("Didn't get field " + string + " e=" + exception);
        }
        if (field != null) {
            if (this.m_readAccessMethods == null) {
                this.m_readAccessMethods = new IntHashtable();
            }
            this.m_readAccessMethods.put(n, field);
            if (this.m_writeAccessMethods == null) {
                this.m_writeAccessMethods = new IntHashtable();
            }
            this.m_writeAccessMethods.put(n, field);
        }
    }

    public void registerPropField(int n, String string, String string2, String string3) {
        this.registerProp(n, string, string2);
        this.registerPropField(n, string3);
    }

    public void registerPropReadMethod(int n, String string) {
        if (string == null) {
            return;
        }
        Method method = null;
        try {
            method = this.getClass().getMethod(string, this.m_readMethodParamTypes);
        }
        catch (Exception exception) {
            System.out.println("didn't get read method " + string + " e=" + exception);
        }
        if (method != null) {
            if (this.m_readAccessMethods == null) {
                this.m_readAccessMethods = new IntHashtable();
            }
            this.m_readAccessMethods.put(n, method);
        }
    }

    public void registerPropWriteMethod(int n, String string) {
        if (string == null) {
            return;
        }
        Class[] classArray = new Class[1];
        switch (AdminProp.getPropType(n)) {
            case 0x200000: {
                classArray[0] = class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = AdminProp.class$("java.lang.Integer"));
                break;
            }
            case 0x100000: 
            case 0xB00000: 
            case 0xD00000: {
                classArray[0] = class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = AdminProp.class$("java.lang.String"));
                break;
            }
            case 0xE00000: {
                classArray[0] = class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = AdminProp.class$("java.lang.Long"));
                break;
            }
            case 0x500000: {
                classArray[0] = class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = AdminProp.class$("java.lang.Double"));
                break;
            }
            case 0x300000: {
                classArray[0] = class$java$util$Date != null ? class$java$util$Date : (class$java$util$Date = AdminProp.class$("java.util.Date"));
                break;
            }
            case 0x400000: {
                classArray[0] = class$oracle$ldap$admin$common$IAdminProp != null ? class$oracle$ldap$admin$common$IAdminProp : (class$oracle$ldap$admin$common$IAdminProp = AdminProp.class$("oracle.ldap.admin.common.IAdminProp"));
                break;
            }
            case 0x800000: {
                classArray[0] = class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = AdminProp.class$("java.lang.Boolean"));
                break;
            }
            case 0x10400000: {
                classArray[0] = new AdminProp[0].getClass();
                break;
            }
            case 0x10200000: {
                classArray[0] = new Integer[0].getClass();
                break;
            }
            case 0x10100000: {
                classArray[0] = new String[0].getClass();
                break;
            }
            case 0x10C00000: {
                classArray[0] = new int[0].getClass();
                break;
            }
            case 0x10D00000: {
                classArray[0] = new Long[0].getClass();
                break;
            }
            case 0x10500000: {
                classArray[0] = new Double[0].getClass();
                break;
            }
        }
        if (classArray[0] != null) {
            Method method = null;
            try {
                method = this.getClass().getMethod(string, classArray);
            }
            catch (Exception exception) {}
            if (method != null) {
                if (this.m_writeAccessMethods == null) {
                    this.m_writeAccessMethods = new IntHashtable();
                }
                this.m_writeAccessMethods.put(n, method);
                return;
            }
            System.out.println("AdminProp.registerProp(): Couldn't find write method\n    " + this.getClass().getName() + "." + string + "(" + classArray[0] + ");");
            return;
        }
        System.out.println("AdminProp.registerProp(): Couldn't determine write method signiture\n    " + this.getClass().getName() + "." + string + "(?);");
    }

    public void registerProp(int n, String string, String string2, String string3, String string4) {
        this.registerProp(n, string, string2);
        this.registerPropReadMethod(n, string3);
        this.registerPropWriteMethod(n, string4);
    }

    public void registerProp(int n, String string, String string2) {
        int n2 = n;
        if (this.m_Properties.get(n2) == null) {
            this.m_Properties.put(n2, m_null_value);
        }
        try {
            this.m_lang.setProp(n | 0x20000000, (Object)string);
            this.m_lang.setProp(n | 0x40000000, (Object)string2);
            return;
        }
        catch (PropertyException propertyException) {
            System.out.println("AdminProp::registerProp failed class = " + this.getClass().getName() + " PropId = 0x" + Integer.toHexString(n) + " name='" + string + "' desc='" + string2 + "'");
            return;
        }
    }

    public void registerProp(int n, String string, String string2, String string3) {
        this.registerProp(n, string, string2);
        this.setPropGroup(n, string3);
    }

    public void registerPropOnTabPage(int n, String string, String string2, String string3) {
        this.registerProp(n, string, string2);
        this.setPropTabPages(n, string3);
    }

    public void unregisterProp(int n) {
        try {
            this.deleteProp(n);
            this.m_lang.deleteProp(n | 0x20000000);
            this.m_lang.deleteProp(n | 0x40000000);
            return;
        }
        catch (PropertyException propertyException) {
            System.out.println("AdminProp::unregisterProp failed class = " + this.getClass().getName() + " PropId = 0x" + Integer.toHexString(n));
            return;
        }
    }

    public void registerPropRange(int n, int n2, int n3) {
        int[] nArray = new int[]{n2, n3};
        this.registerPropListOfValues(n, nArray);
        this.sendAdminPropertyChangeEvents(276758675, null);
    }

    public void registerPropHeight(int n, int n2) {
        if (this.m_dpyHeight == null) {
            this.m_dpyHeight = new IntHashtable();
        }
        this.m_dpyHeight.put(n, new Integer(n2));
    }

    public int[] getVisiblePropertyListOfHeight() throws PropertyException {
        int[] nArray = (int[])this.getProp(282001422);
        return this.getListOfHeight(nArray);
    }

    public int[] getListOfHeight(int[] nArray) throws PropertyException {
        return this.getListOfInt(nArray, this.m_dpyHeight);
    }

    public void registerPropWidth(int n, int n2) {
        if (this.m_dpyWidth == null) {
            this.m_dpyWidth = new IntHashtable();
        }
        this.m_dpyWidth.put(n, new Integer(n2));
    }

    public int[] getVisiblePropertyListOfWidth() throws PropertyException {
        int[] nArray = (int[])this.getProp(282001422);
        return this.getListOfWidth(nArray);
    }

    public int[] getListOfWidth(int[] nArray) throws PropertyException {
        return this.getListOfInt(nArray, this.m_dpyWidth);
    }

    public void registerPropLength(int n, int n2) {
        if (this.m_dpyLength == null) {
            this.m_dpyLength = new IntHashtable();
        }
        this.m_dpyLength.put(n, new Integer(n2));
    }

    public int[] getVisiblePropertyListOfLength() throws PropertyException {
        int[] nArray = (int[])this.getProp(282001422);
        return this.getListOfLength(nArray);
    }

    public int[] getListOfLength(int[] nArray) throws PropertyException {
        return this.getListOfInt(nArray, this.m_dpyLength);
    }

    public int[] getListOfInt(int[] nArray, IntHashtable intHashtable) throws PropertyException {
        if (intHashtable == null) {
            return null;
        }
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            Object object = intHashtable.get(nArray[n]);
            if (object != null) {
                nArray2[n] = (Integer)object;
            }
            ++n;
        }
        return nArray2;
    }

    public void setPropTabPages(int n, String string) {
        if (this.m_propTabPages == null) {
            this.m_propTabPages = new IntHashtable();
        }
        if (string == null) {
            this.m_propTabPages.remove(n);
            return;
        }
        this.m_propTabPages.put(n, string);
    }

    public String[] getPropTabPages(int[] nArray) throws PropertyException {
        if (this.m_propTabPages == null) {
            return null;
        }
        String[] stringArray = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            stringArray[n] = (String)this.m_propTabPages.get(nArray[n]);
            ++n;
        }
        return stringArray;
    }

    public String[] getPropTabPages() throws PropertyException {
        int[] nArray = (int[])this.getProp(282001422);
        return this.getPropTabPages(nArray);
    }

    public void registerTabPage(String string, int n) {
        if (this.m_registerTabPages == null) {
            this.m_registerTabPages = new Vector();
        }
        if (n < 0) {
            this.m_registerTabPages.insertElementAt(string, 0);
            return;
        }
        this.m_registerTabPages.setElementAt(string, n);
    }

    public String[] getTabNameList() {
        int n;
        Vector vector;
        block19: {
            String[] stringArray;
            vector = this.m_registerTabPages;
            n = 0;
            if (vector == null || vector.size() == 0) {
                try {
                    stringArray = this.getPropTabPages();
                    if (stringArray != null) {
                        vector = new Vector();
                        int n2 = 0;
                        while (n2 < stringArray.length) {
                            if (stringArray[n2] != null && !vector.contains(stringArray[n2])) {
                                vector.addElement(stringArray[n2]);
                            }
                            ++n2;
                        }
                        if (vector.size() == 0) {
                            return null;
                        }
                        break block19;
                    }
                    return null;
                }
                catch (Exception exception) {
                    this.unexpectedException(exception);
                }
            } else {
                try {
                    stringArray = this.getPropTabPages();
                    if (stringArray != null) {
                        Vector vector2 = vector;
                        int n3 = 0;
                        while (n3 < stringArray.length) {
                            if (stringArray[n3] != null && !vector2.contains(stringArray[n3])) {
                                if (vector2 == vector) {
                                    vector2 = (Vector)vector.clone();
                                }
                                vector2.addElement(stringArray[n3]);
                            }
                            ++n3;
                        }
                        vector = vector2;
                    }
                }
                catch (Exception exception) {
                    this.unexpectedException(exception);
                }
            }
        }
        int n4 = vector.size();
        int n5 = 0;
        while (n5 < n4) {
            Object e = vector.elementAt(n5);
            if (e != null && vector.indexOf(e) == n5) {
                ++n;
            }
            ++n5;
        }
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        n = 0;
        int n6 = 0;
        while (n6 < n4) {
            Object e = vector.elementAt(n6);
            if (e != null && vector.indexOf(e) == n6) {
                stringArray[n++] = (String)vector.elementAt(n6);
            }
            ++n6;
        }
        return stringArray;
    }

    public void setPropGroup(int n, String string) {
        if (this.m_propGroups == null) {
            this.m_propGroups = new IntHashtable();
        }
        if (string == null) {
            this.m_propGroups.remove(n);
            return;
        }
        this.m_propGroups.put(n, string);
    }

    public String[] getPropGroups() throws PropertyException {
        int[] nArray = (int[])this.getProp(282001422);
        return this.getPropGroups(nArray);
    }

    public String[] getPropGroups(int[] nArray) throws PropertyException {
        if (this.m_propGroups == null) {
            return null;
        }
        String[] stringArray = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            stringArray[n] = (String)this.m_propGroups.get(nArray[n]);
            ++n;
        }
        return stringArray;
    }

    public void setGroupLayout(String string, Object object) {
        if (object == null) {
            if (this.m_groupLayout != null) {
                this.m_groupLayout.remove(string);
                return;
            }
        } else {
            if (this.m_groupLayout == null) {
                this.m_groupLayout = new Hashtable();
            }
            this.m_groupLayout.put(string, object);
        }
    }

    public Hashtable getGroupLayout() {
        return this.m_groupLayout;
    }

    public void registerPropUnits(int n, int n2) {
    }

    public void registerPropUnits(int n, String string) {
        if (this.m_units == null) {
            this.m_units = new IntHashtable();
        }
        if (string == null) {
            this.m_units.remove(n);
        } else {
            this.m_units.put(n, string);
        }
        this.sendAdminPropertyChangeEvents(276758675, null);
    }

    public String[] getVisiblePropertyListOfUnits() throws PropertyException {
        int[] nArray = (int[])this.getProp(282001422);
        return this.getVisiblePropertyListOfUnits(nArray);
    }

    public String[] getVisiblePropertyListOfUnits(int[] nArray) throws PropertyException {
        if (this.m_units == null) {
            return null;
        }
        String[] stringArray = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            stringArray[n] = (String)this.m_units.get(nArray[n]);
            ++n;
        }
        return stringArray;
    }

    public void registerPropTranslations(int n, Hashtable hashtable) {
        this.registerPropListOfValues(n, hashtable);
    }

    public void registerMessage(int n, String string) {
        try {
            this.m_lang.setProp(n, (Object)string);
            return;
        }
        catch (PropertyException propertyException) {
            System.out.println("AdminProp::registerMessage failed class = " + this.getClass().getName() + " PropId = 0x" + Integer.toHexString(n) + " message = " + string);
            return;
        }
    }

    public int[] getPropListByType(int n, boolean bl) {
        int n2;
        int[] nArray = this.getPropList();
        if (nArray == null) {
            return null;
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < nArray.length) {
            n2 = nArray[n4] & n;
            if (bl) {
                if (n2 == 0) {
                    ++n3;
                }
            } else if (n2 != 0) {
                ++n3;
            }
            ++n4;
        }
        if (n3 == 0) {
            return null;
        }
        int[] nArray2 = new int[n3];
        int n5 = 0;
        n4 = 0;
        while (n4 < nArray.length) {
            n2 = nArray[n4] & n;
            if (bl) {
                if (n2 == 0) {
                    nArray2[n5++] = nArray[n4];
                }
            } else if (n2 != 0) {
                nArray2[n5++] = nArray[n4];
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < nArray2.length) {
            n5 = n4 + 1;
            while (n5 < nArray2.length) {
                if ((nArray2[n4] & 0xFFFF) > (nArray2[n5] & 0xFFFF)) {
                    int n6 = nArray2[n4];
                    nArray2[n4] = nArray2[n5];
                    nArray2[n5] = n6;
                }
                ++n5;
            }
            ++n4;
        }
        return nArray2;
    }

    public String getMessage(int n) {
        try {
            return (String)this.m_lang.getProp(n);
        }
        catch (PropertyException propertyException) {
            System.out.println("AdminProp::getMessage failed Class = " + this.getClass().getName() + " PropId = 0x" + Integer.toHexString(n));
            return "Unknown message  Class = " + this.getClass().getName() + " PropId = 0x" + Integer.toHexString(n);
        }
    }

    public String getMessage(int n, Object[] objectArray) throws PropertyException {
        String string = (String)this.m_lang.getProp(n);
        return this.getMessage(string, objectArray);
    }

    public String getMessage(String string, Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        MessageFormat messageFormat = new MessageFormat(string);
        messageFormat.format(objectArray, stringBuffer, (FieldPosition)null);
        return stringBuffer.toString();
    }

    public String getAdmPropURL() throws PropertyException {
        if (this.m_url != null) {
            return this.m_url;
        }
        this.m_url = (String)this.getProp(0x110001);
        return this.m_url;
    }

    public void registerPropListOfValues(int n, Object object) {
        if (this.m_lovs == null) {
            this.m_lovs = new IntHashtable();
        }
        if (object == null) {
            this.m_lovs.remove(n);
            return;
        }
        this.m_lovs.put(n, object);
    }

    public void unregisterPropListOfValues(int n) {
        if (this.m_lovs == null) {
            return;
        }
        this.m_lovs.remove(n);
    }

    public void unregisterPropRange(int n) {
        this.unregisterPropListOfValues(n);
    }

    public Object[] getVisiblePropertyListOfValues() throws PropertyException {
        int[] nArray = (int[])this.getProp(282001422);
        return this.getVisiblePropertyListOfValues(nArray);
    }

    public Object[] getVisiblePropertyListOfValues(int[] nArray) throws PropertyException {
        if (this.m_lovs == null) {
            return null;
        }
        Object[] objectArray = new Object[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            objectArray[n] = this.m_lovs.get(nArray[n]);
            ++n;
        }
        return objectArray;
    }

    public void registerAffectedPropList(int n, int[] nArray) {
        if (this.m_affectedPropList == null) {
            this.m_affectedPropList = new IntHashtable();
        }
        if (nArray == null) {
            this.m_affectedPropList.remove(n);
            return;
        }
        this.m_affectedPropList.put(n, nArray);
    }

    public void unregisterAffectedPropList(int n) {
        if (this.m_affectedPropList == null) {
            return;
        }
        this.m_affectedPropList.remove(n);
    }

    public int[] getAffectedPropList(int[] nArray) {
        if (this.m_affectedPropList == null) {
            return null;
        }
        Vector<Integer> vector = null;
        int n = 0;
        while (n < nArray.length) {
            int[] nArray2 = (int[])this.m_affectedPropList.get(nArray[n]);
            if (nArray2 != null && nArray2.length != 0) {
                if (vector == null) {
                    vector = new Vector<Integer>();
                }
                int n2 = 0;
                while (n2 < nArray2.length) {
                    Integer n3 = new Integer(nArray2[n]);
                    if (!vector.contains(n3)) {
                        vector.addElement(n3);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        if (vector == null) {
            return null;
        }
        int n4 = vector.size();
        int[] nArray3 = new int[n4];
        int n5 = 0;
        while (n5 < n4) {
            nArray3[n5] = (Integer)vector.elementAt(n5);
            ++n5;
        }
        return nArray3;
    }

    public void registerPropMaxLength(int n, int n2) {
    }

    public static void main(String[] stringArray) {
        int[] nArray;
        Object[] objectArray;
        AdminProp adminProp = new AdminProp();
        int n = 0x102000;
        int n2 = 0x202001;
        int n3 = 0x102002;
        int n4 = 0x202003;
        Integer n5 = new Integer(10);
        String string = "Test";
        System.out.print("Starting tests of AdminProp\n");
        try {
            adminProp.setProp(n, (Object)string);
            if (!adminProp.getProp(n).equals(string)) {
                System.out.print("test1: Simple get props failed\n");
            }
        }
        catch (PropertyException propertyException) {
            System.out.print("test1: Property operation failed type=" + propertyException.GetType());
            return;
        }
        try {
            adminProp.setProp(n2, (Object)n5);
            if (!adminProp.getProp(n2).equals(n5)) {
                System.out.print("test2: Simple get props failed");
            }
        }
        catch (PropertyException propertyException) {
            System.out.print("test2: Property operation failed type=" + propertyException.GetType());
            return;
        }
        int[] nArray2 = new int[]{n, n2};
        try {
            objectArray = adminProp.getProps(nArray2);
            if (objectArray.length != 2) {
                System.out.print("test3: Multiple property get produces unexpected number of values. expected=2, got=" + objectArray.length);
            }
            if (!objectArray[0].equals(string) || !objectArray[1].equals(n5)) {
                System.out.print("test3: Simple get props failed");
            }
        }
        catch (PropertyException propertyException) {
            System.out.print("test3: Property operation failed type=" + propertyException.GetType());
        }
        nArray2[0] = n3;
        nArray2[1] = n4;
        objectArray = new Object[]{string, n5};
        try {
            adminProp.setProps(nArray2, objectArray);
        }
        catch (PropertyException propertyException) {
            System.out.print("test3: Property operation failed type=" + propertyException.GetType());
        }
        int[] nArray3 = adminProp.getPropList();
        if (nArray3.length < 4) {
            System.out.print("test4: Property list is smaller than expected\n");
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (n8 < nArray3.length) {
            if (nArray3[n8] == n) {
                ++n6;
                n7 |= 1;
            } else if (nArray3[n8] == n2) {
                ++n6;
                n7 |= 2;
            } else if (nArray3[n8] == n3) {
                ++n6;
                n7 |= 4;
            } else if (nArray3[n8] == n4) {
                ++n6;
                n7 |= 8;
            }
            ++n8;
        }
        if (n6 != 4 || (~n7 & 0xF) != 0) {
            System.out.print("test4: PropertList seems incomplete\n");
        }
        try {
            adminProp.deleteProp(n);
            if (adminProp.getProp(n) != null) {
                System.out.print("test5: delete property failed\n");
            }
        }
        catch (PropertyException propertyException) {
            System.out.print("test5: Property operation failed type=" + propertyException.GetType());
        }
        if ((nArray = adminProp.getPropList()).length < 3) {
            System.out.print("test5a: Property list is smaller than expected\n");
        }
        int n9 = 0;
        while (n9 < nArray.length) {
            if (nArray[n9] == n) {
                System.out.print("test5a: Delete of property didn't change property list.\n");
            }
            ++n9;
        }
        try {
            adminProp.deleteProps(nArray2);
            if (adminProp.getProp(n3) != null) {
                System.out.print("test6: delete property failed\n");
            }
            if (adminProp.getProp(n4) != null) {
                System.out.print("test6: delete property failed\n");
            }
        }
        catch (PropertyException propertyException) {
            System.out.print("test6: Property operation failed type=" + propertyException.GetType());
        }
        try {
            adminProp.setProp(282001412, null);
            System.out.print("test7: was able to set readonly property\n");
        }
        catch (PropertyException propertyException) {}
        try {
            adminProp.saveChanges(0);
        }
        catch (SaveChangeException saveChangeException) {
            System.out.print("test8: unable to call saveChanges\n");
        }
        String string2 = "String1";
        String string3 = "This is a test string 1";
        adminProp.registerProp(n, string2, string3);
        adminProp.registerProp(n2, "Integer1", "This is a test integer 1");
        adminProp.registerProp(n3, "String2", "This is a test string 2");
        adminProp.registerProp(n4, "Integer2", "This is a test integer 2");
        if (!adminProp.getPropName(n).equals(string2)) {
            System.out.print("test9: Unable to get name of register prop\n");
        }
        if (!adminProp.getPropDescription(n).equals(string3)) {
            System.out.print("test9: Unable to get name of register prop\n");
        }
        adminProp.unregisterProp(n);
        adminProp.unregisterProp(n2);
        adminProp.unregisterProp(n3);
        adminProp.unregisterProp(n4);
        try {
            int[] nArray4 = (int[])adminProp.getProp(282001412);
            int[] nArray5 = (int[])adminProp.getProp(282001422);
            if (nArray4 == null) {
                System.out.println("test10: propList is null");
            }
            if (nArray5 == null) {
                System.out.println("test10: visiblePropList is null");
            } else if (nArray4.length == nArray5.length) {
                System.out.println("test10: visible property list equal to total property list is unexpected");
            } else {
                int n10 = 0;
                while (n10 < nArray5.length) {
                    if ((nArray5[n10] & 0x10000) != 0) {
                        System.out.println("test10: visible property list  has non-visible member");
                    }
                    ++n10;
                }
                int n11 = 0;
                while (n11 < nArray4.length) {
                    if ((nArray4[n11] & 0x10000) == 0) {
                        n10 = 0;
                        while (n10 < nArray5.length) {
                            if (nArray5[n10] == nArray4[n11]) break;
                            ++n10;
                        }
                        if (n10 == nArray5.length) {
                            System.out.println("test10: found visible property not included in PR_VISIBLE_PROPERTY_LIST");
                        }
                    }
                    ++n11;
                }
            }
        }
        catch (PropertyException propertyException) {
            System.out.println("test10: property exeception prevented test");
        }
        System.out.print("Ending tests of AdminProp\n");
    }

    public static Vector objectArrayToVector(Object[] objectArray) {
        return Util.objectArrayToVector(objectArray);
    }

    public static Object[] vectorToObjectArray(Vector vector) {
        return Util.vectorToObjectArray(vector);
    }

    public static String[] vectorToStringArray(Vector vector) {
        return Util.vectorToStringArray(vector);
    }

    public static Object[] cloneAdminPropArray(AdminProp[] adminPropArray) {
        return Util.cloneAdminPropArray(adminPropArray);
    }

    public void printDebug(PrintStream printStream) {
        this.printDebug(printStream, true, true, false);
    }

    public static void printDebug(PrintStream printStream, Vector vector, boolean bl, boolean bl2, boolean bl3) {
        if (vector == null) {
            return;
        }
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            try {
                AdminProp adminProp = (AdminProp)vector.elementAt(n2);
                printStream.println("Element[" + n2 + "] = " + adminProp.getClass().getName());
                adminProp.printDebug(printStream, bl, bl2, bl3);
            }
            catch (ClassCastException classCastException) {
                AdminProp.sUnexpectedException(classCastException);
            }
            ++n2;
        }
    }

    public static void printDebug(PrintStream printStream, AdminProp[] adminPropArray, boolean bl, boolean bl2, boolean bl3) {
        if (adminPropArray == null) {
            return;
        }
        int n = 0;
        while (n < adminPropArray.length) {
            try {
                AdminProp adminProp = adminPropArray[n];
                printStream.println("Element[" + n + "] = " + adminProp.getClass().getName());
                adminProp.printDebug(printStream, bl, bl2, bl3);
            }
            catch (ClassCastException classCastException) {
                AdminProp.sUnexpectedException(classCastException);
            }
            ++n;
        }
    }

    public static void printDebugValue(PrintStream printStream, int n, Object object, String string, boolean bl, boolean bl2, boolean bl3) {
        String string2 = "                    ";
        if (!bl2 && object == null) {
            return;
        }
        if (AdminProp.isPropHidden(n)) {
            if (!bl) {
                return;
            }
            printStream.print("*");
        } else {
            printStream.print(" ");
        }
        String string3 = bl3 ? String.valueOf(string == null ? "<noname>" : string) + " " + "0x" + Integer.toHexString(n) + " " : String.valueOf(string == null ? "<noname>" : string) + " ";
        printStream.print(string3);
        if (string3.length() < string2.length()) {
            printStream.print(string2.substring(string3.length()));
        }
        if (AdminProp.isPropArray(n) && object != null) {
            if (AdminProp.getPropType(n) == 0x10C00000) {
                int[] nArray = (int[])object;
                int n2 = 0;
                while (n2 < nArray.length) {
                    printStream.print("[" + n2 + "] ");
                    printStream.println(String.valueOf(nArray[n2]) + " /* 0x" + Integer.toHexString(nArray[n2]) + " */");
                    if (n2 != nArray.length - 1) {
                        printStream.print(" ");
                        printStream.print(string2);
                    }
                    ++n2;
                }
                return;
            }
            Object[] objectArray = null;
            try {
                objectArray = (Object[])object;
            }
            catch (ClassCastException classCastException) {
                System.out.println("objarr class=" + object.getClass().getName());
                classCastException.printStackTrace();
            }
            if (objectArray != null) {
                int n3 = 0;
                while (n3 < objectArray.length) {
                    int n4;
                    Object[] objectArray2;
                    printStream.print("[" + n3 + "] ");
                    if (objectArray[n3] instanceof Object[]) {
                        objectArray2 = (Object[])objectArray[n3];
                        printStream.print("(");
                        n4 = 0;
                        while (n4 < objectArray2.length) {
                            if (objectArray2[n4] instanceof String) {
                                printStream.print("\"");
                            }
                            if (objectArray2[n4] instanceof IAdminProp) {
                                try {
                                    printStream.println(((IAdminProp)objectArray2[n4]).getProp(0x110001));
                                }
                                catch (Exception exception) {}
                            } else {
                                printStream.print(objectArray2[n4] == null ? "<novalue>" : objectArray2[n4].toString());
                            }
                            if (objectArray2[n4] instanceof String) {
                                printStream.print("\"");
                            }
                            if (n4 + 1 < objectArray2.length) {
                                printStream.print(", ");
                            }
                            ++n4;
                        }
                        printStream.println(")");
                    } else if (objectArray[n3] instanceof int[]) {
                        objectArray2 = (int[])objectArray[n3];
                        printStream.print("(");
                        n4 = 0;
                        while (n4 < objectArray2.length) {
                            printStream.print((int)objectArray2[n4]);
                            if (n4 + 1 < objectArray2.length) {
                                printStream.print(", ");
                            }
                            ++n4;
                        }
                        printStream.println(")");
                    } else if (objectArray[n3] instanceof IAdminProp) {
                        try {
                            printStream.println(((IAdminProp)objectArray[n3]).getProp(0x110001));
                        }
                        catch (Exception exception) {}
                    } else {
                        printStream.println(objectArray[n3] == null ? "<novalue>" : objectArray[n3].toString());
                    }
                    if (n3 != objectArray.length - 1) {
                        printStream.print(" ");
                        printStream.print(string2);
                    }
                    ++n3;
                }
                return;
            }
        } else {
            if (n == 3080204) {
                if (!(object instanceof Integer)) {
                    printStream.println(object == null ? "<novalue>" : "0x" + Integer.toHexString((Integer)object));
                    return;
                }
                int n5 = (Integer)object;
                Field[] fieldArray = (class$oracle$ldap$admin$common$IAdminProp != null ? class$oracle$ldap$admin$common$IAdminProp : (class$oracle$ldap$admin$common$IAdminProp = AdminProp.class$("oracle.ldap.admin.common.IAdminProp"))).getFields();
                AdminProp adminProp = new AdminProp();
                int n6 = 0;
                while (n6 < fieldArray.length) {
                    String string4 = fieldArray[n6].getName();
                    if (string4.startsWith("STATUS_")) {
                        try {
                            int n7 = fieldArray[n6].getInt(adminProp);
                            if (n7 != 0 && (n5 & n7) == n7) {
                                n5 &= ~n7;
                                printStream.print(string4);
                                printStream.print("|");
                            }
                        }
                        catch (Exception exception) {}
                    }
                    ++n6;
                }
                printStream.println();
                return;
            }
            if (object instanceof IAdminProp) {
                try {
                    printStream.println(((IAdminProp)object).getProp(0x110001));
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }
            printStream.println(object == null ? "<novalue>" : object.toString());
        }
    }

    public void printDebug(PrintStream printStream, boolean bl, boolean bl2, boolean bl3) {
        Object[] objectArray;
        int[] nArray = this.getPropList();
        if (nArray == null) {
            printStream.println("No property list!!");
            return;
        }
        try {
            objectArray = this.getProps(nArray);
        }
        catch (PropertyException propertyException) {
            printStream.println("Couldn't get property values");
            propertyException.printStackTrace();
            return;
        }
        if (objectArray == null) {
            printStream.println("No value list!!");
            return;
        }
        String[] stringArray = this.getPropNames(nArray);
        if (stringArray == null) {
            printStream.println("No name list!!");
            return;
        }
        int n = 0;
        while (n < nArray.length) {
            AdminProp.printDebugValue(printStream, nArray[n], objectArray[n], stringArray[n], bl, bl2, bl3);
            ++n;
        }
    }

    public void printDebugTraverse(PrintStream printStream, boolean bl, boolean bl2, boolean bl3) {
        try {
            printStream.println("----- " + this.getProp(0x110001) + "-----");
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
        }
        this.printDebug(printStream, bl, bl2, bl3);
        try {
            AdminProp[] adminPropArray = (AdminProp[])this.getProp(273612805);
            if (adminPropArray != null) {
                printStream.println("{ Children");
                int n = 0;
                while (n < adminPropArray.length) {
                    adminPropArray[n].printDebugTraverse(printStream, bl, bl2, bl3);
                    adminPropArray[n] = null;
                    ++n;
                }
                printStream.println("}");
                return;
            }
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
        }
    }

    public String toString() {
        if (this.lockAccessTo_toString) {
            return super.toString();
        }
        this.lockAccessTo_toString = true;
        try {
            String string = (String)this.getProp(0x110001);
            this.lockAccessTo_toString = false;
            if (string != null) {
                return string;
            }
        }
        catch (PropertyException propertyException) {}
        this.lockAccessTo_toString = false;
        return super.toString();
    }

    public void setDebug(boolean bl) {
        this.m_bDebug = bl;
    }

    public boolean isDebug() {
        return this.m_bDebug;
    }

    public void debugMessage(String string) {
        if (this.m_bDebug) {
            AdminProp.sDebugMessage(string);
        }
    }

    public void debugMessageLn(String string) {
        if (this.m_bDebug) {
            AdminProp.sDebugMessageLn(string);
        }
        this.sendAdminPropertyChangeEvents(2031762, string);
    }

    public static void sDebugMessage(String string) {
        System.out.print(string);
    }

    public static void sDebugMessageLn(String string) {
        System.out.println(string);
    }

    public static void errorMessage(String string) {
        System.out.print(string);
    }

    public static void errorMessageLn(String string) {
        System.out.println(string);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return super.equals(object);
        }
        try {
            AdminProp adminProp = (AdminProp)object;
            int[] nArray = (int[])this.getProp(281608214);
            if (nArray == null) {
                nArray = this.getPropList();
            }
            if (nArray == null) {
                return super.equals(object);
            }
            int n = 0;
            while (n < nArray.length) {
                Object object2;
                Object object3 = this.getProp(nArray[n]);
                if (object3 != (object2 = adminProp.getProp(nArray[n]))) {
                    if (object3 != null != (object2 != null)) {
                        return false;
                    }
                    if (object3 instanceof AdminProp) {
                        return false;
                    }
                    if (!object3.equals(object2)) {
                        return false;
                    }
                }
                ++n;
            }
            return true;
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
            return super.equals(object);
        }
    }

    public void copyTo(IAdminProp iAdminProp, int[] nArray) throws PropertyException {
        PropertyException propertyException = null;
        PropertyException propertyException2 = null;
        if (nArray == null) {
            nArray = this.getPropList();
        }
        if (nArray == null) {
            return;
        }
        int n = 0;
        while (n < nArray.length) {
            try {
                Object object = this.getProp(nArray[n]);
                iAdminProp.setProp(nArray[n], object);
            }
            catch (PropertyException propertyException3) {
                if (propertyException == null) {
                    propertyException = propertyException2 = propertyException3;
                }
                propertyException2.SetNext(propertyException3);
                propertyException2 = propertyException3;
            }
            ++n;
        }
        if (propertyException != null) {
            throw propertyException;
        }
    }

    public void copyTo(IAdminProp iAdminProp) throws PropertyException {
        this.copyTo(iAdminProp, (int[])this.getProp(281608215));
    }

    public void unexpectedException(Exception exception) {
        AdminProp.sUnexpectedException(exception);
    }

    public static void sUnexpectedException(Exception exception) {
        exception.printStackTrace();
        AdminProp.errorMessageLn("Unexpected Exception " + exception);
    }

    public boolean getBoolean(int n) throws PropertyException {
        Boolean bl = (Boolean)this.getProp(n);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public int getInt(int n) throws PropertyException {
        Integer n2 = (Integer)this.getProp(n);
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    public static boolean vectorContains(Vector vector, Object object) {
        return Util.vectorContains(vector, object);
    }

    public static int vectorIndexOf(Vector vector, Object object) {
        return Util.vectorIndexOf(vector, object);
    }

    public static boolean vectorContainsIgnoreCase(Vector vector, String string) {
        return Util.vectorContainsIgnoreCase(vector, string);
    }

    public static void subtract(Vector vector, Vector vector2) {
        Util.subtract(vector, vector2);
    }

    public static void intersect(Vector vector, Vector vector2) {
        Util.intersect(vector, vector2);
    }

    public static int compareToIgnoreCase(String string, String string2) {
        return Util.compareToIgnoreCase(string, string2);
    }

    public static int addSortedCmp(Object object, Object object2) {
        return Util.addSortedCmp(object, object2);
    }

    public static void addSorted(Vector vector, IAdminProp iAdminProp, int n) {
        Util.addSorted(vector, iAdminProp, n);
    }

    public static void addSorted(Vector vector, IAdminProp iAdminProp) {
        Util.addSorted(vector, iAdminProp, 0x110001);
    }

    public static int count(Vector vector, int n, Object object, int n2) {
        return Util.count(vector, n, object, n2);
    }

    public static Object[] findObjects(Vector vector, int n, Object object) {
        return Util.findObjects(vector, n, object);
    }

    public static Object[] findObjects(IAdminProp[] iAdminPropArray, int n, Object object) {
        return Util.findObjects(iAdminPropArray, n, object);
    }

    public static Object findObject(Vector vector, int n, Object object) {
        return Util.findObject(vector, n, object);
    }

    public static Object findObject(IAdminProp[] iAdminPropArray, int n, Object object) {
        return Util.findObject(iAdminPropArray, n, object);
    }

    static boolean keyEqualsValue(IAdminProp iAdminProp, Object object, int n) {
        return Util.keyEqualsValue(iAdminProp, object, n);
    }

    public void makeInvalid() {
        this.sendAdminPropertyChangeEvents(8454179, Boolean.FALSE);
    }

    public static void handleLOVNotification(IAdminProp iAdminProp, boolean bl) throws SaveChangeException {
        AdminProp.handleLOVNotification(iAdminProp, bl, 273220105);
    }

    public static void handleLOVNotification(IAdminProp iAdminProp, boolean bl, int n) throws SaveChangeException {
        try {
            int n2;
            int n3;
            IAdminProp[] iAdminPropArray = (IAdminProp[])iAdminProp.getProp(n);
            if (iAdminPropArray == null || iAdminPropArray.length == 0) {
                if (bl) {
                    System.out.println("AdminDirectory.saveChanges: Selection is null");
                }
                return;
            }
            IAdminProp iAdminProp2 = (IAdminProp)iAdminProp.getProp(4260001);
            if (iAdminProp2 == null) {
                if (bl) {
                    System.out.println("AdminDirectory.saveChanges: finder obj is null");
                }
                return;
            }
            iAdminProp2.setProp(272695458, iAdminPropArray);
            Integer n4 = (Integer)iAdminProp.getProp(2162850);
            if (n4 == null) {
                if (bl) {
                    System.out.println("AdminDirectory.saveChanges: finder prop is null");
                }
                return;
            }
            int n5 = n3 = n4.intValue();
            Integer n6 = (Integer)iAdminProp.getProp(2163785);
            if (n6 != null && ((n2 = n6.intValue()) & 1) != 0) {
                iAdminProp2 = iAdminProp;
                n3 = 7405739;
                if (bl) {
                    System.out.println("AdminDirectory.saveChanges: notif client only");
                }
            }
            int[] nArray = new int[]{n3};
            switch (AdminProp.getPropType(n4)) {
                case 0x10400000: {
                    int n7;
                    IAdminProp[] iAdminPropArray2;
                    if (bl) {
                        System.out.println("AdminDirectory.saveChanges: val type is adminobj[]");
                    }
                    if ((iAdminPropArray2 = (IAdminProp[])iAdminProp2.getProp(n3)) == null || iAdminPropArray2.length == 0) {
                        if (bl) {
                            System.out.println("AdminDirectory.saveChanges: current vals null");
                        }
                        Object[] objectArray = new Object[]{iAdminPropArray};
                        iAdminProp2.setProps(nArray, objectArray);
                        return;
                    }
                    int n8 = 0;
                    int n9 = 0;
                    while (n9 < iAdminPropArray2.length) {
                        n7 = 0;
                        while (n7 < iAdminPropArray.length) {
                            if (iAdminPropArray2[n9] == iAdminPropArray[n7]) break;
                            ++n7;
                        }
                        if (n9 == iAdminPropArray.length) {
                            ++n8;
                        }
                        ++n9;
                    }
                    if (n8 <= 0) break;
                    IAdminProp[] iAdminPropArray3 = new IAdminProp[n8 += iAdminPropArray2.length];
                    n7 = 0;
                    while (n7 < iAdminPropArray2.length) {
                        iAdminPropArray3[n7] = iAdminPropArray2[n7];
                        ++n7;
                    }
                    n8 = 0;
                    int n10 = 0;
                    while (n10 < iAdminPropArray.length) {
                        int n11 = 0;
                        while (n11 < iAdminPropArray2.length) {
                            if (iAdminPropArray2[n11] == iAdminPropArray[n10]) break;
                            ++n11;
                        }
                        if (n11 == iAdminPropArray2.length) {
                            iAdminPropArray3[iAdminPropArray2.length + n8++] = iAdminPropArray[n10];
                        }
                        ++n10;
                    }
                    Object[] objectArray = new Object[]{iAdminPropArray3};
                    iAdminProp2.setProps(nArray, objectArray);
                    return;
                }
                case 0x400000: {
                    if (bl) {
                        System.out.println("AdminDirectory.saveChanges: val type is adminobj");
                    }
                    int n12 = 0;
                    while (n12 < iAdminPropArray.length) {
                        Object[] objectArray = new Object[]{iAdminPropArray[n12]};
                        iAdminProp2.setProps(nArray, objectArray);
                        ++n12;
                    }
                    return;
                }
                default: {
                    Integer n13;
                    if (bl) {
                        System.out.println("AdminDirectory.saveChanges: val type is unknown");
                    }
                    if ((n13 = (Integer)iAdminProp.getProp(2162855)) == null) {
                        n13 = new Integer(0x110001);
                    }
                    if (AdminProp.isPropArray(n3) || n3 == 7405739 && AdminProp.isPropArray(n5) && iAdminPropArray.length > 1) {
                        if (bl) {
                            System.out.println("AdminDirectory.saveChanges: setting array finder objs prop");
                        }
                        Object[] objectArray = new Object[iAdminPropArray.length];
                        Object[] objectArray2 = new Object[]{objectArray};
                        int n14 = 0;
                        while (n14 < iAdminPropArray.length) {
                            objectArray[n14] = iAdminPropArray[n14].getProp(n13);
                            if (bl) {
                                System.out.println("AdminDirectory.saveChanges: setting finder obj prop " + n14 + " " + objectArray[n14]);
                            }
                            ++n14;
                        }
                        iAdminProp2.setProps(nArray, objectArray2);
                        return;
                    }
                    Object[] objectArray = new Object[]{iAdminPropArray[0].getProp(n13)};
                    if (bl) {
                        System.out.println("AdminDirectory.saveChanges: setting finder obj prop " + objectArray[0]);
                    }
                    iAdminProp2.setProps(nArray, objectArray);
                }
            }
            return;
        }
        catch (Exception exception) {
            throw new SaveChangeException(exception.getMessage());
        }
    }

    public static String parseDate(String string) {
        String string2 = string;
        DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 1);
        try {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(Integer.parseInt(string.substring(0, 4)), Integer.parseInt(string.substring(4, 6)) - 1, Integer.parseInt(string.substring(6, 8)), Integer.parseInt(string.substring(8, 10)), Integer.parseInt(string.substring(10, 12)), Integer.parseInt(string.substring(12, 14)));
            string2 = dateFormat.format(gregorianCalendar.getTime());
        }
        catch (Exception exception) {
            string2 = null;
        }
        return string2;
    }

    public static Calendar parseCalendar(String string) {
        try {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(Integer.parseInt(string.substring(0, 4)), Integer.parseInt(string.substring(4, 6)) - 1, Integer.parseInt(string.substring(6, 8)), Integer.parseInt(string.substring(8, 10)), Integer.parseInt(string.substring(10, 12)), Integer.parseInt(string.substring(12, 14)));
            return gregorianCalendar;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String convertCalendar2String(Calendar calendar) {
        try {
            String string;
            String string2;
            String string3;
            String string4 = new Integer(calendar.get(1)).toString();
            String string5 = new Integer(calendar.get(2) + 1).toString();
            if (string5.length() == 1) {
                string5 = "0" + string5;
            }
            if ((string3 = new Integer(calendar.get(5)).toString()).length() == 1) {
                string3 = "0" + string3;
            }
            if ((string2 = new Integer(calendar.get(10)).toString()) == null || string2.length() == 0) {
                string2 = "00";
            } else if (string2.length() == 1) {
                string2 = "0" + string2;
            }
            String string6 = new Integer(calendar.get(12)).toString();
            if (string6 == null || string6.length() == 0) {
                string6 = "00";
            }
            if (string6.length() == 1) {
                string6 = "0" + string6;
            }
            if ((string = new Integer(calendar.get(12)).toString()) == null || string.length() == 0) {
                string = "00";
            }
            if (string.length() == 1) {
                string = "0" + string;
            }
            String string7 = String.valueOf(string4) + string5 + string3 + string2 + string6 + string;
            return string7;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        m_null_value = new NullValue();
        initCachePropList = new int[]{2686979, 3080204, 0x110001, 1114150, 3080231};
        initCacheTablePropList = new int[]{0x10110021, 281083936, 282001424, 2686995};
    }

    private static class NullValue {
        NullValue() {
        }
    }
}

