/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.common;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Enumeration;
import oracle.ldap.admin.common.URLEnumerator;

public class AdminURL
implements Serializable {
    public static final String COLON_SEPARATOR = ":";
    public static final String FWD_SLASH_SEPARATOR = "/";
    public static final String PATH_SEPARATOR = "/";
    public static final String DOMAIN_SEPARATOR = "@";
    public static final String DN_MODIFIER_L = "(";
    public static final String DN_MODIFIER_R = ")";
    public static final String DN_MODIFIER_PREFIX = "0x";
    public static final String VIEW_MODIFIER_L = "[";
    public static final String VIEW_MODIFIER_R = "]";
    String m_url;
    String m_path;
    transient String m_next;

    private void init() {
        this.m_url = null;
        this.m_next = null;
        this.m_path = null;
    }

    public AdminURL(String string) throws MalformedURLException {
        this.init();
        this.m_url = string;
    }

    public AdminURL(String string, String string2) throws MalformedURLException {
        this.init();
        this.m_url = String.valueOf(string) + "/" + string2;
    }

    public AdminURL(String string, String string2, String string3, int n) throws MalformedURLException {
        String string4 = AdminURL.makeComponent(string2, string3, n);
        this.init();
        this.m_url = String.valueOf(string) + "/" + string4;
    }

    public AdminURL(String string, String string2, String string3) throws MalformedURLException {
        this(string, string2, string3, -1);
    }

    public AdminURL(String string, String string2, int n) throws MalformedURLException {
        this(string, string2, null, n);
    }

    public String getPath() {
        if (this.m_path != null) {
            return this.m_path;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < 3) {
            n2 = this.m_url.indexOf("/", n);
            if (n2 == -1) break;
            n = n2 + 1;
            ++n3;
        }
        this.m_path = this.m_url.substring(n2);
        return this.m_path;
    }

    public Enumeration getPathEnumerator() {
        return new URLEnumerator(this.getPath());
    }

    public String toString() {
        return this.m_url;
    }

    public static String makeComponent(String string, String string2, int n) {
        if (string2 == null && n == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (string2 != null) {
            stringBuffer.append(DOMAIN_SEPARATOR + string2);
        }
        if (n != -1) {
            stringBuffer.append("(0x" + Integer.toHexString(n) + DN_MODIFIER_R);
        }
        return stringBuffer.toString();
    }

    public static String makeComponent(String string, String string2) {
        return AdminURL.makeComponent(string, string2, -1);
    }

    public static String makeComponent(String string, int n) {
        return AdminURL.makeComponent(string, null, n);
    }

    public static String makeComponent(String string) {
        return AdminURL.makeComponent(string, null, -1);
    }

    public static String makeViewComponent(String string, String string2, int n, String string3) {
        String string4 = AdminURL.makeComponent(string, string2, n);
        if (string3 == null) {
            return string4;
        }
        return String.valueOf(string4) + VIEW_MODIFIER_L + string3 + VIEW_MODIFIER_R;
    }

    public static String makeViewComponent(String string, String string2, String string3) {
        return AdminURL.makeViewComponent(string, string2, -1, string3);
    }

    public static String makeViewComponent(String string, int n, String string2) {
        return AdminURL.makeViewComponent(string, null, n, string2);
    }

    public static String makeViewComponent(String string, String string2) {
        return AdminURL.makeViewComponent(string, null, -1, string2);
    }

    public static String getObjComponent(String string) {
        int n = string.lastIndexOf(DN_MODIFIER_L);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String getComponentDN(String string) {
        int n = string.indexOf(DOMAIN_SEPARATOR);
        if (n == -1) {
            n = string.indexOf(DN_MODIFIER_L);
        }
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String getComponentDomain(String string) {
        int n = string.indexOf(DOMAIN_SEPARATOR);
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf(DN_MODIFIER_L);
        if (n2 == -1) {
            return string.substring(n + 1);
        }
        return string.substring(n + 1, n2);
    }

    public static int getComponentModifier(String string) throws MalformedURLException, NumberFormatException {
        int n = string.lastIndexOf(DN_MODIFIER_PREFIX);
        if (n == -1) {
            return -1;
        }
        int n2 = string.indexOf(DN_MODIFIER_R, n);
        if (n2 == -1) {
            throw new MalformedURLException(string);
        }
        return Integer.parseInt(string.substring(n + DN_MODIFIER_PREFIX.length(), n2), 16);
    }

    public static boolean isViewURL(String string) {
        return string.indexOf(VIEW_MODIFIER_L) != -1;
    }

    public static String getViewComponent(String string) {
        int n = string.indexOf(VIEW_MODIFIER_L);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n);
    }

    public static String getViewObject(String string) throws MalformedURLException {
        int n = string.indexOf(VIEW_MODIFIER_L);
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf(VIEW_MODIFIER_R);
        if (n2 == -1) {
            throw new MalformedURLException(string);
        }
        return string.substring(n + VIEW_MODIFIER_L.length(), n2);
    }

    public static String getViewDN(String string) {
        String string2 = AdminURL.getViewComponent(string);
        if (string2 == null) {
            return null;
        }
        return AdminURL.getComponentDN(string2);
    }

    public static String getViewDomain(String string) {
        String string2 = AdminURL.getViewComponent(string);
        if (string2 == null) {
            return null;
        }
        return AdminURL.getComponentDomain(string2);
    }

    public static int getViewModifier(String string) throws MalformedURLException, NumberFormatException {
        String string2 = AdminURL.getViewComponent(string);
        if (string2 == null) {
            return -1;
        }
        return AdminURL.getComponentModifier(string2);
    }

    public static void main(String[] stringArray) {
        String string;
        Object object;
        AdminURL adminURL;
        String[] stringArray2;
        System.out.println("Starting AdminURL tests.");
        String string2 = "Submission-1";
        String string3 = "chacha";
        int n = 273612805;
        String string4 = AdminURL.makeComponent(string2, string3, n);
        String string5 = AdminURL.makeComponent(string2, string3);
        String string6 = AdminURL.makeComponent(string2, n);
        String string7 = AdminURL.makeComponent(string2);
        if (!string4.equals(String.valueOf(string2) + DOMAIN_SEPARATOR + string3 + DN_MODIFIER_L + DN_MODIFIER_PREFIX + Integer.toHexString(n) + DN_MODIFIER_R)) {
            System.out.println("AdminURL::Util Test: Full makeComp failed.");
        }
        if (!string5.equals(String.valueOf(string2) + DOMAIN_SEPARATOR + string3)) {
            System.out.println("AdminURL::Util Test: Domain makeComp failed.");
        }
        if (!string6.equals(String.valueOf(string2) + DN_MODIFIER_L + DN_MODIFIER_PREFIX + Integer.toHexString(n) + DN_MODIFIER_R)) {
            System.out.println("AdminURL::Util Test: Mod makeComp failed.");
        }
        if (!string7.equals(string2)) {
            System.out.println("AdminURL::Util Test: Simple makeComp failed.");
        }
        if (!string2.equals(AdminURL.getComponentDN(string4))) {
            System.out.println("AdminURL::Util Test: getCompDN failed.");
        }
        if (!string3.equals(AdminURL.getComponentDomain(string4))) {
            System.out.println("AdminURL::Util Test: getCompDomain failed.");
        }
        try {
            if (n != AdminURL.getComponentModifier(string4)) {
                System.out.println("AdminURL::Util Test: getCompMod failed.");
            }
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("AdminURL::Util Test: getCompMod failed: ");
            malformedURLException.printStackTrace();
        }
        String string8 = "http://AdminRoot";
        String string9 = String.valueOf(string8) + "/" + string4;
        try {
            stringArray2 = new AdminURL(string9);
            if (!string9.equals(stringArray2.toString())) {
                System.out.println("AdminURL::Construct Tst: simple failed: " + stringArray2.toString());
            }
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("AdminURL::Construct Tst: simple excepted.");
            malformedURLException.printStackTrace();
        }
        try {
            stringArray2 = new AdminURL(string8, string4);
            if (!string9.equals(stringArray2.toString())) {
                System.out.println("AdminURL::Construct Tst: 2 part failed: " + stringArray2.toString());
            }
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("AdminURL::Construct Tst: 2 part excepted.");
            malformedURLException.printStackTrace();
        }
        try {
            stringArray2 = new AdminURL(string8, string2, string3, n);
            if (!string9.equals(stringArray2.toString())) {
                System.out.println("AdminURL::Construct Tst: multi failed: " + stringArray2.toString());
            }
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("AdminURL::Construct Tst: multi excepted.");
            malformedURLException.printStackTrace();
        }
        stringArray2 = new String[]{"AdminRoot", "Msging", "US.ORACLE.COM", "CHACHA", string4};
        String string10 = "http://melange/AdminRoot/Msging/US.ORACLE.COM/CHACHA";
        try {
            adminURL = new AdminURL(string10, string4);
            int n2 = 0;
            object = adminURL.getPathEnumerator();
            while (object.hasMoreElements()) {
                string = (String)object.nextElement();
                if (string == null) {
                    System.out.println("AdminURL::Enum tst: comp[" + n2 + "] is null");
                    continue;
                }
                if (!string.equals(stringArray2[n2])) {
                    System.out.println("AdminURL::Enum tst: comp[" + n2 + "] failed: " + string);
                }
                ++n2;
            }
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("AdminURL::Enum test url create excepted ");
            malformedURLException.printStackTrace();
        }
        stringArray2[0] = string4;
        stringArray2[1] = "AdminRoot";
        stringArray2[2] = "Msging";
        stringArray2[3] = "US.ORACLE.COM";
        stringArray2[4] = "CHACHA";
        String string11 = "http://melange/";
        object = "/AdminRoot/Msging/US.ORACLE.COM/CHACHA";
        string10 = String.valueOf(string11) + string4 + (String)object;
        try {
            adminURL = new AdminURL(string10);
            int n3 = 0;
            Enumeration enumeration = adminURL.getPathEnumerator();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (string == null) {
                    System.out.println("AdminURL::Enum tst: comp[" + n3 + "] is null");
                    continue;
                }
                if (!string.equals(stringArray2[n3])) {
                    System.out.println("AdminURL::Enum tst: comp[" + n3 + "] failed: " + string);
                }
                ++n3;
            }
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("AdminURL::Enum test url create excepted ");
            malformedURLException.printStackTrace();
        }
        System.out.println("Ending AdminURL tests.");
    }
}

