/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.common;

import corbaException.ProxyPropertyException;
import corbaException.ProxySaveChangeException;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ldap.admin.common.AdminClassCache;
import oracle.ldap.admin.common.AdminPropertyChangeEvent;
import oracle.ldap.admin.common.AdminPropertyChangeListener;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.IListenerProxy;
import oracle.ldap.admin.common.IProxy;
import oracle.ldap.admin.common.ListenerThread;
import oracle.ldap.admin.common.PropValue;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.ProxyCacheStatistics;
import oracle.ldap.admin.common.ProxyLog;
import oracle.ldap.admin.common.SaveChangeException;
import oracle.ldap.admin.common._IListenerProxyImplBase;

public class WrapperProxy
extends _IListenerProxyImplBase
implements IAdminProp,
IListenerProxy {
    static Hashtable hTable = new Hashtable();
    static ListenerThread lThread = new ListenerThread("admThread");
    static Vector adminClassCacheVec = new Vector();
    static int OP_DEBUG = 1;
    static int GC_DEBUG = 16;
    static int CACHE_DEBUG = 256;
    static int DEBUG_FLAG = GC_DEBUG | OP_DEBUG;
    static int hCount;
    static boolean do_gc;
    static ProxyLog pLog;
    static ProxyCacheStatistics pCacheStat;
    static int m_cacheLevel;
    private static final String DUMMY_STRING;
    private IProxy p;
    public Vector m_adminPropertyChangeListener;
    private String m_sClassName;
    private Vector m_initCachePropIds;
    private Hashtable hPropValCacheTable;
    public int hIndex;

    public void init() {
        this.m_adminPropertyChangeListener = new Vector();
    }

    public WrapperProxy() {
        this.init();
    }

    public WrapperProxy(IProxy iProxy) {
        this.init();
        this.p = iProxy;
    }

    public IProxy getProxy() {
        return this.p;
    }

    public static void DebugMessageLn(int n, String string) {
        if ((DEBUG_FLAG & n) != 0) {
            System.out.println(string);
        }
    }

    public void initResource(boolean bl, boolean bl2, boolean bl3, int n) {
        try {
            if (bl) {
                this.openProxyLog();
                this.turnOnProxyLogCacheFlag();
                this.turnOnProxyLogExcepFlag();
            }
            if (bl2) {
                this.turnOnProxyStatistColl();
            } else {
                this.turnOffProxyStatistColl();
            }
            if (bl3) {
                this.setCacheLevel(n);
                return;
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    public WrapperProxy newWrapperProxy(IProxy iProxy) {
        if (iProxy != null) {
            Integer n = new Integer(iProxy.hCode());
            if (hTable.containsKey(n)) {
                pLog.put(4, "MappingTable: hit  -> get " + n + "(" + ((WrapperProxy)WrapperProxy.hTable.get((Object)n)).m_sClassName + ") " + ((WrapperProxy)WrapperProxy.hTable.get((Object)n)).hIndex);
                return (WrapperProxy)hTable.get(n);
            }
            if ((DEBUG_FLAG & GC_DEBUG) != 0) {
                ++hCount;
            }
            WrapperProxy wrapperProxy = new WrapperProxy(iProxy);
            int[] nArray = iProxy.initCachePropIds();
            Object[] objectArray = iProxy.initCacheData();
            wrapperProxy.addInitCachePropIds(nArray);
            wrapperProxy.addInitCacheHashTable(nArray, objectArray);
            wrapperProxy.initClassName();
            wrapperProxy.initCacheLevel();
            wrapperProxy.mightInitTableProp();
            hTable.put(n, wrapperProxy);
            this.logCacheStatistics();
            pLog.put(4, "MappingTable: miss -> add " + n + "(" + this.m_sClassName + ") " + hCount);
            if ((DEBUG_FLAG & GC_DEBUG) != 0) {
                wrapperProxy.hIndex = hCount;
            }
            return wrapperProxy;
        }
        return null;
    }

    public Object getProp(int n) throws PropertyException {
        try {
            switch (n & 0x10F00000) {
                case 0x400000: {
                    pLog.put(1, "(" + this.m_sClassName + ") getAdminProp(" + n + ") " + this.hIndex);
                    IProxy iProxy = this.p.getAdmobjProp(n);
                    return this.newWrapperProxy(iProxy);
                }
                case 0x10400000: {
                    String string = n == 273219999 ? new String("PR_GRID_VIEW_COMMAND_LIST") : (n == 272695330 ? new String("PR_TAB_OBJ_LIST") : (n == 273612805 ? new String("PR_TREE_VIEW_CHILDREN_LIST") : (n == 272630384 ? new String("PR_SPLIT_PANEL_OBJ_LIST") : String.valueOf(n))));
                    pLog.put(1, "(" + this.m_sClassName + ") getAdminArrProp(" + string + ") " + this.hIndex);
                    IProxy[] iProxyArray = this.p.getAdmobjArrProp(n);
                    if (iProxyArray != null) {
                        WrapperProxy[] wrapperProxyArray = new WrapperProxy[iProxyArray.length];
                        int n2 = 0;
                        while (n2 < iProxyArray.length) {
                            wrapperProxyArray[n2] = this.newWrapperProxy(iProxyArray[n2]);
                            ++n2;
                        }
                        return wrapperProxyArray;
                    }
                    return null;
                }
                case 0x10700000: {
                    pLog.put(1, "(" + this.m_sClassName + ") getObjectArrProp(" + n + ") " + this.hIndex);
                    Object[] objectArray = (Object[])this.p.getObjectArrProp(n);
                    if (objectArray != null) {
                        int n3;
                        int n4;
                        int n5;
                        WrapperProxy[][] wrapperProxyArray;
                        IProxy[][] iProxyArray;
                        boolean bl = false;
                        boolean bl2 = false;
                        String string = null;
                        String string2 = null;
                        int n6 = 0;
                        while (n6 < objectArray.length) {
                            if (objectArray[n6] instanceof String) {
                                if (!bl && ((String)objectArray[n6]).startsWith("admobjarr")) {
                                    bl = true;
                                    string = (String)objectArray[n6];
                                } else if (!bl2 && ((String)objectArray[n6]).startsWith("admobj")) {
                                    bl2 = true;
                                    string2 = (String)objectArray[n6];
                                }
                            }
                            if (bl && bl2) break;
                            ++n6;
                        }
                        if (bl && (iProxyArray = this.p.getMissingAdmobjArr(string)) != null) {
                            wrapperProxyArray = new WrapperProxy[iProxyArray.length][0];
                            n5 = 0;
                            while (n5 < iProxyArray.length) {
                                WrapperProxy[] wrapperProxyArray2 = null;
                                if (iProxyArray[n5] != null) {
                                    wrapperProxyArray2 = new WrapperProxy[iProxyArray[n5].length];
                                    n4 = 0;
                                    while (n4 < wrapperProxyArray2.length) {
                                        wrapperProxyArray2[n4] = iProxyArray[n5][n4] == null ? null : this.newWrapperProxy(iProxyArray[n5][n4]);
                                        ++n4;
                                    }
                                }
                                wrapperProxyArray[n5] = wrapperProxyArray2;
                                ++n5;
                            }
                            n3 = 0;
                            n4 = 0;
                            while (n3 < objectArray.length) {
                                if (objectArray[n3] instanceof String && ((String)objectArray[n3]).startsWith("admobjarr")) {
                                    objectArray[n3] = wrapperProxyArray[n4++];
                                }
                                ++n3;
                            }
                        }
                        if (bl2 && (iProxyArray = this.p.getMissingAdmobj(string2)) != null) {
                            wrapperProxyArray = new WrapperProxy[iProxyArray.length];
                            n5 = 0;
                            while (n5 < wrapperProxyArray.length) {
                                wrapperProxyArray[n5] = this.newWrapperProxy((IProxy)iProxyArray[n5]);
                                ++n5;
                            }
                            n3 = 0;
                            n4 = 0;
                            while (n3 < objectArray.length) {
                                if (objectArray[n3] instanceof String && ((String)objectArray[n3]).startsWith("admobj")) {
                                    objectArray[n3] = wrapperProxyArray[n4++];
                                }
                                ++n3;
                            }
                        }
                    }
                    return objectArray;
                }
            }
            pLog.put(1, "(" + this.m_sClassName + ") getObjectProp(" + n + ") " + this.hIndex);
            return this.getPropFromCacheOrServer(n);
        }
        catch (ProxyPropertyException proxyPropertyException) {
            PropertyException propertyException = this.convert2AdminPropertyException(proxyPropertyException);
            throw propertyException;
        }
    }

    public void setProp(int n, Object object) throws PropertyException {
        IProxy iProxy = this.p;
        try {
            switch (n & 0x10F00000) {
                case 0x400000: {
                    pLog.put(1, "(" + this.m_sClassName + ") setAdminProp(" + n + ") " + this.hIndex);
                    iProxy.setAdmobjProp(n, ((WrapperProxy)object).getProxy());
                    return;
                }
                case 0x10400000: {
                    pLog.put(1, "(" + this.m_sClassName + ") setAdminArrProp(" + n + ") " + this.hIndex);
                    IProxy[] iProxyArray = null;
                    if (object != null) {
                        iProxyArray = new IProxy[((IAdminProp[])object).length];
                        int n2 = 0;
                        while (n2 < iProxyArray.length) {
                            iProxyArray[n2] = ((WrapperProxy)((IAdminProp[])object)[n2]).getProxy();
                            ++n2;
                        }
                    } else {
                        iProxyArray = new IProxy[]{};
                    }
                    iProxy.setAdmobjArrProp(n, iProxyArray);
                    return;
                }
            }
            pLog.put(1, "(" + this.m_sClassName + ") setObjectProp(" + n + ") " + this.hIndex);
            iProxy.setObjectProp(n, object);
            return;
        }
        catch (ProxyPropertyException proxyPropertyException) {
            PropertyException propertyException = this.convert2AdminPropertyException(proxyPropertyException);
            throw propertyException;
        }
    }

    public Object[] getProps(int[] nArray) throws PropertyException {
        pLog.put(1, "(" + this.m_sClassName + ") getProps " + this.hIndex);
        try {
            IProxy[] iProxyArray;
            if (nArray == null) {
                return null;
            }
            Object[] objectArray = new Object[nArray.length];
            WrapperProxy[] wrapperProxyArray = null;
            WrapperProxy[][] wrapperProxyArray2 = null;
            Object[] objectArray2 = null;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int[] nArray2 = null;
            int[] nArray3 = null;
            int[] nArray4 = null;
            int[] nArray5 = null;
            int[] nArray6 = null;
            int[] nArray7 = null;
            int n4 = 0;
            while (n4 < nArray.length) {
                switch (nArray[n4] & 0x10F00000) {
                    case 0x400000: {
                        ++n3;
                        break;
                    }
                    case 0x10400000: {
                        ++n2;
                        break;
                    }
                    default: {
                        ++n;
                    }
                    case 0x10700000: 
                }
                ++n4;
            }
            pLog.put(1, "   numAdmObj=" + n3 + " numArrAdmObj=" + n2 + " other=" + n);
            if (n3 > 0) {
                nArray4 = new int[n3];
                nArray7 = new int[n3];
                wrapperProxyArray = new WrapperProxy[n3];
            }
            if (n2 > 0) {
                nArray3 = new int[n2];
                nArray6 = new int[n2];
                wrapperProxyArray2 = new WrapperProxy[n2][0];
            }
            if (n > 0) {
                nArray2 = new int[n];
                nArray5 = new int[n];
                objectArray2 = new Object[n];
            }
            n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            while (n4 < nArray.length) {
                switch (nArray[n4] & 0x10F00000) {
                    case 0x400000: {
                        nArray4[n5] = nArray[n4];
                        nArray7[n5++] = n4;
                        break;
                    }
                    case 0x10400000: {
                        nArray3[n6] = nArray[n4];
                        nArray6[n6++] = n4;
                        break;
                    }
                    case 0x10700000: {
                        objectArray[n4] = this.getProp(nArray[n4]);
                        break;
                    }
                    default: {
                        nArray2[n7] = nArray[n4];
                        nArray5[n7++] = n4;
                        break;
                    }
                }
                ++n4;
            }
            if (n3 > 0) {
                iProxyArray = this.p.getAdmobjProps(nArray4);
                if (iProxyArray != null) {
                    n4 = 0;
                    while (n4 < iProxyArray.length) {
                        wrapperProxyArray[n4] = iProxyArray[n4] == null ? null : this.newWrapperProxy(iProxyArray[n4]);
                        ++n4;
                    }
                }
                if (wrapperProxyArray.length != n3) {
                    System.err.println("getProps error--1");
                }
            }
            if (n2 > 0) {
                iProxyArray = this.p.getAdmobjArrProps(nArray3);
                if (iProxyArray != null) {
                    n4 = 0;
                    while (n4 < iProxyArray.length) {
                        WrapperProxy[] wrapperProxyArray3 = null;
                        if (iProxyArray[n4] != null) {
                            wrapperProxyArray3 = new WrapperProxy[((IProxy)iProxyArray[n4]).length];
                            n5 = 0;
                            while (n5 < ((IProxy)iProxyArray[n4]).length) {
                                wrapperProxyArray3[n5] = iProxyArray[n4][n5] == null ? null : this.newWrapperProxy(iProxyArray[n4][n5]);
                                ++n5;
                            }
                        }
                        wrapperProxyArray2[n4] = wrapperProxyArray3;
                        ++n4;
                    }
                }
                if (wrapperProxyArray2.length != n2) {
                    System.err.println("getProps error--2");
                }
            }
            if (n > 0 && (objectArray2 = this.p.getObjectProps(nArray2)).length != n) {
                System.err.println("getProps error--3");
            }
            if (n3 > 0) {
                n4 = 0;
                while (n4 < n3) {
                    objectArray[nArray7[n4]] = wrapperProxyArray[n4];
                    ++n4;
                }
            }
            if (n2 > 0) {
                n4 = 0;
                while (n4 < n2) {
                    objectArray[nArray6[n4]] = wrapperProxyArray2[n4];
                    ++n4;
                }
            }
            if (n > 0) {
                n4 = 0;
                while (n4 < n) {
                    objectArray[nArray5[n4]] = objectArray2[n4];
                    ++n4;
                }
            }
            return objectArray;
        }
        catch (ProxyPropertyException proxyPropertyException) {
            PropertyException propertyException = this.convert2AdminPropertyException(proxyPropertyException);
            throw propertyException;
        }
    }

    public void setProps(int[] nArray, Object[] objectArray) throws PropertyException {
        pLog.put(1, "(" + this.m_sClassName + ") setProps " + this.hIndex);
        try {
            if (nArray == null) {
                return;
            }
            IProxy[] iProxyArray = null;
            IProxy[][] iProxyArray2 = null;
            Object[] objectArray2 = null;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int[] nArray2 = null;
            int[] nArray3 = null;
            int[] nArray4 = null;
            int n4 = 0;
            while (n4 < nArray.length) {
                switch (nArray[n4] & 0x10F00000) {
                    case 0x400000: {
                        ++n3;
                        break;
                    }
                    case 0x10400000: {
                        ++n2;
                        break;
                    }
                    default: {
                        ++n;
                        break;
                    }
                }
                ++n4;
            }
            pLog.put(1, "   numAdmObj=" + n3 + " numArrAdmObj=" + n2 + " other=" + n);
            if (n3 > 0) {
                nArray4 = new int[n3];
                iProxyArray = new IProxy[n3];
            }
            if (n2 > 0) {
                nArray3 = new int[n2];
                iProxyArray2 = new IProxy[n2][0];
            }
            if (n > 0) {
                nArray2 = new int[n];
                objectArray2 = new Object[n];
            }
            n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            while (n4 < nArray.length) {
                switch (nArray[n4] & 0x10F00000) {
                    case 0x400000: {
                        nArray4[n5] = nArray[n4];
                        iProxyArray[n5++] = objectArray[n4] == null ? null : ((WrapperProxy)objectArray[n4]).getProxy();
                        break;
                    }
                    case 0x10400000: {
                        nArray3[n6] = nArray[n4];
                        IProxy[] iProxyArray3 = null;
                        if ((WrapperProxy[])objectArray[n4] != null) {
                            iProxyArray3 = new IProxy[((IAdminProp[])objectArray[n4]).length];
                            int n8 = 0;
                            while (n8 < ((IAdminProp[])objectArray[n4]).length) {
                                iProxyArray3[n8] = ((IAdminProp[])objectArray[n4])[n8] == null ? null : ((WrapperProxy)((IAdminProp[])objectArray)[n8]).getProxy();
                                ++n8;
                            }
                        }
                        iProxyArray2[n6++] = iProxyArray3;
                        break;
                    }
                    default: {
                        nArray2[n7] = nArray[n4];
                        objectArray2[n7++] = objectArray == null ? null : objectArray[n4];
                        break;
                    }
                }
                ++n4;
            }
            if (n3 > 0) {
                this.p.setAdmobjProps(nArray4, iProxyArray);
            }
            if (n2 > 0) {
                this.p.setAdmobjArrProps(nArray3, iProxyArray2);
            }
            if (n > 0) {
                this.p.setObjectProps(nArray2, objectArray2);
                return;
            }
        }
        catch (ProxyPropertyException proxyPropertyException) {
            PropertyException propertyException = this.convert2AdminPropertyException(proxyPropertyException);
            throw propertyException;
        }
    }

    public PropValue getPropValue(int n) throws PropertyException {
        System.out.println("Sorry! getPropValue() is not implemented yet.******");
        return null;
    }

    public PropValue[] getPropValues(int[] nArray) throws PropertyException {
        System.out.println("Sorry! getPropValues() is not implemented yet.*****");
        return null;
    }

    public void setPropValue(PropValue propValue) throws PropertyException {
        System.out.println("Sorry! setPropValue() is not implemented yet.******");
    }

    public void setPropValues(PropValue[] propValueArray) throws PropertyException {
        System.out.println("Sorry! setPropValues() is not implemented yet.*****");
    }

    public void deleteProp(int n) throws PropertyException {
        System.out.println("WrapperProxy::deleteProp " + this.hIndex);
        try {
            if (n != 0) {
                this.p.deleteProp(n);
                return;
            }
        }
        catch (ProxyPropertyException proxyPropertyException) {
            PropertyException propertyException = this.convert2AdminPropertyException(proxyPropertyException);
            throw propertyException;
        }
    }

    public void deleteProps(int[] nArray) throws PropertyException {
        pLog.put(1, "(" + this.m_sClassName + ") deleteProps " + this.hIndex);
        try {
            if (nArray != null) {
                this.p.deleteProps(nArray);
                return;
            }
        }
        catch (ProxyPropertyException proxyPropertyException) {
            PropertyException propertyException = this.convert2AdminPropertyException(proxyPropertyException);
            throw propertyException;
        }
    }

    public String getPropName(int n) {
        pLog.put(1, "(" + this.m_sClassName + ") getPropName " + this.hIndex);
        if (n != 0) {
            AdminClassCache adminClassCache = this.getAdminClassCache(this.m_sClassName);
            if (adminClassCache == null) {
                adminClassCache = this.addAdminClassCache(this.m_sClassName);
            }
            return adminClassCache.getPropName(this.p, n, pLog, pCacheStat, m_cacheLevel);
        }
        return null;
    }

    public String[] getPropNames(int[] nArray) {
        pLog.put(1, "(" + this.m_sClassName + ") getPropNames " + this.hIndex);
        if (nArray != null) {
            AdminClassCache adminClassCache = this.getAdminClassCache(this.m_sClassName);
            if (adminClassCache == null) {
                adminClassCache = this.addAdminClassCache(this.m_sClassName);
            }
            return adminClassCache.getPropNames(this.p, nArray, pLog, pCacheStat, m_cacheLevel);
        }
        return null;
    }

    public String getPropDescription(int n) {
        pLog.put(1, "(" + this.m_sClassName + ") getPropDescription " + this.hIndex);
        if (n != 0) {
            AdminClassCache adminClassCache = this.getAdminClassCache(this.m_sClassName);
            if (adminClassCache == null) {
                adminClassCache = this.addAdminClassCache(this.m_sClassName);
            }
            return adminClassCache.getPropDescription(this.p, n, pLog, pCacheStat, m_cacheLevel);
        }
        return null;
    }

    public String[] getPropDescriptions(int[] nArray) {
        pLog.put(1, "(" + this.m_sClassName + ") getPropDescriptions " + this.hIndex);
        if (nArray != null) {
            AdminClassCache adminClassCache = this.getAdminClassCache(this.m_sClassName);
            if (adminClassCache == null) {
                adminClassCache = this.addAdminClassCache(this.m_sClassName);
            }
            return adminClassCache.getPropDescriptions(this.p, nArray, pLog, pCacheStat, m_cacheLevel);
        }
        return null;
    }

    public void saveChanges(int n) throws SaveChangeException {
        pLog.put(1, "(" + this.m_sClassName + ") saveChanges " + this.hIndex);
        try {
            this.p.saveChanges(n);
            return;
        }
        catch (ProxySaveChangeException proxySaveChangeException) {
            pLog.put(8, "CATCH ProxySaveChangeException");
            SaveChangeException saveChangeException = new SaveChangeException(proxySaveChangeException.m_msg, proxySaveChangeException.m_type);
            if (proxySaveChangeException.type == 1) {
                saveChangeException.setError();
            } else if (proxySaveChangeException.type == 2) {
                saveChangeException.setWarning();
            } else if (proxySaveChangeException.type == 3) {
                saveChangeException.setNotice();
            }
            throw saveChangeException;
        }
    }

    public void addAdminPropertyChangeListener(AdminPropertyChangeListener adminPropertyChangeListener) {
        int n = this.m_adminPropertyChangeListener.size() + 1;
        pLog.put(1, "(" + this.m_sClassName + ") addAdminPropListener #=" + n + " " + this.hIndex);
        if (this.m_adminPropertyChangeListener.size() == 0) {
            this.p.addAdminPropertyChangeListener(this);
        }
        this.m_adminPropertyChangeListener.addElement(adminPropertyChangeListener);
    }

    public void removeAdminPropertyChangeListener(AdminPropertyChangeListener adminPropertyChangeListener) {
        this.m_adminPropertyChangeListener.removeElement(adminPropertyChangeListener);
        String string = new String("(" + this.m_sClassName + ") removeAdminPropListener #=" + this.m_adminPropertyChangeListener.size() + " " + this.hIndex);
        pLog.put(1, string);
        if (this.m_adminPropertyChangeListener.size() == 0) {
            this.p.removeAdminPropertyChangeListener();
            Integer n = new Integer(this.getProxy().hCode());
            if (hTable.containsKey(n)) {
                if (do_gc) {
                    hTable.remove(this.getProxy());
                }
                pLog.put(4, "==== " + this.hIndex + " " + n + "(" + this.m_sClassName + ") " + " garbage collected ====");
            }
        }
    }

    public void adminPropertyChange(AdminPropertyChangeEvent adminPropertyChangeEvent) {
        Serializable serializable;
        pLog.put(1, "Callback: (" + this.m_sClassName + ") callback is called ");
        if (this.hPropValCacheTable != null) {
            int n = adminPropertyChangeEvent.getPropId();
            serializable = new Integer(n);
            String string = Integer.toHexString(n);
            if (this.hPropValCacheTable.containsKey(serializable)) {
                pLog.put(2, "remove from hPropValCacheTable: property id=" + string);
                this.hPropValCacheTable.remove(serializable);
            }
        }
        AdminPropertyChangeEvent adminPropertyChangeEvent2 = null;
        serializable = null;
        while (true) {
            if (adminPropertyChangeEvent2 == null) {
                serializable = new AdminPropertyChangeEvent(this, adminPropertyChangeEvent);
                adminPropertyChangeEvent2 = serializable;
            } else {
                ((AdminPropertyChangeEvent)serializable).setNext(new AdminPropertyChangeEvent(this, adminPropertyChangeEvent));
                serializable = ((AdminPropertyChangeEvent)serializable).getNext();
            }
            if (!adminPropertyChangeEvent.hasMoreElements()) break;
            adminPropertyChangeEvent = (AdminPropertyChangeEvent)adminPropertyChangeEvent.nextElement();
        }
        lThread.addJob(this, adminPropertyChangeEvent2);
        pLog.put(1, "Callback: (" + this.m_sClassName + ") exit callback .....");
    }

    public void setCacheLevel(int n) {
        pLog.put(2, "====================  Setting CACHE LEVEL ============");
        pLog.put(16, "              cache level is " + Integer.toHexString(n));
        m_cacheLevel = n;
    }

    public void clearProxyClassCache() {
        int n = 0;
        while (n < adminClassCacheVec.size()) {
            AdminClassCache adminClassCache = (AdminClassCache)adminClassCacheVec.elementAt(n);
            adminClassCache.clearAll();
            ++n;
        }
        adminClassCacheVec.removeAllElements();
    }

    public void clearProxyCacheStat() {
        pCacheStat.clearAll();
    }

    public void logCacheStatistics() {
        String string = "GetProp num=" + pCacheStat.getNumGetProp() + "\n" + "   GetPropName num=" + pCacheStat.getNumGetPropName() + "\n" + "   GetPropDescp num=" + pCacheStat.getNumGetPropDescp() + "\n" + "   CacheInstance num=" + pCacheStat.getNumCacheInstance() + "\n" + "   CacheClassPropName num=" + pCacheStat.getNumCacheClassPropName() + "\n" + "   CacheClassPropDescp num=" + pCacheStat.getNumCacheClassPropDescp() + "\n" + "   CacheClassPropVal num=" + pCacheStat.getNumCacheClassPropVal();
        pLog.put(2, "Cache Statistics :");
        pLog.put(16, string);
    }

    public int getNumGetProp() {
        return pCacheStat.getNumGetProp();
    }

    public int getNumGetPropName() {
        return pCacheStat.getNumGetPropName();
    }

    public int getNumGetPropDescp() {
        return pCacheStat.getNumGetPropDescp();
    }

    public int getNumCacheInstance() {
        return pCacheStat.getNumCacheInstance();
    }

    public int getNumCacheClassPropName() {
        return pCacheStat.getNumCacheClassPropName();
    }

    public int getNumCacheClassPropDescp() {
        return pCacheStat.getNumCacheClassPropDescp();
    }

    public int getNumCacheClassPropVal() {
        return pCacheStat.getNumCacheClassPropVal();
    }

    public void turnOnProxyStatistColl() {
        pCacheStat.turnOn();
    }

    public void turnOffProxyStatistColl() {
        pCacheStat.turnOff();
    }

    public void stopWPThread() {
        lThread.stop();
    }

    public void turnOffProxyLogFlag() {
        pLog.turnOff();
    }

    public void turnOnProxyLogOperFlag() {
        pLog.turnOnOper();
    }

    public void turnOnProxyLogCacheFlag() {
        pLog.turnOnCache();
    }

    public void turnOnProxyLogGarbCollFlag() {
        pLog.turnOnCarbColl();
    }

    public void turnOnProxyLogExcepFlag() {
        pLog.turnOnExcep();
    }

    public void openProxyLog() {
        pLog.open("proxy" + new Date().hashCode() + ".log");
    }

    public void closeProxyLog() {
        pLog.close();
    }

    private PropertyException convert2AdminPropertyException(ProxyPropertyException proxyPropertyException) {
        pLog.put(8, "CATCH ProxyPropertyException");
        PropertyException propertyException = null;
        PropertyException propertyException2 = new PropertyException("dummy");
        int n = 0;
        while (n < proxyPropertyException.exceptionList.length) {
            PropertyException propertyException3 = proxyPropertyException.exceptionList[n].isRealException ? new PropertyException(new Exception(proxyPropertyException.exceptionList[n].m_msg)) : (proxyPropertyException.exceptionList[n].m_title != null ? new PropertyException(proxyPropertyException.exceptionList[n].m_title, proxyPropertyException.exceptionList[n].m_msg) : new PropertyException(proxyPropertyException.exceptionList[n].m_msg, proxyPropertyException.exceptionList[n].m_type, proxyPropertyException.exceptionList[n].m_property, proxyPropertyException.exceptionList[n].m_value));
            if (proxyPropertyException.exceptionList[n].type == 1) {
                propertyException3.setError();
            } else if (proxyPropertyException.exceptionList[n].type == 2) {
                propertyException3.setWarning();
            } else if (proxyPropertyException.exceptionList[n].type == 3) {
                propertyException3.setNotice();
            }
            if (propertyException == null) {
                propertyException = propertyException3;
            } else {
                propertyException2.SetNext(propertyException3);
            }
            propertyException2 = propertyException3;
            ++n;
        }
        return propertyException;
    }

    private void addInitCachePropIds(int[] nArray) {
        if (m_cacheLevel == 0) {
            return;
        }
        if ((m_cacheLevel & 1) == 0 && (m_cacheLevel & 2) == 0 && (m_cacheLevel & 4) == 0) {
            return;
        }
        if (this.m_initCachePropIds == null) {
            this.m_initCachePropIds = new Vector();
        }
        if (nArray != null) {
            int n = 0;
            while (n < nArray.length) {
                this.m_initCachePropIds.addElement(new Integer(nArray[n]));
                ++n;
            }
        }
    }

    private void addInitCacheHashTable(int[] nArray, Object[] objectArray) {
        if (m_cacheLevel == 0) {
            return;
        }
        if ((m_cacheLevel & 1) == 0 && (m_cacheLevel & 2) == 0 && (m_cacheLevel & 4) == 0) {
            return;
        }
        if (this.hPropValCacheTable == null) {
            this.hPropValCacheTable = new Hashtable();
        }
        int n = 0;
        while (n < nArray.length) {
            Integer n2 = new Integer(nArray[n]);
            if (objectArray[n] == null) {
                objectArray[n] = new String(DUMMY_STRING);
            }
            this.hPropValCacheTable.put(n2, objectArray[n]);
            ++n;
        }
    }

    private void initClassName() {
        try {
            Integer n = new Integer(1114150);
            if (this.hPropValCacheTable != null && this.hPropValCacheTable.containsKey(n)) {
                pLog.put(2, "initClassName: found in cache : iPropId = PR_CLASS_NAME");
                pCacheStat.addNumCacheInstance();
                this.m_sClassName = (String)this.hPropValCacheTable.get(n);
            }
            if (this.m_sClassName == null) {
                pLog.put(2, "initClassName: access server proxy : iPropId = PR_CLASS_NAME");
                pCacheStat.addNumGetProp();
                this.m_sClassName = (String)this.p.getObjectProp(1114150);
            }
            pLog.put(2, "initClassName: m_sClassName=" + this.m_sClassName);
            return;
        }
        catch (ProxyPropertyException proxyPropertyException) {
            PropertyException propertyException = this.convert2AdminPropertyException(proxyPropertyException);
            System.out.println(propertyException.getMessage());
            return;
        }
    }

    private void initCacheLevel() {
        try {
            if (m_cacheLevel != 999) {
                return;
            }
            Integer n = new Integer(3080231);
            Integer n2 = null;
            if (this.hPropValCacheTable != null && this.hPropValCacheTable.containsKey(n)) {
                pLog.put(2, "initCacheLevel: found in cache : iPropId = PR_CACHE_LEVEL");
                pCacheStat.addNumCacheInstance();
                n2 = (Integer)this.hPropValCacheTable.get(n);
            }
            if (n2 == null) {
                pLog.put(2, "initCacheLevel: access server proxy: iPropId = PR_CACHE_LEVEL");
                n2 = (Integer)this.p.getObjectProp(3080231);
                pCacheStat.addNumGetProp();
            }
            m_cacheLevel = n2;
            pLog.put(2, "initCacheLevel: m_cacheLevel=" + Integer.toHexString(m_cacheLevel));
            return;
        }
        catch (ProxyPropertyException proxyPropertyException) {
            PropertyException propertyException = this.convert2AdminPropertyException(proxyPropertyException);
            System.out.println(propertyException.getMessage());
            return;
        }
    }

    private void mightInitTableProp() {
        try {
            if (m_cacheLevel == 0) {
                return;
            }
            if ((m_cacheLevel & 2) != 0) {
                int[] nArray = (int[])this.p.getObjectProp(281083945);
                Object[] objectArray = this.p.getObjectProps(nArray);
                this.addInitCachePropIds(nArray);
                this.addInitCacheHashTable(nArray, objectArray);
                return;
            }
        }
        catch (ProxyPropertyException proxyPropertyException) {
            PropertyException propertyException = this.convert2AdminPropertyException(proxyPropertyException);
            System.out.println(propertyException.getMessage());
        }
    }

    private AdminClassCache getAdminClassCache(String string) {
        Enumeration enumeration = adminClassCacheVec.elements();
        while (enumeration.hasMoreElements()) {
            AdminClassCache adminClassCache = (AdminClassCache)enumeration.nextElement();
            if (!adminClassCache.isTheCache(string)) continue;
            return adminClassCache;
        }
        return null;
    }

    private AdminClassCache addAdminClassCache(String string) {
        pLog.put(2, "Add Class Name to Class Cache Vector : " + string);
        AdminClassCache adminClassCache = new AdminClassCache(string);
        adminClassCacheVec.addElement(adminClassCache);
        return adminClassCache;
    }

    private Object getPropFromCacheOrServer(int n) throws ProxyPropertyException {
        Object object;
        Integer n2 = new Integer(n);
        if (m_cacheLevel == 0) {
            pLog.put(2, "getPropFromCacheOrServer: access server proxy : iPropId=" + Integer.toHexString(n));
            pCacheStat.addNumGetProp();
            return this.p.getObjectProp(n);
        }
        if (((m_cacheLevel & 1) != 0 || (m_cacheLevel & 2) != 0) && this.hPropValCacheTable.containsKey(n2)) {
            pLog.put(2, "INSTANCE INIT CACHE: found in cache: iPropId =" + Integer.toHexString(n));
            pCacheStat.addNumCacheInstance();
            Object v = this.hPropValCacheTable.get(n2);
            if (v.getClass().getName().equalsIgnoreCase("java.lang.String") && ((String)v).equalsIgnoreCase(DUMMY_STRING)) {
                return null;
            }
            return v;
        }
        switch (n & 0xF000000) {
            case 0x1000000: {
                pLog.put(2, "NO CACHE: access server proxy : iPropId=" + Integer.toHexString(n));
                pCacheStat.addNumGetProp();
                return this.p.getObjectProp(n);
            }
            case 0x2000000: {
                if ((m_cacheLevel & 0x10) == 0) break;
                AdminClassCache adminClassCache = this.getAdminClassCache(this.m_sClassName);
                if (adminClassCache == null) {
                    adminClassCache = this.addAdminClassCache(this.m_sClassName);
                }
                return adminClassCache.getProp(this.p, n, pLog, pCacheStat, m_cacheLevel);
            }
        }
        if ((m_cacheLevel & 4) != 0 && this.hPropValCacheTable.containsKey(n2)) {
            pLog.put(2, "INSTANCE CACHE: found in cache : iPropId=" + Integer.toHexString(n));
            pCacheStat.addNumCacheInstance();
            object = this.hPropValCacheTable.get(n2);
            if (object.getClass().getName().equalsIgnoreCase("java.lang.String")) {
                if (((String)object).equalsIgnoreCase(DUMMY_STRING)) {
                    return null;
                }
                return object;
            }
        } else {
            pLog.put(2, "INSTANCE CACHE: access server object : iPropId=" + Integer.toHexString(n));
            pCacheStat.addNumGetProp();
            object = this.p.getObjectProp(n);
        }
        this.putPropToCache(n, object);
        return object;
    }

    private void putPropToCache(int n, Object object) {
        Integer n2 = new Integer(n);
        if (object == null) {
            pLog.put(2, "putPropToCache: val is null");
            object = new String(DUMMY_STRING);
        }
        if ((m_cacheLevel & 1) != 0 || (m_cacheLevel & 2) != 0) {
            int n3 = 0;
            while (n3 < this.m_initCachePropIds.size()) {
                if (n == (Integer)this.m_initCachePropIds.elementAt(n3)) {
                    pLog.put(2, "putPropToCache: put a new entry");
                    this.hPropValCacheTable.put(n2, object);
                    return;
                }
                ++n3;
            }
        }
        if ((m_cacheLevel & 4) != 0) {
            this.hPropValCacheTable.put(n2, object);
            return;
        }
    }

    static {
        do_gc = true;
        pLog = new ProxyLog();
        pCacheStat = new ProxyCacheStatistics();
        m_cacheLevel = 999;
        DUMMY_STRING = new String("dummy string");
    }
}

