/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.oemclient;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import oracle.ldap.admin.client.AdminUtil;
import oracle.ldap.admin.client.EditorFactory;
import oracle.ldap.admin.client.ICommitPanel;
import oracle.ldap.admin.client.propEditors.IEditor;
import oracle.ldap.admin.common.AdminPropertyChangeEvent;
import oracle.ldap.admin.common.AdminPropertyChangeListener;
import oracle.ldap.admin.common.ClientLang;
import oracle.ldap.admin.common.IAdminProp;
import oracle.sysman.emSDK.adminObj.client.PropertyPage;

public class MyPropertyPage
extends PropertyPage
implements ICommitPanel,
AdminPropertyChangeListener {
    public boolean m_initiallyModified = false;
    Component m_editor;
    IEditor m_ieditor;
    IAdminProp m_ap;
    int m_level;

    public MyPropertyPage(IAdminProp iAdminProp) {
        super("");
        this.m_ap = iAdminProp;
        this.setupDisplayName();
        this.setupTabPageStatus();
        this.setupTabPageEnabled();
        AdminUtil.addAdminPropertyChangeListener(this.m_ap, this);
    }

    public MyPropertyPage(IAdminProp iAdminProp, boolean bl) {
        this(iAdminProp);
        this.m_initiallyModified = bl;
    }

    public String getHelpTopic() {
        try {
            return (String)this.m_ap.getProp(1048745);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getHelpBookName() {
        try {
            return (String)this.m_ap.getProp(1049370);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void initializePage() {
    }

    protected void onSetActive() {
        if (this.m_editor == null) {
            this.m_editor = EditorFactory.getEditor(this.m_ap, null, true);
            this.m_ieditor = (IEditor)((Object)AdminUtil.removeScrollBox(this.m_editor));
            ((Container)((Object)this)).setLayout(new BorderLayout());
        }
        if (this.m_ieditor != null) {
            this.m_ieditor.setupToolbar(this.m_level);
        }
    }

    protected void onCreatePage() {
        if (this.m_editor == null) {
            this.m_editor = EditorFactory.getEditor(this.m_ap, null, true);
            this.m_ieditor = (IEditor)((Object)AdminUtil.removeScrollBox(this.m_editor));
            ((Container)((Object)this)).setLayout(new BorderLayout());
        }
        ((Container)((Object)this)).add("Center", this.m_editor);
        AdminUtil.fixup((Component)((Object)this));
        if (this.m_initiallyModified) {
            this.setModified(true);
        }
    }

    protected boolean isModified() {
        if (this.m_ieditor != null) {
            return this.m_ieditor.isModified(null);
        }
        return false;
    }

    public void notifyState(int n, Object object) {
        this.setModified(n == 2);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        int n = 0;
        while (n < ((Container)((Object)this)).getComponentCount()) {
            ((Container)((Object)this)).getComponent(n).setEnabled(bl);
            ++n;
        }
    }

    public boolean displayObject(Object object) {
        if (this.m_ieditor == null) {
            return false;
        }
        return this.m_ieditor.displayObject(object);
    }

    public Object getHelpObject() {
        if (this.m_ieditor == null) {
            return this.m_ap;
        }
        return this.m_ieditor.getHelpObject();
    }

    public Object getObject() {
        if (this.m_ieditor == null) {
            return this.m_ap;
        }
        return this.m_ieditor.getObject();
    }

    public boolean isModified2(StringBuffer stringBuffer) {
        if (this.m_ieditor == null) {
            return false;
        }
        return this.m_ieditor.isModified(stringBuffer);
    }

    public void revert() {
        if (this.m_ieditor == null) {
            return;
        }
        this.m_ieditor.revert();
    }

    public boolean commit() {
        if (this.m_ieditor == null) {
            return true;
        }
        return this.m_ieditor.commit();
    }

    public void update() {
        if (this.m_ieditor == null) {
            return;
        }
        this.m_ieditor.update();
    }

    public void shutdown() {
        AdminUtil.removeAdminPropertyChangeListener(this.m_ap, this);
        if (this.m_ieditor == null) {
            return;
        }
        this.m_ieditor.shutdown();
    }

    public IAdminProp properties() {
        if (this.m_ieditor == null) {
            return null;
        }
        return this.m_ieditor.properties();
    }

    public boolean setObject(Object object) {
        if (this.m_ieditor == null) {
            return false;
        }
        return this.m_ieditor.setObject(object);
    }

    public int getEditorType() {
        if (this.m_ieditor == null) {
            return 0;
        }
        return this.m_ieditor.getEditorType();
    }

    public void setupToolbar(int n) {
        this.m_level = n;
    }

    public void setupTabPageStatus() {
        try {
            Integer n = (Integer)this.m_ap.getProp(2098293);
            if (n != null) {
                this.setEnabled((n & 1) == 0);
                return;
            }
        }
        catch (Exception exception) {}
    }

    public void setupTabPageEnabled() {
        try {
            Boolean bl = (Boolean)this.m_ap.getProp(8389142);
            if (bl != null) {
                this.setEnabled(bl);
                return;
            }
        }
        catch (Exception exception) {}
    }

    public void setupStatus() {
        try {
            Integer n = (Integer)this.m_ap.getProp(3080204);
            if (n != null) {
                this.setModified((n & 2) != 0);
                return;
            }
        }
        catch (Exception exception) {}
    }

    public void setupDisplayName() {
        try {
            String string = (String)this.m_ap.getProp(0x110001);
            if (string == null || string.equals("")) {
                string = ClientLang.getStrGeneral();
            }
            this.setTitle(string);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void adminPropertyChange(AdminPropertyChangeEvent adminPropertyChangeEvent) {
        while (true) {
            switch (adminPropertyChangeEvent.getPropId()) {
                case 2098293: {
                    this.setupTabPageStatus();
                    break;
                }
                case 8389142: {
                    this.setupTabPageEnabled();
                    break;
                }
                case 0x110001: {
                    this.setupDisplayName();
                }
                case 3080204: {
                    this.setupStatus();
                    break;
                }
            }
            if (!adminPropertyChangeEvent.hasMoreElements()) {
                return;
            }
            adminPropertyChangeEvent = (AdminPropertyChangeEvent)adminPropertyChangeEvent.nextElement();
        }
    }
}

