/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.oemclient;

import java.awt.Component;
import oracle.ldap.admin.client.AdminUtil;
import oracle.ldap.admin.client.ErrorAlert;
import oracle.ldap.admin.common.AdminPropertyChangeEvent;
import oracle.ldap.admin.common.AdminPropertyChangeListener;
import oracle.ldap.admin.common.ClientLang;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.oemclient.AdminTreeDataSource;
import oracle.ldap.admin.oemclient.TreeDetailApp;
import oracle.sysman.emSDK.client.appComponent.TreeDetailAppComponent;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeDataSource;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeParentNode;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeProxy;

public class MyTreeParentNode
extends TreeParentNode
implements AdminPropertyChangeListener {
    public static boolean DEBUG = true;
    boolean m_apHasChildren = true;
    TreeDataSource m_tds;
    IAdminProp m_ap;
    TreeProxy m_tp;
    int m_status;
    String m_label;

    public MyTreeParentNode(TreeDataSource treeDataSource, TreeProxy treeProxy, String string, IAdminProp iAdminProp) {
        super(treeDataSource, treeProxy, string);
        this.setAdminProp(iAdminProp);
        this.m_tp = treeProxy;
        this.m_tds = treeDataSource;
        AdminUtil.addAdminPropertyChangeListener(this.m_ap, this);
        this.updateStatus();
    }

    public String getLabel() {
        if (this.m_label == null) {
            return "";
        }
        return this.m_label;
    }

    public void setAdminProp(IAdminProp iAdminProp) {
        this.m_ap = iAdminProp;
        this.updateStatus();
        try {
            this.m_label = (String)this.m_ap.getProp(0x110001);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public IAdminProp getAdminProp() {
        return this.m_ap;
    }

    void updateStatus() {
        try {
            this.m_status = (Integer)this.m_ap.getProp(3080204);
            if ((this.m_status & 0x300000) != 0) {
                this.m_apHasChildren = true;
                return;
            }
            this.m_apHasChildren = false;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void adminPropertyChange(AdminPropertyChangeEvent adminPropertyChangeEvent) {
        if (adminPropertyChangeEvent.getPropId() == 273612805) {
            if (this.m_tds != null) {
                ((AdminTreeDataSource)this.m_tds).external_refreshData();
                return;
            }
        } else {
            if (adminPropertyChangeEvent.getPropId() == 1638408) {
                this.setAdminProp(this.m_ap);
                return;
            }
            if (adminPropertyChangeEvent.getPropId() == 0x110001) {
                this.setAdminProp(this.m_ap);
                return;
            }
            if (adminPropertyChangeEvent.getPropId() == 0x1F000F) {
                Object object = this.m_tp.getTree().getAppComponent();
                TreeDetailAppComponent treeDetailAppComponent = (TreeDetailAppComponent)object;
                TreeDetailApp treeDetailApp = (TreeDetailApp)treeDetailAppComponent.getContainer();
                try {
                    String string = (String)this.m_ap.getProp(0x1F000F);
                    if (string != null) {
                        AdminUtil.showSBMessage((Component)((Object)treeDetailApp), string);
                        return;
                    }
                    AdminUtil.showSBMessage((Component)((Object)treeDetailApp), ClientLang.getStrReady());
                    return;
                }
                catch (PropertyException propertyException) {
                    new ErrorAlert(treeDetailApp.getFrame(), propertyException);
                    return;
                }
            }
        }
    }

    public boolean isExpandable() {
        return this.m_apHasChildren;
    }
}

