/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.dbutil;

import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ResourceBundle;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleStatement;
import oracle.jsp.dbutil.BeanUtil;
import oracle.jsp.dbutil.ConnBean;
import oracle.jsp.event.JspScopeEvent;
import oracle.jsp.event.JspScopeListener;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;

public class CursorBean
implements JspScopeListener {
    private Statement m_stmt;
    private Connection m_conn;
    private String m_sql;
    public static final int PLAIN_STMT = 0;
    public static final int PREP_STMT = 1;
    public static final int CALL_STMT = 2;
    public static final int TYPE_FORWARD_ONLY = 1003;
    public static final int TYPE_SCROLL_INSENSITIVE = 1004;
    public static final int TYPE_SCROLL_SENSITIVE = 1005;
    public static final int CONCUR_READ_ONLY = 1007;
    public static final int CONCUR_UPDATABLE = 1008;
    private int m_stmtType = 0;
    private int m_rsetType = 1003;
    private int m_rsetCon = 1007;
    private int m_preFetch = 10;
    private int m_batchSize = 1;
    private int m_queryTimeout;
    private static final String MSG_FILE = "oracle.jsp.dbutil.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.dbutil.LocalStrings");

    public synchronized void setConnBean(ConnBean connBean) {
        this.m_conn = connBean.m_conn;
    }

    public void create(ConnBean connBean, int n, String string) throws SQLException {
        this.m_conn = connBean.m_conn;
        this.create(n, string);
    }

    public void create(ConnBean connBean) throws SQLException {
        this.m_conn = connBean.m_conn;
        if (this.m_conn == null) {
            throw new SQLException(msgs.getString("conn_null"));
        }
        this.create(0, null);
    }

    public void create() throws SQLException {
        this.create(0, null);
    }

    public synchronized Connection getJDBCConnection() {
        return this.m_conn;
    }

    public synchronized void create(int n, String string) throws SQLException {
        if (this.m_conn == null) {
            throw new SQLException(msgs.getString("conn_null"));
        }
        this.m_sql = string;
        this.m_stmtType = n;
        if (this.m_stmt != null) {
            this.m_stmt.close();
            this.m_stmt = null;
        }
        this.m_stmt = this.m_stmtType == 2 ? ((OracleConnection)this.m_conn).prepareCall(string, this.m_rsetType, this.m_rsetCon) : (this.m_stmtType == 1 ? ((OracleConnection)this.m_conn).prepareStatement(string, this.m_rsetType, this.m_rsetCon) : ((OracleConnection)this.m_conn).createStatement(this.m_rsetType, this.m_rsetCon));
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_err"));
        }
        if (this.m_preFetch != 10) {
            ((OracleStatement)this.m_stmt).setRowPrefetch(this.m_preFetch);
        }
        if (this.m_stmtType != 0) {
            ((OraclePreparedStatement)this.m_stmt).setExecuteBatch(this.m_batchSize);
        }
        if (this.m_queryTimeout != 0) {
            ((OracleStatement)this.m_stmt).setQueryTimeout(this.m_queryTimeout);
        }
    }

    public synchronized ResultSet executeQuery(String string) throws SQLException {
        this.m_sql = string;
        return this.executeQuery();
    }

    public synchronized ResultSet executeQuery() throws SQLException {
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        if (this.m_stmtType == 0) {
            return this.m_stmt.executeQuery(this.m_sql);
        }
        return ((OraclePreparedStatement)this.m_stmt).executeQuery();
    }

    public synchronized int executeUpdate(String string) throws SQLException {
        this.m_sql = string;
        return this.executeUpdate();
    }

    public synchronized int executeUpdate() throws SQLException {
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        if (this.m_stmtType == 0) {
            return this.m_stmt.executeUpdate(this.m_sql);
        }
        return ((OraclePreparedStatement)this.m_stmt).executeUpdate();
    }

    public synchronized int getUpdateCount() throws SQLException {
        return ((OracleStatement)this.m_stmt).getUpdateCount();
    }

    public synchronized boolean execute(String string) throws SQLException {
        this.m_sql = string;
        return this.execute();
    }

    public synchronized boolean execute() throws SQLException {
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        if (this.m_stmtType == 0) {
            return this.m_stmt.execute(this.m_sql);
        }
        return ((OraclePreparedStatement)this.m_stmt).execute();
    }

    public synchronized void close() throws SQLException {
        if (this.m_stmt != null) {
            this.m_stmt.close();
            this.m_stmt = null;
        }
    }

    public synchronized void setResultSetType(int n) {
        this.m_rsetType = n;
    }

    public synchronized int getResultSetType() {
        return this.m_rsetType;
    }

    public synchronized void setResultSetConcurrency(int n) {
        this.m_rsetCon = n;
    }

    public synchronized int getResultSetConcurrency() {
        return this.m_rsetCon;
    }

    public synchronized void setPreFetch(int n) {
        this.m_preFetch = n;
    }

    public synchronized int getPreFetch() {
        return this.m_preFetch;
    }

    public synchronized void setExecuteBatch(int n) {
        this.m_batchSize = n;
    }

    public synchronized int getExecuteBatch() {
        return this.m_batchSize;
    }

    public synchronized void setQueryTimeout(int n) {
        this.m_queryTimeout = n;
    }

    public synchronized int getQueryTimeout() {
        return this.m_queryTimeout;
    }

    public synchronized void setNull(int n, int n2, String string) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((OraclePreparedStatement)this.m_stmt).setNull(n, n2, string);
    }

    public synchronized void setNull(int n, int n2) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((PreparedStatement)this.m_stmt).setNull(n, n2);
    }

    public synchronized void setBoolean(int n, boolean bl) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((PreparedStatement)this.m_stmt).setBoolean(n, bl);
    }

    public synchronized void setByte(int n, byte by) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((PreparedStatement)this.m_stmt).setByte(n, by);
    }

    public synchronized void setShort(int n, short s) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((PreparedStatement)this.m_stmt).setShort(n, s);
    }

    public synchronized void setInt(int n, int n2) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((PreparedStatement)this.m_stmt).setInt(n, n2);
    }

    public synchronized void setLong(int n, long l) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((PreparedStatement)this.m_stmt).setLong(n, l);
    }

    public synchronized void setFloat(int n, float f) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((PreparedStatement)this.m_stmt).setFloat(n, f);
    }

    public synchronized void setDouble(int n, double d) throws SQLException {
        if (this.m_stmt != null && this.m_stmtType != 0) {
            ((PreparedStatement)this.m_stmt).setDouble(n, d);
        }
    }

    public synchronized void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((PreparedStatement)this.m_stmt).setBigDecimal(n, bigDecimal);
    }

    public synchronized void setString(int n, String string) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((PreparedStatement)this.m_stmt).setString(n, string);
    }

    public synchronized void setFixedCHAR(int n, String string) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((OraclePreparedStatement)this.m_stmt).setFixedCHAR(n, string);
    }

    public synchronized void setCursor(int n, ResultSet resultSet) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((OraclePreparedStatement)this.m_stmt).setCursor(n, resultSet);
    }

    public synchronized void setROWID(int n, ROWID rOWID) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((OraclePreparedStatement)this.m_stmt).setROWID(n, rOWID);
    }

    public synchronized void setARRAY(int n, ARRAY aRRAY) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((OraclePreparedStatement)this.m_stmt).setARRAY(n, aRRAY);
    }

    public synchronized void setSTRUCT(int n, STRUCT sTRUCT) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((OraclePreparedStatement)this.m_stmt).setSTRUCT(n, sTRUCT);
    }

    public synchronized void setRAW(int n, RAW rAW) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((OraclePreparedStatement)this.m_stmt).setRAW(n, rAW);
    }

    public synchronized void setCHAR(int n, CHAR cHAR) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((OraclePreparedStatement)this.m_stmt).setCHAR(n, cHAR);
    }

    public synchronized void setDATE(int n, DATE dATE) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((OraclePreparedStatement)this.m_stmt).setDATE(n, dATE);
    }

    public synchronized void setNUMBER(int n, NUMBER nUMBER) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((OraclePreparedStatement)this.m_stmt).setNUMBER(n, nUMBER);
    }

    public synchronized void setBLOB(int n, BLOB bLOB) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((OraclePreparedStatement)this.m_stmt).setBLOB(n, bLOB);
    }

    public synchronized void setCLOB(int n, CLOB cLOB) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((OraclePreparedStatement)this.m_stmt).setCLOB(n, cLOB);
    }

    public synchronized void setBFILE(int n, BFILE bFILE) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((OraclePreparedStatement)this.m_stmt).setBFILE(n, bFILE);
    }

    public synchronized void setBfile(int n, BFILE bFILE) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((OraclePreparedStatement)this.m_stmt).setBfile(n, bFILE);
    }

    public synchronized void setBytes(int n, byte[] byArray) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((OraclePreparedStatement)this.m_stmt).setBytes(n, byArray);
    }

    public synchronized void setDate(int n, Date date) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((OraclePreparedStatement)this.m_stmt).setDate(n, date);
    }

    public synchronized void setTime(int n, Time time) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((OraclePreparedStatement)this.m_stmt).setTime(n, time);
    }

    public synchronized void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((OraclePreparedStatement)this.m_stmt).setTimestamp(n, timestamp);
    }

    public synchronized void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((OraclePreparedStatement)this.m_stmt).setUnicodeStream(n, inputStream, n2);
    }

    public synchronized void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((OraclePreparedStatement)this.m_stmt).setAsciiStream(n, inputStream, n2);
    }

    public synchronized void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((OraclePreparedStatement)this.m_stmt).setBinaryStream(n, inputStream, n2);
    }

    public synchronized void setCustomDatum(int n, CustomDatum customDatum) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((OraclePreparedStatement)this.m_stmt).setCustomDatum(n, customDatum);
    }

    public synchronized void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((OraclePreparedStatement)this.m_stmt).setObject(n, object, n2, n3);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((OraclePreparedStatement)this.m_stmt).setObject(n, object, n2);
    }

    public void setRefType(int n, REF rEF) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((OraclePreparedStatement)this.m_stmt).setRefType(n, rEF);
    }

    public synchronized void setREF(int n, REF rEF) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((OraclePreparedStatement)this.m_stmt).setREF(n, rEF);
    }

    public synchronized void setObject(int n, Object object) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((OraclePreparedStatement)this.m_stmt).setObject(n, object);
    }

    public synchronized void setOracleObject(int n, Datum datum) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((OraclePreparedStatement)this.m_stmt).setOracleObject(n, datum);
    }

    public synchronized void registerOutParameter(int n, int n2, String string) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((OracleCallableStatement)this.m_stmt).registerOutParameter(n, n2, string);
    }

    public synchronized void registerOutParameter(int n, int n2, int n3) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((OracleCallableStatement)this.m_stmt).registerOutParameter(n, n2, n3);
    }

    public synchronized void registerOutParameter(int n, int n2, int n3, int n4) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((OracleCallableStatement)this.m_stmt).registerOutParameter(n, n2, n3, n4);
    }

    public synchronized void registerOutParameter(int n, int n2) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((OracleCallableStatement)this.m_stmt).registerOutParameter(n, n2);
    }

    public String getString(int n) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((OracleCallableStatement)this.m_stmt).getString(n);
    }

    public Datum getOracleObject(int n) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((OracleCallableStatement)this.m_stmt).getOracleObject(n);
    }

    public ROWID getROWID(int n) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((OracleCallableStatement)this.m_stmt).getROWID(n);
    }

    public NUMBER getNUMBER(int n) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((OracleCallableStatement)this.m_stmt).getNUMBER(n);
    }

    public DATE getDATE(int n) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((OracleCallableStatement)this.m_stmt).getDATE(n);
    }

    public REF getREF(int n) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((OracleCallableStatement)this.m_stmt).getREF(n);
    }

    public ARRAY getARRAY(int n) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((OracleCallableStatement)this.m_stmt).getARRAY(n);
    }

    public STRUCT getSTRUCT(int n) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((OracleCallableStatement)this.m_stmt).getSTRUCT(n);
    }

    public CHAR getCHAR(int n) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((OracleCallableStatement)this.m_stmt).getCHAR(n);
    }

    public RAW getRAW(int n) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((OracleCallableStatement)this.m_stmt).getRAW(n);
    }

    public BLOB getBLOB(int n) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((OracleCallableStatement)this.m_stmt).getBLOB(n);
    }

    public CLOB getCLOB(int n) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((OracleCallableStatement)this.m_stmt).getCLOB(n);
    }

    public BFILE getBFILE(int n) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((OracleCallableStatement)this.m_stmt).getBFILE(n);
    }

    public boolean getBoolean(int n) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((OracleCallableStatement)this.m_stmt).getBoolean(n);
    }

    public byte getByte(int n) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((OracleCallableStatement)this.m_stmt).getByte(n);
    }

    public short getShort(int n) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((OracleCallableStatement)this.m_stmt).getShort(n);
    }

    public int getInt(int n) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((OracleCallableStatement)this.m_stmt).getInt(n);
    }

    public long getLong(int n) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((OracleCallableStatement)this.m_stmt).getLong(n);
    }

    public float getFloat(int n) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((OracleCallableStatement)this.m_stmt).getFloat(n);
    }

    public double getDouble(int n) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((OracleCallableStatement)this.m_stmt).getDouble(n);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((OracleCallableStatement)this.m_stmt).getBigDecimal(n);
    }

    public byte[] getBytes(int n) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((OracleCallableStatement)this.m_stmt).getBytes(n);
    }

    public Date getDate(int n) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((OracleCallableStatement)this.m_stmt).getDate(n);
    }

    public Time getTime(int n) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((OracleCallableStatement)this.m_stmt).getTime(n);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((OracleCallableStatement)this.m_stmt).getTimestamp(n);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((OracleCallableStatement)this.m_stmt).getAsciiStream(n);
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((OracleCallableStatement)this.m_stmt).getUnicodeStream(n);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        if (this.m_stmt != null && this.m_stmtType == 2) {
            return ((OracleCallableStatement)this.m_stmt).getBinaryStream(n);
        }
        return null;
    }

    public Object getObject(int n) throws SQLException {
        if (this.m_stmt != null && this.m_stmtType == 2) {
            return ((OracleCallableStatement)this.m_stmt).getObject(n);
        }
        return null;
    }

    public Object getCustomDatum(int n, CustomDatumFactory customDatumFactory) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((OracleCallableStatement)this.m_stmt).getCustomDatum(n, customDatumFactory);
    }

    public ResultSet getCursor(int n) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((OracleCallableStatement)this.m_stmt).getCursor(n);
    }

    public String getResultAsXMLString() throws SQLException {
        ResultSet resultSet = this.executeQuery();
        String string = BeanUtil.translateToXML(this.m_conn, this.m_sql, resultSet);
        resultSet.close();
        return string;
    }

    public String getResultAsXMLString(String string) throws SQLException {
        ResultSet resultSet = this.executeQuery(string);
        String string2 = BeanUtil.translateToXML(this.m_conn, string, resultSet);
        resultSet.close();
        return string2;
    }

    public String getResultAsHTMLTable(String string) throws SQLException {
        ResultSet resultSet = this.executeQuery(string);
        String string2 = BeanUtil.translateToHTMLTable(resultSet);
        if (resultSet != null) {
            resultSet.close();
        }
        return string2;
    }

    public String getResultAsHTMLTable() throws SQLException {
        ResultSet resultSet = this.executeQuery();
        String string = BeanUtil.translateToHTMLTable(resultSet);
        resultSet.close();
        return string;
    }

    public void outOfScope(JspScopeEvent jspScopeEvent) {
        try {
            this.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }
}

