/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.addr;

import oracle.net.asst.addr.Address;
import oracle.net.asst.addr.CreateAddressException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public class AddressFactory {
    private static AddressFactory _sfactory = null;

    public static void loadClass() {
    }

    private AddressFactory() {
    }

    public static AddressFactory getFactory() {
        if (_sfactory == null) {
            _sfactory = new AddressFactory();
        }
        return _sfactory;
    }

    public Address createAddress(NVPair nVPair) throws CreateAddressException {
        if (nVPair == null) {
            throw new IllegalArgumentException("AddressFactory.createAddress(): NVPair nvp is null.");
        }
        if (nVPair.getRHSType() != NVPair.RHS_LIST) {
            throw new CreateAddressException("The ADDRESS section does not contain a list of parameters.");
        }
        NVNavigator nVNavigator = new NVNavigator();
        NVPair nVPair2 = nVNavigator.findNVPair(nVPair, "PROTOCOL");
        if (nVPair2 == null) {
            throw new CreateAddressException("A PROTOCOL could not be found for this Address.");
        }
        if (nVPair2.getRHSType() != NVPair.RHS_ATOM) {
            throw new CreateAddressException("The value for the PROTOCOL in the Address is invalid.");
        }
        return new Address(nVPair);
    }

    public Address createAddress(String string) throws CreateAddressException {
        NVFactory nVFactory = new NVFactory();
        NVPair nVPair = nVFactory.createNVPair(string);
        Address address = this.createAddress(nVPair);
        return address;
    }

    private static void _print(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        String string;
        Address address;
        String string2;
        String string3;
        if (_sfactory == null) {
            _sfactory = new AddressFactory();
        }
        AddressFactory addressFactory = _sfactory;
        System.out.println("Verifying createAddress()");
        try {
            System.out.println("  With VALID input: ");
            string3 = "(Address = (Protocol = TCPS) (Port = 1521) (Host = winter))";
            string2 = "    Case 0: " + string3;
            System.out.println(string2);
            address = addressFactory.createAddress(string3);
            string2 = "      Result = " + address.toNVString();
            System.out.println(string2);
            string3 = "(Address = (Protocol = TCP) (Port = 1521) (Host = winter))";
            string2 = "    Case 1: " + string3;
            System.out.println(string2);
            address = addressFactory.createAddress(string3);
            string2 = "      Result = " + address.toNVString();
            System.out.println(string2);
            string3 = "(address=(service = winter_lsnr)(protocol = spx))";
            string2 = "    Case 2: " + string3;
            System.out.println(string2);
            address = addressFactory.createAddress(string3);
            string2 = "      Result = " + address.toNVString();
            System.out.println(string2);
            string3 = "(ADDRESS=(PROTOCOl=NMP)(SERVER=winter)(PIPE=ORAPIPE))";
            string2 = "    Case 3: " + string3;
            System.out.println(string2);
            address = addressFactory.createAddress(string3);
            string2 = "      Result = " + address.toNVString();
            System.out.println(string2);
            string3 = "(ADDRESS=(PROTOCOl=BEQ)(ARGV0 = oracle73DEQ))";
            string2 = "    Case 4: " + string3;
            System.out.println(string2);
            address = addressFactory.createAddress(string3);
            string2 = "      Result = " + address.toNVString();
            System.out.println(string2);
            string3 = "(ADDRESS=(PROTOCOl=IPC)(KEY = oracle))";
            string2 = "    Case 5: " + string3;
            System.out.println(string2);
            address = addressFactory.createAddress(string3);
            string2 = "      Result = " + address.toNVString();
            System.out.println(string2);
        }
        catch (CreateAddressException createAddressException) {
            string = "      ERROR: Unexpected exception: " + createAddressException.getMessage();
            System.out.println(string);
        }
        System.out.println("\n  With INVALID input: ");
        try {
            string3 = "(ADDRESS=(PROTOCOl=IPC)(KEY=winter))";
            string2 = "    Case 1: " + string3;
            System.out.println(string2);
            address = addressFactory.createAddress(string3);
            System.out.println("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            string = "      Exception Received: " + createAddressException.getMessage();
            System.out.println(string);
        }
        try {
            string3 = "(ADDRESS=NONE)";
            string2 = "    Case 2: " + string3;
            System.out.println(string2);
            address = addressFactory.createAddress(string3);
            System.out.println("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            string = "      Exception Received: " + createAddressException.getMessage();
            System.out.println(string);
        }
        try {
            string3 = "(()()((())))";
            string2 = "    Case 3: " + string3;
            System.out.println(string2);
            address = addressFactory.createAddress(string3);
            System.out.println("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            string = "      Exception Received: " + createAddressException.getMessage();
            System.out.println(string);
        }
        try {
            string3 = "(Address=(Host=winter)(Port=1521))";
            string2 = "    Case 4: " + string3;
            System.out.println(string2);
            address = addressFactory.createAddress(string3);
            System.out.println("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            string = "      Exception Received: " + createAddressException.getMessage();
            System.out.println(string);
        }
        try {
            string3 = "(ADDRESS=(PROTOCOL=(A=B))(HOST=winter)(Port=1521))";
            string2 = "    Case 5: " + string3;
            System.out.println(string2);
            address = addressFactory.createAddress(string3);
            System.out.println("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            string = "      Exception Received: " + createAddressException.getMessage();
            System.out.println(string);
        }
        try {
            string3 = "(ADDRESS=)";
            string2 = "    Case 6: " + string3;
            System.out.println(string2);
            address = addressFactory.createAddress(string3);
            System.out.println("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            string = "      Exception Received: " + createAddressException.getMessage();
            System.out.println(string);
        }
        System.out.println("\n  With PROTOCOL-specific INVALID input: ");
        try {
            string3 = "(address = (protocol=tcp)(port=1521))";
            string2 = "    Case 1: " + string3;
            System.out.println(string2);
            address = addressFactory.createAddress(string3);
            System.out.println("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            string = "      Exception Received: " + createAddressException.getMessage();
            System.out.println(string);
        }
        try {
            string3 = "(address = (protocol=tcp)(host=summer))";
            string2 = "    Case 2: " + string3;
            System.out.println(string2);
            address = addressFactory.createAddress(string3);
            System.out.println("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            string = "      Exception Received: " + createAddressException.getMessage();
            System.out.println(string);
        }
        try {
            string3 = "(address = (protocol=tcp)(host=summer)(port=1521)";
            string2 = "    Case 3: " + string3;
            System.out.println(string2);
            address = addressFactory.createAddress(string3);
            System.out.println("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            string = "      Exception Received: " + createAddressException.getMessage();
            System.out.println(string);
        }
        try {
            string3 = "(address = (protocol=tcp)(host=summer)(port=foo))";
            string2 = "    Case 4: " + string3;
            System.out.println(string2);
            address = addressFactory.createAddress(string3);
            System.out.println("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            string = "      Exception Received: " + createAddressException.getMessage();
            System.out.println(string);
        }
        try {
            string3 = "(address = (protocol=spx))";
            string2 = "    Case 5: " + string3;
            System.out.println(string2);
            address = addressFactory.createAddress(string3);
            System.out.println("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            string = "      Exception Received: " + createAddressException.getMessage();
            System.out.println(string);
        }
        try {
            string3 = "(address = (protocol=spx)(service=summer_lsnr)";
            string2 = "    Case 6: " + string3;
            System.out.println(string2);
            address = addressFactory.createAddress(string3);
            System.out.println("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            string = "      Exception Received: " + createAddressException.getMessage();
            System.out.println(string);
        }
        try {
            string3 = "(address = (protocol=nmp)(pipe=orapipe))";
            string2 = "    Case 7: " + string3;
            System.out.println(string2);
            address = addressFactory.createAddress(string3);
            System.out.println("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            string = "      Exception Received: " + createAddressException.getMessage();
            System.out.println(string);
        }
        try {
            string3 = "(address = (protocol=nmp)(server=summer))";
            string2 = "    Case 8: " + string3;
            System.out.println(string2);
            address = addressFactory.createAddress(string3);
            System.out.println("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            string = "      Exception Received: " + createAddressException.getMessage();
            System.out.println(string);
        }
        try {
            string3 = "(address = (protocol=nmp)(server=summer)(pipe=orapipe)";
            string2 = "    Case 9: " + string3;
            System.out.println(string2);
            address = addressFactory.createAddress(string3);
            System.out.println("    ERROR: expected CreateAddressException");
            return;
        }
        catch (CreateAddressException createAddressException) {
            string = "      Exception Received: " + createAddressException.getMessage();
            System.out.println(string);
            return;
        }
    }
}

