/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.addr;

import oracle.net.asst.addr.Address;
import oracle.net.asst.addr.CreateAddressException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public final class BEQAddress
extends Address {
    public static String BEQ_PROTOCOL = "BEQ";

    protected BEQAddress(NVPair nVPair) throws CreateAddressException {
        super(nVPair);
        String string = Address._getParameter(nVPair, "PROTOCOL");
        if (string == null || !string.equalsIgnoreCase(BEQ_PROTOCOL)) {
            throw new CreateAddressException("Bequeath: Invalid protocol (" + string + ") in Address.");
        }
        String string2 = BEQ_PROTOCOL;
        this._setParameter("PROTOCOL", string2);
        this.setSID("ORCL");
    }

    public String getSID() {
        String string = this._getParameter("ARGV0");
        String string2 = string.substring(8);
        return string2;
    }

    public void setSID(String string) {
        this._setParameter("PROGRAM", "oracle80");
        this._setParameter("ARGV0", "oracle80" + string);
        this._setParameter("ARGS", "'(DESCRIPTION=(LOCAL=YES)(ADDRESS=(PROTOCOL=BEQ)))'");
    }

    private static void _validateSID(String string) {
    }

    private static void _print(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        String string;
        BEQAddress bEQAddress;
        NVPair nVPair;
        String string2;
        String string3;
        NVFactory nVFactory = new NVFactory();
        System.out.println("Verifying constructor BEQAddress(nvp)");
        System.out.println("  With VALID input");
        try {
            string3 = "(ADDRESS=(PROTOCOL=BEQ)(ARGV0=oracle73ORCL))";
            string2 = "    Case 1: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            bEQAddress = new BEQAddress(nVPair);
            string2 = "      Result: " + bEQAddress.toNVString();
            System.out.println(string2);
            string3 = "(Address = (ARGV0=oracle80EM1) (protocol = BEQ))";
            string2 = "    Case 2: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            bEQAddress = new BEQAddress(nVPair);
            string2 = "      Result: " + bEQAddress.toNVString();
            System.out.println(string2);
            string3 = "(address = (Protocol = BEQ) (argv0 = oracle80Tst))";
            string2 = "    Case 3: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            bEQAddress = new BEQAddress(nVPair);
            string2 = "      Result: " + bEQAddress.toNVString();
            System.out.println(string2);
        }
        catch (CreateAddressException createAddressException) {
            string = "      ERROR: Unexpected exception: " + createAddressException.getMessage();
            System.out.println(string);
        }
        System.out.println("\n  With INVALID input");
        try {
            string3 = "(address = (argv0 = oracle80orcl))";
            string2 = "    Case 1: Missing protocol: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            bEQAddress = new BEQAddress(nVPair);
            System.out.println("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            string = "      Exception Received: " + createAddressException.getMessage();
            System.out.println(string);
        }
        try {
            string3 = "(address = (protocol=tcp)(host=winter)(port=1521))";
            string2 = "    Case 2: Incorrect protocol: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            bEQAddress = new BEQAddress(nVPair);
            System.out.println("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            string = "      Exception Received: " + createAddressException.getMessage();
            System.out.println(string);
        }
        try {
            string3 = "(address = (protocol=BEQ))";
            string2 = "    Case 3: Missing ARGV0: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            bEQAddress = new BEQAddress(nVPair);
            System.out.println("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            string = "      Exception Received: " + createAddressException.getMessage();
            System.out.println(string);
        }
        try {
            string3 = "(address = (protocol=BEQ)(argv0 = oracle80orcl)";
            string2 = "    Case 4: Parse error: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            bEQAddress = new BEQAddress(nVPair);
            System.out.println("      ERROR: expected NVParseException");
            return;
        }
        catch (CreateAddressException createAddressException) {
            string = "      ERROR: Unexpected exception: " + createAddressException.getMessage();
            System.out.println(string);
            return;
        }
    }
}

