/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.container;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import oracle.ewt.EwtContainer;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.net.asst.container.ContextSelectionPanel;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.common.dataStore.DataStoreException;
import oracle.net.common.dataStore.LDAPDataStore;

public class ContextChooser
extends BufferedDialog
implements ActionListener {
    private Frame m_frame;
    private ContextSelectionPanel m_contextPanel;
    private String m_okString;
    private String m_cancelString;
    private String m_helpString;
    private String m_context;
    private static final String HELP_TOPIC = "TOPICchangeContext";

    public ContextChooser(Frame frame, String string, String string2, int n, String[] stringArray) {
        super(frame, string, true);
        LDAPDataStore lDAPDataStore;
        NetStrings netStrings = new NetStrings();
        this.m_okString = netStrings.getString("CNTOK");
        this.m_cancelString = netStrings.getString("CNTCancel");
        this.m_helpString = netStrings.getString("CNTHelp");
        LWButton lWButton = new LWButton(this.m_okString);
        lWButton.setLeftmost(true);
        LWButton lWButton2 = new LWButton(this.m_cancelString);
        lWButton2.setRightmost(true);
        LWButton lWButton3 = new LWButton(this.m_helpString);
        lWButton3.setLeftmost(true);
        lWButton3.setRightmost(true);
        lWButton.addActionListener((ActionListener)this);
        lWButton2.addActionListener((ActionListener)this);
        lWButton3.addActionListener((ActionListener)this);
        EwtContainer ewtContainer = new EwtContainer();
        ewtContainer.setBorderPainter((BorderPainter)new FixedBorderPainter(15, 5, 5, 5));
        ewtContainer.add((Component)lWButton);
        ewtContainer.add((Component)lWButton2);
        ewtContainer.add((Component)lWButton3);
        try {
            lDAPDataStore = new LDAPDataStore();
            lDAPDataStore.setAuthInfo(n, stringArray);
            this.m_contextPanel = new ContextSelectionPanel(lDAPDataStore, lDAPDataStore.getOracleContext());
        }
        catch (DataStoreException dataStoreException) {
            return;
        }
        lDAPDataStore = new EwtContainer();
        lDAPDataStore.setBorderPainter((BorderPainter)new FixedBorderPainter(15, 15, 15, 15));
        ((Container)((Object)lDAPDataStore)).setLayout(new BorderLayout());
        ((Container)((Object)lDAPDataStore)).add((Component)((Object)this.m_contextPanel), "Center");
        ((Container)((Object)lDAPDataStore)).add((Component)ewtContainer, "South");
        ((Container)((Object)this)).add((Component)((Object)lDAPDataStore), "Center");
        ((Window)((Object)this)).pack();
        ((Dialog)((Object)this)).setResizable(false);
        ((Window)((Object)this)).addWindowListener(new 1());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equalsIgnoreCase(this.m_helpString)) {
            NetUtils.getHelpContext().showTopic(HELP_TOPIC);
            return;
        }
        this.m_context = string.equalsIgnoreCase(this.m_cancelString) ? null : this.m_contextPanel.getContext();
        ((Component)((Object)this)).setVisible(false);
    }

    public String choose(String string) {
        if (this.m_contextPanel == null) {
            return string;
        }
        this.m_contextPanel.setContext(string);
        ((Window)((Object)this)).pack();
        ((Dialog)((Object)this)).show();
        return this.m_context;
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            ((Component)((Object)ContextChooser.this)).setVisible(false);
        }

        /* synthetic */ 1() {
        }
    }
}

