/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.container;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.util.StringTokenizer;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NullFieldMessage;
import oracle.net.asst.container.RangeErrorMessage;

public class NetValidate {
    NetStrings netStrings = new NetStrings();
    BufferedFrame frame;
    Toolkit toolkit;
    String os;

    public NetValidate(BufferedFrame bufferedFrame) {
        this.frame = bufferedFrame;
        this.toolkit = bufferedFrame.getToolkit();
        this.os = System.getProperty("os.name");
    }

    public boolean validateNumber(LWTextField lWTextField, int n, int n2) {
        int n3;
        String string = lWTextField.getText();
        try {
            n3 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return n3 >= n && n3 <= n2;
    }

    public void validateNumber(KeyEvent keyEvent, String string, int n, int n2) {
        Component component = keyEvent.getComponent();
        char c = keyEvent.getKeyChar();
        LWTextField lWTextField = (LWTextField)component;
        String string2 = lWTextField.getText();
        if (c == '\b') {
            return;
        }
        if (Character.isDigit(c)) {
            String string3 = this.os.startsWith("Windows") ? new String(String.valueOf(string2) + String.valueOf(c)) : new String(string2);
            int n3 = Integer.parseInt(string3);
            if (n3 >= n && n3 <= n2) {
                return;
            }
            RangeErrorMessage.display((Component)this.frame, string, n, n2);
        }
        if (this.os.startsWith("Windows")) {
            keyEvent.setKeyChar('\u0000');
            return;
        }
        lWTextField.setText(string2.substring(0, string2.length() - 1));
    }

    public void showDialog(String string, int n, int n2) {
        RangeErrorMessage.display((Component)this.frame, this.cleanFieldName(string), n, n2);
    }

    public void showDialog(String string) {
        NullFieldMessage.display((Component)this.frame, string);
    }

    public boolean validateHostName(LWTextField lWTextField) {
        String string = lWTextField.getText();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!Character.isLetterOrDigit(c) && c != '-' && c != '_' && c != '.') {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean validateName(LWTextField lWTextField) {
        return this.validateName(lWTextField.getText());
    }

    public boolean validateName(String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!Character.isLetterOrDigit(c) && c != '-' && c != '.' && c != '_') {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String cleanFieldName(String string) {
        if (string.endsWith(":")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static boolean validateServiceName(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() < 1 || string.length() > 137) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        String string2 = stringTokenizer.nextToken();
        int n = string2.length();
        if (n > 8) {
            return false;
        }
        if (!Character.isLetter(string2.charAt(0))) {
            return false;
        }
        int n2 = 1;
        while (n2 < n) {
            char c = string2.charAt(n2);
            if (!Character.isLetterOrDigit(c) && c != '_' && c != '#' && c != '$') {
                return false;
            }
            ++n2;
        }
        if (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            int n3 = string3.length();
            if (n3 > 128) {
                return false;
            }
            int n4 = 0;
            while (n4 < n3) {
                char c = string3.charAt(n4);
                if (!Character.isLetterOrDigit(c) && c != '_' && c != '#' && c != '.') {
                    return false;
                }
                ++n4;
            }
        }
        return true;
    }

    public static boolean validateSID(String string) {
        if (string == null) {
            return false;
        }
        if (string.equals("PLSExtProc")) {
            return true;
        }
        if (string.length() < 1 || string.length() > 8) {
            return false;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (!Character.isLetterOrDigit(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

