/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.listener;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.alert.Alert;
import oracle.ewt.border.Border;
import oracle.ewt.border.GroupBoxBorder;
import oracle.ewt.graphics.frame.InsetFramePainter;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWPasswordField;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.listener.ListenerCache;
import oracle.net.asst.listener.ListenerGeneric;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVPair;
import oracle.sysman.emSDK.client.appContainer.WebApplication;

public class ListenerAuthentication
extends EwtContainer
implements ListenerCache,
ItemListener,
KeyListener {
    private String name;
    private WebApplication app = ListenerGeneric.getApp();
    private NetStrings ns = ListenerGeneric.getNS();
    private NLParamParser nlpa = ListenerGeneric.getNLP();
    private boolean changed = false;
    private String authString;
    private String requiredString;
    private String notRequiredString;
    private String passwordString;
    private String confirmString;
    private LWLabel passwordLabel;
    private LWLabel confirmLabel;
    private LWCheckbox requiredBox;
    private LWCheckbox notRequiredBox;
    private LWCheckboxGroup logGroup = new LWCheckboxGroup();
    private int pwCount;
    private String[] pwArray;
    private EwtContainer passwordsPanel;
    private LWPasswordField passwordField;
    private LWPasswordField confirmField;

    public ListenerAuthentication() {
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        ((GridBagLayout)((Container)((Object)this)).getLayout()).setConstraints((Component)((Object)this), gridBagConstraints);
        this.authString = new String(this.ns.getString("LCCAuthentication"));
        this.requiredString = new String(this.ns.getString("LCCPasswordRequired"));
        this.notRequiredString = new String(this.ns.getString("LCCPasswordNotRequired"));
        this.passwordString = new String(this.ns.getString("LCCPassword"));
        this.confirmString = new String(this.ns.getString("LCCConfirmPassword"));
        this.passwordLabel = new LWLabel(this.passwordString);
        this.confirmLabel = new LWLabel(this.confirmString);
        this.passwordField = new LWPasswordField("", 20);
        this.confirmField = new LWPasswordField("", 20);
        this.passwordField.addKeyListener(this);
        this.confirmField.addKeyListener(this);
        this.confirmField.setEditable(false);
        this.requiredBox = new LWCheckbox(this.requiredString, this.logGroup, false);
        this.notRequiredBox = new LWCheckbox(this.notRequiredString, this.logGroup, true);
        this.requiredBox.addItemListener((ItemListener)this);
        this.notRequiredBox.addItemListener((ItemListener)this);
        ListenerAuthentication listenerAuthentication = this;
        LWCheckbox lWCheckbox = this.notRequiredBox;
        ListenerGeneric.constrain((Container)((Object)listenerAuthentication), (Component)lWCheckbox, 0, 0, 1, 1, 0, 18, 0.0, 0.0, 15, 15, 0, 0);
        listenerAuthentication = this;
        lWCheckbox = this.requiredBox;
        ListenerGeneric.constrain((Container)((Object)listenerAuthentication), (Component)lWCheckbox, 0, 1, 1, 1, 0, 18, 0.0, 0.0, 0, 15, 0, 0);
        this.passwordsPanel = new EwtContainer();
        this.passwordsPanel.setBorder((Border)new GroupBoxBorder("", InsetFramePainter.getFramePainter(), 2));
        this.passwordsPanel.setLayout(new GridBagLayout());
        listenerAuthentication = this.passwordsPanel;
        lWCheckbox = this.passwordLabel;
        ListenerGeneric.constrain((Container)((Object)listenerAuthentication), (Component)lWCheckbox, 0, 0, 1, 1, 0, 18, 0.0, 0.0, 10, 0, 10, 0);
        listenerAuthentication = this.passwordsPanel;
        lWCheckbox = this.passwordField;
        ListenerGeneric.constrain((Container)((Object)listenerAuthentication), (Component)lWCheckbox, 1, 0, 1, 1, 0, 18, 0.0, 0.0, 10, 0, 10, 0);
        listenerAuthentication = this.passwordsPanel;
        lWCheckbox = this.confirmLabel;
        ListenerGeneric.constrain((Container)((Object)listenerAuthentication), (Component)lWCheckbox, 0, 1, 1, 1, 0, 18, 0.0, 0.0, 0, 0, 10, 0);
        listenerAuthentication = this.passwordsPanel;
        lWCheckbox = this.confirmField;
        ListenerGeneric.constrain((Container)((Object)listenerAuthentication), (Component)lWCheckbox, 1, 1, 1, 1, 0, 18, 0.0, 0.0, 0, 0, 10, 0);
        listenerAuthentication = this;
        lWCheckbox = this.passwordsPanel;
        ListenerGeneric.constrain((Container)((Object)listenerAuthentication), (Component)lWCheckbox, 0, 1, 1, 1, 1, 18, 0.0, 0.0, 0, 10, 10, 10);
        ListenerGeneric.constrain((Container)((Object)this), (Component)new LWLabel(" "), 0, 2, 1, 1, 1, 18, 100.0, 100.0, 0, 0, 0, 0);
    }

    public void addNotify() {
        super.addNotify();
        this.requiredBox.setBackground(this.requiredBox.getBackground());
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.changed = true;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object.equals(this.requiredBox)) {
            this.passwordsPanel.setEnabled(true);
            this.passwordField.setEditable(true);
            this.confirmField.setEditable(true);
            this.passwordsPanel.repaint(0L);
        } else if (object.equals(this.notRequiredBox)) {
            this.passwordsPanel.setEnabled(false);
            this.passwordField.setEditable(false);
            this.confirmField.setEditable(false);
        }
        this.changed = true;
    }

    public void setListenerName(String string) {
        this.name = string;
    }

    public void set() {
        if (this.notRequiredBox.getState()) {
            this.nlpa.removeNLPListElement("PASSWORDS_" + this.name);
            this.changed = false;
            return;
        }
        try {
            String string = "(" + this.passwordField.getText();
            if (this.pwCount > 1) {
                int n = 1;
                while (n < this.pwCount) {
                    string = String.valueOf(string) + ", " + this.pwArray[n - 1];
                    ++n;
                }
            }
            string = String.valueOf(string) + ")";
            this.nlpa.addNLPListElement("PASSWORDS_" + this.name + "=" + string);
        }
        catch (NLException nLException) {
            ListenerGeneric.devTrc("ListenerAuthentication.set: nlpa exception");
        }
        this.changed = false;
    }

    public void get() {
        NVPair nVPair = this.nlpa.getNLPListElement("PASSWORDS_" + this.name);
        if (nVPair != null) {
            if (nVPair.getRHSType() == NVPair.RHS_LIST) {
                this.pwCount = nVPair.getListSize();
                this.pwArray = new String[this.pwCount - 1];
                this.passwordField.setText(nVPair.getListElement(0).getAtom());
                this.confirmField.setText(nVPair.getListElement(0).getAtom());
                int n = 1;
                while (n < this.pwCount) {
                    this.pwArray[n - 1] = nVPair.getListElement(n).getAtom();
                    ++n;
                }
            } else if (nVPair.getRHSType() == NVPair.RHS_ATOM) {
                this.pwCount = 1;
                this.passwordField.setText(nVPair.getAtom());
                this.confirmField.setText(nVPair.getAtom());
            }
            this.requiredBox.setState(true);
            this.passwordsPanel.setEnabled(true);
            this.passwordField.setEditable(true);
            this.confirmField.setEditable(true);
            return;
        }
        this.requiredBox.setState(false);
        this.passwordsPanel.setEnabled(false);
        this.passwordField.setEditable(false);
        this.confirmField.setEditable(false);
    }

    public boolean isChanged() {
        return this.changed;
    }

    public boolean areDataValid() {
        return this.notRequiredBox.getState() || this.passwordField.getText().length() > 0 && this.confirmField.getText().equals(this.passwordField.getText());
    }

    public void setFocus() {
        BufferedFrame bufferedFrame = (BufferedFrame)ListenerGeneric.getApp().getFrame();
        if (this.passwordField.getText().length() == 0) {
            Alert alert = new Alert((Frame)bufferedFrame, this.ns.getString("LCCMustSpecifyPassword"), 0, 1);
            alert.setTitle(this.ns.getString("nnaError"));
            alert.setDefaultButton(1);
            alert.setCenterOver((Component)bufferedFrame);
            alert.runAlert();
            alert.dispose();
            this.passwordField.requestFocus();
            return;
        }
        Alert alert = new Alert((Frame)bufferedFrame, this.ns.getString("LCCPasswordsDontMatch"), 0, 1);
        alert.setTitle(this.ns.getString("nnaError"));
        alert.setDefaultButton(1);
        alert.setCenterOver((Component)bufferedFrame);
        alert.runAlert();
        alert.dispose();
        this.confirmField.requestFocus();
        this.confirmField.selectAll();
    }
}

