/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.listener;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Vector;
import oracle.ewt.alert.Alert;
import oracle.ewt.dTree.DTreeDeferringParent;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeSelectionEvent;
import oracle.ewt.dataSource.OneDDataSourceEvent;
import oracle.ewt.event.Cancelable;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.net.asst.component.NetComponent;
import oracle.net.asst.component.NetObjectMenu;
import oracle.net.asst.component.NetObjectToolbar;
import oracle.net.asst.component.NetVector;
import oracle.net.asst.container.NetContainer;
import oracle.net.asst.container.NetNameDialog;
import oracle.net.asst.container.NetPanel;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.container.NetValidate;
import oracle.net.asst.listener.ListenerConfigure;
import oracle.net.asst.listener.ListenerGeneric;
import oracle.net.common.dataStore.DataStore;
import oracle.net.common.dataStore.FileDataStore;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.sysman.emSDK.client.appContainer.WebApplication;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.DataDrivenTree;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeChildNode;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeDataSource;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeItem;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeItemData;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeNodeSelectionListener;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeParentNode;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeProxy;

public class ListenerComponent
extends NetComponent {
    NetStrings ns = ListenerGeneric.getNS();
    private final String TITLE = this.ns.getString("LCCListeners");
    private final String FILENAME = "listener.ora";
    private WebApplication theApp;
    private NetContainer theContainer;
    private NetPanel lsnrPlacebo;
    private NetNameDialog dialog;
    private ListenerConfigure activeLsnr;
    private NetVector lsnrVector;
    private NLParamParser nlpa;
    private NetVector menuVect;
    private NetVector toolbarVect;
    private NetObjectMenu deleteMenuItem;
    private NetObjectMenu renameMenuItem;
    private NetObjectToolbar deleteToolbarItem;
    private TreeParentNode myTreeNode;
    private boolean loaded;
    private boolean changed;
    private boolean snmp_rw_exists;
    private FileDataStore fds;
    private final String[] ignoreArray = new String[]{"OSS.SOURCE.MY_WALLET", "SSL_CIPHER_SUITES", "SSL_VERSION", "SSL_CLIENT_AUTHENTICATION", "TRACE_TIMESTAMP_", "TRACE_FILELEN_", "TRACE_FILENO_"};
    private final String[] paramArray = new String[]{"CONNECT_TIMEOUT_", "LOG_DIRECTORY_", "LOG_FILE_", "LOGGING_", "PASSWORDS_", "SAVE_CONFIG_ON_STOP_", "SID_LIST_", "STARTUP_WAIT_TIME_", "TRACE_DIRECTORY_", "TRACE_FILE_", "TRACE_LEVEL_", "USE_PLUG_AND_PLAY_", "SERVICE_LIST_"};

    public ListenerComponent(WebApplication webApplication, DataStore dataStore) {
        ListenerGeneric.setTrace();
        this.theApp = webApplication;
        this.theContainer = NetUtils.getContainer();
        this.lsnrVector = new NetVector();
        if (dataStore instanceof FileDataStore) {
            this.fds = (FileDataStore)dataStore;
        }
        ListenerGeneric.setApp(this.theApp);
        ListenerGeneric.setHelp(NetUtils.getHelpContext());
        this.lsnrPlacebo = new NetPanel(this.theApp, "LC_placebo.gif", this.ns.getString("LCCIntroMessage"));
        this.menuVect = new NetVector();
        this.menuVect.addElement(new NetObjectMenu(this.ns.getString("CNTEdit"), this.ns.getString("CNTCreate"), true));
        this.deleteMenuItem = new NetObjectMenu(this.ns.getString("CNTEdit"), this.ns.getString("CNTDelete"), false);
        this.menuVect.addElement(this.deleteMenuItem);
        this.renameMenuItem = new NetObjectMenu(this.ns.getString("CNTEdit"), this.ns.getString("CNTRename"), false);
        this.menuVect.addElement(this.renameMenuItem);
        this.toolbarVect = new NetVector();
        this.toolbarVect.addElement(new NetObjectToolbar(this.ns.getString("CNTCreate"), null, true));
        this.deleteToolbarItem = new NetObjectToolbar(this.ns.getString("CNTDelete"), null, false);
        this.toolbarVect.addElement(this.deleteToolbarItem);
    }

    public DataStore getDataStore() {
        return this.fds;
    }

    public void loadData() {
        ListenerGeneric.devTrc("ListenerComponent::loadObjects " + this.fds.getAdminDir());
        Enumeration enumeration = this.lsnrVector.elements();
        while (enumeration.hasMoreElements()) {
            ((ListenerConfigure)enumeration.nextElement()).finalizeListener();
        }
        this.lsnrVector.removeAllElements();
        this.activeLsnr = null;
        this.changed = false;
        try {
            this.nlpa = new NLParamParser(String.valueOf(this.fds.getAdminDir()) + "listener.ora");
            ListenerGeneric.setNLP(this.nlpa);
        }
        catch (FileNotFoundException fileNotFoundException) {
            ListenerGeneric.devTrc("FileNotFoundException");
        }
        catch (IOException iOException) {
            ListenerGeneric.devTrc("IOException");
        }
        catch (NLException nLException) {
            ListenerGeneric.devTrc("NLException");
        }
        String[] stringArray = this.nlpa.getNLPAllNames();
        int n = 0;
        while (n < stringArray.length) {
            boolean bl = false;
            int n2 = 0;
            while (n2 < this.paramArray.length) {
                if (stringArray[n].startsWith(this.paramArray[n2])) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < this.ignoreArray.length) {
                if (stringArray[n].startsWith(this.ignoreArray[n3])) {
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (!bl) {
                this.loadListener(this.fds.getAdminDir(), stringArray[n]);
            }
            ++n;
        }
        this.loaded = true;
    }

    public TreeItem getTreeNode(DataDrivenTree dataDrivenTree) {
        if (this.myTreeNode == null) {
            this.myTreeNode = new TreeParentNode((TreeDataSource)new ListenerCompDataSource(dataDrivenTree), (TreeProxy)new ListenerCompProxy(dataDrivenTree), "oracle_sysman_netasst_lsnr_comp");
        }
        this.myTreeNode.setExpanded(false);
        return this.myTreeNode;
    }

    public boolean save(DataStore dataStore) {
        ListenerGeneric.devTrc("ListenerComponent::save");
        if (!this.loaded) {
            this.loadData();
        }
        if (this.activeLsnr != null && !this.activeLsnr.validateConfig()) {
            return false;
        }
        int n = 0;
        while (n < this.lsnrVector.size()) {
            if (this.lsnrVector.elementAt(n) != this.activeLsnr && !((ListenerConfigure)this.lsnrVector.elementAt(n)).validateConfig()) {
                return false;
            }
            ++n;
        }
        if (!(dataStore instanceof FileDataStore)) {
            return false;
        }
        this.fds = (FileDataStore)dataStore;
        int n2 = 0;
        while (n2 < this.lsnrVector.size()) {
            ListenerConfigure listenerConfigure = (ListenerConfigure)this.lsnrVector.elementAt(n2);
            listenerConfigure.set();
            if (listenerConfigure.snmpChanged()) {
                this.writeSNMP(this.fds.getAdminDir(), listenerConfigure.toString(), listenerConfigure.getSNMP());
            }
            ++n2;
        }
        try {
            this.nlpa.saveNLParams(String.valueOf(this.fds.getAdminDir()) + "listener.ora");
        }
        catch (IOException iOException) {
            System.err.println("failed writing listener.ora");
            return false;
        }
        this.changed = false;
        ListenerGeneric.devTrc("--saved--");
        return true;
    }

    public void refresh(DataStore dataStore) {
        ListenerGeneric.devTrc("ListenerComponent::discardObjects");
        if (dataStore instanceof FileDataStore) {
            this.fds = (FileDataStore)dataStore;
        }
        if (this.loaded) {
            this.loadData();
            ((DataDrivenTree)this.myTreeNode.getTree()).refreshTree((DTreeItem)this.myTreeNode);
            this.myTreeNode.setExpanded(false);
        }
    }

    public boolean isChanged() {
        if (!this.loaded) {
            return false;
        }
        if (this.changed) {
            return true;
        }
        int n = 0;
        while (n < this.lsnrVector.size()) {
            if (((ListenerConfigure)this.lsnrVector.elementAt(n)).isChanged()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void create(Object object) {
        ListenerConfigure listenerConfigure;
        ListenerGeneric.devTrc("ListenerComponent::createObject");
        if (!this.loaded) {
            this.loadData();
        }
        if (this.activeLsnr != null && !this.activeLsnr.validateConfig()) {
            return;
        }
        boolean bl = false;
        BufferedFrame bufferedFrame = (BufferedFrame)this.theApp.getFrame();
        bufferedFrame.getToolkit();
        String string = this.nextDefaultName();
        NetValidate netValidate = new NetValidate(bufferedFrame);
        this.dialog = new NetNameDialog(bufferedFrame, this.ns.getString("LCCChooseName"), null, this.ns.getString("LCCListenerName"), string, "TOPIClsnrNaming");
        while (!bl) {
            ((Component)((Object)this.dialog)).setVisible(true);
            if (this.dialog.getName() == null) {
                return;
            }
            if (this.lsnrVector.findObjectByName(this.dialog.getName()) != null) {
                listenerConfigure = new Alert((Frame)bufferedFrame, this.ns.getString("LCCDuplicate", new Object[]{this.dialog.getName()}), 0, 1);
                listenerConfigure.runAlert();
                string = this.dialog.getName();
                continue;
            }
            if (!netValidate.validateName(this.dialog.getName()) || this.dialog.getName() == "") {
                netValidate.showDialog(this.ns.getString("LCCListenerName"));
                string = this.dialog.getName();
                continue;
            }
            bl = true;
        }
        this.dialog.dispose();
        listenerConfigure = new ListenerConfigure(this.dialog.getName().toUpperCase());
        this.changed = true;
        this.lsnrVector.addElement(listenerConfigure);
        ((DataDrivenTree)this.myTreeNode.getTree()).refreshTree((DTreeItem)this.myTreeNode);
        this.myTreeNode.setExpanded(true);
        this.selectChildNode(listenerConfigure.toString());
    }

    public void delete() {
        ListenerGeneric.devTrc("ListenerComponent::deleteObject");
        if (this.activeLsnr == null) {
            return;
        }
        this.activeLsnr.finalizeListener();
        this.lsnrVector.removeElement(this.activeLsnr);
        int n = 0;
        while (n < this.paramArray.length) {
            this.nlpa.removeNLPListElement(String.valueOf(this.paramArray[n]) + this.activeLsnr.toString());
            ++n;
        }
        this.nlpa.removeNLPListElement(this.activeLsnr.toString());
        this.activeLsnr = null;
        ((DataDrivenTree)this.myTreeNode.getTree()).refreshTree((DTreeItem)this.myTreeNode);
        if (this.myTreeNode.getItemCount() > 0) {
            this.myTreeNode.setExpanded(true);
        } else {
            this.myTreeNode.setExpanded(false);
        }
        this.myTreeNode.getTree().getSelection().selectItem((DTreeItem)this.myTreeNode);
        this.changed = true;
    }

    public boolean executeComponentMenu(String string) {
        if (string.equals(this.ns.getString("CNTRename"))) {
            int n;
            if (this.activeLsnr == null) {
                return true;
            }
            String string2 = null;
            NetValidate netValidate = new NetValidate((BufferedFrame)this.theApp.getFrame());
            NetNameDialog netNameDialog = new NetNameDialog((BufferedFrame)this.theApp.getFrame(), null, this.ns.getString("LCCRenameInstructions"), null, null, null);
            while (true) {
                ((Component)((Object)netNameDialog)).setVisible(true);
                string2 = netNameDialog.getName();
                if (string2 == null) {
                    return true;
                }
                if (string2.equalsIgnoreCase(this.activeLsnr.toString())) {
                    return true;
                }
                n = 0;
                Enumeration enumeration = this.lsnrVector.elements();
                while (enumeration.hasMoreElements()) {
                    if (!enumeration.nextElement().toString().equalsIgnoreCase(string2)) continue;
                    n = 1;
                    break;
                }
                if (n != 0) {
                    Alert alert = new Alert(this.theApp.getFrame(), this.ns.getString("LCCDuplicate", new Object[]{string2}), 0, 1);
                    alert.runAlert();
                    continue;
                }
                if (!string2.equals("") && netValidate.validateName(string2)) break;
                netValidate.showDialog(this.ns.getString("CNTNetNameFieldLabel"));
            }
            n = 0;
            while (n < this.paramArray.length) {
                this.nlpa.removeNLPListElement(String.valueOf(this.paramArray[n]) + this.activeLsnr.toString());
                ++n;
            }
            this.nlpa.removeNLPListElement(this.activeLsnr.toString());
            this.activeLsnr.setListenerName(string2.toUpperCase());
            this.changed = true;
            ((DataDrivenTree)this.myTreeNode.getTree()).refreshTree((DTreeItem)this.myTreeNode);
            this.myTreeNode.setExpanded(true);
        }
        return true;
    }

    public String toString() {
        return this.TITLE;
    }

    public NetVector getComponentMenus() {
        return this.menuVect;
    }

    public NetVector getComponentToolbar() {
        return this.toolbarVect;
    }

    public boolean Comp_file_has_Comments() {
        return this.nlpa.fileHasComments();
    }

    private void selectChildNode(String string) {
        ListenerCompDataSource listenerCompDataSource = (ListenerCompDataSource)this.myTreeNode.getDataSource();
        int n = this.myTreeNode.getItemCount() - 1;
        while (n >= 0) {
            if (((TreeItemData)listenerCompDataSource.getData(n)).getLabel().equalsIgnoreCase(string)) {
                this.myTreeNode.getTree().getSelection().selectItem(this.myTreeNode.getItem(n));
                return;
            }
            --n;
        }
    }

    private void loadListener(String string, String string2) {
        ListenerGeneric.devTrc("loading listener " + string2);
        StringBuffer stringBuffer = new StringBuffer();
        NetValidate netValidate = new NetValidate((BufferedFrame)this.theApp.getFrame());
        if (!netValidate.validateName(string2)) {
            ListenerGeneric.devTrc("Invalid listener name found in listener.ora.  Skipping.");
            return;
        }
        ListenerConfigure listenerConfigure = new ListenerConfigure(string2);
        if (this.readSNMP(string, string2, stringBuffer)) {
            listenerConfigure.setSNMP(stringBuffer.toString());
        } else {
            listenerConfigure.disableSNMP();
        }
        this.lsnrVector.addElement(listenerConfigure);
    }

    private String nextDefaultName() {
        int n = this.lsnrVector.size();
        if (this.lsnrVector.findObjectByName("LISTENER") == null) {
            return "LISTENER";
        }
        int n2 = 1;
        while (n2 < n + 1) {
            if (this.lsnrVector.findObjectByName("LISTENER" + n2) == null) {
                return "LISTENER" + n2;
            }
            ++n2;
        }
        return "LISTENER" + (n + 1);
    }

    private boolean readSNMP(String string, String string2, StringBuffer stringBuffer) {
        int n;
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        String string3 = null;
        try {
            String string4;
            File file = new File(string, "snmp_rw.ora");
            fileInputStream = new FileInputStream(file);
            inputStreamReader = new InputStreamReader(fileInputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((string4 = bufferedReader.readLine()) != null) {
                n = string4.indexOf(61);
                if (n == -1 || !string4.substring(0, n).trim().equalsIgnoreCase("SNMP.CONTACT." + string2)) continue;
                string3 = string4;
            }
            fileInputStream.close();
            inputStreamReader.close();
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        if (string3 == null) {
            return false;
        }
        n = string3.indexOf(61);
        if (n == -1) {
            return false;
        }
        stringBuffer.append(string3.substring(n + 1).trim());
        this.snmp_rw_exists = true;
        return true;
    }

    private void writeSNMP(String string, String string2, String string3) {
        if (!this.snmp_rw_exists) {
            return;
        }
        ListenerGeneric.devTrc("would write: snmp.contact." + string2 + "=" + string3);
        Vector<String> vector = new Vector<String>(100, 50);
        try {
            String string4;
            File file = new File(string, "snmp_rw.ora");
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((string4 = bufferedReader.readLine()) != null) {
                int n = string4.indexOf(61);
                if (n != -1 && string4.substring(0, n).trim().equalsIgnoreCase("SNMP.CONTACT." + string2)) {
                    vector.addElement("snmp.contact." + string2 + "=" + string3);
                    continue;
                }
                vector.addElement(string4);
            }
            fileInputStream.close();
            inputStreamReader.close();
            bufferedReader.close();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            int n = 0;
            while (n < vector.size()) {
                bufferedWriter.write((String)vector.elementAt(n));
                bufferedWriter.newLine();
                ++n;
            }
            bufferedWriter.flush();
            fileOutputStream.close();
            outputStreamWriter.close();
            bufferedWriter.close();
            return;
        }
        catch (IOException iOException) {
            ListenerGeneric.devTrc("writeSNMP exception");
            return;
        }
    }

    public void markChangedFlag() {
        this.changed = true;
    }

    public NLParamParser getNLPA() {
        if (!this.loaded) {
            this.loadData();
        }
        return this.nlpa;
    }

    static /* synthetic */ NetContainer access$0(ListenerComponent listenerComponent) {
        return listenerComponent.theContainer;
    }

    static /* synthetic */ WebApplication access$1(ListenerComponent listenerComponent) {
        return listenerComponent.theApp;
    }

    static /* synthetic */ NetPanel access$2(ListenerComponent listenerComponent) {
        return listenerComponent.lsnrPlacebo;
    }

    static /* synthetic */ NetObjectMenu access$3(ListenerComponent listenerComponent) {
        return listenerComponent.renameMenuItem;
    }

    static /* synthetic */ NetVector access$4(ListenerComponent listenerComponent) {
        return listenerComponent.menuVect;
    }

    static /* synthetic */ NetVector access$5(ListenerComponent listenerComponent) {
        return listenerComponent.toolbarVect;
    }

    static /* synthetic */ ListenerConfigure access$6(ListenerComponent listenerComponent) {
        return listenerComponent.activeLsnr;
    }

    static /* synthetic */ void access$7(ListenerComponent listenerComponent, ListenerConfigure listenerConfigure) {
        listenerComponent.activeLsnr = listenerConfigure;
    }

    static /* synthetic */ NetObjectMenu access$8(ListenerComponent listenerComponent) {
        return listenerComponent.deleteMenuItem;
    }

    static /* synthetic */ NetObjectToolbar access$9(ListenerComponent listenerComponent) {
        return listenerComponent.deleteToolbarItem;
    }

    static /* synthetic */ NetVector access$10(ListenerComponent listenerComponent) {
        return listenerComponent.lsnrVector;
    }

    static /* synthetic */ boolean access$11(ListenerComponent listenerComponent) {
        return listenerComponent.loaded;
    }

    private class ListenerCompDataSource
    extends TreeDataSource {
        String[] treeItems;
        private Image lsnrIcon;
        private TreeProxy sharedProxy;

        public ListenerCompDataSource(DataDrivenTree dataDrivenTree) {
            super(dataDrivenTree);
            ListenerComponent.this = ListenerComponent.this;
            ListenerComponent listenerComponent2 = ListenerComponent.this;
            listenerComponent2.getClass();
            this.sharedProxy = listenerComponent2.new ListenerProxy(dataDrivenTree);
            this.lsnrIcon = Toolkit.getDefaultToolkit().getImage(String.valueOf(NetUtils.getImageDirectory()) + "listener.gif");
        }

        protected void internal_refreshData() {
            ListenerComponent listenerComponent;
            this.internal_clearData();
            ListenerComponent listenerComponent2 = ListenerComponent.this;
            if (!listenerComponent2.loaded) {
                ListenerComponent.this.loadData();
            }
            listenerComponent2 = ListenerComponent.this;
            this.treeItems = new String[listenerComponent2.lsnrVector.size()];
            int n = 0;
            while (n < this.treeItems.length) {
                listenerComponent = ListenerComponent.this;
                this.treeItems[n] = listenerComponent.lsnrVector.elementAt(n).toString();
                ++n;
            }
            if (this.treeItems != null && this.treeItems.length > 0) {
                listenerComponent = new OneDDataSourceEvent((Object)this, 2001, 0, this.treeItems.length);
                this.processEvent((OneDDataSourceEvent)listenerComponent);
            }
        }

        protected DTreeItem internal_createItem(DTreeDeferringParent dTreeDeferringParent, int n) {
            return new TreeChildNode(this.sharedProxy, "oracle_sysman_netasst_lsnr_item");
        }

        protected void internal_setData(int n, Object object) {
        }

        protected Object internal_getData(int n) {
            return new TreeItemData(this.treeItems[n], this.lsnrIcon);
        }

        protected int internal_getItemCount() {
            if (this.treeItems == null) {
                return 0;
            }
            return this.treeItems.length;
        }

        protected void internal_clearData() {
            if (this.treeItems != null) {
                OneDDataSourceEvent oneDDataSourceEvent = new OneDDataSourceEvent((Object)this, 2002, 0, this.treeItems.length);
                this.processEvent(oneDDataSourceEvent);
                this.treeItems = null;
            }
        }
    }

    private class ListenerCompProxy
    extends TreeProxy
    implements TreeNodeSelectionListener {
        public ListenerCompProxy(DataDrivenTree dataDrivenTree) {
            super(dataDrivenTree);
            ListenerComponent.this = ListenerComponent.this;
        }

        public void treeSelectionChanging(DTreeSelectionEvent dTreeSelectionEvent, TreeItem treeItem) {
            ListenerComponent listenerComponent = ListenerComponent.this;
            listenerComponent.theContainer.setMenuStatus(null);
            listenerComponent = ListenerComponent.this;
            listenerComponent.theContainer.setToolBarStatus(null);
            listenerComponent = ListenerComponent.this;
            listenerComponent.theApp.showStatus("");
        }

        public void treeSelectionChanged(DTreeSelectionEvent dTreeSelectionEvent, TreeItem treeItem) {
            ListenerComponent listenerComponent = ListenerComponent.this;
            listenerComponent = ListenerComponent.this;
            listenerComponent.theContainer.display(ListenerComponent.this, (Component)((Object)listenerComponent.lsnrPlacebo));
            listenerComponent = ListenerComponent.this;
            listenerComponent.renameMenuItem.setEnabled(false);
            listenerComponent = ListenerComponent.this;
            listenerComponent = ListenerComponent.this;
            listenerComponent.theContainer.setMenuStatus(listenerComponent.menuVect);
            listenerComponent = ListenerComponent.this;
            listenerComponent = ListenerComponent.this;
            listenerComponent.theContainer.setToolBarStatus(listenerComponent.toolbarVect);
            listenerComponent = ListenerComponent.this;
            listenerComponent.theApp.showStatus("");
        }
    }

    private class ListenerProxy
    extends TreeProxy
    implements TreeNodeSelectionListener {
        public ListenerProxy(DataDrivenTree dataDrivenTree) {
            super(dataDrivenTree);
            ListenerComponent.this = ListenerComponent.this;
        }

        public void treeSelectionChanging(DTreeSelectionEvent dTreeSelectionEvent, TreeItem treeItem) {
            ListenerComponent listenerComponent = ListenerComponent.this;
            if (listenerComponent.activeLsnr == null) {
                return;
            }
            listenerComponent = ListenerComponent.this;
            if (listenerComponent.activeLsnr != null) {
                listenerComponent = ListenerComponent.this;
                if (!listenerComponent.activeLsnr.validateConfig()) {
                    ((Cancelable)dTreeSelectionEvent).cancel();
                    return;
                }
            }
            listenerComponent = ListenerComponent.this;
            listenerComponent.activeLsnr = null;
            listenerComponent = ListenerComponent.this;
            listenerComponent.deleteMenuItem.setEnabled(false);
            listenerComponent = ListenerComponent.this;
            listenerComponent.renameMenuItem.setEnabled(false);
            listenerComponent = ListenerComponent.this;
            listenerComponent.deleteToolbarItem.setEnabled(false);
            listenerComponent = ListenerComponent.this;
            listenerComponent = ListenerComponent.this;
            listenerComponent.theContainer.setMenuStatus(listenerComponent.menuVect);
            listenerComponent = ListenerComponent.this;
            listenerComponent = ListenerComponent.this;
            listenerComponent.theContainer.setToolBarStatus(listenerComponent.toolbarVect);
            listenerComponent = ListenerComponent.this;
            listenerComponent.theApp.showStatus("");
        }

        public void treeSelectionChanged(DTreeSelectionEvent dTreeSelectionEvent, TreeItem treeItem) {
            ListenerComponent listenerComponent = ListenerComponent.this;
            Object object = ListenerComponent.this;
            listenerComponent.activeLsnr = object = (ListenerConfigure)((ListenerComponent)object).lsnrVector.findObjectByName(treeItem.getLabel());
            listenerComponent = ListenerComponent.this;
            listenerComponent = ListenerComponent.this;
            listenerComponent.theContainer.display(ListenerComponent.this, (Component)((Object)listenerComponent.activeLsnr));
            listenerComponent = ListenerComponent.this;
            listenerComponent.deleteMenuItem.setEnabled(true);
            listenerComponent = ListenerComponent.this;
            listenerComponent.renameMenuItem.setEnabled(true);
            listenerComponent = ListenerComponent.this;
            listenerComponent.deleteToolbarItem.setEnabled(true);
            listenerComponent = ListenerComponent.this;
            listenerComponent = ListenerComponent.this;
            listenerComponent.theContainer.setMenuStatus(listenerComponent.menuVect);
            listenerComponent = ListenerComponent.this;
            listenerComponent = ListenerComponent.this;
            listenerComponent.theContainer.setToolBarStatus(listenerComponent.toolbarVect);
            listenerComponent = ListenerComponent.this;
            ((Component)listenerComponent.theApp.getFrame()).setCursor(Cursor.getDefaultCursor());
            listenerComponent = ListenerComponent.this;
            listenerComponent.theApp.showStatus("");
        }
    }
}

