/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.listener;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.event.Cancelable;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.tabPanel.TabPanel;
import oracle.ewt.tabPanel.TabPanelEvent;
import oracle.ewt.tabPanel.TabPanelListener;
import oracle.ewt.tabPanel.TabPanelPage;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.listener.ListenerCache;
import oracle.net.asst.listener.ListenerDBServicePage;
import oracle.net.asst.listener.ListenerGeneric;
import oracle.net.asst.uniword.UniWordWrapper;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public class ListenerDatabaseServices
extends EwtContainer
implements ListenerCache,
TabPanelListener,
ActionListener {
    private String name;
    private LWButton addButton;
    private LWButton removeButton;
    private LWButton helpButton;
    private String addString;
    private String removeString;
    private String helpString;
    private String databaseString;
    private TabPanel tp;
    private NetStrings ns = ListenerGeneric.getNS();
    private int dbCount;
    private boolean changed = false;
    private ListenerDBServicePage currDatabase;
    private LWLabel noDatabasesLabel;
    private EwtContainer noDatabasesPanel;
    private EwtContainer buttonPanel;
    private NLParamParser nlpa = ListenerGeneric.getNLP();
    private final NVNavigator nav = new NVNavigator();
    private String dbHelpTopic = "TOPIClsnrDatabaseServices";

    public ListenerDatabaseServices() {
        ListenerGeneric.devTrc("entered ListenerDatabaseServices");
        this.databaseString = new String(this.ns.getString("LCCDatabase"));
        this.addString = new String(this.ns.getString("LCCAddDatabase"));
        this.removeString = new String(this.ns.getString("LCCRemoveDatabase"));
        this.helpString = new String(this.ns.getString("LCCHelp"));
        this.addButton = new LWButton(this.addString);
        this.addButton.addActionListener((ActionListener)this);
        this.removeButton = new LWButton(this.removeString);
        this.removeButton.addActionListener((ActionListener)this);
        this.removeButton.setEnabled(false);
        this.helpButton = new LWButton(this.helpString);
        this.helpButton.addActionListener((ActionListener)this);
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        this.buttonPanel = new EwtContainer();
        this.noDatabasesPanel = new EwtContainer();
        this.noDatabasesPanel.setLayout(new GridBagLayout());
        MultiLineLabel multiLineLabel = new MultiLineLabel(UniWordWrapper.getTextWrapper(), this.ns.getString("LCCNoDatabases"));
        multiLineLabel.setPreferredAspectRatio(10.0f);
        multiLineLabel.setAlignment(1);
        EwtContainer ewtContainer = this.noDatabasesPanel;
        MultiLineLabel multiLineLabel2 = multiLineLabel;
        ListenerGeneric.constrain((Container)ewtContainer, (Component)multiLineLabel2, 2, 0, 0, 1, 1, 18, 0.0, 0.0, 0, 0, 0, 0);
        ewtContainer = this;
        multiLineLabel2 = this.noDatabasesPanel;
        ListenerGeneric.constrain((Container)ewtContainer, (Component)multiLineLabel2, 0, 0, 1, 1, 1, 18, 100.0, 100.0, 0, 0, 0, 0);
        this.buttonPanel.add((Component)this.addButton);
        this.buttonPanel.add((Component)this.removeButton);
        this.buttonPanel.add((Component)this.helpButton);
        ewtContainer = this;
        multiLineLabel2 = this.buttonPanel;
        ListenerGeneric.constrain((Container)ewtContainer, (Component)multiLineLabel2, 0, 1, 1, 1, 0, 18, 0.0, 0.0, 0, 0, 0, 0);
    }

    public void addDatabase(NVPair nVPair) {
        TabPanel tabPanel;
        if (this.tp == null) {
            tabPanel = new TabPanel();
            tabPanel.addTabPanelListener((TabPanelListener)this);
            ((Container)((Object)this)).remove((Component)this.noDatabasesPanel);
        } else {
            tabPanel = this.tp;
        }
        ListenerDBServicePage listenerDBServicePage = new ListenerDBServicePage(nVPair);
        tabPanel.addPage(String.valueOf(this.databaseString) + ++this.dbCount, (Component)((Object)listenerDBServicePage));
        tabPanel.getPage(tabPanel.getPageCount() - 1).setSelected(true);
        listenerDBServicePage.invalidate();
        this.validate();
        this.currDatabase = listenerDBServicePage;
        if (tabPanel.getPageCount() == 1) {
            this.removeButton.setEnabled(true);
        }
        if (this.tp == null) {
            this.tp = tabPanel;
        }
        ListenerDatabaseServices listenerDatabaseServices = this;
        TabPanel tabPanel2 = this.tp;
        ListenerGeneric.constrain((Container)((Object)listenerDatabaseServices), (Component)tabPanel2, 0, 0, 1, 1, 1, 18, 100.0, 100.0, 0, 0, 0, 0);
    }

    public void removeDatabase() {
        TabPanelPage tabPanelPage = this.tp.getSelectedPage();
        this.tp.removeTabPanelListener((TabPanelListener)this);
        this.tp.removePage(tabPanelPage);
        this.tp.addTabPanelListener((TabPanelListener)this);
        --this.dbCount;
        if (this.tp.getPageCount() == 0) {
            this.removeButton.setEnabled(false);
            this.tp.removeTabPanelListener((TabPanelListener)this);
            ((Container)((Object)this)).remove((Component)this.tp);
            this.tp = null;
            this.currDatabase = null;
            ListenerDatabaseServices listenerDatabaseServices = this;
            EwtContainer ewtContainer = this.noDatabasesPanel;
            ListenerGeneric.constrain((Container)((Object)listenerDatabaseServices), (Component)ewtContainer, 0, 0, 1, 1, 1, 18, 100.0, 100.0, 0, 0, 0, 0);
            return;
        }
        this.currDatabase = (ListenerDBServicePage)((Object)this.tp.getSelectedPage().getContent());
        int n = 0;
        while (n < this.tp.getPageCount()) {
            this.tp.getPage(n).setLabel(String.valueOf(this.databaseString) + (n + 1));
            ++n;
        }
    }

    public void tabPanelSelectionChanged(TabPanelEvent tabPanelEvent) {
        this.currDatabase = (ListenerDBServicePage)((Object)tabPanelEvent.getPage().getContent());
    }

    public void tabPanelSelectionChanging(TabPanelEvent tabPanelEvent) {
        if (ListenerGeneric.allowInvalid()) {
            return;
        }
        if (this.currDatabase != null && !this.currDatabase.areDataValid()) {
            ((Cancelable)tabPanelEvent).cancel();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(this.addString)) {
            this.changed = true;
            if (this.currDatabase != null && !this.currDatabase.areDataValid()) {
                return;
            }
            this.addDatabase(null);
            return;
        }
        if (string.equals(this.removeString)) {
            this.changed = true;
            this.removeDatabase();
            return;
        }
        if (string.equals(this.helpString)) {
            ListenerGeneric.getHelp().showTopic(this.dbHelpTopic);
            return;
        }
    }

    public void setListenerName(String string) {
        this.name = string;
    }

    public void set() {
        Object object;
        NVPair nVPair = this.nlpa.getNLPListElement("SID_LIST_" + this.name);
        if (this.tp == null) {
            if (!this.changed) {
                return;
            }
            nVPair = this.stripDBsFromNVP(nVPair);
        } else {
            String[] stringArray = new String[this.tp.getPageCount()];
            int n = 0;
            while (n < this.tp.getPageCount()) {
                object = (ListenerDBServicePage)((Object)this.tp.getPage(n).getContent());
                stringArray[n] = ((ListenerDBServicePage)object).toString();
                if (((ListenerDBServicePage)object).isChanged()) {
                    ((ListenerDBServicePage)object).setChanged(false);
                    this.changed = true;
                }
                ++n;
            }
            if (this.changed) {
                NVPair nVPair2 = this.stripDBsFromNVP(nVPair);
                nVPair = this.addDBsToNVP(nVPair2, stringArray);
            } else {
                return;
            }
        }
        try {
            if (nVPair != null) {
                object = this.nav.findNVPair(nVPair, "SID_LIST");
                if (object == null || ((NVPair)object).getListSize() == 0) {
                    this.nlpa.removeNLPListElement("SID_LIST_" + this.name);
                } else {
                    this.nlpa.addNLPListElement(nVPair.toString());
                }
            }
        }
        catch (NLException nLException) {
            ListenerGeneric.devTrc("LDS set failed");
        }
        this.changed = false;
    }

    public void get() {
        NVPair nVPair = this.nlpa.getNLPListElement("SID_LIST_" + this.name);
        if (nVPair != null) {
            NVPair nVPair2 = this.nav.findNVPair(nVPair, "SID_DESC");
            if (nVPair2 != null) {
                NVPair nVPair3 = this.nav.findNVPair(nVPair2, "PROGRAM");
                if (nVPair3 == null) {
                    this.addDatabase(nVPair2);
                    return;
                }
            } else {
                nVPair2 = this.nav.findNVPair(nVPair, "SID_LIST");
                if (nVPair2 != null) {
                    int n = 0;
                    while (n < nVPair2.getListSize()) {
                        NVPair nVPair4 = this.nav.findNVPair(nVPair2.getListElement(n), "PROGRAM");
                        if (nVPair4 == null) {
                            this.addDatabase(nVPair2.getListElement(n));
                        }
                        ++n;
                    }
                }
            }
        }
    }

    private NVPair addDBsToNVP(NVPair nVPair, String[] stringArray) {
        if (stringArray.length == 0) {
            return nVPair;
        }
        NVFactory nVFactory = new NVFactory();
        NVPair nVPair2 = this.nav.findNVPair(nVPair, "SID_DESC");
        if (nVPair2 != null) {
            nVPair = nVFactory.createNVPair("(SID_LIST_" + this.name + "=(SID_LIST=" + nVPair2.toString() + "))");
        }
        if ((nVPair2 = this.nav.findNVPair(nVPair, "SID_LIST")) == null) {
            nVPair = nVFactory.createNVPair("(SID_LIST_" + this.name + "=(SID_LIST=))");
        }
        nVPair2 = this.nav.findNVPair(nVPair, "SID_LIST");
        int n = 0;
        while (n < stringArray.length) {
            nVPair2.addListElement(nVFactory.createNVPair(stringArray[n]));
            ++n;
        }
        return nVPair;
    }

    private NVPair stripDBsFromNVP(NVPair nVPair) {
        if (nVPair != null) {
            NVPair nVPair2 = this.nav.findNVPair(nVPair, "SID_DESC");
            if (nVPair2 != null) {
                if (this.nav.findNVPair(nVPair2, "PROGRAM") == null) {
                    return null;
                }
                return nVPair;
            }
            nVPair2 = this.nav.findNVPair(nVPair, "SID_LIST");
            if (nVPair2 == null) {
                return null;
            }
            int n = 0;
            while (n < nVPair2.getListSize()) {
                NVPair nVPair3 = nVPair2.getListElement(n);
                if (this.nav.findNVPair(nVPair3, "PROGRAM") == null) {
                    nVPair2.removeListElement(n);
                    --n;
                }
                ++n;
            }
            if (nVPair.getListSize() > 0) {
                return nVPair;
            }
            return null;
        }
        return null;
    }

    public boolean isChanged() {
        if (this.changed) {
            return true;
        }
        if (this.tp == null) {
            return false;
        }
        int n = 0;
        while (n < this.tp.getPageCount()) {
            ListenerDBServicePage listenerDBServicePage = (ListenerDBServicePage)((Object)this.tp.getPage(n).getContent());
            if (listenerDBServicePage.isChanged()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean areDataValid() {
        if (this.tp == null) {
            return true;
        }
        int n = 0;
        while (n < this.tp.getPageCount()) {
            if (!((ListenerDBServicePage)((Object)this.tp.getPage(n).getContent())).areDataValid()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void setFocus() {
    }
}

