/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.listener;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.Border;
import oracle.ewt.border.GroupBoxBorder;
import oracle.ewt.graphics.frame.InsetFramePainter;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetValidate;
import oracle.net.asst.listener.ListenerCache;
import oracle.net.asst.listener.ListenerGeneric;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVPair;

public class ListenerGeneral
extends EwtContainer
implements ListenerCache,
KeyListener,
ItemListener {
    private NetStrings ns = ListenerGeneric.getNS();
    private LWLabel nameLabel;
    private LWLabel waitLabel;
    private LWLabel timeoutLabel;
    private LWLabel secondsLabel;
    private LWLabel secondsLabel2;
    private LWTextField nameField;
    private LWTextField waitField;
    private LWTextField timeoutField;
    private LWCheckbox saveOnQuitBox;
    private LWCheckbox registerBox;
    private LWTextField snmpField;
    private String optionsString = this.ns.getString("LCCOptions");
    private String snmpString = this.ns.getString("LCCSNMPInfo");
    private EwtContainer optionsPanel;
    private EwtContainer snmpPanel;
    private NLParamParser nlpa = ListenerGeneric.getNLP();
    private String name;
    private NetValidate netValidate = new NetValidate((BufferedFrame)ListenerGeneric.getApp().getFrame());
    private String invalidString;
    private LWTextField invalidField;
    private boolean changed = false;
    private boolean snmpChanged = false;
    private static final String[] PARAMS = new String[]{"STARTUP_WAIT_TIME_", "CONNECT_TIMEOUT_", "SAVE_CONFIG_ON_STOP_", "USE_PLUG_AND_PLAY_"};
    private static final String[] PARAMS_LABELS = new String[]{"LCCStartupWaitTime", "LCCConnectTimeout", "LCCSaveOnQuit", "LCCRegisterServices"};
    private static final String[] PARAMS_DEFAULT = new String[]{"0", "10", "FALSE", "OFF"};

    public ListenerGeneral() {
        this.nameLabel = new LWLabel(this.ns.getString("LCCListenerName"));
        this.waitLabel = new LWLabel(this.ns.getString(PARAMS_LABELS[0]));
        this.timeoutLabel = new LWLabel(this.ns.getString(PARAMS_LABELS[1]));
        this.secondsLabel = new LWLabel(this.ns.getString("LCCseconds"));
        this.secondsLabel2 = new LWLabel(this.ns.getString("LCCseconds"));
        this.nameField = new LWTextField(20);
        this.nameField.setEditable(false);
        this.waitField = new LWTextField(PARAMS_DEFAULT[0], 20);
        this.waitField.addKeyListener(this);
        this.timeoutField = new LWTextField(PARAMS_DEFAULT[1], 20);
        this.timeoutField.addKeyListener(this);
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        ((GridBagLayout)((Container)((Object)this)).getLayout()).setConstraints((Component)((Object)this), gridBagConstraints);
        ListenerGeneral listenerGeneral = this;
        LWLabel lWLabel = this.nameLabel;
        ListenerGeneric.constrain((Container)((Object)listenerGeneral), (Component)lWLabel, 0, 0, 1, 1, 0, 18, 0.0, 0.0, 0, 10, 0, 0);
        listenerGeneral = this;
        lWLabel = this.nameField;
        ListenerGeneric.constrain((Container)((Object)listenerGeneral), (Component)lWLabel, 1, 0, 1, 1, 0, 18, 0.0, 0.0, 0, 0, 0, 0);
        listenerGeneral = this;
        lWLabel = this.waitLabel;
        ListenerGeneric.constrain((Container)((Object)listenerGeneral), (Component)lWLabel, 0, 1, 1, 1, 0, 18, 0.0, 0.0, 10, 10, 0, 0);
        listenerGeneral = this;
        lWLabel = this.waitField;
        ListenerGeneric.constrain((Container)((Object)listenerGeneral), (Component)lWLabel, 1, 1, 1, 1, 0, 18, 0.0, 0.0, 10, 0, 0, 0);
        listenerGeneral = this;
        lWLabel = this.secondsLabel;
        ListenerGeneric.constrain((Container)((Object)listenerGeneral), (Component)lWLabel, 2, 1, 1, 1, 0, 18, 0.0, 0.0, 10, 0, 0, 0);
        listenerGeneral = this;
        lWLabel = this.timeoutLabel;
        ListenerGeneric.constrain((Container)((Object)listenerGeneral), (Component)lWLabel, 0, 2, 1, 1, 0, 18, 0.0, 0.0, 10, 10, 0, 0);
        listenerGeneral = this;
        lWLabel = this.timeoutField;
        ListenerGeneric.constrain((Container)((Object)listenerGeneral), (Component)lWLabel, 1, 2, 1, 1, 0, 18, 0.0, 0.0, 10, 0, 0, 0);
        listenerGeneral = this;
        lWLabel = this.secondsLabel2;
        ListenerGeneric.constrain((Container)((Object)listenerGeneral), (Component)lWLabel, 2, 2, 1, 1, 0, 18, 0.0, 0.0, 10, 0, 0, 0);
        this.optionsPanel = new EwtContainer();
        this.optionsPanel.setBorder((Border)new GroupBoxBorder(" " + this.optionsString + " ", InsetFramePainter.getFramePainter(), 2));
        this.optionsPanel.setLayout(new GridBagLayout());
        this.saveOnQuitBox = new LWCheckbox(this.ns.getString(PARAMS_LABELS[2]), !PARAMS_DEFAULT[2].equals("FALSE"));
        this.registerBox = new LWCheckbox(this.ns.getString(PARAMS_LABELS[3]), !PARAMS_DEFAULT[3].equals("OFF"));
        this.saveOnQuitBox.addItemListener((ItemListener)this);
        this.registerBox.addItemListener((ItemListener)this);
        ListenerGeneric.constrain((Container)this.optionsPanel, (Component)this.saveOnQuitBox, 0, 0, 1, 1, 0, 17, 1.0, 1.0, 5, 5, 0, 0);
        ListenerGeneric.constrain((Container)this.optionsPanel, (Component)this.registerBox, 0, 1, 1, 1, 0, 17, 1.0, 1.0, 5, 5, 5, 0);
        listenerGeneral = this;
        lWLabel = this.optionsPanel;
        ListenerGeneric.constrain((Container)((Object)listenerGeneral), (Component)lWLabel, 0, 4, 0, 1, 1, 18, 0.0, 0.0, 10, 10, 0, 10);
        this.snmpPanel = new EwtContainer();
        this.snmpPanel.setBorder((Border)new GroupBoxBorder(" " + this.snmpString + " ", InsetFramePainter.getFramePainter(), 2));
        this.snmpField = new LWTextField(40);
        this.snmpField.addKeyListener(this);
        this.snmpPanel.add((Component)this.snmpField);
        listenerGeneral = this;
        lWLabel = this.snmpPanel;
        ListenerGeneric.constrain((Container)((Object)listenerGeneral), (Component)lWLabel, 0, 5, 0, 1, 1, 18, 0.0, 0.0, 15, 10, 40, 10);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource().equals(this.snmpField)) {
            this.changed = true;
            this.snmpChanged = true;
            return;
        }
        char c = keyEvent.getKeyChar();
        if (!Character.isDigit(c) && c != '\b') {
            keyEvent.consume();
            return;
        }
        this.changed = true;
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.changed = true;
    }

    public void setListenerName(String string) {
        this.name = string;
        this.nameField.setText(string);
    }

    public void set() {
        try {
            String string = this.waitField.getText();
            if (string.equalsIgnoreCase(PARAMS_DEFAULT[0])) {
                this.nlpa.removeNLPListElement(String.valueOf(PARAMS[0]) + this.name);
            } else {
                this.nlpa.addNLPListElement(String.valueOf(PARAMS[0]) + this.name + "=" + string);
            }
            string = this.timeoutField.getText();
            if (string.equalsIgnoreCase(PARAMS_DEFAULT[1])) {
                this.nlpa.removeNLPListElement(String.valueOf(PARAMS[1]) + this.name);
            } else {
                this.nlpa.addNLPListElement(String.valueOf(PARAMS[1]) + this.name + "=" + string);
            }
            String string2 = string = this.saveOnQuitBox.getState() ? "TRUE" : "FALSE";
            if (string.equalsIgnoreCase(PARAMS_DEFAULT[2])) {
                this.nlpa.removeNLPListElement(String.valueOf(PARAMS[2]) + this.name);
            } else {
                this.nlpa.addNLPListElement(String.valueOf(PARAMS[2]) + this.name + "=" + string);
            }
            String string3 = string = this.registerBox.getState() ? "ON" : "OFF";
            if (string.equalsIgnoreCase(PARAMS_DEFAULT[3])) {
                this.nlpa.removeNLPListElement(String.valueOf(PARAMS[3]) + this.name);
            } else {
                this.nlpa.addNLPListElement(String.valueOf(PARAMS[3]) + this.name + "=" + string);
            }
        }
        catch (NLException nLException) {}
        this.changed = false;
    }

    public void get() {
        NVPair nVPair = this.nlpa.getNLPListElement(String.valueOf(PARAMS[0]) + this.name);
        if (nVPair != null && nVPair.getAtom() != null) {
            this.waitField.setText(nVPair.getAtom());
        }
        if ((nVPair = this.nlpa.getNLPListElement(String.valueOf(PARAMS[1]) + this.name)) != null && nVPair.getAtom() != null) {
            this.timeoutField.setText(nVPair.getAtom());
        }
        if ((nVPair = this.nlpa.getNLPListElement(String.valueOf(PARAMS[2]) + this.name)) != null && nVPair.getAtom() != null) {
            this.saveOnQuitBox.setState(nVPair.getAtom().equalsIgnoreCase("TRUE"));
        }
        if ((nVPair = this.nlpa.getNLPListElement(String.valueOf(PARAMS[3]) + this.name)) != null && nVPair.getAtom() != null) {
            this.registerBox.setState(nVPair.getAtom().equalsIgnoreCase("ON"));
        }
    }

    public boolean isChanged() {
        return this.changed;
    }

    public boolean areDataValid() {
        try {
            if (Integer.parseInt(this.waitField.getText()) < 0) {
                this.invalidField = this.waitField;
                this.invalidString = PARAMS_LABELS[0];
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.invalidField = this.waitField;
            this.invalidString = PARAMS_LABELS[0];
            return false;
        }
        try {
            if (Integer.parseInt(this.timeoutField.getText()) < 0) {
                this.invalidField = this.timeoutField;
                this.invalidString = PARAMS_LABELS[1];
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.invalidField = this.timeoutField;
            this.invalidString = PARAMS_LABELS[1];
            return false;
        }
        return true;
    }

    public void setFocus() {
        this.netValidate.showDialog(this.invalidString);
        this.invalidField.requestFocus();
        this.invalidField.selectAll();
    }

    public void setSNMP(String string) {
        this.snmpField.setText(string);
        this.snmpChanged = false;
    }

    public String getSNMP() {
        return this.snmpField.getText();
    }

    public void disableSNMP() {
        this.snmpField.setText("");
        this.snmpField.setEditable(false);
    }

    public boolean snmpChanged() {
        return this.snmpChanged;
    }
}

