/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.listener;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.event.Cancelable;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.tabPanel.TabPanel;
import oracle.ewt.tabPanel.TabPanelEvent;
import oracle.ewt.tabPanel.TabPanelListener;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.listener.ListenerAuthentication;
import oracle.net.asst.listener.ListenerCache;
import oracle.net.asst.listener.ListenerGeneral;
import oracle.net.asst.listener.ListenerGeneric;
import oracle.net.asst.listener.ListenerLoggingTracing;

public class ListenerGeneralParameters
extends EwtContainer
implements ListenerCache,
TabPanelListener,
ActionListener {
    private String name;
    private TabPanel tp;
    private NetStrings ns = ListenerGeneric.getNS();
    private String[] tabNames = new String[]{this.ns.getString("LCCGeneral"), this.ns.getString("LCCLogTrace"), this.ns.getString("LCCAuthentication")};
    private ListenerCache[] displayPanel;
    private ListenerCache currPanel;
    private String helpString;
    private LWButton helpButton;
    private EwtContainer buttonDeck;
    private String generalHelpTopic = "TOPIClsnrGeneralParam";
    private String logTraceHelpTopic = "TOPIClsnrLoggingTracing";
    private String authHelpTopic = "TOPIClsnrAuth";
    private String currHelpTopic;

    public ListenerGeneralParameters() {
        ListenerGeneric.devTrc("entered ListenerGeneralParameters");
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        this.tp = new TabPanel();
        this.tp.setOrientation(0);
        this.tp.addTabPanelListener((TabPanelListener)this);
        ListenerGeneralParameters listenerGeneralParameters = this;
        TabPanel tabPanel = this.tp;
        ListenerGeneric.constrain((Container)((Object)listenerGeneralParameters), (Component)tabPanel, 0, 0, 1, 1, 1, 18, 100.0, 100.0, 0, 0, 0, 0);
        this.buttonDeck = new EwtContainer();
        this.helpString = new String(this.ns.getString("LCCHelp"));
        this.helpButton = new LWButton(this.helpString);
        this.buttonDeck.add((Component)this.helpButton);
        this.helpButton.addActionListener((ActionListener)this);
        listenerGeneralParameters = this;
        tabPanel = this.buttonDeck;
        ListenerGeneric.constrain((Container)((Object)listenerGeneralParameters), (Component)tabPanel, 0, 1, 1, 1, 0, 18, 0.0, 0.0, 0, 0, 0, 0);
        this.displayPanel = new ListenerCache[this.tabNames.length];
        this.displayPanel[0] = new ListenerGeneral();
        this.displayPanel[1] = new ListenerLoggingTracing();
        this.displayPanel[2] = new ListenerAuthentication();
        int n = 0;
        while (n < this.tabNames.length) {
            this.tp.addPage(this.tabNames[n], (Component)((EwtContainer)this.displayPanel[n]));
            ++n;
        }
        this.currHelpTopic = this.generalHelpTopic;
    }

    public void tabPanelSelectionChanged(TabPanelEvent tabPanelEvent) {
        this.currPanel = (ListenerCache)((Object)tabPanelEvent.getPage().getContent());
        if (this.currPanel == this.displayPanel[0]) {
            this.currHelpTopic = this.generalHelpTopic;
        }
        if (this.currPanel == this.displayPanel[1]) {
            this.currHelpTopic = this.logTraceHelpTopic;
        }
        if (this.currPanel == this.displayPanel[2]) {
            this.currHelpTopic = this.authHelpTopic;
        }
    }

    public void tabPanelSelectionChanging(TabPanelEvent tabPanelEvent) {
        if (ListenerGeneric.allowInvalid()) {
            return;
        }
        if (this.currPanel != null && !this.currPanel.areDataValid()) {
            ((Cancelable)tabPanelEvent).cancel();
            this.currPanel.setFocus();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(this.helpString)) {
            ListenerGeneric.getHelp().show(this.currHelpTopic);
            return;
        }
    }

    public void setListenerName(String string) {
        this.name = string;
        int n = 0;
        while (n < this.displayPanel.length) {
            this.displayPanel[n].setListenerName(string);
            ++n;
        }
    }

    public void set() {
        int n = 0;
        while (n < this.displayPanel.length) {
            this.displayPanel[n].set();
            ++n;
        }
    }

    public void get() {
        int n = 0;
        while (n < this.displayPanel.length) {
            this.displayPanel[n].get();
            ++n;
        }
    }

    public boolean isChanged() {
        int n = 0;
        while (n < this.displayPanel.length) {
            if (this.displayPanel[n].isChanged()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean areDataValid() {
        int n = 0;
        while (n < this.displayPanel.length) {
            if (!this.displayPanel[n].areDataValid()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void setFocus() {
        this.currPanel.setFocus();
    }

    public void setSNMP(String string) {
        ((ListenerGeneral)this.displayPanel[0]).setSNMP(string);
    }

    public String getSNMP() {
        return ((ListenerGeneral)this.displayPanel[0]).getSNMP();
    }

    public void disableSNMP() {
        ((ListenerGeneral)this.displayPanel[0]).disableSNMP();
    }

    public boolean snmpChanged() {
        return ((ListenerGeneral)this.displayPanel[0]).snmpChanged();
    }
}

