/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.names;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.Border;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.asst.names.NamesValidate;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public class ConnectData
extends EwtContainer {
    NetStrings ns = new NetStrings();
    private String[][] itemNames = new String[][]{{this.ns.getString("nnaSID"), "oracle", "SID"}, {this.ns.getString("nnaServerType"), "Dedicated", "Server"}};
    private String[] servertype = new String[]{"Dedicated", "Dispatched"};
    private LWTextField[] itemText;
    private MarginBorder sharedBorderPixel;
    private int i;
    private int j;
    private GridBagConstraints gbc;
    private GridBagLayout gb;
    private LWLabel l;
    private NVNavigator nvnav = new NVNavigator();
    private NVFactory nvfactory = new NVFactory();
    private LWChoice servertypeChoice;
    private int invalidIndex;
    private int initialChoice;
    private String[] initialVals = new String[this.itemNames.length - 1];

    public ConnectData() {
        NamesGeneric.debugTracing("Entering ConnectData");
        this.gb = new GridBagLayout();
        ((Container)((Object)this)).setLayout(this.gb);
        this.gbc = new GridBagConstraints();
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.insets = new Insets(0, 0, 0, 0);
        this.gbc.fill = 2;
        this.sharedBorderPixel = new MarginBorder(4, 4, 4, 4);
        this.setBorder((Border)this.sharedBorderPixel);
        this.itemText = new LWTextField[this.itemNames.length];
        this.i = 0;
        while (this.i < this.itemNames.length) {
            this.gbc.gridx = 0;
            this.gbc.gridy = this.i;
            this.l = new LWLabel(new String(this.itemNames[this.i][0]), 1);
            this.gb.setConstraints((Component)this.l, this.gbc);
            ((Container)((Object)this)).add((Component)this.l);
            ++this.gbc.gridx;
            NamesGeneric.debugTracing("loading sys items");
            if (this.i == this.itemNames.length - 1) {
                this.servertypeChoice = new LWChoice();
                this.j = 0;
                while (this.j < this.servertype.length) {
                    this.servertypeChoice.addItem(this.servertype[this.j]);
                    ++this.j;
                }
                this.gb.setConstraints((Component)this.servertypeChoice, this.gbc);
                ((Container)((Object)this)).add((Component)this.servertypeChoice);
            } else {
                this.itemText[this.i] = new LWTextField(15);
                this.gb.setConstraints((Component)this.itemText[this.i], this.gbc);
                ((Container)((Object)this)).add((Component)this.itemText[this.i]);
            }
            ++this.i;
        }
    }

    public ConnectData(NVPair nVPair) {
        this();
        this.display(nVPair);
        NamesGeneric.debugTracing("Exitting ConnectData");
    }

    public void display(NVPair nVPair) {
        NamesGeneric.debugTracing("Entering ConnectData:display");
        NVNavigator nVNavigator = new NVNavigator();
        if (nVPair != null) {
            NamesGeneric.debugTracing("connectadata=" + nVPair.toString());
            this.i = 0;
            while (this.i < this.itemNames.length) {
                NVPair nVPair2 = nVNavigator.findNVPairRecurse(nVPair, this.itemNames[this.i][2]);
                if (this.i != this.itemNames.length - 1) {
                    if (nVPair2 != null) {
                        NamesGeneric.debugTracing(nVPair2.toString());
                        this.itemText[this.i].setText(nVPair2.getAtom());
                        this.initialVals[this.i] = nVPair2.getAtom();
                    } else {
                        this.itemText[this.i].setText(this.itemNames[this.i][1]);
                        this.initialVals[this.i] = this.itemNames[this.i][1];
                    }
                } else if (nVPair2 != null) {
                    if (nVPair2.getAtom().equalsIgnoreCase(this.servertype[0])) {
                        this.servertypeChoice.select(0);
                        this.initialChoice = 0;
                    } else {
                        this.servertypeChoice.select(1);
                        this.initialChoice = 1;
                    }
                } else {
                    this.servertypeChoice.select(0);
                    this.initialChoice = 0;
                }
                ++this.i;
            }
        }
        NamesGeneric.debugTracing("Exitting ConnectData:display");
    }

    public NVPair getConnectData() {
        NamesGeneric.debugTracing("Entering ConnectData:getConnectData");
        NVPair nVPair = this.nvfactory.createNVPair("(CONNECT_DATA=)");
        int n = 0;
        while (n < this.itemNames.length) {
            String string = n != this.itemNames.length - 1 ? this.itemText[n].getText() : this.servertypeChoice.getSelectedItem();
            String string2 = new String(this.itemNames[n][2]);
            if (string.length() > 0) {
                nVPair.addListElement(this.nvfactory.createNVPair("(" + string2 + "=" + string + ")"));
            }
            ++n;
        }
        return nVPair;
    }

    public void setEditable(boolean bl) {
        NamesGeneric.debugTracing("Entering ConnectData:setEditable");
        int n = 0;
        while (n < this.itemNames.length) {
            if (n != this.itemNames.length - 1) {
                this.itemText[n].setEditable(bl);
            } else {
                this.servertypeChoice.setEnabled(bl);
            }
            ++n;
        }
        NamesGeneric.debugTracing("Exitting ConnectData:setEditable");
    }

    public boolean isDataValid() {
        NamesGeneric.debugTracing("Entering ConnectData:isDataValid");
        int n = 0;
        while (n < this.itemNames.length) {
            if (n != this.itemNames.length - 1 && !NamesValidate.validateText(this.itemText[n], this.itemNames[n][0])) {
                this.invalidIndex = n;
                this.itemText[this.invalidIndex].requestFocus();
                this.itemText[this.invalidIndex].selectAll();
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isChanged() {
        int n = this.servertypeChoice.getSelectedIndex();
        if (n != this.initialChoice) {
            return true;
        }
        int n2 = 0;
        while (n2 < this.itemNames.length - 1) {
            if (this.itemText[n2].getText().compareTo(this.initialVals[n2]) != 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

