/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.names;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import oracle.ewt.EwtContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.asst.names.NamesValidate;
import oracle.net.asst.names.TimePanel;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public class Domain
extends EwtContainer {
    NetStrings ns = new NetStrings();
    private String[][] itemNames = new String[][]{{this.ns.getString("nnaDomName"), "", "Name"}, {this.ns.getString("nnaMinTTl"), "86400", "MIN_TTL"}};
    private LWTextField[] itemText;
    private TimePanel ttlPanel;
    private int i;
    private GridBagConstraints gbc;
    private GridBagLayout gb;
    private LWLabel l;
    private LWLabel timel;
    private NVNavigator nvnav = new NVNavigator();
    private NVFactory nvfactory = new NVFactory();
    private int invalidIndex;
    private NVPair curnvDomain;
    private Insets panelInsets;

    public Domain() {
        NamesGeneric.debugTracing("Entering Domain");
        this.panelInsets = new Insets(5, 5, 5, 5);
        this.gb = new GridBagLayout();
        ((Container)((Object)this)).setLayout(this.gb);
        this.gbc = new GridBagConstraints();
        this.gbc.insets = this.panelInsets;
        this.gbc.fill = 2;
        this.gbc.anchor = 11;
        this.itemText = new LWTextField[this.itemNames.length];
        this.i = 0;
        while (this.i < this.itemNames.length) {
            if (this.i == 1) {
                this.l = new LWLabel(new String(this.itemNames[this.i][0]), 1);
                this.gbc.gridx = 0;
                ++this.gbc.gridy;
                this.gbc.gridwidth = -1;
                this.gbc.weightx = 0.0;
                this.gbc.fill = 0;
                this.gb.setConstraints((Component)this.l, this.gbc);
                ((Container)((Object)this)).add((Component)this.l);
                this.ttlPanel = new TimePanel(true, true, true);
                this.gbc.gridx = 0;
                ++this.gbc.gridy;
                this.gbc.fill = 2;
                this.gbc.gridwidth = 0;
                this.gbc.weightx = 2.0;
                this.gb.setConstraints((Component)((Object)this.ttlPanel), this.gbc);
                ((Container)((Object)this)).add((Component)((Object)this.ttlPanel));
            } else {
                this.l = new LWLabel(new String(this.itemNames[this.i][0]), 1);
                this.gbc.gridx = 0;
                ++this.gbc.gridy;
                this.gbc.gridwidth = -1;
                this.gbc.weightx = 0.0;
                this.gbc.weighty = 1.0;
                this.gbc.fill = 0;
                this.gb.setConstraints((Component)this.l, this.gbc);
                ((Container)((Object)this)).add((Component)this.l);
                this.gbc.gridx = -1;
                this.gbc.gridwidth = 0;
                this.gbc.fill = 2;
                this.gbc.weightx = 3.0;
                this.itemText[this.i] = new LWTextField();
                this.gb.setConstraints((Component)this.itemText[this.i], this.gbc);
                ((Container)((Object)this)).add((Component)this.itemText[this.i]);
            }
            ++this.i;
        }
    }

    public Domain(NVPair nVPair) {
        this();
        this.display(nVPair);
        this.curnvDomain = nVPair;
        NamesGeneric.debugTracing("Exitting Domain");
    }

    public void display(NVPair nVPair) {
        NamesGeneric.debugTracing("Entering Domain:display");
        NVNavigator nVNavigator = new NVNavigator();
        if (nVPair != null) {
            NamesGeneric.debugTracing("nvDomain=" + nVPair.toString());
            this.i = 0;
            while (this.i < this.itemNames.length) {
                NVPair nVPair2 = nVNavigator.findNVPairRecurse(nVPair, this.itemNames[this.i][2]);
                if (this.i == 1) {
                    if (nVPair2 != null) {
                        NamesGeneric.debugTracing("Domain:display:nvpairi=1=" + nVPair2.toString());
                        this.ttlPanel.setTime(Integer.parseInt(nVPair2.getAtom(), 10));
                    } else {
                        this.ttlPanel.setTime(Integer.parseInt(this.itemNames[this.i][1], 10));
                    }
                } else if (nVPair2 != null) {
                    this.itemText[this.i].setText(nVPair2.getAtom());
                    NamesGeneric.debugTracing("Domain:display:nvpair=" + nVPair2.toString());
                } else {
                    this.itemText[this.i].setText(this.itemNames[this.i][1]);
                }
                ++this.i;
            }
        }
        NamesGeneric.debugTracing("Exitting Domain:display");
    }

    public NVPair getDisplayedDomain() {
        NamesGeneric.debugTracing("Entering Domain:getDomain");
        NVPair nVPair = this.nvfactory.createNVPair("(DOMAIN=)");
        int n = 0;
        while (n < this.itemNames.length) {
            String string;
            if (n == 1) {
                int n2 = this.ttlPanel.getTimeInSec();
                string = String.valueOf(n2);
            } else {
                string = this.itemText[n].getText();
            }
            String string2 = new String(this.itemNames[n][2]);
            if (string.length() > 0) {
                nVPair.addListElement(this.nvfactory.createNVPair("(" + string2 + "=" + string + ")"));
            } else if (n == 0) {
                nVPair.addListElement(this.nvfactory.createNVPair("(Name=)"));
            }
            ++n;
        }
        this.curnvDomain = nVPair;
        return nVPair;
    }

    public NVPair getDomain() {
        return this.curnvDomain;
    }

    public boolean isDataValid() {
        NamesGeneric.debugTracing("Entering Domain:isDataValid");
        int n = 0;
        while (n < this.itemNames.length) {
            if (n == 1) {
                if (!NamesValidate.validateTimeField(this.ttlPanel, this.itemNames[n][0])) {
                    this.invalidIndex = n;
                    return false;
                }
                int n2 = this.ttlPanel.getTimeInSec();
            } else {
                String string = this.itemText[n].getText().trim();
                if (string != null && string.length() != 0 && !NamesValidate.validateText(this.itemText[n], this.itemNames[n][0])) {
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    public void setDomainName(String string) {
        this.itemText[0].setText(string);
    }

    public void setMinTTL(String string) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        this.ttlPanel.setTime(n);
    }
}

