/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.names;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.Border;
import oracle.ewt.border.GroupBoxBorder;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.graphics.frame.InsetFramePainter;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.names.NamesAdvMisc;
import oracle.net.asst.names.NamesCache;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.asst.names.NamesValidate;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVPair;

public class NamesAdvanced
extends EwtContainer
implements NamesCache,
ActionListener {
    NetStrings ns = new NetStrings();
    private String oraNames = NamesGeneric.getOraNames();
    private String oraHome = NamesGeneric.getOraHome();
    private String[][] itemNames = new String[][]{{this.ns.getString("nnaCkpCch"), String.valueOf(this.oraNames) + "ckpcch.ora", "names.cache_checkpoint_file"}, {this.ns.getString("nnaCkpCfg"), String.valueOf(this.oraNames) + "ckpcfg.ora", "names.config_checkpoint_file"}, {this.ns.getString("nnaCkpReg"), String.valueOf(this.oraNames) + "ckpreg.ora", "names.region_checkpoint_file"}, {this.ns.getString("nnaLogDir"), String.valueOf(this.oraHome) + "log", "names.log_directory"}, {this.ns.getString("nnaLogFile"), "names.log", "names.log_file"}, {this.ns.getString("nnaTraceDir"), String.valueOf(this.oraHome) + "trace", "names.trace_directory"}, {this.ns.getString("nnaTracefile"), "names.trc", "names.trace_file"}, {this.ns.getString("nnaTraceUnique"), "yes", "names.trace_unique"}, {this.ns.getString("nnaMaxOpenConn"), "10", "names.max_open_connections"}, {this.ns.getString("nnaMsgPoolSize"), "10", "names.message_pool_start_size"}, {this.ns.getString("nnaAutoRefreshExp"), "259200", "names.auto_refresh_expire"}, {this.ns.getString("nnaAutoRefreshRetry"), "180", "names.auto_refresh_retry"}};
    private boolean[] presentf = new boolean[this.itemNames.length];
    private boolean changed = false;
    private static final short ckpItems = 3;
    private static final short logFilePos = 4;
    private static final short traceFilePos = 6;
    private static final short traceUniquePos = 7;
    private static final short noNameItems = 8;
    private static final short timeItemsBegin = 10;
    private LWTextField[] itemText;
    private MarginBorder sharedBorderPixel;
    private int i;
    private GridBagConstraints gbc;
    private GridBagLayout gb;
    private LWLabel l;
    private LWCheckbox cb;
    private NLParamParser nlpa;
    private EwtContainer ckpPanel;
    private EwtContainer noNamePanel;
    private EwtContainer buttonPanel;
    private EwtContainer advPanel;
    private LWButton miscButton;
    private NamesAdvMisc miscDialog;
    private String[] miscValues = new String[this.itemNames.length - 8];
    private int invalidIndex;
    private String os = System.getProperty("os.name");
    private Insets bigInsets;
    private Insets smallInsets;

    public NamesAdvanced() {
        NamesGeneric.debugTracing("Entering NamesAdvanced");
        this.gb = new GridBagLayout();
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.bigInsets = new Insets(2, 5, 2, 5);
        this.smallInsets = new Insets(0, 4, 0, 4);
        this.gbc.insets = this.bigInsets;
        this.gbc.fill = 2;
        this.sharedBorderPixel = new MarginBorder(4, 4, 4, 4);
        this.setBorder((Border)this.sharedBorderPixel);
        this.itemText = new LWTextField[7];
        this.advPanel = new EwtContainer();
        this.advPanel.setLayout(this.gb);
        this.ckpPanel = new EwtContainer();
        this.ckpPanel.setLayout(this.gb);
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.weightx = 100.0;
        this.gbc.weighty = 100.0;
        this.gb.setConstraints((Component)this.ckpPanel, this.gbc);
        this.ckpPanel.setBorder((Border)new GroupBoxBorder(this.ns.getString("nnaCkpInfo"), InsetFramePainter.getFramePainter(), 2));
        this.advPanel.add((Component)this.ckpPanel);
        this.noNamePanel = new EwtContainer();
        this.noNamePanel.setLayout(this.gb);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gb.setConstraints((Component)this.noNamePanel, this.gbc);
        this.noNamePanel.setBorder((Border)new GroupBoxBorder("", InsetFramePainter.getFramePainter(), 2));
        this.advPanel.add((Component)this.noNamePanel);
        this.buttonPanel = new EwtContainer();
        this.buttonPanel.setLayout(new FlowLayout(0));
        ++this.gbc.gridy;
        this.gbc.insets = this.smallInsets;
        this.gb.setConstraints((Component)this.buttonPanel, this.gbc);
        this.advPanel.add((Component)this.buttonPanel);
        this.gbc.insets = this.bigInsets;
        this.i = 0;
        while (this.i < 8) {
            this.gbc.gridx = 0;
            ++this.gbc.gridy;
            this.l = new LWLabel(new String(this.itemNames[this.i][0]), 1);
            this.gb.setConstraints((Component)this.l, this.gbc);
            if (this.i == 7) {
                ++this.gbc.gridx;
                this.cb = new LWCheckbox(this.itemNames[7][0]);
                this.gb.setConstraints((Component)this.cb, this.gbc);
                this.cb.setState(true);
                this.noNamePanel.add((Component)this.cb);
            } else if (this.i < 3) {
                this.ckpPanel.add((Component)this.l);
                ++this.gbc.gridx;
                this.itemText[this.i] = new LWTextField(24);
                this.gb.setConstraints((Component)this.itemText[this.i], this.gbc);
                this.ckpPanel.add((Component)this.itemText[this.i]);
            } else {
                this.noNamePanel.add((Component)this.l);
                ++this.gbc.gridx;
                this.itemText[this.i] = new LWTextField(20);
                this.gb.setConstraints((Component)this.itemText[this.i], this.gbc);
                this.noNamePanel.add((Component)this.itemText[this.i]);
            }
            ++this.i;
        }
        this.miscButton = new LWButton(this.ns.getString("nnaMisc"));
        this.gbc.insets = this.smallInsets;
        this.gb.setConstraints((Component)this.miscButton, this.gbc);
        this.miscButton.addActionListener((ActionListener)this);
        this.buttonPanel.add((Component)this.miscButton);
        ((Container)((Object)this)).add((Component)this.advPanel, "North");
        int n = 0;
        while (n < this.itemNames.length) {
            this.presentf[n] = false;
            ++n;
        }
        this.invalidIndex = 0;
        NamesGeneric.debugTracing("Exitting NamesAdvanced");
    }

    public void setNLP(NLParamParser nLParamParser) {
        NamesGeneric.debugTracing("Entering NamesAdvanced:setNLP");
        this.nlpa = nLParamParser;
        NamesGeneric.debugTracing("Exitting NamesAdvanced:setNLP");
    }

    public void get() {
        this.changed = false;
        NamesGeneric.debugTracing("Entering NamesAdvanced:get");
        int n = 0;
        while (n < this.itemNames.length) {
            NVPair nVPair = this.nlpa.getNLPListElement(new String(this.itemNames[n][2]));
            if (n < 8) {
                String string;
                if (nVPair != null) {
                    if (n == 7) {
                        string = nVPair.getAtom();
                        this.cb.setState(string.compareTo("yes") == 0 || string.compareTo("true") == 0 || string.compareTo("on") == 0);
                        this.presentf[n] = true;
                    } else {
                        this.itemText[n].setText(nVPair.getAtom());
                        this.presentf[n] = true;
                    }
                } else if (n == 7) {
                    string = this.itemNames[n][1];
                    this.cb.setState(string.compareTo("yes") == 0 || string.compareTo("true") == 0 || string.compareTo("on") == 0);
                } else {
                    this.itemText[n].setText(this.itemNames[n][1]);
                }
            } else {
                int n2 = n - 8;
                if (nVPair != null) {
                    this.miscValues[n2] = nVPair.getAtom();
                    this.presentf[n] = true;
                } else {
                    this.miscValues[n2] = this.itemNames[n][1];
                }
            }
            ++n;
        }
        NamesGeneric.debugTracing("Exitting NamesAdvanced:get");
    }

    public void set() {
        NamesGeneric.debugTracing("Entering NamesAdvanced:set");
        String string = "";
        int n = 0;
        while (n < this.itemNames.length) {
            if (n < 8) {
                string = n == 7 ? (this.cb.getState() ? "yes" : "no") : this.itemText[n].getText();
            } else {
                int n2 = n - 8;
                string = this.miscValues[n2];
            }
            if ((string.compareTo(this.itemNames[n][1]) != 0 || this.presentf[n]) && string.length() > 0) {
                String string2 = new String(this.itemNames[n][2]);
                try {
                    this.nlpa.addNLPListElement(String.valueOf(string2) + "=" + string);
                }
                catch (NLException nLException) {}
            }
            ++n;
        }
        this.changed = false;
        NamesGeneric.debugTracing("Exitting NamesAdvanced:set");
    }

    public boolean isDataValid() {
        NamesGeneric.debugTracing("Entering NamesAdvanced:isDataValid");
        int n = 0;
        while (n < 8) {
            if (n != 7 && !NamesValidate.validateText(this.itemText[n], this.itemNames[n][0])) {
                this.invalidIndex = n;
                this.setFocus();
                return false;
            }
            ++n;
        }
        return true;
    }

    public void setFocus() {
        this.itemText[this.invalidIndex].requestFocus();
        this.itemText[this.invalidIndex].selectAll();
    }

    public boolean isChanged() {
        NamesGeneric.debugTracing("Entering NamesAdvanced:isPanelChanged");
        if (this.changed) {
            return true;
        }
        int n = 0;
        while (n < 8) {
            String string;
            NVPair nVPair = this.nlpa.getNLPListElement(new String(this.itemNames[n][2]));
            if (nVPair != null) {
                if (n == 7) {
                    if (this.cb.getState() != ((string = nVPair.getAtom()).compareTo("yes") == 0 || string.compareTo("true") == 0 || string.compareTo("on") == 0)) {
                        this.changed = true;
                        break;
                    }
                } else if (!this.itemText[n].getText().equalsIgnoreCase(nVPair.getAtom())) {
                    this.changed = true;
                    break;
                }
            } else if (n == 7) {
                if (this.cb.getState() != ((string = this.itemNames[n][1]).compareTo("yes") == 0 || string.compareTo("true") == 0 || string.compareTo("on") == 0)) {
                    this.changed = true;
                    break;
                }
            } else if (!this.itemText[n].getText().equalsIgnoreCase(this.itemNames[n][1])) {
                this.changed = true;
                break;
            }
            ++n;
        }
        return this.changed;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        NamesGeneric.debugTracing("Entering NamesAdvanced:actionPerformed");
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        String string2 = this.ns.getString("nnaOk");
        String string3 = this.ns.getString("nnaCancel");
        String string4 = this.ns.getString("nnaMisc");
        if (object instanceof LWButton) {
            if (string.compareTo(string4) == 0) {
                this.miscDialog = new NamesAdvMisc(NamesGeneric.appFrame, this.ns.getString("nnaMiscellaneous"), this, this.miscValues);
                this.miscDialog.dlgShow();
            } else if (string.compareTo(string2) == 0) {
                boolean bl = this.miscDialog.checkMiscValues();
                if (bl) {
                    this.miscDialog.getMiscValues(this.miscValues);
                    ((Component)((Object)this.miscDialog)).setVisible(false);
                    this.miscDialog.dispose();
                    if (!this.changed) {
                        this.changed = this.miscDialog.isDialogChanged(this.nlpa);
                    }
                }
            } else if (string.compareTo(string3) == 0) {
                ((Component)((Object)this.miscDialog)).setVisible(false);
                this.miscDialog.dispose();
            }
        }
        NamesGeneric.debugTracing("Exitting NamesAdvanced:actionPerformed");
    }

    private boolean getBool(String string) {
        return string.compareTo("yes") == 0 || string.compareTo("true") == 0 || string.compareTo("on") == 0;
    }
}

