/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.names;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import oracle.ewt.EwtContainer;
import oracle.ewt.tabPanel.TabPanel;
import oracle.ewt.tabPanel.TabPanelPage;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.names.NamesAddress;
import oracle.net.asst.names.NamesAdvanced;
import oracle.net.asst.names.NamesCache;
import oracle.net.asst.names.NamesDomains;
import oracle.net.asst.names.NamesGeneral;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.asst.names.NamesRegion;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;

public class NamesConfigure
extends EwtContainer {
    NetStrings ns = new NetStrings();
    private String[] panelNames = new String[]{this.ns.getString("nnaGeneral"), this.ns.getString("nnaAddress"), this.ns.getString("nnaDomains"), this.ns.getString("nnaDatabase"), this.ns.getString("nnaAdvanced")};
    private NamesCache[] panels;
    private TabPanel tp;
    private TabPanelPage[] tpp;
    private int i;
    private NLParamParser nlpa;

    public NamesConfigure() {
        NamesGeneric.debugTracing("Entering NamesConfigure");
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.tp = new TabPanel();
        ((Container)((Object)this)).add((Component)this.tp, "Center");
        this.panels = new NamesCache[this.panelNames.length];
        this.tpp = new TabPanelPage[this.panelNames.length];
        this.panels[0] = new NamesGeneral();
        NamesGeneric.debugTracing("general");
        this.panels[1] = new NamesAddress();
        NamesGeneric.debugTracing("addr");
        this.panels[2] = new NamesDomains();
        NamesGeneric.debugTracing("domain");
        this.panels[3] = new NamesRegion();
        NamesGeneric.debugTracing("region");
        this.panels[4] = new NamesAdvanced();
        NamesGeneric.debugTracing("adv");
        this.i = 0;
        while (this.i < this.panelNames.length) {
            this.tpp[this.i] = this.tp.addPage(" " + this.panelNames[this.i] + " ", (Component)((EwtContainer)this.panels[this.i]));
            ++this.i;
        }
    }

    public NamesConfigure(String string) throws IOException, NLException {
        this();
        this.activate(string);
    }

    public void activate(String string) {
        NamesGeneric.debugTracing("Entering NamesConfigure:activate");
        try {
            this.nlpa = new NLParamParser(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            NamesGeneric.debugTracing("IO problem.../n");
        }
        catch (NLException nLException) {
            NamesGeneric.debugTracing("NL.../n");
        }
        catch (Exception exception) {
            NamesGeneric.debugTracing("message" + exception.getMessage());
            exception.printStackTrace();
        }
        int n = 0;
        while (n < this.panelNames.length) {
            this.panels[n].setNLP(this.nlpa);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.panelNames.length) {
            this.panels[n2].get();
            ++n2;
        }
        NamesGeneric.debugTracing("Exitting NamesConfigure:activate");
    }

    public boolean discard() {
        String string = null;
        if (this.nlpa != null) {
            string = this.nlpa.getFilename();
        }
        if (string != null) {
            this.activate(string);
        }
        return true;
    }

    public boolean isChanged() {
        NamesGeneric.debugTracing("Entering/Exitting NamesConfigure:isChanged");
        int n = 0;
        while (n < this.panelNames.length) {
            if (this.panels[n].isChanged()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean validateConfig() {
        NamesGeneric.debugTracing("Entering/Exitting NamesConfigure:validateConfig");
        int n = 0;
        while (n < this.panelNames.length) {
            if (!this.panels[n].isDataValid()) {
                this.tpp[n].setSelected(true);
                this.panels[n].setFocus();
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean save(String string) {
        NamesGeneric.debugTracing("Entering NamesConfigure:save");
        if (!this.validateConfig()) {
            return false;
        }
        int n = 0;
        while (n < this.panelNames.length) {
            this.panels[n].set();
            ++n;
        }
        try {
            if (this.nlpa.getNLPListSize() != 0) {
                this.nlpa.saveNLParams(string);
            } else {
                new File(string).delete();
            }
        }
        catch (IOException iOException) {
            NamesGeneric.debugTracing("Saving Problem");
            return false;
        }
        return true;
    }

    public void rename(String string, String string2) {
        ((NamesGeneral)this.panels[0]).setServerName(string2);
    }

    public int getCurrTab_index() {
        NamesGeneric.debugTracing("Entering/Exitting NamesConfigure:getCurrTab_index");
        return this.tp.getIndexOf(this.tp.getSelectedPage());
    }

    public NamesCache getCurrTab() {
        NamesGeneric.debugTracing("Entering NamesConfigure:getCurrTab");
        int n = this.tp.getIndexOf(this.tp.getSelectedPage());
        return this.panels[n];
    }

    public boolean fileHasComments() {
        return this.nlpa.fileHasComments();
    }
}

