/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.names;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import oracle.ewt.EwtContainer;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.LWList;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.names.Domain;
import oracle.net.asst.names.NamesCache;
import oracle.net.asst.names.NamesDialog;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public class NamesDomains
extends EwtContainer
implements NamesCache,
ActionListener,
ItemListener {
    NetStrings ns = new NetStrings();
    private String[][] itemNames = new String[][]{{this.ns.getString("nnaDomains"), "NS1", "names.domains"}};
    private String addString = this.ns.getString("nnaAdd");
    private String removeString = this.ns.getString("nnaRemove");
    private String changeString = this.ns.getString("nnaChange");
    private LWTextField[] itemText;
    private LWList curList;
    private LWLabel l;
    private LWCheckbox cb;
    private LWButton addButton;
    private LWButton removeButton;
    private LWButton changeButton;
    private GridBagConstraints gbc;
    private GridBagLayout gb;
    private NLParamParser nlpa;
    private Domain domainPanel;
    private NVFactory nvfactory = new NVFactory();
    private Vector domainVector = new Vector(3);
    private boolean changed = false;

    public NamesDomains() {
        NamesGeneric.debugTracing("Entering NamesDomains");
        this.gb = new GridBagLayout();
        ((Container)((Object)this)).setLayout(this.gb);
        this.gbc = new GridBagConstraints();
        this.gbc.gridwidth = 1;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.gbc.fill = 1;
        this.gbc.anchor = 11;
        NVPair nVPair = this.nvfactory.createNVPair("(Domain=(Min_ttl=86400))");
        this.domainPanel = new Domain(nVPair);
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 0.25;
        this.gbc.gridwidth = 3;
        this.gbc.insets.bottom = 0;
        ((Container)((Object)this)).add((Component)((Object)this.domainPanel), this.gbc);
        this.gbc.insets.bottom = 5;
        this.addButton = new LWButton(this.addString);
        this.gbc.weighty = 0.25;
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.weightx = 0.25;
        this.gbc.gridwidth = 1;
        this.gbc.fill = 0;
        this.addButton.addActionListener((ActionListener)this);
        ((Container)((Object)this)).add((Component)this.addButton, this.gbc);
        this.removeButton = new LWButton(this.removeString);
        ++this.gbc.gridx;
        this.removeButton.addActionListener((ActionListener)this);
        ((Container)((Object)this)).add((Component)this.removeButton, this.gbc);
        this.changeButton = new LWButton(this.changeString);
        ++this.gbc.gridx;
        this.changeButton.addActionListener((ActionListener)this);
        ((Container)((Object)this)).add((Component)this.changeButton, this.gbc);
        this.removeButton.setEnabled(false);
        this.changeButton.setEnabled(false);
        this.curList = new LWList(5, false);
        this.curList.addItemListener((ItemListener)this);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.weighty = 1.5;
        this.gbc.gridwidth = 3;
        this.gbc.fill = 1;
        ((Container)((Object)this)).add((Component)this.curList, this.gbc);
        NamesGeneric.debugTracing("Exitting NamesDomains");
    }

    public void setNLP(NLParamParser nLParamParser) {
        this.nlpa = nLParamParser;
    }

    public void get() {
        NamesGeneric.debugTracing("Entering NamesDomains:get");
        this.changed = false;
        int n = 0;
        while (n < this.itemNames.length) {
            this.domainVector.removeAllElements();
            this.curList.removeAll();
            NVPair nVPair = this.nlpa.getNLPListElement(new String(this.itemNames[n][2]));
            if (nVPair != null) {
                if (nVPair.getListSize() > 0) {
                    String string = (nVPair = nVPair.getListElement(0)).getName();
                    if (string.equalsIgnoreCase("Domain_list")) {
                        this.doDomainList(nVPair);
                    } else {
                        this.addDomainPanel(nVPair);
                    }
                } else {
                    this.changed = true;
                }
            } else {
                nVPair = this.nvfactory.createNVPair("(Domain=(name=)(min_ttl=86400))");
                this.addDomainPanel(nVPair);
            }
            ++n;
        }
        NamesGeneric.debugTracing("Exitting NamesDomains:get");
    }

    public void set() {
        NamesGeneric.debugTracing("Entering NamesDomains:set");
        NVPair nVPair = null;
        NVNavigator nVNavigator = new NVNavigator();
        if (this.domainVector.size() != 0) {
            if (this.domainVector.size() > 1) {
                nVPair = this.nvfactory.createNVPair("(Domain_List=)");
                int n = 0;
                while (n < this.domainVector.size()) {
                    nVPair.addListElement((NVPair)this.domainVector.elementAt(n));
                    ++n;
                }
            } else {
                NVPair nVPair2 = (NVPair)this.domainVector.firstElement();
                NVPair nVPair3 = nVNavigator.findNVPair(nVPair2, "Name");
                NVPair nVPair4 = nVNavigator.findNVPair(nVPair2, "Min_TTL");
                if (nVPair3 == null || nVPair4 == null || nVPair3.getAtom() != null || !nVPair4.getAtom().equalsIgnoreCase("86400")) {
                    nVPair = this.nvfactory.createNVPair(this.domainVector.elementAt(0).toString());
                }
            }
        }
        if (nVPair != null) {
            try {
                this.nlpa.addNLPListElement(String.valueOf(this.itemNames[0][2]) + "=" + nVPair.toString());
            }
            catch (NLException nLException) {
                NamesGeneric.debugTracing("Unable to add names.domains. " + nLException);
            }
        } else {
            NamesGeneric.debugTracing("Removing names.domains param");
            this.nlpa.removeNLPListElement(this.itemNames[0][2]);
        }
        this.changed = false;
        NamesGeneric.debugTracing("Exitting NamesDomains:set");
    }

    public boolean isDataValid() {
        NamesGeneric.debugTracing("Entering NamesDomains:isDataValid");
        return this.domainPanel.isDataValid();
    }

    public void setFocus() {
    }

    public boolean isChanged() {
        NamesGeneric.debugTracing("Entering/Exiting isChanged:NamesDomains");
        return this.changed;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        NamesGeneric.debugTracing("Entering NamesDomains:actionPerformed");
        Object object = actionEvent.getSource();
        if (object instanceof LWButton) {
            if (actionEvent.getActionCommand().compareTo(this.addString) == 0) {
                if (!this.domainPanel.isDataValid()) {
                    return;
                }
                NVPair nVPair = this.domainPanel.getDisplayedDomain();
                NVPair nVPair2 = this.nvfactory.createNVPair(nVPair.toString());
                if (this.checkDups(nVPair2)) {
                    String string = this.ns.getString("nnaError");
                    String string2 = this.ns.getString("nnaSameDomain");
                    NamesDialog.popUp(string, string2, 2);
                    return;
                }
                this.domainVector.addElement(nVPair2);
                this.curList.addItem(nVPair.toString().toLowerCase());
                this.changed = true;
            } else if (actionEvent.getActionCommand().compareTo(this.removeString) == 0) {
                int n = this.curList.getSelectedIndex();
                if (n >= 0) {
                    NVPair nVPair = this.nvfactory.createNVPair(this.curList.getSelectedItem());
                    this.curList.remove(n);
                    this.domainVector.removeElementAt(n);
                    int n2 = this.curList.getSelectedIndex();
                    if (n2 > 0) {
                        this.curList.deselect(n2);
                    }
                    this.removeButton.setEnabled(false);
                    this.changeButton.setEnabled(false);
                    this.changed = true;
                }
            } else if (actionEvent.getActionCommand().compareTo(this.changeString) == 0) {
                if (!this.domainPanel.isDataValid()) {
                    return;
                }
                int n = this.curList.getSelectedIndex();
                if (n >= 0) {
                    NVPair nVPair = this.domainPanel.getDisplayedDomain();
                    NVPair nVPair3 = this.nvfactory.createNVPair(nVPair.toString());
                    if (this.checkDups(nVPair3)) {
                        String string = this.ns.getString("nnaError");
                        String string3 = this.ns.getString("nnaSameDomain");
                        NamesDialog.popUp(string, string3, 2);
                        return;
                    }
                    this.domainVector.removeElementAt(n);
                    this.domainVector.insertElementAt(nVPair3, n);
                    this.curList.remove(n);
                    this.curList.addItem(nVPair3.toString().toLowerCase(), n);
                    int n3 = this.curList.getSelectedIndex();
                    if (n3 > 0) {
                        this.curList.deselect(n3);
                    }
                    this.changeButton.setEnabled(false);
                    this.removeButton.setEnabled(false);
                    this.changed = true;
                }
            }
        }
        NamesGeneric.debugTracing("Exitting NamesDomains:actionPerformed");
    }

    private void doDomainList(NVPair nVPair) {
        NamesGeneric.debugTracing("Entering NamesDomains:doDomainList");
        int n = 0;
        while (n < nVPair.getListSize()) {
            this.addDomainPanel(nVPair.getListElement(n));
            ++n;
        }
        NamesGeneric.debugTracing("Exitting NamesDomains:doDomainList");
    }

    private void addDomainPanel(NVPair nVPair) {
        NamesGeneric.debugTracing("Entering NamesDomains:addDomainPanel");
        this.domainVector.addElement(this.nvfactory.createNVPair(nVPair.toString()));
        this.curList.addItem(nVPair.toString().toLowerCase());
        NamesGeneric.debugTracing("Exitting NamesDomains:addDomainPanel");
    }

    private void displaydomainPanel(NVPair nVPair) {
        NamesGeneric.debugTracing("Entering NamesDomains:displaydomainPanel");
        this.curList.addItem(nVPair.toString());
        NamesGeneric.debugTracing("Exitting NamesDomains:displaydomainPanel");
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        NamesGeneric.debugTracing("Entering NamesDomains:itemStateChanged");
        int n = itemEvent.getStateChange();
        if (n == 1) {
            this.removeButton.setEnabled(true);
            this.changeButton.setEnabled(true);
            NVPair nVPair = this.nvfactory.createNVPair(this.curList.getSelectedItem());
            this.domainPanel.display(nVPair);
        }
        NamesGeneric.debugTracing("Exitting NamesDomains:itemStateChanged");
    }

    private boolean checkDups(NVPair nVPair) {
        NamesGeneric.debugTracing("Entering NamesAddress:checkDups");
        String string = nVPair.toString();
        int n = 0;
        while (n < this.domainVector.size()) {
            if (string.equalsIgnoreCase(this.domainVector.elementAt(n).toString())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Vector getDomainList() {
        return this.domainVector;
    }

    public void setDomains(Vector vector) {
        this.domainVector = vector;
        int n = 0;
        while (n < this.domainVector.size()) {
            this.curList.addItem(this.domainVector.elementAt(n).toString());
            ++n;
        }
    }

    public void setDomain(NVPair nVPair) {
        this.domainPanel.display(nVPair);
    }

    public void setDomainName(String string) {
        this.domainPanel.setDomainName(string);
    }

    public void setMinTTL(String string) {
        this.domainPanel.setMinTTL(string);
    }
}

