/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.names;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.names.NamesCache;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.asst.names.NamesPasswd;
import oracle.net.asst.names.NamesValidate;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVPair;

public class NamesGeneral
extends EwtContainer
implements NamesCache,
ActionListener {
    NetStrings ns = new NetStrings();
    private String[][] itemNames = new String[][]{{this.ns.getString("nnaNameCol"), "onames", "names.server_name"}, {this.ns.getString("nnaPassword"), "", "names.password"}};
    private EwtContainer generalPanel;
    private LWButton changePasswd;
    private LWTextField[] itemText;
    private LWLabel l;
    private LWCheckbox cb;
    private GridBagConstraints gbc;
    private NamesPasswd passwdDialog;
    private int i;
    private int invalidIndex;
    private NLParamParser nlpa;
    private String latestPasswd;
    private String defaultName;
    private boolean passwdUp = false;

    public NamesGeneral() {
        NamesGeneric.debugTracing("Entering NamesGeneral");
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.insets = new Insets(10, 5, 5, 5);
        this.gbc.fill = 2;
        this.setBorderPainter((BorderPainter)new FixedBorderPainter(10, 5, 5, 5));
        this.generalPanel = new EwtContainer();
        this.generalPanel.setLayout(new GridBagLayout());
        this.itemText = new LWTextField[this.itemNames.length];
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.i = 0;
        while (this.i < this.itemNames.length) {
            this.gbc.gridx = 0;
            this.gbc.gridy = 2 * this.i + 1;
            this.l = new LWLabel(new String(this.itemNames[this.i][0]), 1);
            this.generalPanel.add((Component)this.l, this.gbc);
            ++this.gbc.gridx;
            this.itemText[this.i] = new LWTextField(15);
            this.generalPanel.add((Component)this.itemText[this.i], this.gbc);
            ++this.i;
        }
        this.itemText[0].setEditable(false);
        this.itemText[1].setEditable(false);
        ++this.gbc.gridx;
        this.changePasswd = new LWButton(this.ns.getString("nnaChangePasswd"));
        this.changePasswd.addActionListener((ActionListener)this);
        this.generalPanel.add((Component)this.changePasswd, this.gbc);
        ((Container)((Object)this)).add((Component)this.generalPanel, "North");
        this.invalidIndex = 0;
        NamesGeneric.debugTracing("Exiting NamesGeneral");
    }

    public void setNLP(NLParamParser nLParamParser) {
        NamesGeneric.debugTracing("Entering NamesGeneral:setNLP");
        this.nlpa = nLParamParser;
        NamesGeneric.debugTracing("Exitting NamesGeneral:setNLP");
    }

    public void get() {
        NamesGeneric.debugTracing("Entering NamesGeneral:get");
        this.defaultName = "onames_" + NamesGeneric.getLocalHost();
        int n = 0;
        while (n < this.itemNames.length) {
            NVPair nVPair = this.nlpa.getNLPListElement(new String(this.itemNames[n][2]));
            if (nVPair != null) {
                if (n == 0) {
                    this.itemText[n].setText(nVPair.getAtom());
                } else {
                    this.latestPasswd = nVPair.getAtom();
                    char[] cArray = new char[this.latestPasswd.length()];
                    int n2 = 0;
                    while (n2 < cArray.length) {
                        cArray[n2] = 42;
                        ++n2;
                    }
                    this.itemText[1].setText(String.valueOf(cArray));
                }
            } else if (n == 0) {
                this.itemText[n].setText(this.defaultName);
            } else {
                this.itemText[n].setText(this.itemNames[n][1]);
                this.latestPasswd = this.itemNames[n][1];
            }
            ++n;
        }
        this.itemText[0].transferFocus();
        NamesGeneric.debugTracing("Exitting NamesGeneral:get");
    }

    public void set() {
        NamesGeneric.debugTracing("Entering NamesGeneral:set");
        int n = 0;
        while (n < this.itemNames.length) {
            String string = this.itemText[n].getText();
            if (n == 1) {
                string = this.latestPasswd;
            }
            if (string.compareTo(this.itemNames[n][1]) != 0 && (n != 0 || string.compareTo(this.defaultName) != 0) && string.length() > 0) {
                String string2 = new String(this.itemNames[n][2]);
                try {
                    this.nlpa.addNLPListElement(String.valueOf(string2) + "=" + string);
                }
                catch (NLException nLException) {}
            }
            ++n;
        }
        NamesGeneric.debugTracing("Exitting NamesGeneral:set");
    }

    public void setServerName(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        this.itemText[0].setText(string);
    }

    public String getServerName() {
        return this.itemText[0].getText();
    }

    public boolean isDataValid() {
        NamesGeneric.debugTracing("Entering NamesGeneral:isDataValid");
        if (!NamesValidate.validateText(this.itemText[0], this.itemNames[0][0])) {
            this.invalidIndex = 0;
            this.setFocus();
            return false;
        }
        return true;
    }

    public void setFocus() {
        this.itemText[this.invalidIndex].requestFocus();
        this.itemText[this.invalidIndex].selectAll();
    }

    public boolean isChanged() {
        NamesGeneric.debugTracing("Entering NamesGeneral:isChanged");
        this.defaultName = "onames_" + NamesGeneric.getLocalHost();
        int n = 0;
        while (n < this.itemNames.length) {
            NVPair nVPair = this.nlpa.getNLPListElement(new String(this.itemNames[n][2]));
            if (nVPair != null) {
                if (n == 0 ? !this.itemText[n].getText().equalsIgnoreCase(nVPair.getAtom()) : !this.latestPasswd.equalsIgnoreCase(nVPair.getAtom())) {
                    return true;
                }
            } else if (n == 0) {
                if (!this.itemText[n].getText().equalsIgnoreCase(this.defaultName)) {
                    return true;
                }
            } else {
                if (this.latestPasswd.length() == 0) {
                    return false;
                }
                if (!this.latestPasswd.equalsIgnoreCase(this.itemNames[n][1])) {
                    return true;
                }
            }
            ++n;
        }
        NamesGeneric.debugTracing("Exitting NamesGeneral:isChanged");
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        NamesGeneric.debugTracing("Entering NamesGeneral:actionPerformed");
        Object object = actionEvent.getSource();
        String string = this.ns.getString("nnaOk");
        String string2 = this.ns.getString("nnaCancel");
        String string3 = this.ns.getString("nnaChangePasswd");
        System.getProperty("os.name");
        if (object instanceof LWButton) {
            if (actionEvent.getActionCommand().compareTo(string3) == 0) {
                this.passwdDialog = new NamesPasswd(NamesGeneric.appFrame, this, this.latestPasswd);
                this.passwdUp = true;
                this.passwdDialog.dlgShow();
            } else if (actionEvent.getActionCommand().compareTo(string) == 0) {
                int n;
                if (this.passwdUp && (n = this.passwdDialog.checkNewPasswd()) == 0) {
                    this.latestPasswd = this.passwdDialog.getNewPasswd();
                    char[] cArray = new char[this.latestPasswd.length()];
                    int n2 = 0;
                    while (n2 < cArray.length) {
                        cArray[n2] = 42;
                        ++n2;
                    }
                    this.itemText[1].setText(String.valueOf(cArray));
                    ((Component)((Object)this.passwdDialog)).setVisible(false);
                    this.passwdDialog.dispose();
                    this.passwdUp = false;
                }
            } else if (actionEvent.getActionCommand().compareTo(string2) == 0) {
                ((Component)((Object)this.passwdDialog)).setVisible(false);
                this.passwdDialog.dispose();
                this.passwdUp = false;
            }
        }
        NamesGeneric.debugTracing("Exitting NamesGeneral:actionPerformed");
    }
}

