/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.names;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.Border;
import oracle.ewt.border.GroupBoxBorder;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.graphics.frame.InsetFramePainter;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.names.NamesAdvRegion;
import oracle.net.asst.names.NamesCache;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.asst.names.NamesValidate;
import oracle.net.asst.servicename.AddressListPanel;
import oracle.net.asst.servicename.DBPanel;
import oracle.net.common.netObject.Description;
import oracle.net.common.netObject.NetObjectException;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public class NamesRegion
extends EwtContainer
implements NamesCache,
ItemListener,
ActionListener {
    NetStrings ns = new NetStrings();
    private String[] cbNames = new String[]{this.ns.getString("nnaNoRegionDb"), this.ns.getString("nnaRegionDb")};
    private String[][] itemNames = new String[][]{{this.ns.getString("nnaDescription"), "junk", "DESCRIPTION"}, {this.ns.getString("nnaUser"), "names", "USERID"}, {this.ns.getString("nnaPassword"), null, "PASSWORD"}, {this.ns.getString("nnaRegionName"), "LOCAL_REGION", "NAME"}, {this.ns.getString("nnaRefresh"), "86400", "REFRESH"}, {this.ns.getString("nnaRetry"), "60", "RETRY"}, {this.ns.getString("nnaExpire"), "600", "EXPIRE"}};
    private String regionString = "names.admin_region";
    private String versionString = "(VERSION=134230016)";
    private String[] optValues = new String[this.itemNames.length - 3];
    private static final short addrPanelIndex = 0;
    private static final short usrItemIndex = 1;
    private static final short passwdItemIndex = 2;
    private static final short timeItemsBegin = 4;
    private static final short regionNameIndex = 3;
    private LWTextField[] itemText;
    private LWLabel l;
    private LWCheckbox[] cb;
    private LWCheckboxGroup cbg = new LWCheckboxGroup();
    private EwtContainer cbPanel;
    private EwtContainer descPanel;
    private EwtContainer buttonPanel;
    private EwtContainer usrPanel;
    private EwtContainer outPanel;
    private LWButton moreButton;
    private GridBagConstraints gbc;
    private GridBagLayout gb;
    private AddressListPanel addrPanel;
    private DBPanel condataPanel;
    private Description desc;
    private NamesAdvRegion advDialog;
    private int i;
    private int j;
    private boolean presentf;
    private int invalidIndex;
    private boolean changed = false;
    private NLParamParser nlpa;
    private NVFactory nvfactory = new NVFactory();

    public NamesRegion() {
        NamesGeneric.debugTracing("Entering NamesRegion");
        try {
            this.desc = new Description(this.nvfactory.createNVPair("(Description=(Address_List=(Address=(protocol=tcp)))(Connect_data=(SID=oracle)(SRVR=dedicated)))"));
        }
        catch (NetObjectException netObjectException) {
            NamesGeneric.debugTracing(netObjectException.toString());
            throw new IllegalArgumentException();
        }
        this.optValues[0] = new String(this.itemNames[3][1]);
        this.optValues[1] = new String(this.itemNames[4][1]);
        this.optValues[2] = new String(this.itemNames[5][1]);
        this.optValues[3] = new String(this.itemNames[6][1]);
        this.gb = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.cbPanel = new EwtContainer();
        this.cbPanel.setLayout(new FlowLayout(0));
        this.cb = new LWCheckbox[2];
        this.itemText = new LWTextField[3];
        this.cb[0] = new LWCheckbox(new String(this.cbNames[0]), this.cbg, false);
        this.cb[0].addItemListener((ItemListener)this);
        this.cbPanel.add((Component)this.cb[0]);
        this.cb[1] = new LWCheckbox(new String(this.cbNames[1]), this.cbg, false);
        this.cb[1].addItemListener((ItemListener)this);
        this.cbPanel.add((Component)this.cb[1]);
        this.descPanel = new EwtContainer();
        this.descPanel.setLayout(this.gb);
        this.descPanel.setBorder((Border)new MarginBorder(0, 5, 0, 5));
        EwtContainer ewtContainer = new EwtContainer();
        ewtContainer.setBorder((Border)new GroupBoxBorder(this.ns.getString("nnaDatabase"), InsetFramePainter.getFramePainter(), 2, (Border)new MarginBorder(5, 10, 5, 10)));
        ewtContainer.setLayout(new BorderLayout(0, 3));
        this.addrPanel = new AddressListPanel();
        this.addrPanel.setAddressList(this.desc.getAddressList(), 2);
        this.condataPanel = new DBPanel();
        this.condataPanel.setDescription(this.desc, 2);
        ewtContainer.add((Component)((Object)this.addrPanel), "Center");
        ewtContainer.add((Component)((Object)this.condataPanel), "South");
        this.gbc.gridy = 0;
        this.gbc.gridx = 0;
        this.gbc.weighty = 1.0;
        this.gbc.weightx = 1.0;
        this.gbc.gridheight = 1;
        this.gbc.gridwidth = 1;
        this.gbc.insets = new Insets(0, 0, 0, 0);
        this.gbc.fill = 2;
        this.gbc.anchor = 11;
        this.descPanel.add((Component)ewtContainer, this.gbc);
        this.usrPanel = new EwtContainer();
        this.usrPanel.setBorder((Border)new GroupBoxBorder(this.ns.getString("nnaAdditional"), InsetFramePainter.getFramePainter(), 2, (Border)new MarginBorder(5, 10, 5, 10)));
        this.usrPanel.setLayout(this.gb);
        ++this.gbc.gridy;
        this.gbc.insets.top = 3;
        this.descPanel.add((Component)this.usrPanel, this.gbc);
        this.l = new LWLabel(new String(this.itemNames[1][0]), 1);
        this.gbc.gridy = 0;
        this.gbc.gridx = 0;
        this.gbc.weighty = 0.0;
        this.gbc.gridheight = 1;
        this.gbc.gridwidth = 1;
        this.gbc.insets = new Insets(2, 2, 2, 2);
        this.gbc.fill = 0;
        this.gbc.weightx = 1.0;
        this.gbc.anchor = 13;
        this.usrPanel.add((Component)this.l, this.gbc);
        this.itemText[1] = new LWTextField(12);
        ++this.gbc.gridx;
        this.gbc.anchor = 17;
        this.usrPanel.add((Component)this.itemText[1], this.gbc);
        this.l = new LWLabel(new String(this.itemNames[2][0]), 1);
        ++this.gbc.gridx;
        this.gbc.anchor = 13;
        this.usrPanel.add((Component)this.l, this.gbc);
        this.itemText[2] = new LWTextField(12);
        ++this.gbc.gridx;
        this.gbc.anchor = 17;
        this.usrPanel.add((Component)this.itemText[2], this.gbc);
        this.moreButton = new LWButton(this.ns.getString("nnaOptional"));
        this.moreButton.setLeftmost(true);
        this.moreButton.setRightmost(true);
        this.moreButton.addActionListener((ActionListener)this);
        ++this.gbc.gridx;
        this.gbc.weightx = 1.0;
        this.gbc.anchor = 13;
        this.gbc.fill = 0;
        this.gbc.insets.top = 0;
        this.gbc.insets.right = 0;
        this.usrPanel.add((Component)this.moreButton, this.gbc);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.setBorder((Border)new MarginBorder(2, 2, 2, 2));
        ((Container)((Object)this)).add((Component)this.cbPanel, "North");
        ((Container)((Object)this)).add((Component)this.descPanel, "Center");
        this.presentf = false;
        this.invalidIndex = 0;
        NamesGeneric.debugTracing("Exitting NamesRegion");
    }

    public void setNLP(NLParamParser nLParamParser) {
        NamesGeneric.debugTracing("Entering NamesRegion:setNLP");
        this.nlpa = nLParamParser;
        NamesGeneric.debugTracing("Exitting NamesRegion:setNLP");
    }

    public void get() {
        NamesGeneric.debugTracing("Entering NamesRegion:get");
        NVNavigator nVNavigator = new NVNavigator();
        this.changed = false;
        NVPair nVPair = this.nlpa.getNLPListElement(new String(this.regionString));
        if (nVPair != null) {
            this.presentf = true;
            this.cb[0].setState(false);
            this.cb[1].setState(true);
            this.moreButton.setEnabled(true);
            nVPair = nVNavigator.findNVPair(nVPair, "Region");
            if (nVPair != null) {
                NamesGeneric.debugTracing("region1" + nVPair.toString());
                int n = 0;
                while (n < this.itemNames.length) {
                    NVPair nVPair2 = nVNavigator.findNVPair(nVPair, this.itemNames[n][2]);
                    if (nVPair2 != null) {
                        NamesGeneric.debugTracing("region2" + nVPair2.toString());
                        if (n < 4) {
                            if (n == 0) {
                                try {
                                    this.desc = new Description(nVPair2);
                                }
                                catch (NetObjectException netObjectException) {
                                    NamesGeneric.debugTracing(netObjectException.toString());
                                    throw new IllegalArgumentException();
                                }
                                this.addrPanel.setAddressList(this.desc.getAddressList(), 2);
                                this.condataPanel.setDescription(this.desc, 2);
                            } else if (n == 3) {
                                this.optValues[0] = nVPair2.getAtom();
                            } else {
                                this.itemText[n].setText(nVPair2.getAtom());
                            }
                        } else {
                            int n2 = n - 4 + 1;
                            this.optValues[n2] = nVPair2.getAtom();
                        }
                    } else {
                        NamesGeneric.debugTracing("NUll");
                    }
                    ++n;
                }
            }
            this.setPanelEditable(true);
        } else {
            this.cb[0].setState(true);
            this.cb[1].setState(false);
            this.setPanelEditable(false);
        }
        NamesGeneric.debugTracing("Exitting NamesRegion:get");
    }

    public void set() {
        NamesGeneric.debugTracing("Entering NamesRegion:set");
        NVPair nVPair = this.nvfactory.createNVPair("(REGION=)");
        if (!this.cb[1].getState()) {
            this.nlpa.removeNLPListElement("names.admin_region");
            return;
        }
        int n = 0;
        while (n < this.itemNames.length) {
            if (n == 0) {
                this.addrPanel.apply();
                this.condataPanel.apply();
                nVPair.addListElement(this.nvfactory.createNVPair(this.desc.toNVString()));
            } else {
                String string;
                if (n < 4) {
                    if (n == 3) {
                        string = "";
                        if (this.optValues[0] != null) {
                            string = this.optValues[0];
                        }
                    } else {
                        string = this.itemText[n].getText();
                    }
                } else {
                    int n2 = n - 4 + 1;
                    string = "";
                    if (this.optValues[n2] != null) {
                        string = this.optValues[n2];
                    }
                }
                String string2 = new String(this.itemNames[n][2]);
                nVPair.addListElement(this.nvfactory.createNVPair("(" + string2 + "=" + string + ")"));
                this.presentf = true;
            }
            ++n;
        }
        if (this.presentf || this.cb[1].getState()) {
            nVPair.addListElement(this.nvfactory.createNVPair(this.versionString));
            try {
                this.nlpa.addNLPListElement(String.valueOf(this.regionString) + "=" + nVPair.toString());
            }
            catch (NLException nLException) {}
        }
        this.changed = false;
        NamesGeneric.debugTracing("Exitting NamesRegion:set");
    }

    public void setFocus() {
        if (this.invalidIndex != 0 && this.invalidIndex < 4) {
            this.itemText[this.invalidIndex].requestFocus();
            this.itemText[this.invalidIndex].selectAll();
        }
    }

    public boolean isDataValid() {
        NamesGeneric.debugTracing("Entering NamesRegion:isDataValid");
        if (!this.cb[1].getState()) {
            return true;
        }
        int n = 0;
        while (n < this.itemNames.length) {
            if (n == 0) {
                if (!this.addrPanel.areDataValid()) {
                    this.invalidIndex = n;
                    return false;
                }
                if (!this.condataPanel.areDataValid()) {
                    this.invalidIndex = n;
                    return false;
                }
            } else if (n < 4) {
                if (n == 1 && !NamesValidate.validateText(this.itemText[n], this.itemNames[n][0])) {
                    this.invalidIndex = n;
                    this.setFocus();
                    return false;
                }
            } else {
                int n2 = n - 4;
                if (this.optValues[n2] == null) {
                    this.invalidIndex = n;
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    public boolean isChanged() {
        NVNavigator nVNavigator = new NVNavigator();
        NamesGeneric.debugTracing("Entering NamesRegion:isChanged");
        if (this.changed) {
            return true;
        }
        NVPair nVPair = this.nlpa.getNLPListElement(new String(this.regionString));
        if (nVPair != null && this.cb[0].getState() || nVPair == null && this.cb[1].getState()) {
            this.changed = true;
            return true;
        }
        if (nVPair != null && (nVPair = nVNavigator.findNVPair(nVPair, "Region")) != null) {
            int n = 0;
            while (n < 3) {
                if (n == 0) {
                    if (this.changed) {
                        return this.changed;
                    }
                    this.changed = this.condataPanel.isChanged();
                    if (this.changed) {
                        return this.changed;
                    }
                } else {
                    NVPair nVPair2 = nVNavigator.findNVPair(nVPair, this.itemNames[n][2]);
                    if (nVPair2 != null) {
                        if (this.itemNames[n][0].compareTo(this.ns.getString("nnaPassword")) == 0 && (nVPair2.getAtom() == null || nVPair2.getAtom().length() == 0)) {
                            if (this.itemText[n].getText() != null && this.itemText[n].getText().length() != 0) {
                                this.changed = true;
                                return this.changed;
                            }
                        } else if (!this.itemText[n].getText().equalsIgnoreCase(nVPair2.getAtom())) {
                            this.changed = true;
                            return this.changed;
                        }
                    } else if (!this.itemText[n].getText().equalsIgnoreCase(this.itemNames[n][1])) {
                        this.changed = true;
                        return this.changed;
                    }
                }
                ++n;
            }
        }
        return this.changed;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        NamesGeneric.debugTracing("Entering NamesRegion:itemStateChanged");
        String string = itemEvent.getItem().toString();
        if (string.compareTo(this.ns.getString("nnaNoRegionDb")) == 0) {
            this.setPanelEditable(false);
        } else if (string.compareTo(this.ns.getString("nnaRegionDb")) == 0) {
            this.setPanelEditable(true);
        }
        NamesGeneric.debugTracing("Exitting NamesRegion:itemStateChanged");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        NamesGeneric.debugTracing("Entering NamesRegion:actionPerformed");
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        String string2 = this.ns.getString("nnaOk");
        String string3 = this.ns.getString("nnaCancel");
        BufferedFrame bufferedFrame = NamesGeneric.appFrame;
        System.getProperty("os.name");
        if (object instanceof LWButton) {
            if (string.compareTo(this.ns.getString("nnaOptional")) == 0) {
                this.advDialog = new NamesAdvRegion(bufferedFrame, this.ns.getString("nnaAdvRegion"), this, this.optValues);
                this.advDialog.dlgShow();
            } else if (string.compareTo(string2) == 0) {
                boolean bl = this.advDialog.checkOptValues();
                if (bl) {
                    this.advDialog.getOptValues(this.optValues);
                    ((Component)((Object)this.advDialog)).setVisible(false);
                    this.advDialog.dispose();
                    bufferedFrame.requestFocus();
                    if (!this.changed) {
                        this.changed = this.advDialog.isDialogChanged(this.nlpa);
                    }
                }
            } else if (string.compareTo(string3) == 0) {
                ((Component)((Object)this.advDialog)).setVisible(false);
                this.advDialog.dispose();
                bufferedFrame.requestFocus();
            }
        }
        NamesGeneric.debugTracing("Exitting NamesRegion:actionPerformed");
    }

    private void setPanelEditable(boolean bl) {
        this.addrPanel.setEnabled(bl);
        this.condataPanel.setEnabled(bl);
        Component[] componentArray = this.usrPanel.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            componentArray[n].setEnabled(bl);
            ++n;
        }
    }
}

