/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.names;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.Border;
import oracle.ewt.border.GroupBoxBorder;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.graphics.frame.InsetFramePainter;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.asst.names.NamesValidate;
import oracle.net.asst.names.TimePanel;
import oracle.net.asst.names.nnccj;
import oracle.net.asst.names.tuning;

public class NamesTuning
extends EwtContainer {
    NetStrings ns = new NetStrings();
    private String[] itemNames = new String[]{this.ns.getString("nnaCacheCheckInterval"), this.ns.getString("nnaStatsResetInterval"), this.ns.getString("nnaStatsLogInterval"), this.ns.getString("nnaAutoRefreshRetry"), this.ns.getString("nnaAutoRefreshExp")};
    private LWTextField[] itemText;
    private MarginBorder sharedBorderPixel;
    private int i;
    private GridBagConstraints gbc;
    private GridBagLayout gb;
    private LWLabel l;
    private EwtContainer labelPanel;
    private EwtContainer controlPanel;
    private EwtContainer mainTimePanel;
    private EwtContainer[] timePanel;
    private LWLabel label;
    private boolean initialized;
    private TimePanel[] tp;
    private tuning m_tune;

    public NamesTuning() {
        NamesGeneric.debugTracing("Entering class:NamesTuning");
        this.m_tune = new tuning();
        this.gb = new GridBagLayout();
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.insets = new Insets(1, 4, 1, 4);
        this.gbc.fill = 2;
        this.gbc.anchor = 11;
        this.sharedBorderPixel = new MarginBorder(2, 4, 2, 4);
        this.setBorder((Border)this.sharedBorderPixel);
        this.controlPanel = new EwtContainer();
        this.controlPanel.setLayout(this.gb);
        this.gbc.weightx = 100.0;
        this.gbc.weighty = 100.0;
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.labelPanel = new EwtContainer();
        this.labelPanel.setLayout(new GridLayout(1, 1));
        this.gb.setConstraints((Component)this.labelPanel, this.gbc);
        this.controlPanel.add((Component)this.labelPanel);
        this.label = new LWLabel(this.ns.getString("nnaTuningLabel1"), 1);
        this.gb.setConstraints((Component)this.label, this.gbc);
        this.labelPanel.add((Component)this.label);
        this.itemText = new LWTextField[this.itemNames.length];
        this.mainTimePanel = new EwtContainer();
        this.mainTimePanel.setLayout(this.gb);
        ++this.gbc.gridy;
        this.gb.setConstraints((Component)this.mainTimePanel, this.gbc);
        this.controlPanel.add((Component)this.mainTimePanel);
        this.timePanel = new EwtContainer[this.itemNames.length];
        this.tp = new TimePanel[this.itemNames.length];
        this.i = 0;
        while (this.i < this.itemNames.length) {
            this.gbc.gridx = 0;
            this.gbc.gridy = 2 * this.i + 1;
            this.timePanel[this.i] = new EwtContainer();
            this.timePanel[this.i].setLayout(new FlowLayout(1));
            this.gb.setConstraints((Component)this.timePanel[this.i], this.gbc);
            this.timePanel[this.i].setBorder((Border)new GroupBoxBorder(this.itemNames[this.i], InsetFramePainter.getFramePainter(), 2));
            this.mainTimePanel.add((Component)this.timePanel[this.i]);
            this.tp[this.i] = new TimePanel(true, true, true);
            this.gb.setConstraints((Component)((Object)this.tp[this.i]), this.gbc);
            this.timePanel[this.i].add((Component)((Object)this.tp[this.i]));
            ++this.i;
        }
        ((Container)((Object)this)).add((Component)this.controlPanel, "North");
        NamesGeneric.debugTracing("Exiting class:NamesTuning");
    }

    public void LoadFirstTime() {
        NamesGeneric.debugTracing("Entering LoadFirstTime:NamesTuning");
        if (this.initialized) {
            return;
        }
        if (!nnccj.serverSet) {
            NetUtils.getApplication().showStatus(this.ns.getString("nnaNameServerUnreachable"));
        } else {
            this.initialized = true;
            this.LoadIntoScreen();
        }
        NamesGeneric.debugTracing("Exiting LoadFirstTime:NamesTuning");
    }

    public String setInterval(int n) throws Exception {
        String[] stringArray = new String[]{String.valueOf(this.tp[n].getTimeInSec())};
        int n2 = -1;
        switch (n) {
            case 0: {
                n2 = this.m_tune.setCacheCkpInterval(stringArray, 1);
                break;
            }
            case 1: {
                n2 = this.m_tune.setResetStatInterval(stringArray, 1);
                break;
            }
            case 2: {
                n2 = this.m_tune.setLogStatsInterval(stringArray, 1);
                break;
            }
            case 3: {
                n2 = this.m_tune.setAutoRefreshRetry(stringArray, 1);
                break;
            }
            case 4: {
                n2 = this.m_tune.setAutoRefreshExpire(stringArray, 1);
                break;
            }
            default: {
                NamesGeneric.debugTracing("Tuning: error");
            }
        }
        if (n2 != 0) {
            throw new Exception(this.m_tune.returnError());
        }
        return this.m_tune.returnResp();
    }

    public String getInterval(int n) throws Exception {
        NamesGeneric.debugTracing("Entering getinterval:NamesTuning");
        int n2 = -1;
        switch (n) {
            case 0: {
                n2 = this.m_tune.getCacheCkpInterval();
                break;
            }
            case 1: {
                n2 = this.m_tune.getResetStatInterval();
                break;
            }
            case 2: {
                n2 = this.m_tune.getLogStatsInterval();
                break;
            }
            case 3: {
                n2 = this.m_tune.getAutoRefreshRetry();
                break;
            }
            case 4: {
                n2 = this.m_tune.getAutoRefreshExpire();
                break;
            }
            default: {
                NamesGeneric.debugTracing("Tuning : Error");
            }
        }
        if (n2 != 0) {
            throw new Exception(this.m_tune.returnError());
        }
        String string = new String(this.m_tune.returnResp());
        return string;
    }

    public void LoadIntoScreen() {
        NamesGeneric.debugTracing("Entering LoadIntoScreen:NamesTuning");
        int n = 0;
        while (n < this.itemNames.length) {
            try {
                this.tp[n].setTime(this.getInterval(n));
            }
            catch (Exception exception) {
                this.clearPanel();
                break;
            }
            ++n;
        }
        NamesGeneric.debugTracing("Exiting LoadIntoScreen:NamesTuning");
    }

    public void StoreFromScreen() {
        NamesGeneric.debugTracing("Entering StoreFromScreen:NamesTuning");
        int n = 0;
        while (n < this.itemNames.length) {
            if (!NamesValidate.validateTimeField(this.tp[n], this.itemNames[n])) {
                return;
            }
            ++n;
        }
        try {
            n = 0;
            while (n < this.itemNames.length) {
                this.setInterval(n);
                ++n;
            }
        }
        catch (Exception exception) {
            this.clearPanel();
            return;
        }
        this.m_tune.saveConfig();
        NamesGeneric.debugTracing("Exiting StoreFromScreen:NamesTuning");
    }

    public void clearPanel() {
        int n = 0;
        while (n < this.itemNames.length) {
            this.tp[n].clearTimeFields();
            ++n;
        }
    }
}

