/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.names;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.names.NamesDialog;
import oracle.net.asst.names.NamesGeneric;

public class TimePanel
extends EwtContainer
implements FocusListener {
    NetStrings ns = new NetStrings();
    private String[] itemNames = new String[]{this.ns.getString("nnaDays"), this.ns.getString("nnaHours"), this.ns.getString("nnaMinutes"), this.ns.getString("nnaSeconds")};
    private LWTextField[] itemText;
    private GridBagLayout gb;
    private GridBagConstraints gbc;
    private int startIndex;
    private int totalItems;

    public TimePanel(boolean bl, boolean bl2, boolean bl3) {
        NamesGeneric.debugTracing("Entering class:TimePanel");
        this.gb = new GridBagLayout();
        ((Container)((Object)this)).setLayout(this.gb);
        this.gbc = new GridBagConstraints();
        this.gbc.gridwidth = 1;
        this.gbc.anchor = 10;
        this.gbc.fill = 0;
        this.startIndex = bl2 ? 0 : 1;
        this.totalItems = bl3 ? this.itemNames.length - this.startIndex : this.itemNames.length - this.startIndex - 1;
        this.itemText = new LWTextField[this.totalItems];
        int n = 0;
        while (n < this.totalItems) {
            int n2 = n + this.startIndex;
            this.itemText[n] = this.itemNames[n2].compareTo(this.ns.getString("nnaDays")) == 0 ? new LWTextField(3) : new LWTextField(2);
            this.itemText[n].addFocusListener(this);
            this.gbc.weightx = 1.0;
            ++this.gbc.gridx;
            if (!bl) {
                if (n == 0) {
                    this.gbc.insets.right = 4;
                    this.gbc.insets.left = 0;
                } else if (n == this.totalItems - 1) {
                    this.gbc.insets.right = 0;
                    this.gbc.insets.left = 4;
                } else {
                    this.gbc.insets.right = 4;
                    this.gbc.insets.left = 4;
                }
            }
            this.gbc.insets.right = 1;
            this.gbc.insets.left = 2;
            this.gb.setConstraints((Component)this.itemText[n], this.gbc);
            ((Container)((Object)this)).add((Component)this.itemText[n]);
            if (bl) {
                LWLabel lWLabel = new LWLabel(this.itemNames[n2], 1);
                this.gbc.weightx = 0.25;
                ++this.gbc.gridx;
                this.gbc.insets.right = 0;
                this.gbc.insets.left = 0;
                this.gb.setConstraints((Component)lWLabel, this.gbc);
                ((Container)((Object)this)).add((Component)lWLabel);
            }
            ++n;
        }
        NamesGeneric.debugTracing("Exiting class:TimePanel");
    }

    public void focusLost(FocusEvent focusEvent) {
        NamesGeneric.debugTracing("Entering focuLost:TimePanel");
        if (focusEvent.isTemporary()) {
            return;
        }
        int n = 0;
        while (n < this.totalItems) {
            if (focusEvent.getComponent() == this.itemText[n]) {
                int n2 = 0;
                String string = this.itemText[n].getText();
                if (string.compareTo("") != 0) {
                    try {
                        n2 = Integer.parseInt(string);
                        return;
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.itemText[n].requestFocus();
                        this.itemText[n].selectAll();
                        return;
                    }
                }
                this.itemText[n].setText("0");
                return;
            }
            ++n;
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void setTime(int n) {
        int[] nArray = new int[4];
        NamesGeneric.debugTracing("Entering setTime:TimePanel");
        int n2 = n;
        nArray[3] = n2 % 60;
        nArray[2] = (n2 /= 60) % 60;
        nArray[1] = (n2 /= 60) % 24;
        nArray[0] = n2 / 24;
        int n3 = 0;
        while (n3 < this.totalItems) {
            this.itemText[n3].setText(String.valueOf(nArray[n3 + this.startIndex]));
            ++n3;
        }
        NamesGeneric.debugTracing("Exiting setTime:TimePanel");
    }

    public void setTime(String string) {
        int[] nArray = new int[4];
        NamesGeneric.debugTracing("Entering setTime:TimePanel");
        try {
            int n = string.indexOf("day");
            if (n != -1) {
                nArray[0] = Integer.parseInt(string.substring(0, n - 1));
                string = nArray[0] > 1 ? string.substring(n + 5) : string.substring(n + 4);
            } else {
                nArray[0] = 0;
            }
            n = string.indexOf("hour");
            if (n != -1) {
                nArray[1] = Integer.parseInt(string.substring(0, n - 1));
                string = nArray[1] > 1 ? string.substring(n + 6) : string.substring(n + 5);
            } else {
                nArray[1] = 0;
            }
            n = string.indexOf("minute");
            if (n != -1) {
                nArray[2] = Integer.parseInt(string.substring(0, n - 1));
                string = nArray[2] > 1 ? string.substring(n + 8) : string.substring(n + 7);
            } else {
                nArray[2] = 0;
            }
            n = string.indexOf("second");
            nArray[3] = n != -1 ? Integer.parseInt(string.substring(0, n - 1)) : 0;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        int n = 0;
        while (n < this.totalItems) {
            this.itemText[n].setText(String.valueOf(nArray[n + this.startIndex]));
            ++n;
        }
        NamesGeneric.debugTracing("Exiting setTime:TimePanel");
    }

    public int getTimeInSec() {
        int n = 0;
        int n2 = 0;
        String string = this.ns.getString("nnaTimeInvalid");
        NamesGeneric.debugTracing("Entering getTimeInSec:TimePanel");
        try {
            String string2;
            if (this.startIndex == 0) {
                string2 = this.itemText[n2++].getText();
                n += Integer.parseInt(string2) * 24;
            }
            while (n2 < this.totalItems) {
                string2 = this.itemText[n2].getText();
                if (string2.compareTo("") != 0) {
                    n += Integer.parseInt(string2);
                } else {
                    this.itemText[n2].setText("0");
                }
                if (n2 < this.itemNames.length - 1) {
                    n *= 60;
                }
                ++n2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = this.ns.getString("nnaError");
            NamesDialog.popUp(string3, string, 2);
            this.itemText[n2].requestFocus();
            return -1;
        }
        NamesGeneric.debugTracing("Exiting getTimeInSec:TimePanel");
        return n;
    }

    public void setTimeEditable(boolean bl) {
        NamesGeneric.debugTracing("Entering setTimeEditable:TimePanel");
        int n = 0;
        while (n < this.totalItems) {
            this.itemText[n].setEditable(bl);
            ++n;
        }
        NamesGeneric.debugTracing("Exiting setTimeEditable:TimePanel");
    }

    public void clearTimeFields() {
        NamesGeneric.debugTracing("Entering clearTimeFields:TimePanel");
        int n = 0;
        while (n < this.totalItems) {
            this.itemText[n].setText("");
            ++n;
        }
        NamesGeneric.debugTracing("Exiting clearTimeFields:TimePanel");
    }
}

