/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.nameswizard;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import oracle.ewt.EwtContainer;
import oracle.ewt.alert.Alert;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.TextWrapper;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.names.NamesDialog;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.asst.names.control;
import oracle.net.asst.nameswizard.BasicWizardPanel;
import oracle.net.asst.nameswizard.NamesWizardInterface;
import oracle.net.asst.profile.NetAddr;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public class WKNSAddress
extends BasicWizardPanel
implements NamesWizardInterface {
    private EwtContainer contentPanel;
    private NetAddr addrPanel;
    private GridBagLayout gb;
    private GridBagConstraints gbc;
    private MultiLineLabel multiLabel;
    private TextWrapper Textwrap = WordWrapper.getTextWrapper();
    private NetStrings ns = new NetStrings();
    private NVFactory nvf = new NVFactory();
    private NVPair address;
    private boolean goAhead = true;
    public boolean discoveredNS = false;

    public WKNSAddress() {
        NamesGeneric.debugTracing("Entering init:WKNSAddress");
        this.gb = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.insets.left = 10;
        this.gbc.fill = 2;
        this.gbc.anchor = 11;
        this.contentPanel = new EwtContainer();
        this.contentPanel.setLayout(this.gb);
        this.gb.setConstraints((Component)this.contentPanel, this.gbc);
        try {
            this.multiLabel = new MultiLineLabel(this.Textwrap, this.ns.getString("nnaWKNSAddressMsg1"));
            this.multiLabel.setAlignment(1);
            this.multiLabel.setWrapWidth(350);
        }
        catch (NullPointerException nullPointerException) {}
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.weighty = 0.5;
        this.gbc.weightx = 1.0;
        this.gbc.gridwidth = 2;
        this.gb.setConstraints((Component)this.multiLabel, this.gbc);
        this.contentPanel.add((Component)this.multiLabel);
        try {
            this.multiLabel = new MultiLineLabel(this.Textwrap, this.ns.getString("nnaWKNSAddressMsg2"));
            this.multiLabel.setAlignment(1);
            this.multiLabel.setWrapWidth(350);
        }
        catch (NullPointerException nullPointerException) {}
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.weighty = 1.0;
        this.gbc.weightx = 1.0;
        this.gbc.gridwidth = 2;
        this.gb.setConstraints((Component)this.multiLabel, this.gbc);
        this.contentPanel.add((Component)this.multiLabel);
        this.address = this.nvf.createNVPair("(Address=(protocol=tcp))");
        this.addrPanel = new NetAddr(this.address);
        this.addrPanel.setAppEnv(NetUtils.getApplication());
        ++this.gbc.gridy;
        this.gbc.weighty = 0.05;
        this.gbc.gridwidth = 1;
        this.gb.setConstraints((Component)((Object)this.addrPanel), this.gbc);
        this.contentPanel.add((Component)((Object)this.addrPanel));
        this.setImage("images/NamesWiz.gif");
        this.setInteractiveArea((Component)this.contentPanel);
        NamesGeneric.debugTracing("Exiting init:WKNSAddress");
    }

    public String getPageData() {
        return this.address.toString();
    }

    public boolean isPageValid() {
        if (!this.addrPanel.areDataValid()) {
            return false;
        }
        this.address = this.addrPanel.getAddr();
        if (this.address == null) {
            String string = this.ns.getString("nnaError");
            String string2 = this.ns.getString("nnaAddressNull");
            NamesDialog.popUp(string, string2, 2);
            return false;
        }
        if (!this.discoveredNS) {
            Cursor cursor = Cursor.getDefaultCursor();
            ((Component)((Object)this)).setCursor(new Cursor(3));
            control control2 = new control();
            String[] stringArray = new String[]{this.address.toString()};
            control2.reorderNS(stringArray, 1, (short)3);
            File file = new File(String.valueOf(NamesGeneric.getOraNames()) + ".sdns.ora");
            if (file.exists()) {
                this.discoveredNS = true;
            } else {
                file = new File(String.valueOf(NamesGeneric.getOraNames()) + "sdns.ora");
                this.discoveredNS = file.exists();
            }
            if (!this.discoveredNS) {
                Alert alert = new Alert((Frame)NamesGeneric.appFrame, this.ns.getString("nnaDiscoveryFailed"), 1, 5);
                alert.setCenterOver((Component)NamesGeneric.appFrame);
                alert.setDefaultButton(1);
                alert.setTitle(this.ns.getString("nnaMessage"));
                this.goAhead = alert.runAlert() == 1;
                alert.dispose();
            } else {
                String string = this.ns.getString("nnaMessage");
                String string3 = this.ns.getString("nnaDiscoveredNS");
                NamesDialog.popUp(string, string3, 2);
            }
            ((Component)((Object)this)).setCursor(cursor);
        }
        if (this.discoveredNS) {
            return true;
        }
        return this.goAhead;
    }
}

