/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.profile;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.UIManager;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.painter.Painter;
import oracle.net.asst.container.NetHelp;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.profile.NetButton;
import oracle.net.asst.profile.NetButtonListener;
import oracle.net.asst.profile.NetLayout;
import oracle.net.asst.profile.ProfileCache;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVPair;

public class NativeName
extends NetLayout
implements ProfileCache,
NetButtonListener,
KeyListener {
    private static final String[] NATIVE_NAMING_GROUP_LABELS = new String[]{"PFCexternalBorderLabel1", "PFCexternalBorderLabel2", "PFCexternalBorderLabel3"};
    private static final String[] NATIVE_NAMING_ADAPTERS_LABELS = new String[]{"PFCdcePrefix", "PFCndsNameContext", "PFCnisMetaMap"};
    private static final String[] NATIVE_NAMING_ADAPTERS = new String[]{"names.dce.prefix", "names.nds.name_context", "names.nis.meta_map"};
    private static final String[] NATIVE_NAMING_DEFAULTS = new String[]{"/../subsys/oracle/names", "", ""};
    private static final String[] NET_NAT_NM_BUTTONS = new String[]{"PFChelp"};
    private final NetStrings netStrings = new NetStrings();
    private final String NET_NATIVE_NAME_HELP_TOPIC = "TOPICprofNamingNative";
    private EwtContainer[] panel;
    private LWTextField[] textField;
    private NLParamParser nlpa;
    private String[] netNatNmButton;
    private int invalidField;

    public NativeName() {
        this.setBorderPainter((BorderPainter)new FixedBorderPainter(25, 25, 25, 25));
        this.netNatNmButton = new String[NET_NAT_NM_BUTTONS.length];
        int n = 0;
        while (n < NET_NAT_NM_BUTTONS.length) {
            this.netNatNmButton[n] = this.netStrings.getString(NET_NAT_NM_BUTTONS[n]);
            ++n;
        }
        this.panel = new EwtContainer[NATIVE_NAMING_ADAPTERS.length];
        this.textField = new LWTextField[NATIVE_NAMING_ADAPTERS.length];
        n = 0;
        while (n < NATIVE_NAMING_ADAPTERS.length) {
            this.panel[n] = new EwtContainer();
            this.panel[n].setLayout(new GridBagLayout());
            this.panel[n].setBorderPainter(UIManager.createGroupBoxPainter((Painter)new FixedBorderPainter(10, 0, 5, 0), (String)this.netStrings.getString(NATIVE_NAMING_GROUP_LABELS[n])));
            this.constrain((Container)this.panel[n], (Component)new LWLabel(this.netStrings.getString(NATIVE_NAMING_ADAPTERS_LABELS[n])), 0, 1, 1, 1, 2, 17, 0.0, 0.0, 0, 10, 5, 10);
            this.textField[n] = new LWTextField(NATIVE_NAMING_DEFAULTS[n], 30 - NATIVE_NAMING_ADAPTERS[n].length());
            this.textField[n].addKeyListener(this);
            this.constrain((Container)this.panel[n], (Component)this.textField[n], 1, 1, 1, 1, 2, 13, 1.0, 0.0, 0, 10, 5, 10);
            this.constrain((Container)((Object)this), (Component)this.panel[n], 0, n, 1, 1, 2, 18, 0.0, 0.0, 0, 0, 15, 0);
            ++n;
        }
        this.constrain((Container)((Object)this), (Component)new LWLabel(""), 0, n, 1, 1, 3, 10, 1.0, 1.0, 0, 0, 0, 0);
    }

    public NativeName(NLParamParser nLParamParser) {
        this();
        this.setNLP(nLParamParser);
    }

    public void setNLP(NLParamParser nLParamParser) {
        this.devTrc("NativeName: setNLP():");
        this.nlpa = nLParamParser;
    }

    public void cacheIt() {
        this.devTrc("NativeName: cacheIt():");
        int n = 0;
        while (n < NATIVE_NAMING_ADAPTERS.length) {
            String string = this.textField[n].getText();
            if (string.compareTo(NATIVE_NAMING_DEFAULTS[n]) != 0) {
                try {
                    this.nlpa.addNLPListElement(String.valueOf(NATIVE_NAMING_ADAPTERS[n]) + "=" + string);
                }
                catch (NLException nLException) {}
            } else {
                this.nlpa.removeNLPListElement(NATIVE_NAMING_ADAPTERS[n]);
            }
            ++n;
        }
    }

    public void refresh() {
        this.devTrc("NativeName: refresh():");
        int n = 0;
        while (n < NATIVE_NAMING_ADAPTERS.length) {
            String string;
            NVPair nVPair = this.nlpa.getNLPListElement(NATIVE_NAMING_ADAPTERS[n]);
            if (nVPair != null && (string = nVPair.getAtom()) != null) {
                this.textField[n].setText(string);
            } else {
                this.textField[n].setText(NATIVE_NAMING_DEFAULTS[n]);
            }
            ++n;
        }
    }

    public boolean hasChanged() {
        boolean bl = false;
        this.devTrc("NativeName: refresh():");
        int n = 0;
        while (n < NATIVE_NAMING_ADAPTERS.length) {
            NVPair nVPair = this.nlpa.getNLPListElement(NATIVE_NAMING_ADAPTERS[n]);
            if (nVPair != null) {
                if (!this.textField[n].getText().equalsIgnoreCase(nVPair.getAtom())) {
                    bl = true;
                    break;
                }
            } else if (!this.textField[n].getText().equalsIgnoreCase(NATIVE_NAMING_DEFAULTS[n])) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    public boolean areDataValid() {
        this.devTrc("NativeName: areDataValid():");
        return true;
    }

    public void setFocus() {
    }

    public NetButton createNetButton() {
        this.devTrc("NativeName: createNetButton()");
        NetButton netButton = new NetButton(this.netNatNmButton);
        netButton.addNetButtonListener(this);
        return netButton;
    }

    public void buttonPushed(String string) {
        this.devTrc("NativeName: buttonPushed()");
        if (string.equalsIgnoreCase(this.netNatNmButton[0])) {
            this.devTrc("NetLog: buttonPushed(): do help.");
            NetHelp netHelp = NetUtils.getHelpContext();
            netHelp.showTopic("TOPICprofNamingNative");
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        LWTextField lWTextField = (LWTextField)keyEvent.getComponent();
        lWTextField.getText();
        char c = keyEvent.getKeyChar();
        if (c == '\b') {
            return;
        }
        if (!Character.isLetterOrDigit(c) && c != '-' && c != '_' && c != '.' && c != '/' && c != ':' && c != '\\') {
            keyEvent.setKeyChar('\u0000');
        }
    }
}

