/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.profile;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import oracle.ewt.EwtContainer;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.profile.NetIPCAddr;
import oracle.net.asst.profile.NetLayout;
import oracle.net.asst.profile.NetNMPAddr;
import oracle.net.asst.profile.NetProtocolAddr;
import oracle.net.asst.profile.NetSPXAddr;
import oracle.net.asst.profile.NetTCPAddr;
import oracle.net.asst.profile.NetTCPSAddr;
import oracle.net.common.NetProperties;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;
import oracle.sysman.emSDK.client.appContainer.WebApplication;

public class NetAddr
extends NetLayout
implements ItemListener {
    private static final String PROTOCOL_LABEL = "PFCaddrProtocolLabel";
    private static final NetStrings ns = new NetStrings();
    private static NetProperties netprop;
    private LWChoice protoChoice;
    private EwtContainer protoDisplay;
    private CardLayout protoCardLayout;
    private NetProtocolAddr[] protocolPanels;
    private boolean[] enabledProtocols;
    private int currentProto;
    private boolean editable = true;
    private boolean changed;
    private static final String[] SUPPORTED_PROTOCOL;
    private static final String[] PROTOCOL_NAMES;

    public NetAddr() {
        int n;
        this.setBorderPainter((BorderPainter)new FixedBorderPainter(8, 8, 8, 8));
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        ((Container)((Object)this)).add((Component)new LWLabel(ns.getString(PROTOCOL_LABEL)), gridBagConstraints);
        this.protoChoice = new LWChoice();
        this.protoChoice.addItemListener((ItemListener)this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        ((Container)((Object)this)).add((Component)this.protoChoice, gridBagConstraints);
        this.protoDisplay = new EwtContainer();
        this.protoCardLayout = new CardLayout();
        this.protoDisplay.setLayout(this.protoCardLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.left = 0;
        ((Container)((Object)this)).add((Component)this.protoDisplay, gridBagConstraints);
        if (netprop == null) {
            try {
                netprop = NetProperties.getInstance();
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(fileNotFoundException);
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                System.err.println(iOException);
                iOException.printStackTrace();
            }
        }
        this.protocolPanels = new NetProtocolAddr[SUPPORTED_PROTOCOL.length];
        this.enabledProtocols = new boolean[SUPPORTED_PROTOCOL.length];
        int n2 = 0;
        while (n2 < this.enabledProtocols.length) {
            this.enabledProtocols[n2] = false;
            ++n2;
        }
        boolean bl = false;
        if (netprop != null) {
            n = 0;
            while (n < SUPPORTED_PROTOCOL.length) {
                String string = netprop.getProperty(SUPPORTED_PROTOCOL[n]);
                if (string != null && string.equalsIgnoreCase("yes")) {
                    bl = true;
                    this.enableProtocol(n);
                }
                ++n;
            }
        }
        if (!bl) {
            this.enableProtocol(0);
        }
        n = 0;
        while (n < SUPPORTED_PROTOCOL.length) {
            if (this.enabledProtocols[n]) {
                this.currentProto = n;
                break;
            }
            ++n;
        }
        this.displayAddrPanel(SUPPORTED_PROTOCOL[this.currentProto]);
    }

    public NetAddr(NVPair nVPair) {
        this();
        if (nVPair != null) {
            this.display(nVPair);
        }
    }

    public void display(NVPair nVPair) {
        int n;
        if (nVPair == null) {
            return;
        }
        try {
            n = this.chooseAddr(nVPair);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException);
            return;
        }
        if (!this.enabledProtocols[n]) {
            this.enableProtocol(n);
        }
        this.currentProto = n;
        int n2 = 0;
        while (n2 < this.protocolPanels.length) {
            if (this.enabledProtocols[n2] && this.protocolPanels[n2].getProtocol() == SUPPORTED_PROTOCOL[this.currentProto]) {
                this.protocolPanels[n2].setAddr(nVPair);
            }
            ++n2;
        }
        this.displayAddrPanel(SUPPORTED_PROTOCOL[this.currentProto]);
    }

    private void displayAddrPanel(String string) {
        int n = 0;
        while (n < SUPPORTED_PROTOCOL.length) {
            if (string == SUPPORTED_PROTOCOL[n] && this.enabledProtocols[n]) {
                this.protoCardLayout.show((Container)this.protoDisplay, string);
                this.protoChoice.select(string);
            }
            ++n;
        }
    }

    public NVPair getAddr() {
        return this.protocolPanels[this.currentProto].getAddr();
    }

    public String getProtocol() {
        return this.protocolPanels[this.currentProto].getProtocol().toUpperCase();
    }

    public boolean areDataValid() {
        return this.protocolPanels[this.currentProto].areDataValid();
    }

    public void setFocus() {
        this.protocolPanels[this.currentProto].setFocus();
    }

    public void setAppEnv(WebApplication webApplication) {
        int n = 0;
        while (n < this.protocolPanels.length) {
            if (this.protocolPanels[n] != null) {
                this.protocolPanels[n].setAppEnv(webApplication);
            }
            ++n;
        }
    }

    public synchronized void setEditable(boolean bl) {
        this.editable = bl;
        this.protoChoice.setEnabled(bl);
        int n = 0;
        while (n < this.protocolPanels.length) {
            if (this.enabledProtocols[n]) {
                this.protocolPanels[n].setEditable(bl);
            }
            ++n;
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void discard() {
        int n = 0;
        while (n < this.protocolPanels.length) {
            if (this.enabledProtocols[n]) {
                this.protocolPanels[n].discard();
            }
            ++n;
        }
    }

    public boolean hasChanged() {
        int n = 0;
        while (n < this.protocolPanels.length) {
            if (this.enabledProtocols[n] && this.protocolPanels[n].hasChanged()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean sameEndpoint(NetAddr netAddr) {
        return this.protocolPanels[this.currentProto].sameEndpoint(netAddr.protocolPanels[netAddr.currentProto]);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() instanceof LWChoice) {
            if (this.editable) {
                String string = itemEvent.getItem().toString();
                int n = 0;
                while (n < PROTOCOL_NAMES.length) {
                    if (string == PROTOCOL_NAMES[n]) break;
                    ++n;
                }
                this.displayAddrPanel(SUPPORTED_PROTOCOL[n]);
                this.currentProto = n;
                return;
            }
            this.protoChoice.select(this.currentProto);
        }
    }

    private NetProtocolAddr createAddr(String string) {
        if (string.equalsIgnoreCase("tcp")) {
            return new NetTCPAddr();
        }
        if (string.equalsIgnoreCase("tcps")) {
            return new NetTCPSAddr();
        }
        if (string.equalsIgnoreCase("spx")) {
            return new NetSPXAddr();
        }
        if (string.equalsIgnoreCase("ipc")) {
            return new NetIPCAddr();
        }
        if (string.equalsIgnoreCase("nmp")) {
            return new NetNMPAddr();
        }
        throw new IllegalStateException("Unable to create protocol address panel of specified type. TYPE: " + string);
    }

    private int chooseAddr(String string) throws IllegalArgumentException {
        int n = 0;
        while (n < SUPPORTED_PROTOCOL.length) {
            if (string.equalsIgnoreCase(SUPPORTED_PROTOCOL[n])) {
                return n;
            }
            ++n;
        }
        throw new IllegalArgumentException("Protocol: " + string + " is invalid.");
    }

    private int chooseAddr(NVPair nVPair) throws IllegalArgumentException {
        NVNavigator nVNavigator = new NVNavigator();
        NVPair nVPair2 = nVNavigator.findNVPair(nVPair, "protocol");
        String string = nVPair2.getAtom();
        return this.chooseAddr(string);
    }

    private void enableProtocol(int n) {
        this.protoChoice.addItem(PROTOCOL_NAMES[n]);
        this.enabledProtocols[n] = true;
        this.protocolPanels[n] = this.createAddr(SUPPORTED_PROTOCOL[n]);
        this.protoDisplay.add(SUPPORTED_PROTOCOL[n], (Component)((Object)this.protocolPanels[n]));
    }

    static {
        SUPPORTED_PROTOCOL = new String[]{"TCP", "TCPS", "SPX", "IPC", "NMP"};
        PROTOCOL_NAMES = new String[]{ns.getString("PFCprotNameTCP"), ns.getString("PFCprotNameTCPS"), ns.getString("PFCprotNameSPX"), ns.getString("PFCprotNameIPC"), ns.getString("PFCprotNameNMP")};
    }
}

