/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.profile;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.LWList;
import oracle.net.asst.container.NetHelp;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.profile.NetButton;
import oracle.net.asst.profile.NetButtonListener;
import oracle.net.asst.profile.NetLayout;
import oracle.net.asst.profile.ProfileCache;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVPair;

public class NetNmService
extends NetLayout
implements ProfileCache,
ActionListener,
NetButtonListener {
    private static final String NM_DIR_PATH_PARAM = "names.directory_path";
    private static final String[] selectDefault = new String[]{"TNSNAMES", "ONAMES", "HOSTNAME"};
    private static final String[] availDefault = new String[]{"LDAP", "CDS", "NOVELL", "NIS"};
    private static final String[] buttonName = new String[]{"PFCaddButtonLabel", "PFCremoveButtonLabel", "PFCpromoteButtonLabel", "PFCdemoteButtonLabel"};
    private final NetStrings netStrings = new NetStrings();
    private final String NET_NM_SERVICE_HELP_TOPIC = "TOPICprofNamingMethods";
    private final String helpNetButton = this.netStrings.getString("PFChelp");
    private EwtContainer lpanel = new EwtContainer();
    private EwtContainer cpanel;
    private EwtContainer rpanel;
    private LWList selectList;
    private LWList availList;
    private LWButton[] button;
    private NLParamParser nlpa;
    private boolean changed;

    public NetNmService() {
        this.lpanel.setLayout(new GridBagLayout());
        this.availList = new LWList(10, false);
        this.constrain((Container)this.lpanel, (Component)new LWLabel(this.netStrings.getString("PFCavailableLabel")), 0, 0, 1, 1, 2, 10, 10.0, 0.0, 5, 5, 0, 5);
        this.constrain((Container)this.lpanel, (Component)this.availList, 0, 1, 1, 1, 2, 18, 10.0, 0.0, 5, 5, 0, 5);
        this.cpanel = new EwtContainer();
        this.cpanel.setLayout(new GridBagLayout());
        this.button = new LWButton[buttonName.length];
        int n = 0;
        while (n < buttonName.length) {
            this.button[n] = new LWButton(this.netStrings.getString(buttonName[n]));
            this.constrain((Container)this.cpanel, (Component)this.button[n], 0, n, 1, 1, 10, 5, 0, 5, 2);
            this.button[n].addActionListener((ActionListener)this);
            ++n;
        }
        this.rpanel = new EwtContainer();
        this.rpanel.setLayout(new GridBagLayout());
        this.selectList = new LWList(10, false);
        this.constrain((Container)this.rpanel, (Component)new LWLabel(this.netStrings.getString("PFCselectedLabel")), 0, 0, 1, 1, 2, 10, 10.0, 0.0, 5, 5, 0, 5);
        this.constrain((Container)this.rpanel, (Component)this.selectList, 0, 1, 1, 1, 2, 18, 10.0, 0.0, 5, 5, 0, 5);
        this.constrain((Container)((Object)this), (Component)this.lpanel, 0, 0, 1, 1, 2, 13, 0.0, 0.0, 0, 0, 0, 0);
        this.constrain((Container)((Object)this), (Component)this.cpanel, 1, 0, 1, 1, 0, 10, 0.0, 0.0, 0, 0, 0, 0);
        this.constrain((Container)((Object)this), (Component)this.rpanel, 2, 0, 1, 1, 2, 17, 0.0, 0.0, 0, 0, 0, 0);
    }

    public NetNmService(NLParamParser nLParamParser) {
        this();
        this.setNLP(nLParamParser);
    }

    public void setNLP(NLParamParser nLParamParser) {
        this.devTrc("NetNmService: setNLP():");
        this.nlpa = nLParamParser;
    }

    public void cacheIt() {
        this.devTrc("NetNmService: cacheIt():");
        NVPair nVPair = this.nlpa.getNLPListElement(NM_DIR_PATH_PARAM);
        int n = this.selectList.getItemCount();
        if (nVPair != null) {
            if (n == 0) {
                this.nlpa.removeNLPListElement(NM_DIR_PATH_PARAM);
                return;
            }
            this.cacheSelectList();
            return;
        }
        if (n == selectDefault.length) {
            boolean bl = true;
            int n2 = 0;
            while (n2 < n) {
                if (!this.selectList.getItem(n2).equalsIgnoreCase(selectDefault[n2])) {
                    bl = false;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                this.cacheSelectList();
                return;
            }
        } else if (n > 0) {
            this.cacheSelectList();
        }
    }

    public void refresh() {
        this.devTrc("NetNmService: refresh()");
        this.changed = false;
        this.availList.removeAll();
        this.selectList.removeAll();
        NVPair nVPair = null;
        if (this.nlpa != null) {
            nVPair = this.nlpa.getNLPListElement(NM_DIR_PATH_PARAM);
        }
        int n = 0;
        while (n < selectDefault.length) {
            this.availList.addItem(selectDefault[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < availDefault.length) {
            this.availList.addItem(availDefault[n2]);
            ++n2;
        }
        if (nVPair != null) {
            int n3 = 0;
            while (n3 < nVPair.getListSize()) {
                NVPair nVPair2 = nVPair.getListElement(n3);
                String string = nVPair2.getAtom().toUpperCase();
                if (string.equals("NDS")) {
                    string = "NOVELL";
                }
                if (this.isValidMethod(string)) {
                    this.availList.remove(string);
                    this.selectList.addItem(string);
                } else {
                    this.changed = true;
                    this.devTrc("Invalid method: " + string + " in sqlnet.ora->" + NM_DIR_PATH_PARAM);
                }
                ++n3;
            }
        }
        if (this.selectList.getItemCount() == 0) {
            int n4 = 0;
            while (n4 < selectDefault.length) {
                this.availList.remove(selectDefault[n4]);
                this.selectList.addItem(selectDefault[n4]);
                ++n4;
            }
        }
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public boolean areDataValid() {
        return true;
    }

    public void setFocus() {
    }

    public NetButton createNetButton() {
        this.devTrc("NetNmService: createNetButton()");
        NetButton netButton = new NetButton(new String[]{this.helpNetButton});
        netButton.addNetButtonListener(this);
        return netButton;
    }

    public void buttonPushed(String string) {
        this.devTrc("NetNmService: buttonPushed()");
        if (string.equalsIgnoreCase(this.helpNetButton)) {
            this.devTrc("NetNmService: buttonPushed(): do help.");
            NetHelp netHelp = NetUtils.getHelpContext();
            netHelp.showTopic("TOPICprofNamingMethods");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        NetStrings netStrings = new NetStrings();
        if (object instanceof LWButton) {
            this.changed = true;
            int n = 0;
            while (n < buttonName.length) {
                if (actionEvent.getActionCommand().compareTo(netStrings.getString(buttonName[n])) == 0) break;
                ++n;
            }
            switch (n) {
                case 0: {
                    int n2 = this.availList.getSelectedIndex();
                    if (n2 < 0) break;
                    String string = this.availList.getSelectedItem();
                    this.availList.remove(n2);
                    this.selectList.addItem(string);
                    return;
                }
                case 1: {
                    int n3 = this.selectList.getSelectedIndex();
                    if (n3 < 0) break;
                    String string = this.selectList.getSelectedItem();
                    this.selectList.remove(n3);
                    this.availList.addItem(string);
                    return;
                }
                case 3: {
                    int n4 = this.selectList.getSelectedIndex();
                    if (n4 < 0 || n4 >= this.selectList.getItemCount() - 1) break;
                    String string = this.selectList.getSelectedItem();
                    String string2 = this.selectList.getItem(n4 + 1);
                    this.selectList.replaceItem(string2, n4);
                    this.selectList.replaceItem(string, n4 + 1);
                    this.selectList.deselect(n4);
                    this.selectList.select(n4 + 1);
                    return;
                }
                case 2: {
                    int n5 = this.selectList.getSelectedIndex();
                    if (n5 <= 0) break;
                    String string = this.selectList.getSelectedItem();
                    String string3 = this.selectList.getItem(n5 - 1);
                    this.selectList.replaceItem(string3, n5);
                    this.selectList.replaceItem(string, n5 - 1);
                    this.selectList.deselect(n5);
                    this.selectList.select(n5 - 1);
                    return;
                }
            }
        }
    }

    private boolean isValidMethod(String string) {
        string = string.toUpperCase();
        int n = 0;
        while (n < availDefault.length) {
            if (string.equals(availDefault[n])) {
                return true;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < selectDefault.length) {
            if (string.equals(selectDefault[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void cacheSelectList() {
        int n;
        boolean bl = false;
        this.devTrc("NetNmService: cacheSelectList():");
        int n2 = this.selectList.getItemCount();
        if (n2 != selectDefault.length) {
            bl = true;
        }
        if (!bl) {
            n = 0;
            while (n < n2) {
                if (this.selectList.getItem(n).compareTo(selectDefault[n]) != 0) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        this.devTrc("NetNmService: cacheSelectList():" + bl);
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer("=(");
            n = 0;
            while (n < n2) {
                String string = this.selectList.getItem(n);
                this.devTrc(string);
                if (string.equals("NOVELL")) {
                    string = "NDS";
                }
                stringBuffer.append(string);
                if (++n >= n2) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(")");
            this.devTrc("NetNmService: cacheSelectList(): " + stringBuffer);
            try {
                this.nlpa.addNLPListElement(NM_DIR_PATH_PARAM + stringBuffer);
                this.changed = false;
                return;
            }
            catch (NLException nLException) {
                this.devTrc("    exception");
                return;
            }
        }
        this.nlpa.removeNLPListElement(NM_DIR_PATH_PARAM);
    }
}

