/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.profile;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import oracle.ewt.event.Cancelable;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.tabPanel.TabPanel;
import oracle.ewt.tabPanel.TabPanelEvent;
import oracle.ewt.tabPanel.TabPanelListener;
import oracle.ewt.tabPanel.TabPanelPage;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.net.asst.container.NetHelp;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.profile.NetAddr;
import oracle.net.asst.profile.NetButton;
import oracle.net.asst.profile.NetButtonListener;
import oracle.net.asst.profile.NetLayout;
import oracle.net.asst.profile.ProfileCache;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public class NetONmServer
extends NetLayout
implements ProfileCache,
NetButtonListener,
TabPanelListener {
    private static final String[] NET_ADDR_BUTTONS = new String[]{"PFCnew", "PFCdelete", "PFChelp"};
    private static final String NAMES_PARAM = "names.preferred_servers";
    private static final String _desc_list = "DESCRIPTION_LIST";
    private static final String _desc = "DESCRIPTION";
    private static final String _addr_list = "ADDRESS_LIST";
    private static final String _addr = "ADDRESS";
    private static final String PANEL_LABEL_PREFIX = "PFCpreferServer";
    private static final String paramFormat = "(ADDRESS_LIST=)";
    private static final String defaultAddr = "(Address=(protocol=tcp))";
    private String[] buttonLabels;
    private String panelNamePrefix;
    private final NetStrings netStrings = new NetStrings();
    private final String NET_ONAME_SERVER_HELP_TOPIC = "TOPICprofPrefONamesServer";
    private NetButton buttonPanel;
    private TabPanel ONStabPanel;
    private MultiLineLabel mainMsg;
    private NVFactory nvfactory = new NVFactory();
    private NLParamParser nlpa;
    private NetAddr currAddr;
    private boolean changed;
    private boolean deletingPage = false;
    private int invalidAddr;

    public NetONmServer() {
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.setBorderPainter((BorderPainter)new FixedBorderPainter(10, 10, 20, 10));
        this.mainMsg = new MultiLineLabel(WordWrapper.getTextWrapper(), this.netStrings.getString("PFCzeroONames"));
        this.mainMsg.setAlignment(1);
        this.mainMsg.setPreferredAspectRatio(10.0f);
        this.buttonLabels = new String[NET_ADDR_BUTTONS.length];
        int n = 0;
        while (n < NET_ADDR_BUTTONS.length) {
            this.buttonLabels[n] = this.netStrings.getString(NET_ADDR_BUTTONS[n]);
            ++n;
        }
        this.panelNamePrefix = this.netStrings.getString(PANEL_LABEL_PREFIX);
        this.buttonPanel = new NetButton(this.buttonLabels);
        this.buttonPanel.addNetButtonListener(this);
        ((Container)((Object)this)).add((Component)this.mainMsg, "Center");
        ((Container)((Object)this)).add((Component)((Object)this.buttonPanel), "South");
    }

    public NetONmServer(NLParamParser nLParamParser) {
        this();
        this.setNLP(nLParamParser);
    }

    public void setNLP(NLParamParser nLParamParser) {
        this.devTrc("NetONmServer: setNLP():");
        this.nlpa = nLParamParser;
    }

    public void cacheIt() {
        NVPair nVPair = this.nvfactory.createNVPair(paramFormat);
        this.devTrc("NetONmServer: cacheIt():");
        if (this.ONStabPanel != null) {
            int n = 0;
            while (n < this.ONStabPanel.getPageCount()) {
                TabPanelPage tabPanelPage = this.ONStabPanel.getPage(n);
                NVPair nVPair2 = ((NetAddr)((Object)tabPanelPage.getContent())).getAddr();
                if (nVPair2 != null) {
                    this.devTrc("NetONmServer: cacheIt():" + nVPair2.toString());
                    nVPair.addListElement(nVPair2);
                }
                ++n;
            }
        }
        if (nVPair.getListSize() > 0) {
            this.devTrc("NetONmServer: cacheIt(): adding address list.");
            try {
                this.nlpa.addNLPListElement("names.preferred_servers=" + nVPair.toString());
                return;
            }
            catch (NLException nLException) {
                return;
            }
        }
        this.devTrc("NetONmServer: cacheIt(): removing names.preferred_servers");
        this.nlpa.removeNLPListElement(NAMES_PARAM);
    }

    public void refresh() {
        String string;
        NVPair nVPair = this.nlpa.getNLPListElement(NAMES_PARAM);
        this.devTrc("NetONmServer: refresh():");
        this.removeTabPanel();
        this.devTrc("NetONmServer: refresh():removed all previous pages.");
        this.changed = false;
        if (nVPair != null && !(string = (nVPair = nVPair.getListElement(0)).getName()).equalsIgnoreCase(_desc_list) && !string.equalsIgnoreCase(_desc)) {
            if (string.equalsIgnoreCase(_addr_list)) {
                this.doAddrList(nVPair);
                return;
            }
            this.addAddrPanel(nVPair);
        }
    }

    public boolean hasChanged() {
        if (!this.changed && this.ONStabPanel != null) {
            this.devTrc("NetONmServer: hasChanged():");
            int n = 0;
            while (n < this.ONStabPanel.getPageCount()) {
                TabPanelPage tabPanelPage = this.ONStabPanel.getPage(n);
                this.changed = ((NetAddr)((Object)tabPanelPage.getContent())).hasChanged();
                if (this.changed) break;
                ++n;
            }
        }
        return this.changed;
    }

    public boolean areDataValid() {
        boolean bl = true;
        if (this.ONStabPanel == null) {
            return true;
        }
        int n = 0;
        while (n < this.ONStabPanel.getPageCount()) {
            this.devTrc("NetONmServer: areDataValid() " + n);
            TabPanelPage tabPanelPage = this.ONStabPanel.getPage(n);
            bl = ((NetAddr)((Object)tabPanelPage.getContent())).areDataValid();
            if (!bl) {
                this.devTrc("NetONmServer: areDataValid(): " + n + " " + bl);
                this.invalidAddr = n;
                break;
            }
            ++n;
        }
        return bl;
    }

    public void setFocus() {
        if (this.ONStabPanel != null && this.invalidAddr < this.ONStabPanel.getPageCount()) {
            TabPanelPage tabPanelPage = this.ONStabPanel.getPage(this.invalidAddr);
            tabPanelPage.setSelected(true);
            ((NetAddr)((Object)tabPanelPage.getContent())).setFocus();
        }
    }

    public void buttonPushed(String string) {
        this.devTrc("NetONmServer: buttonPushed()");
        this.changed = true;
        int n = 0;
        while (n < NET_ADDR_BUTTONS.length) {
            if (string.compareTo(this.buttonLabels[n]) == 0) break;
            ++n;
        }
        switch (n) {
            case 0: {
                if (this.ONStabPanel != null && this.ONStabPanel.getPageCount() > 0 && !this.areDataValid()) {
                    this.setFocus();
                    return;
                }
                TabPanelPage tabPanelPage = this.addAddrPanel(null);
                tabPanelPage.setSelected(true);
                return;
            }
            case 1: {
                this.deletingPage = true;
                if (this.ONStabPanel != null) {
                    if (this.ONStabPanel.getPageCount() > 1) {
                        this.deleteAddrPanel();
                    } else {
                        this.removeTabPanel();
                    }
                }
                this.deletingPage = false;
                return;
            }
            case 2: {
                this.devTrc("NetONmServer: buttonPushed(): do help.");
                NetHelp netHelp = NetUtils.getHelpContext();
                netHelp.showTopic("TOPICprofPrefONamesServer");
                return;
            }
        }
    }

    public void tabPanelSelectionChanged(TabPanelEvent tabPanelEvent) {
        TabPanelPage tabPanelPage = tabPanelEvent.getPage();
        if (tabPanelPage != null) {
            this.currAddr = (NetAddr)((Object)tabPanelPage.getContent());
        }
    }

    public void tabPanelSelectionChanging(TabPanelEvent tabPanelEvent) {
        if (!this.deletingPage && this.currAddr != null && !this.currAddr.areDataValid()) {
            ((Cancelable)tabPanelEvent).cancel();
            this.currAddr.setFocus();
        }
    }

    private void addTabPanel() {
        this.ONStabPanel = new TabPanel();
        this.ONStabPanel.addTabPanelListener((TabPanelListener)this);
        ((Container)((Object)this)).remove((Component)this.mainMsg);
        ((Container)((Object)this)).add((Component)this.ONStabPanel, "Center");
    }

    private void removeTabPanel() {
        if (this.ONStabPanel != null) {
            ((Container)((Object)this)).remove((Component)this.ONStabPanel);
        }
        this.ONStabPanel = null;
        this.currAddr = null;
        ((Container)((Object)this)).add((Component)this.mainMsg, "Center");
        this.validate();
    }

    private void deleteAddrPanel() {
        if (this.ONStabPanel == null) {
            return;
        }
        if (this.ONStabPanel.getPageCount() == 1) {
            this.removeTabPanel();
            return;
        }
        TabPanelPage tabPanelPage = this.ONStabPanel.getSelectedPage();
        int n = tabPanelPage.getIndex();
        this.ONStabPanel.removePage(tabPanelPage);
        while (n < this.ONStabPanel.getPageCount()) {
            TabPanelPage tabPanelPage2 = this.ONStabPanel.getPage(n);
            tabPanelPage2.setLabel(String.valueOf(this.panelNamePrefix) + (n + 1));
            ++n;
        }
    }

    private void doDescList(NVPair nVPair) {
        int n = 0;
        while (n < nVPair.getListSize()) {
            NVPair nVPair2 = nVPair.getListElement(n);
            this.addAddrPanel(nVPair2);
            ++n;
        }
    }

    private void doDesc(NVPair nVPair) {
        int n = 0;
        while (n < nVPair.getListSize()) {
            NVPair nVPair2 = nVPair.getListElement(n);
            this.addAddrPanel(nVPair2);
            ++n;
        }
    }

    private void doAddrList(NVPair nVPair) {
        int n = 0;
        while (n < nVPair.getListSize()) {
            NVPair nVPair2 = nVPair.getListElement(n);
            this.addAddrPanel(nVPair2);
            ++n;
        }
    }

    private TabPanelPage addAddrPanel(NVPair nVPair) {
        if (this.ONStabPanel == null) {
            this.addTabPanel();
        }
        NetAddr netAddr = new NetAddr(nVPair);
        TabPanelPage tabPanelPage = this.ONStabPanel.addPage("", (Component)((Object)netAddr));
        int n = tabPanelPage.getIndex();
        this.devTrc("NetONmServer: addAddrPanel():" + n);
        tabPanelPage.setLabel(String.valueOf(this.panelNamePrefix) + (n + 1));
        netAddr.setAppEnv(this.netApp);
        this.validate();
        this.ONStabPanel.validate();
        return tabPanelPage;
    }
}

