/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.profile;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.ewt.EwtContainer;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.lwAWT.LWLabel;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.profile.NetLayout;
import oracle.net.asst.profile.NetPStack;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public class NetPStack
extends NetLayout {
    private final NVFactory factory = new NVFactory();
    private final String prefix = "(PROTOCOL_STACK=(PRESENTATION=";
    private final String middle = ")(SESSION=";
    private final String suffix = "))";
    private final String[] allPres = new String[]{"TTC", "GIOP"};
    private final String[] allSess = new String[]{"NS", "RAW"};
    private final NetStrings ns = new NetStrings();
    private final String sessLabelString = this.ns.getString("PFCNPSsession");
    private final String presLabelString = this.ns.getString("PFCNPSpresentation");
    private final String customString = this.ns.getString("PFCNPScustom");
    private final String customButtonString = this.ns.getString("PFCNPScustomize");
    private final String net8String = this.ns.getString("PFCNPSnet8");
    private final String iiopString = this.ns.getString("PFCNPSiiop");
    private Hashtable comboDict = new Hashtable(5);
    private String[] defaultCombo;
    private LWChoice presChoice;
    private LWButton customButton;
    private CustomDialog customDialog;
    private NVPair currStack;
    private boolean changed;
    private boolean editable = true;
    protected String[] initialCustomSetting;

    public NetPStack() {
        this(null);
    }

    public NetPStack(NVPair nVPair) {
        this.comboDict.put(this.net8String, new String[]{"TTC", "NS"});
        this.comboDict.put(this.iiopString, new String[]{"GIOP", "RAW"});
        this.defaultCombo = (String[])this.comboDict.get(this.net8String);
        this.presChoice = new LWChoice();
        Enumeration enumeration = this.comboDict.keys();
        while (enumeration.hasMoreElements()) {
            this.presChoice.add((String)enumeration.nextElement());
        }
        this.presChoice.add(this.customString);
        this.presChoice.select(0);
        this.presChoice.addItemListener((ItemListener)new 4());
        this.customButton = new LWButton(this.customButtonString);
        this.customButton.addActionListener((ActionListener)new 5());
        this.customButton.setEnabled(false);
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.ipadx = 20;
        ((Container)((Object)this)).add((Component)this.presChoice, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.insets.left = 5;
        ((Container)((Object)this)).add((Component)this.customButton, gridBagConstraints);
        if (nVPair == null) {
            nVPair = this.factory.createNVPair("(PROTOCOL_STACK=(PRESENTATION=" + this.defaultCombo[0] + ")(SESSION=" + this.defaultCombo[1] + "))");
        }
        this.setPStack(nVPair);
    }

    public void setPStack(NVPair nVPair) {
        if (nVPair == null) {
            return;
        }
        this.currStack = nVPair;
        NVNavigator nVNavigator = new NVNavigator();
        String[] stringArray = new String[2];
        try {
            stringArray[0] = nVNavigator.findNVPairRecurse(nVPair, "PRESENTATION").getAtom();
            stringArray[1] = nVNavigator.findNVPairRecurse(nVPair, "SESSION").getAtom();
        }
        catch (NullPointerException nullPointerException) {}
        if (stringArray[0] == null || stringArray[1] == null) {
            stringArray = this.defaultCombo;
        }
        this.presChoice.select(this.customString);
        Enumeration enumeration = this.comboDict.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String[] stringArray2 = (String[])this.comboDict.get(string);
            if (!stringArray[0].equals(stringArray2[0]) || !stringArray[1].equals(stringArray2[1])) continue;
            this.presChoice.select(string);
        }
        if (this.presChoice.getSelectedItem().equals(this.customString)) {
            this.customButton.setEnabled(true);
            if (this.customDialog != null) {
                this.customDialog.setSelection(stringArray);
                return;
            }
            this.initialCustomSetting = stringArray;
        }
    }

    public NVPair getPStack() {
        if (this.changed) {
            String string = this.presChoice.getSelectedItem();
            String[] stringArray = (String[])this.comboDict.get(string);
            if (stringArray == null) {
                stringArray = this.customDialog != null ? this.customDialog.getSelection() : this.defaultCombo;
            }
            this.currStack = this.factory.createNVPair("(PROTOCOL_STACK=(PRESENTATION=" + stringArray[0] + ")(SESSION=" + stringArray[1] + "))");
        }
        return this.currStack;
    }

    public boolean areDataValid() {
        return true;
    }

    public void setFocus() {
    }

    public synchronized void setEditable(boolean bl) {
        this.editable = bl;
        Component[] componentArray = ((Container)((Object)this)).getComponents();
        int n = 0;
        while (n < componentArray.length) {
            componentArray[n].setEnabled(bl);
            ++n;
        }
        if (this.customButton.isEnabled() && !this.presChoice.getSelectedItem().equals(this.customString)) {
            this.customButton.setEnabled(false);
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void discard() {
        this.setPStack(this.currStack);
    }

    public boolean hasChanged() {
        if (this.changed) {
            return true;
        }
        return this.customDialog != null && this.customDialog.hasChanged();
    }

    static /* synthetic */ String access$0(NetPStack netPStack) {
        return netPStack.customString;
    }

    static /* synthetic */ LWButton access$1(NetPStack netPStack) {
        return netPStack.customButton;
    }

    static /* synthetic */ CustomDialog access$2(NetPStack netPStack) {
        return netPStack.customDialog;
    }

    static /* synthetic */ void access$3(NetPStack netPStack, CustomDialog customDialog) {
        netPStack.customDialog = customDialog;
    }

    static /* synthetic */ boolean access$4(NetPStack netPStack) {
        return netPStack.changed;
    }

    static /* synthetic */ void access$5(NetPStack netPStack, boolean bl) {
        netPStack.changed = bl;
    }

    static /* synthetic */ NetStrings access$6(NetPStack netPStack) {
        return netPStack.ns;
    }

    static /* synthetic */ String access$7(NetPStack netPStack) {
        return netPStack.presLabelString;
    }

    static /* synthetic */ String access$8(NetPStack netPStack) {
        return netPStack.sessLabelString;
    }

    static /* synthetic */ String[] access$9(NetPStack netPStack) {
        return netPStack.allPres;
    }

    static /* synthetic */ String[] access$10(NetPStack netPStack) {
        return netPStack.allSess;
    }

    private final class 4
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                NetPStack netPStack = NetPStack.this;
                if (itemEvent.getItem().equals(netPStack.customString)) {
                    netPStack = NetPStack.this;
                    netPStack.customButton.setEnabled(true);
                    netPStack = NetPStack.this;
                    if (netPStack.customDialog == null) {
                        CustomDialog customDialog;
                        netPStack = NetPStack.this;
                        netPStack.customDialog = customDialog = new CustomDialog((Frame)NetPStack.this.getFrame());
                    }
                    netPStack = NetPStack.this;
                    netPStack.customDialog.runDialog();
                    netPStack = NetPStack.this;
                    if (netPStack.customDialog.hasChanged()) {
                        netPStack = NetPStack.this;
                        netPStack.changed = true;
                        return;
                    }
                } else {
                    netPStack = NetPStack.this;
                    netPStack.customButton.setEnabled(false);
                    netPStack = NetPStack.this;
                    netPStack.changed = true;
                }
            }
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            NetPStack netPStack = NetPStack.this;
            if (netPStack.customDialog == null) {
                CustomDialog customDialog;
                netPStack = NetPStack.this;
                netPStack.customDialog = customDialog = new CustomDialog((Frame)NetPStack.this.getFrame());
            }
            netPStack = NetPStack.this;
            netPStack.customDialog.runDialog();
            netPStack = NetPStack.this;
            if (netPStack.customDialog.hasChanged()) {
                netPStack = NetPStack.this;
                netPStack.changed = true;
            }
        }

        /* synthetic */ 5() {
        }
    }

    private class CustomDialog
    extends BufferedDialog
    implements ActionListener {
        private final int DLG_WIDTH = 300;
        private final int DLG_HEIGHT = 150;
        private LWLabel presLabel;
        private LWLabel sessLabel;
        private LWChoice presChoice;
        private LWChoice sessChoice;
        private LWButton okButton;
        private LWButton cancelButton;
        private LWButton helpButton;
        private final String okButtonString;
        private final String cancelButtonString;
        private final String helpButtonString;
        private final String dialogTitleString;
        private final String helpTopicString = "TOPICprofPStack";
        private int previousPres;
        private int previousSess;

        CustomDialog(Frame frame) {
            super(frame, true);
            NetPStack.this = NetPStack.this;
            Object object = NetPStack.this;
            this.okButtonString = object.ns.getString("PFCNPSok");
            object = NetPStack.this;
            this.cancelButtonString = object.ns.getString("PFCNPScancel");
            object = NetPStack.this;
            this.helpButtonString = object.ns.getString("PFChelp");
            object = NetPStack.this;
            this.dialogTitleString = object.ns.getString("PFCNPSdialogTitle");
            this.helpTopicString = "TOPICprofPStack";
            this.presLabel = new LWLabel(NetPStack.this.presLabelString);
            this.sessLabel = new LWLabel(NetPStack.this.sessLabelString);
            object = new 6(this);
            this.presChoice = new LWChoice();
            int n = 0;
            while (n < NetPStack.this.allPres.length) {
                this.presChoice.addItem(NetPStack.this.allPres[n]);
                ++n;
            }
            this.presChoice.select(0);
            this.presChoice.addItemListener((ItemListener)object);
            this.sessChoice = new LWChoice();
            int n2 = 0;
            while (n2 < NetPStack.this.allSess.length) {
                this.sessChoice.addItem(NetPStack.this.allSess[n2]);
                ++n2;
            }
            this.sessChoice.select(0);
            this.sessChoice.addItemListener((ItemListener)object);
            this.okButton = new LWButton(this.okButtonString);
            this.okButton.setActionCommand("OK");
            this.okButton.addActionListener((ActionListener)this);
            this.okButton.setLeftmost(true);
            this.cancelButton = new LWButton(this.cancelButtonString);
            this.cancelButton.setActionCommand("CANCEL");
            this.cancelButton.addActionListener((ActionListener)this);
            this.cancelButton.setRightmost(true);
            this.helpButton = new LWButton(this.helpButtonString);
            this.helpButton.setActionCommand("HELP");
            this.helpButton.addActionListener((ActionListener)this);
            this.helpButton.setLeftmost(true);
            this.helpButton.setRightmost(true);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets.top = 10;
            gridBagConstraints.insets.left = 10;
            ((Container)((Object)this)).add((Component)this.presLabel, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets.top = 0;
            ((Container)((Object)this)).add((Component)this.sessLabel, gridBagConstraints);
            gridBagConstraints.weightx = 3.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.insets.left = 5;
            gridBagConstraints.insets.top = 10;
            gridBagConstraints.insets.right = 10;
            ((Container)((Object)this)).add((Component)this.presChoice, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets.top = 0;
            ((Container)((Object)this)).add((Component)this.sessChoice, gridBagConstraints);
            EwtContainer ewtContainer = new EwtContainer();
            ewtContainer.setLayout(new GridBagLayout());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets.top = 5;
            gridBagConstraints.insets.bottom = 10;
            gridBagConstraints.insets.right = 0;
            gridBagConstraints.insets.left = 0;
            ((Container)((Object)this)).add((Component)ewtContainer, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets.top = 0;
            gridBagConstraints.insets.bottom = 0;
            gridBagConstraints.insets.left = 10;
            gridBagConstraints.insets.right = 0;
            ewtContainer.add((Component)this.helpButton, gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets.right = 0;
            gridBagConstraints.insets.left = 0;
            gridBagConstraints.anchor = 13;
            ewtContainer.add((Component)this.okButton, gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.insets.left = 3;
            gridBagConstraints.insets.right = 10;
            ewtContainer.add((Component)this.cancelButton, gridBagConstraints);
            ((Dialog)((Object)this)).setTitle(this.dialogTitleString);
            if (NetPStack.this.initialCustomSetting != null) {
                this.setSelection(NetPStack.this.initialCustomSetting);
                NetPStack.this.initialCustomSetting = null;
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("HELP")) {
                NetUtils.getHelpContext().show("TOPICprofPStack");
                return;
            }
            if (actionEvent.getActionCommand().equals("CANCEL")) {
                ((Component)((Object)this)).setVisible(false);
                NetPStack netPStack = NetPStack.this;
                netPStack.changed = false;
                this.presChoice.select(this.previousPres);
                this.sessChoice.select(this.previousSess);
                return;
            }
            ((Component)((Object)this)).setVisible(false);
            NetPStack netPStack = NetPStack.this;
            netPStack.changed = true;
        }

        public void runDialog() {
            this.previousPres = this.presChoice.getSelectedIndex();
            this.previousSess = this.sessChoice.getSelectedIndex();
            ((Component)((Object)this)).setSize(300, 150);
            Rectangle rectangle = NetPStack.this.getFrame().getBounds();
            ((Component)((Object)this)).setLocation(rectangle.x + rectangle.width / 2 - 150, rectangle.y + rectangle.height / 2 - 75);
            ((Component)((Object)this)).setVisible(true);
        }

        public boolean hasChanged() {
            NetPStack netPStack = NetPStack.this;
            return netPStack.changed;
        }

        public void setSelection(String[] stringArray) {
            if (stringArray == null || stringArray[0] == null || stringArray[1] == null) {
                return;
            }
            this.presChoice.select(stringArray[0]);
            this.sessChoice.select(stringArray[1]);
        }

        public String[] getSelection() {
            return new String[]{this.presChoice.getSelectedItem(), this.sessChoice.getSelectedItem()};
        }

        static /* synthetic */ NetPStack access$0(CustomDialog customDialog) {
            return customDialog.NetPStack.this;
        }
    }
}

