/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.profile;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;
import oracle.ewt.EwtContainer;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.profile.NetGeneral;
import oracle.net.asst.profile.NetLayout;
import oracle.net.asst.profile.NetName;
import oracle.net.asst.profile.NetONmServer;
import oracle.net.asst.profile.ProfileCache;
import oracle.net.asst.security.NetANO;
import oracle.net.common.NetProperties;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.sysman.emSDK.client.appContainer.WebApplication;

public class NetProfile
extends NetLayout
implements ItemListener {
    private String[] category;
    private EwtContainer mainPanel;
    private BufferedFrame frame;
    private CardLayout cardLayout;
    private ProfileCache[] categoryPanel;
    private String[] categoryLabel;
    private LWChoice choice;
    private NLParamParser nlpa;
    private int currentCategory;

    public NetProfile() {
        int n;
        try {
            try {
                n = 0;
                NetProperties netProperties = NetProperties.getInstance();
                String string = netProperties.getProperty("INSTALLEDCOMPONENTS");
                if (string == null) {
                    string = netProperties.getProperty("InstalledComponents");
                }
                if (string == null) {
                    string = netProperties.getProperty("installedcomponents");
                }
                if (string != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ", ", false);
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        if (!string2.equalsIgnoreCase("ASO") && !string2.equalsIgnoreCase("ANO")) continue;
                        n = 1;
                        break;
                    }
                    this.category = n != 0 ? new String[4] : new String[3];
                } else {
                    this.category = new String[4];
                }
            }
            catch (Exception exception) {
                this.category = new String[4];
            }
            Object var2_6 = null;
            this.category[0] = "PFCcategoryNaming";
            this.category[1] = "PFCcategoryGeneral";
            this.category[2] = "PFCcategoryONS";
        }
        catch (Throwable throwable) {
            Object var2_7 = null;
            this.category[0] = "PFCcategoryNaming";
            this.category[1] = "PFCcategoryGeneral";
            this.category[2] = "PFCcategoryONS";
            if (this.category.length == 4) {
                this.category[3] = "PFCcategoryANO";
            }
            throw throwable;
        }
        if (this.category.length == 4) {
            this.category[3] = "PFCcategoryANO";
        }
        this.setTrace();
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        NetStrings netStrings = new NetStrings();
        this.choice = new LWChoice();
        int n2 = 0;
        while (n2 < this.category.length) {
            this.choice.addItem(netStrings.getString(this.category[n2]));
            ++n2;
        }
        this.choice.addItemListener((ItemListener)this);
        this.constrain((Container)((Object)this), (Component)this.choice, 0, 0, 1, 1, 0, 10, 0, 0);
        this.cardLayout = new CardLayout();
        this.mainPanel = new EwtContainer();
        this.mainPanel.setLayout(this.cardLayout);
        this.mainPanel.setBorderPainter((BorderPainter)new FixedBorderPainter(8, 8, 8, 8));
        this.categoryPanel = new ProfileCache[this.category.length];
        this.categoryLabel = new String[this.category.length];
        this.categoryPanel[0] = new NetName();
        this.categoryPanel[1] = new NetGeneral();
        this.categoryPanel[2] = new NetONmServer();
        if (this.categoryPanel.length == 4) {
            this.categoryPanel[3] = new NetANO();
        }
        n = 0;
        while (n < this.category.length) {
            this.categoryLabel[n] = netStrings.getString(this.category[n]);
            this.mainPanel.add(this.categoryLabel[n], (Component)((EwtContainer)this.categoryPanel[n]));
            ++n;
        }
        this.constrain((Container)((Object)this), (Component)this.mainPanel, 0, 1, 1, 1);
        this.currentCategory = 0;
    }

    public NetProfile(String string) throws IOException, NLException {
        this();
        this.activate(string);
    }

    public boolean hasChanged() {
        boolean bl = false;
        int n = 0;
        while (n < this.category.length) {
            bl = this.categoryPanel[n].hasChanged();
            if (bl) break;
            ++n;
        }
        this.devTrc("NetProfile: hasChanged(): " + n + " " + bl);
        return bl;
    }

    public void activate(String string) throws FileNotFoundException, IOException, NLException {
        this.devTrc("NetProfile: activate():" + string);
        try {
            this.nlpa = new NLParamParser(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.devTrc("NetProfile: activate():" + this.nlpa.toString());
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            this.devTrc("NetProfile: activate(): IO Exception");
            throw iOException;
        }
        catch (NLException nLException) {
            this.devTrc("NetProfile: activate(): NL Exception");
            throw nLException;
        }
        int n = 0;
        while (n < this.category.length) {
            this.categoryPanel[n].setNLP(this.nlpa);
            ++n;
        }
        n = 0;
        while (n < this.category.length) {
            this.categoryPanel[n].refresh();
            ++n;
        }
    }

    public boolean Comp_file_has_Comments() {
        return this.nlpa.fileHasComments();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object instanceof LWChoice) {
            this.devTrc("NetProfile: itemStateChanged(): validating " + this.currentCategory);
            if (this.categoryPanel[this.currentCategory].areDataValid()) {
                String string = itemEvent.getItem().toString();
                this.currentCategory = this.getCategoryIndex(string);
                this.cardLayout.show((Container)this.mainPanel, string);
            } else {
                this.choice.select(this.currentCategory);
                this.categoryPanel[this.currentCategory].setFocus();
            }
            this.devTrc("NetProfile: itemStateChanged(): currentCategory=" + this.currentCategory);
        }
    }

    public void discard() {
        this.devTrc("NetProfile: discard():");
        String string = null;
        if (this.nlpa != null) {
            string = this.nlpa.getFilename();
        }
        if (string != null) {
            try {
                this.activate(string);
                return;
            }
            catch (IOException iOException) {
                this.devTrc("Unable to load file: " + string);
                this.devTrc(iOException.toString());
                return;
            }
            catch (NLException nLException) {
                this.devTrc("Error reading file: " + string);
                this.devTrc(nLException.toString());
                return;
            }
        }
    }

    public boolean save(String string) {
        this.devTrc("NetProfile: save():" + string);
        if (!this.areDataValid()) {
            return false;
        }
        this.checkSave();
        int n = 0;
        while (n < this.category.length) {
            this.categoryPanel[n].cacheIt();
            ++n;
        }
        try {
            this.nlpa.saveNLParams(string);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public void setAppEnv(WebApplication webApplication) {
        this.devTrc("NetProfile: setAppEnv():");
        this.frame = (BufferedFrame)webApplication.getFrame();
        int n = 0;
        while (n < this.category.length) {
            ((NetLayout)((Object)this.categoryPanel[n])).setAppEnv(webApplication);
            ++n;
        }
    }

    public boolean areDataValid() {
        this.devTrc("NetProfile: areDataValid():");
        boolean bl = true;
        int n = 0;
        while (n < this.category.length) {
            bl = this.categoryPanel[n].areDataValid();
            if (!bl) {
                this.currentCategory = n;
                this.choice.select(this.currentCategory);
                this.cardLayout.show((Container)this.mainPanel, this.categoryLabel[this.currentCategory]);
                this.categoryPanel[this.currentCategory].setFocus();
                break;
            }
            ++n;
        }
        return bl;
    }

    public void checkSave() {
    }

    private int getCategoryIndex(String string) {
        int n = 0;
        while (n < this.category.length) {
            if (this.categoryLabel[n].compareTo(string) == 0) break;
            ++n;
        }
        return n;
    }
}

