/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.profile;

import java.awt.Component;
import oracle.ewt.dTree.DTreeSelectionEvent;
import oracle.ewt.event.Cancelable;
import oracle.net.asst.component.NetComponent;
import oracle.net.asst.component.NetObjectMenu;
import oracle.net.asst.component.NetObjectToolbar;
import oracle.net.asst.component.NetVector;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.profile.NetProfile;
import oracle.net.common.dataStore.DataStore;
import oracle.net.common.dataStore.FileDataStore;
import oracle.sysman.emSDK.client.appContainer.WebApplication;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.DataDrivenTree;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeChildNode;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeItem;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeNodeSelectionListener;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeProxy;

public class NetProfileComponent
extends NetComponent {
    private static final String TITLE = "PFCprofile";
    private static final String FILENAME = "sqlnet.ora";
    private NetProfile netProfile;
    private NetVector menuVector;
    private NetVector toolbarVector;
    private TreeItem profileTreeNode;
    private FileDataStore fds;
    private NetStrings netStrings;
    private boolean loaded;

    private NetProfileComponent() {
    }

    public NetProfileComponent(WebApplication webApplication, DataStore dataStore) {
        this.netStrings = new NetStrings();
        this.menuVector = new NetVector();
        this.toolbarVector = new NetVector();
        if (dataStore instanceof FileDataStore) {
            this.fds = (FileDataStore)dataStore;
        }
        NetObjectToolbar netObjectToolbar = new NetObjectToolbar(this.netStrings.getString("CNTCreate"), null, false);
        this.toolbarVector.addElement(netObjectToolbar);
        netObjectToolbar = new NetObjectToolbar(this.netStrings.getString("CNTDelete"), null, false);
        this.toolbarVector.addElement(netObjectToolbar);
        NetObjectMenu netObjectMenu = new NetObjectMenu(this.netStrings.getString("CNTEdit"), this.netStrings.getString("CNTCreate"), false);
        this.menuVector.addElement(netObjectMenu);
        netObjectMenu = new NetObjectMenu(this.netStrings.getString("CNTEdit"), this.netStrings.getString("CNTDelete"), false);
        this.menuVector.addElement(netObjectMenu);
        this.netProfile = new NetProfile();
        this.netProfile.setAppEnv(webApplication);
    }

    public DataStore getDataStore() {
        return this.fds;
    }

    public TreeItem getTreeNode(DataDrivenTree dataDrivenTree) {
        if (this.profileTreeNode == null) {
            this.profileTreeNode = new TreeChildNode((TreeProxy)new NetProfileProxy(dataDrivenTree), "oracle_sysman_netasst_profile_comp");
        }
        return this.profileTreeNode;
    }

    public boolean save(DataStore dataStore) {
        if (!this.loaded) {
            this.loadData();
        }
        if (!this.netProfile.areDataValid()) {
            return false;
        }
        if (dataStore instanceof FileDataStore) {
            this.fds = (FileDataStore)dataStore;
            return this.netProfile.save(String.valueOf(this.fds.getAdminDir()) + FILENAME);
        }
        return false;
    }

    public void refresh(DataStore dataStore) {
        if (dataStore instanceof FileDataStore) {
            this.fds = (FileDataStore)dataStore;
        }
        if (this.loaded) {
            this.loadData();
        }
    }

    public boolean isChanged() {
        if (!this.loaded) {
            return false;
        }
        return this.netProfile.hasChanged();
    }

    public void create(Object object) {
    }

    public void delete() {
    }

    public String toString() {
        return this.netStrings.getString(TITLE);
    }

    public NetVector getComponentMenus() {
        return this.menuVector;
    }

    public NetVector getComponentToolbar() {
        return this.toolbarVector;
    }

    public boolean Comp_file_has_Comments() {
        return this.netProfile.Comp_file_has_Comments();
    }

    public void loadData() {
        try {
            this.netProfile.activate(String.valueOf(this.fds.getAdminDir()) + FILENAME);
            this.loaded = true;
            return;
        }
        catch (Throwable throwable) {
            System.err.println(throwable);
            throwable.printStackTrace();
            return;
        }
    }

    static /* synthetic */ NetProfile access$0(NetProfileComponent netProfileComponent) {
        return netProfileComponent.netProfile;
    }

    static /* synthetic */ boolean access$1(NetProfileComponent netProfileComponent) {
        return netProfileComponent.loaded;
    }

    private class NetProfileProxy
    extends TreeProxy
    implements TreeNodeSelectionListener {
        public NetProfileProxy(DataDrivenTree dataDrivenTree) {
            super(dataDrivenTree);
            NetProfileComponent.this = NetProfileComponent.this;
        }

        public void treeSelectionChanging(DTreeSelectionEvent dTreeSelectionEvent, TreeItem treeItem) {
            NetProfileComponent netProfileComponent = NetProfileComponent.this;
            if (!netProfileComponent.netProfile.areDataValid()) {
                ((Cancelable)dTreeSelectionEvent).cancel();
                return;
            }
        }

        public void treeSelectionChanged(DTreeSelectionEvent dTreeSelectionEvent, TreeItem treeItem) {
            NetProfileComponent netProfileComponent = NetProfileComponent.this;
            if (!netProfileComponent.loaded) {
                NetProfileComponent.this.loadData();
            }
            netProfileComponent = NetProfileComponent.this;
            NetUtils.getContainer().display(NetProfileComponent.this, (Component)((Object)netProfileComponent.netProfile));
        }
    }
}

