/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.profile;

import java.awt.Component;
import java.awt.Container;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWLabel;
import oracle.net.asst.container.NetHelp;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.profile.NetButton;
import oracle.net.asst.profile.NetButtonListener;
import oracle.net.asst.profile.NetLayout;
import oracle.net.asst.profile.ProfileCache;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVPair;

public class NetRoute
extends NetLayout
implements ProfileCache,
NetButtonListener {
    private static final String[] ROUTING_PARAM = new String[]{"use_dedicated_server", "use_cman"};
    private static final String[] ROUTING_PARAM_LABELS = new String[]{"PFCuseDedicatedServer", "PFCuseCMAN"};
    private static final String[] ROUTING_DISABLE_CODE = new String[]{"off", "false"};
    private static final String[] ROUTING_ENABLE_CODE = new String[]{"on", "true"};
    private static final String[] NET_ROUTE_BUTTONS = new String[]{"PFChelp"};
    private final NetStrings netStrings = new NetStrings();
    private final String NET_ROUTE_HELP_TOPIC = "TOPICprofGeneralRouting";
    private LWCheckbox[] fieldCheckbox;
    private NLParamParser nlpa;
    private String[] netRouteButton = new String[NET_ROUTE_BUTTONS.length];

    public NetRoute() {
        int n = 0;
        while (n < NET_ROUTE_BUTTONS.length) {
            this.netRouteButton[n] = this.netStrings.getString(NET_ROUTE_BUTTONS[n]);
            ++n;
        }
        this.fieldCheckbox = new LWCheckbox[ROUTING_PARAM.length];
        n = 0;
        while (n < ROUTING_PARAM.length) {
            this.fieldCheckbox[n] = new LWCheckbox();
            this.constrain((Container)((Object)this), (Component)new LWLabel(this.netStrings.getString(ROUTING_PARAM_LABELS[n]), 1), 0, n, 1, 1, 5, 5, 5, 5);
            this.constrain((Container)((Object)this), (Component)this.fieldCheckbox[n], 1, n, 1, 1, 5, 5, 5, 5);
            ++n;
        }
    }

    public NetRoute(NLParamParser nLParamParser) {
        this();
        this.setNLP(nLParamParser);
    }

    public void setNLP(NLParamParser nLParamParser) {
        this.devTrc("Caching info into NLPA/n");
        this.nlpa = nLParamParser;
    }

    public void cacheIt() {
        this.devTrc("NetRoute: cacheIt():");
        int n = 0;
        while (n < ROUTING_PARAM.length) {
            if (this.fieldCheckbox[n].getState()) {
                String string = ROUTING_ENABLE_CODE[n];
                try {
                    this.nlpa.addNLPListElement(String.valueOf(ROUTING_PARAM[n]) + "=" + string);
                }
                catch (NLException nLException) {}
            } else {
                this.nlpa.removeNLPListElement(ROUTING_PARAM[n]);
            }
            ++n;
        }
        this.nlpa.removeNLPListElement("AUTOMATIC_IPC");
    }

    public void refresh() {
        this.devTrc("NetRoute: refresh():");
        int n = 0;
        while (n < ROUTING_PARAM.length) {
            String string;
            NVPair nVPair = this.nlpa.getNLPListElement(ROUTING_PARAM[n]);
            if (nVPair != null && (string = nVPair.getAtom()) != null) {
                if (string.equalsIgnoreCase("on") || string.equalsIgnoreCase("true")) {
                    this.fieldCheckbox[n].setState(true);
                } else {
                    this.fieldCheckbox[n].setState(false);
                }
            } else {
                this.fieldCheckbox[n].setState(false);
            }
            ++n;
        }
    }

    public boolean hasChanged() {
        this.devTrc("NetRoute: hasChanged():");
        int n = 0;
        while (n < ROUTING_PARAM.length) {
            NVPair nVPair = this.nlpa.getNLPListElement(ROUTING_PARAM[n]);
            if (nVPair != null ? (nVPair.getAtom().equalsIgnoreCase("on") || nVPair.getAtom().equalsIgnoreCase("true")) && !this.fieldCheckbox[n].getState() : this.fieldCheckbox[n].getState()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean areDataValid() {
        return true;
    }

    public void setFocus() {
    }

    public NetButton createNetButton() {
        this.devTrc("NetRoute: createNetButton()");
        NetButton netButton = new NetButton(this.netRouteButton);
        netButton.addNetButtonListener(this);
        return netButton;
    }

    public void buttonPushed(String string) {
        this.devTrc("NetRoute: buttonPushed()");
        if (string.equalsIgnoreCase(this.netRouteButton[0])) {
            this.devTrc("NetRoute: buttonPushed(): do help.");
            NetHelp netHelp = NetUtils.getHelpContext();
            netHelp.showTopic("TOPICprofGeneralRouting");
        }
    }

    private void pruneObsoleteParams() {
        this.nlpa.removeNLPListElement("AUTOMATIC_IPC");
    }
}

