/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.profile;

import java.net.UnknownHostException;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.profile.NetProtocolAddr;
import oracle.net.asst.profile.NetTCPAddr;
import oracle.net.nl.NVPair;

public class NetTCPSAddr
extends NetProtocolAddr {
    static final String TCPS_PROTOCOL_PREFIX = "TCPS";
    static final String TCPS_ADDR_FORMAT = "(ADDRESS=(PROTOCOL=TCPS))";
    private static final String[] TCPS_ADDR_PARAM = new String[]{"HOST", "PORT"};
    private static final String[] TCPS_ADDR_PARAM_LABEL = new String[]{"PFCaddrHostLabel", "PFCaddrPortLabel"};
    private int inValidField;

    public NetTCPSAddr() {
        super(TCPS_PROTOCOL_PREFIX, TCPS_ADDR_FORMAT, TCPS_ADDR_PARAM, TCPS_ADDR_PARAM_LABEL);
    }

    public NetTCPSAddr(NVPair nVPair) {
        this();
        this.setAddr(nVPair);
    }

    public boolean areDataValid() {
        this.devTrc("NetTCPSAddr: areDataValid():");
        if (this.addrParamText[0].getText().length() == 0 || !this.netValidate.validateHostName(this.addrParamText[0])) {
            this.inValidField = 0;
            return false;
        }
        if (this.addrParamText[1].getText().length() == 0 || !this.netValidate.validateNumber(this.addrParamText[1], 1, 65535)) {
            this.inValidField = 1;
            return false;
        }
        this.devTrc("NetTCPSAddr: areDataValid(): true ");
        return true;
    }

    public void setFocus() {
        this.devTrc("NetTCPSAddr: setFocus():");
        switch (this.inValidField) {
            case 0: {
                this.netValidate.showDialog(TCPS_ADDR_PARAM[this.inValidField]);
                break;
            }
            case 1: {
                this.netValidate.showDialog(TCPS_ADDR_PARAM[this.inValidField], 1, 65535);
            }
        }
        this.addrParamText[this.inValidField].selectAll();
        this.addrParamText[this.inValidField].requestFocus();
    }

    public String getProtocol() {
        return TCPS_PROTOCOL_PREFIX;
    }

    public boolean sameEndpoint(NetProtocolAddr netProtocolAddr) {
        if (netProtocolAddr == null) {
            return false;
        }
        if (!(netProtocolAddr instanceof NetTCPAddr) && !(netProtocolAddr instanceof NetTCPSAddr)) {
            return false;
        }
        String string = this.addrParamText[0].getText();
        String string2 = netProtocolAddr.addrParamText[0].getText();
        String string3 = this.addrParamText[1].getText().toUpperCase();
        String string4 = netProtocolAddr.addrParamText[1].getText().toUpperCase();
        try {
            return NetUtils.isSameHost(string, string2) && string3.equalsIgnoreCase(string4);
        }
        catch (UnknownHostException unknownHostException) {
            return string.equalsIgnoreCase(string2) && string3.equalsIgnoreCase(string4);
        }
    }
}

