/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.profile;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import oracle.ewt.EwtContainer;
import oracle.ewt.UIManager;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.painter.Painter;
import oracle.net.asst.container.NetHelp;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.profile.NetButton;
import oracle.net.asst.profile.NetButtonListener;
import oracle.net.asst.profile.NetLayout;
import oracle.net.asst.profile.ProfileCache;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVPair;

public class NetTrace
extends NetLayout
implements ProfileCache,
NetButtonListener {
    private static final String[] TRACE_LEVEL = new String[]{"OFF", "USER", "ADMIN", "SUPPORT"};
    private static final String[] PANEL_TYPE = new String[]{"client", "server"};
    private static final String[] PANEL_LABEL = new String[]{"PFCclientLabel", "PFCserverLabel"};
    private static final String[] TRACE_PARAM = new String[]{"trace_level", "trace_directory", "trace_file", "trace_unique"};
    private static final String[] TRACE_PARAM_LABEL = new String[]{"PFCtraceLevel", "PFCtraceDirectory", "PFCtraceFile", "PFCtraceUnique"};
    private static final String[] NET_TRACE_BUTTONS = new String[]{"PFChelp"};
    private final NetStrings ns = new NetStrings();
    private final String NET_TRACE_HELP_TOPIC = "TOPICprofGeneralTracing";
    private LWTextField[] itemText;
    private EwtContainer[] panel;
    private LWChoice[] levelChoice;
    private NLParamParser nlpa;
    private String[] netTraceButtons = new String[NET_TRACE_BUTTONS.length];
    private LWCheckbox traceUnique;

    public NetTrace() {
        int n = 0;
        while (n < NET_TRACE_BUTTONS.length) {
            this.netTraceButtons[n] = this.ns.getString(NET_TRACE_BUTTONS[n]);
            ++n;
        }
        this.setBorderPainter((BorderPainter)new FixedBorderPainter(25, 25, 25, 25));
        this.panel = new EwtContainer[PANEL_TYPE.length];
        this.itemText = new LWTextField[TRACE_PARAM.length * PANEL_TYPE.length];
        this.levelChoice = new LWChoice[PANEL_TYPE.length];
        int n2 = 0;
        while (n2 < PANEL_TYPE.length) {
            this.panel[n2] = new EwtContainer();
            this.panel[n2].setLayout(new GridBagLayout());
            this.panel[n2].setBorderPainter(UIManager.createGroupBoxPainter((Painter)new FixedBorderPainter(10, 0, 5, 0), (String)this.ns.getString(PANEL_LABEL[n2])));
            this.constrain((Container)((Object)this), (Component)this.panel[n2], 0, n2, 1, 1, 2, 11, 1.0, 0.0, 0, 0, 15, 0);
            int n3 = n2 * PANEL_TYPE.length;
            n = 0;
            while (n < TRACE_PARAM.length) {
                if (n < TRACE_PARAM.length - 1 || n2 < PANEL_TYPE.length - 1) {
                    this.constrain((Container)this.panel[n2], (Component)new LWLabel(this.ns.getString(TRACE_PARAM_LABEL[n]), 1), 0, n + 1, 1, 1, 0, 17, 0.0, 0.0, 0, 10, 5, 0);
                }
                if (n == 0) {
                    this.levelChoice[n2] = new LWChoice();
                    int n4 = 0;
                    while (n4 < TRACE_LEVEL.length) {
                        this.levelChoice[n2].addItem(TRACE_LEVEL[n4]);
                        ++n4;
                    }
                    this.constrain((Container)this.panel[n2], (Component)this.levelChoice[n2], 1, n + 1, 1, 1, 2, 17, 1.0, 0.0, 0, 10, 5, 10);
                } else if (n == TRACE_PARAM.length - 1) {
                    if (n2 == 0) {
                        this.traceUnique = new LWCheckbox();
                        this.constrain((Container)this.panel[n2], (Component)this.traceUnique, 1, n + 1, 1, 1, 2, 17, 1.0, 0.0, 0, 10, 5, 10);
                    }
                } else {
                    this.itemText[n3 + n] = new LWTextField(10);
                    this.constrain((Container)this.panel[n2], (Component)this.itemText[n3 + n], 1, n + 1, 1, 1, 2, 17, 1.0, 0.0, 0, 10, 5, 10);
                }
                ++n;
            }
            ++n2;
        }
    }

    public NetTrace(NLParamParser nLParamParser) {
        this();
        this.setNLP(nLParamParser);
    }

    public void setNLP(NLParamParser nLParamParser) {
        this.devTrc("Caching info into NLPA");
        this.nlpa = nLParamParser;
    }

    public void cacheIt() {
        this.devTrc("NetTrace: cacheIt():");
        int n = 0;
        while (n < PANEL_TYPE.length) {
            int n2 = n * PANEL_TYPE.length;
            int n3 = 0;
            while (n3 < TRACE_PARAM.length) {
                String string;
                String string2 = new String(String.valueOf(TRACE_PARAM[n3]) + "_" + PANEL_TYPE[n]);
                if (n3 == 0) {
                    int n4 = this.levelChoice[n].getSelectedIndex();
                    this.devTrc("NetTrace: cacheIt(): l=" + n4);
                    if (n4 > 0) {
                        string = this.levelChoice[n].getItem(n4);
                        try {
                            this.nlpa.addNLPListElement(String.valueOf(string2) + "=" + string);
                        }
                        catch (NLException nLException) {}
                    } else {
                        this.nlpa.removeNLPListElement(string2);
                    }
                } else if (n3 == TRACE_PARAM.length - 1) {
                    if (n == 0) {
                        if (this.traceUnique.getState()) {
                            try {
                                this.nlpa.addNLPListElement(String.valueOf(string2) + "=on");
                            }
                            catch (NLException nLException) {}
                        } else {
                            this.nlpa.removeNLPListElement(string2);
                        }
                    }
                } else {
                    string = this.itemText[n2 + n3].getText();
                    if (string.length() > 0) {
                        try {
                            this.nlpa.addNLPListElement(String.valueOf(string2) + "=" + string);
                        }
                        catch (NLException nLException) {}
                    } else {
                        this.nlpa.removeNLPListElement(string2);
                    }
                }
                ++n3;
            }
            ++n;
        }
    }

    public void refresh() {
        this.devTrc("NetTrace: refresh():");
        int n = 0;
        while (n < PANEL_TYPE.length) {
            int n2 = n * PANEL_TYPE.length;
            int n3 = 0;
            while (n3 < TRACE_PARAM.length) {
                String string;
                NVPair nVPair = this.nlpa.getNLPListElement(String.valueOf(TRACE_PARAM[n3]) + "_" + PANEL_TYPE[n]);
                if (nVPair != null && (string = nVPair.getAtom()) != null) {
                    if (n3 == 0) {
                        this.levelChoice[n].select(0);
                        if (string.equalsIgnoreCase("16")) {
                            this.levelChoice[n].select(TRACE_LEVEL.length - 1);
                        } else {
                            int n4 = 0;
                            while (n4 < TRACE_LEVEL.length) {
                                if (TRACE_LEVEL[n4].equalsIgnoreCase(string)) {
                                    this.levelChoice[n].select(n4);
                                    break;
                                }
                                ++n4;
                            }
                        }
                    } else if (n3 == TRACE_PARAM.length - 1) {
                        if (n == 0) {
                            if (string.equalsIgnoreCase("on")) {
                                this.traceUnique.setState(true);
                            } else {
                                this.traceUnique.setState(false);
                            }
                        }
                    } else {
                        this.itemText[n2 + n3].setText(string);
                    }
                } else if (n3 == 0) {
                    this.levelChoice[n].select(0);
                } else if (n3 == TRACE_PARAM.length - 1) {
                    if (n == 0) {
                        this.traceUnique.setState(false);
                    }
                } else {
                    this.itemText[n2 + n3].setText("");
                }
                ++n3;
            }
            ++n;
        }
    }

    public boolean hasChanged() {
        this.devTrc("NetTrace: hasChanged():");
        int n = 0;
        int n2 = 0;
        while (n2 < PANEL_TYPE.length) {
            int n3 = n2 * PANEL_TYPE.length;
            n = 0;
            while (n < TRACE_PARAM.length) {
                String string;
                NVPair nVPair = this.nlpa.getNLPListElement(String.valueOf(TRACE_PARAM[n]) + "_" + PANEL_TYPE[n2]);
                if (nVPair != null && (string = nVPair.getAtom()) != null ? (n == 0 ? !this.levelChoice[n2].getSelectedItem().equalsIgnoreCase(string) : (n == TRACE_PARAM.length - 1 ? n2 == 0 && string.equalsIgnoreCase("on") && !this.traceUnique.getState() : !this.itemText[n3 + n].getText().equalsIgnoreCase(string))) : (n == 0 ? this.levelChoice[n2].getSelectedIndex() > 0 : (n == TRACE_PARAM.length - 1 ? n2 == 0 && this.traceUnique.getState() : this.itemText[n3 + n].getText().length() > 0))) {
                    return true;
                }
                ++n;
            }
            ++n2;
        }
        return false;
    }

    public boolean areDataValid() {
        return true;
    }

    public void setFocus() {
    }

    public NetButton createNetButton() {
        this.devTrc("NetTrace: createNetButton()");
        NetButton netButton = new NetButton(this.netTraceButtons);
        netButton.addNetButtonListener(this);
        return netButton;
    }

    public void buttonPushed(String string) {
        this.devTrc("NetTrace: buttonPushed()");
        if (string.equalsIgnoreCase(this.netTraceButtons[0])) {
            this.devTrc("NetTrace: buttonPushed(): do help.");
            NetHelp netHelp = NetUtils.getHelpContext();
            netHelp.showTopic("TOPICprofGeneralTracing");
        }
    }
}

