/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.security;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.net.asst.container.NetHelp;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.profile.NetButton;
import oracle.net.asst.profile.NetButtonListener;
import oracle.net.asst.profile.NetLayout;
import oracle.net.asst.profile.ProfileCache;
import oracle.net.asst.security.NetBAuthParam;
import oracle.net.asst.security.NetCYBAuth;
import oracle.net.asst.security.NetIDXAuth;
import oracle.net.asst.security.NetKRBAuth;
import oracle.net.asst.security.NetNTSAuth;
import oracle.net.asst.security.NetRADAuth;
import oracle.net.asst.security.NetSECAuth;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;
import oracle.sysman.emSDK.client.appContainer.WebApplication;

public class NetAuthParam
extends NetLayout
implements ItemListener,
ProfileCache,
NetButtonListener {
    private final NetStrings netStrings = new NetStrings();
    private static final String[] supportedAuthSrv = new String[]{"KERBEROS(V5)", "CYBERSAFE", "IDENTIX", "SECURID", "NTS", "RADIUS"};
    private static final String[] NET_AUTHPARAM_BUTTONS = new String[]{"PFChelp"};
    private static final String AUTH_LABEL = "PFCserviceANO";
    private final String NET_AUTHPARAM_HELP_TOPIC = "TOPICanoAuthParam";
    private LWChoice authSrvChoice;
    private NetBAuthParam[] authService;
    private EwtContainer authDisplay;
    private CardLayout authCardLayout;
    private int currentAuthSrv;
    private NLParamParser nlpa;
    private String[] netAuthParamButton = new String[NET_AUTHPARAM_BUTTONS.length];

    public NetAuthParam() {
        int n = 0;
        while (n < NET_AUTHPARAM_BUTTONS.length) {
            this.netAuthParamButton[n] = this.netStrings.getString(NET_AUTHPARAM_BUTTONS[n]);
            ++n;
        }
        this.setBorderPainter((BorderPainter)new FixedBorderPainter(8, 8, 8, 8));
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        this.constrain((Container)((Object)this), (Component)new LWLabel(this.netStrings.getString(AUTH_LABEL), 1), 0, 0, 1, 1, 0, 4, 0, 0, 2);
        this.authSrvChoice = new LWChoice();
        this.authCardLayout = new CardLayout();
        this.authDisplay = new EwtContainer();
        this.authService = new NetBAuthParam[supportedAuthSrv.length];
        this.authDisplay.setLayout(this.authCardLayout);
        n = 0;
        while (n < supportedAuthSrv.length) {
            this.authSrvChoice.addItem(supportedAuthSrv[n]);
            this.authService[n] = this.createAuth(supportedAuthSrv[n]);
            if (this.authService[n] != null) {
                this.authDisplay.add(supportedAuthSrv[n], (Component)((Object)this.authService[n]));
            }
            ++n;
        }
        this.authSrvChoice.addItemListener((ItemListener)this);
        this.constrain((Container)((Object)this), (Component)this.authSrvChoice, 1, 0, 1, 1, 0, 4, 0, 0, 2);
        this.constrain((Container)((Object)this), (Component)this.authDisplay, 0, 1, 2, 1, 0, 4, 0, 0);
        String string = supportedAuthSrv[0];
        this.devTrc("NetAuthParam: displayAuth():");
        this.authCardLayout.show((Container)this.authDisplay, string);
        this.authSrvChoice.select(string);
        this.currentAuthSrv = 0;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.devTrc("NetAuthParam: itemStateChanged():");
        Object object = itemEvent.getSource();
        if (object instanceof LWChoice) {
            String string = itemEvent.getItem().toString();
            this.devTrc("NetAuthParam: displayAuth():");
            this.authCardLayout.show((Container)this.authDisplay, string);
            this.authSrvChoice.select(string);
            this.currentAuthSrv = this.chooseAuth(itemEvent.getItem().toString());
        }
    }

    private void displayAuth(String string) {
        this.devTrc("NetAuthParam: displayAuth():");
        this.authCardLayout.show((Container)this.authDisplay, string);
        this.authSrvChoice.select(string);
    }

    private NetBAuthParam createAuth(String string) {
        this.devTrc("NetAuthParam: createAuth():");
        if (string.equalsIgnoreCase(supportedAuthSrv[0])) {
            return new NetKRBAuth();
        }
        if (string.equalsIgnoreCase(supportedAuthSrv[1])) {
            return new NetCYBAuth();
        }
        if (string.equalsIgnoreCase(supportedAuthSrv[2])) {
            return new NetIDXAuth();
        }
        if (string.equalsIgnoreCase(supportedAuthSrv[3])) {
            return new NetSECAuth();
        }
        if (string.equalsIgnoreCase(supportedAuthSrv[4])) {
            return new NetNTSAuth();
        }
        if (string.equalsIgnoreCase(supportedAuthSrv[5])) {
            return new NetRADAuth();
        }
        return null;
    }

    private int chooseAuth(String string) {
        this.devTrc("NetAuthParam: chooseAuth(String):");
        int n = 0;
        while (n < supportedAuthSrv.length) {
            if (string.equalsIgnoreCase(supportedAuthSrv[n])) break;
            ++n;
        }
        return n;
    }

    private int chooseAuth(NVPair nVPair) {
        NVNavigator nVNavigator = new NVNavigator();
        this.devTrc("NetAuthParam: chooseAuth(NVPair):");
        NVPair nVPair2 = nVNavigator.findNVPair(nVPair, "Auth Service");
        String string = nVPair2.getAtom();
        int n = 0;
        while (n < supportedAuthSrv.length) {
            if (string.equalsIgnoreCase(supportedAuthSrv[n])) break;
            ++n;
        }
        return n;
    }

    public void setNLP(NLParamParser nLParamParser) {
        this.devTrc("Caching info into NLPA");
        this.nlpa = nLParamParser;
        int n = 0;
        while (n < supportedAuthSrv.length) {
            if (this.authService[n] != null) {
                this.authService[n].setNLP(this.nlpa);
            }
            ++n;
        }
    }

    public void cacheIt() {
        this.devTrc("NetAuthParam: cacheIt():");
        int n = 0;
        while (n < supportedAuthSrv.length) {
            if (this.authService[n] != null) {
                this.authService[n].cacheIt();
            }
            ++n;
        }
    }

    public void refresh() {
        this.devTrc("NetAuthParam: cacheIt():");
        int n = 0;
        while (n < supportedAuthSrv.length) {
            if (this.authService[n] != null) {
                this.authService[n].refresh();
            }
            ++n;
        }
    }

    public boolean hasChanged() {
        int n = 0;
        while (n < supportedAuthSrv.length) {
            if (this.authService[n].hasChanged()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public NetButton createNetButton() {
        this.devTrc("NetAuthparam: createNetButton()");
        NetButton netButton = new NetButton(this.netAuthParamButton);
        netButton.addNetButtonListener(this);
        return netButton;
    }

    public void buttonPushed(String string) {
        this.devTrc("NetAuthparam: buttonPushed()");
        if (string.equalsIgnoreCase(this.netAuthParamButton[0])) {
            NetHelp netHelp = NetUtils.getHelpContext();
            netHelp.showTopic("TOPICanoAuthParam");
        }
    }

    public boolean areDataValid() {
        this.devTrc("NetAuthParam areDataValid");
        int n = 0;
        while (n < supportedAuthSrv.length) {
            if (!this.authService[n].areDataValid()) {
                this.currentAuthSrv = n;
                return false;
            }
            ++n;
        }
        return true;
    }

    public void setFocus() {
        this.devTrc("NetAuthParam setFocus");
        String string = supportedAuthSrv[this.currentAuthSrv];
        this.devTrc("NetAuthParam: displayAuth():");
        this.authCardLayout.show((Container)this.authDisplay, string);
        this.authSrvChoice.select(string);
        this.authService[this.currentAuthSrv].setFocus();
    }

    public void setAppEnv(WebApplication webApplication) {
        this.devTrc("NetAuthParam setAppEnv");
        this.frame = (BufferedFrame)webApplication.getFrame();
        int n = 0;
        while (n < supportedAuthSrv.length) {
            this.authService[n].setAppEnv(webApplication);
            ++n;
        }
    }
}

