/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.security;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.net.asst.container.NetHelp;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.profile.NetButton;
import oracle.net.asst.profile.NetButtonListener;
import oracle.net.asst.profile.NetLayout;
import oracle.net.asst.profile.ProfileCache;
import oracle.net.asst.security.NetEncrypParam;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public class NetEncryp
extends NetLayout
implements ProfileCache,
NetButtonListener {
    private final NetStrings netStrings = new NetStrings();
    private static final String[] supportedEncrypSrv = new String[]{"SERVER", "CLIENT"};
    private static final String srvEncrypType = "SERVER";
    private static final String[] srvEncrypParamName = new String[]{"Encryption Server"};
    private static final String[] srvEncrypParam = new String[]{"sqlnet.crypto_seed", "sqlnet.encryption_server", "sqlnet.encryption_types_server"};
    private static final String cliEncrypType = "CLIENT";
    private static final String[] cliEncrypParamName = new String[]{"Encryption Client"};
    private static final String[] cliEncrypParam = new String[]{"sqlnet.crypto_seed", "sqlnet.encryption_client", "sqlnet.encryption_types_client"};
    private static final String[] NET_ENCRYP_BUTTONS = new String[]{"PFChelp"};
    private static final String ENCRYP_LABEL = "PFCselectENC";
    private static final String NET_ENCRYP_HELP_TOPIC = "TOPICanoEncryption";
    private EwtContainer tpanel;
    private LWChoice encrypSrvChoice;
    private CardLayout encrypCardLayout;
    private EwtContainer encrypDisplay;
    private NetEncrypParam[] encrypService = new NetEncrypParam[supportedEncrypSrv.length];
    private String[] netEncrypButton = new String[NET_ENCRYP_BUTTONS.length];
    private NLParamParser nlpa;
    NVPair encryp;
    private int invalidPanel;

    public NetEncryp() {
        int n = 0;
        while (n < NET_ENCRYP_BUTTONS.length) {
            this.netEncrypButton[n] = this.netStrings.getString(NET_ENCRYP_BUTTONS[n]);
            ++n;
        }
        this.encrypDisplay = new EwtContainer();
        this.encrypCardLayout = new CardLayout();
        this.encrypDisplay.setLayout(this.encrypCardLayout);
        this.encrypSrvChoice = new LWChoice();
        int n2 = 0;
        while (n2 < supportedEncrypSrv.length) {
            this.encrypSrvChoice.addItem(supportedEncrypSrv[n2]);
            this.encrypService[n2] = this.createEncryp(supportedEncrypSrv[n2]);
            this.encrypDisplay.add(supportedEncrypSrv[n2], (Component)((Object)this.encrypService[n2]));
            ++n2;
        }
        this.encrypSrvChoice.addItemListener((ItemListener)new 1());
        this.setBorderPainter((BorderPainter)new FixedBorderPainter(10, 10, 10, 10));
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        ((Container)((Object)this)).add((Component)new LWLabel(this.netStrings.getString(ENCRYP_LABEL), 1), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.left = 3;
        ((Container)((Object)this)).add((Component)this.encrypSrvChoice, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        ((Container)((Object)this)).add((Component)this.encrypDisplay, gridBagConstraints);
        String string = supportedEncrypSrv[0];
        this.devTrc("NetEncryp: displayEncryp():");
        this.encrypCardLayout.show((Container)this.encrypDisplay, string);
        this.encrypSrvChoice.select(string);
    }

    public void setNLP(NLParamParser nLParamParser) {
        this.devTrc("setting NLPA");
        this.nlpa = nLParamParser;
        int n = 0;
        while (n < supportedEncrypSrv.length) {
            this.encrypService[n].setNLP(this.nlpa);
            ++n;
        }
    }

    public boolean hasChanged() {
        int n = 0;
        while (n < supportedEncrypSrv.length) {
            if (this.encrypService[n].hasChanged()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void cacheIt() {
        this.devTrc("NetEncryp: cacheIt():");
        int n = 0;
        while (n < supportedEncrypSrv.length) {
            this.encrypService[n].cacheIt();
            ++n;
        }
    }

    public void refresh() {
        this.devTrc("NetEncryp: refresh():");
        int n = 0;
        while (n < supportedEncrypSrv.length) {
            this.encrypService[n].refresh();
            ++n;
        }
    }

    public NetButton createNetButton() {
        this.devTrc("NetEncryp: createNetButton()");
        NetButton netButton = new NetButton(this.netEncrypButton);
        netButton.addNetButtonListener(this);
        return netButton;
    }

    public void buttonPushed(String string) {
        this.devTrc("NetEncryp: buttonPushed()");
        if (string.equalsIgnoreCase(this.netEncrypButton[0])) {
            NetHelp netHelp = NetUtils.getHelpContext();
            netHelp.showTopic(NET_ENCRYP_HELP_TOPIC);
        }
    }

    public boolean areDataValid() {
        int n = 0;
        while (n < supportedEncrypSrv.length) {
            if (!this.encrypService[n].areDataValid()) {
                this.invalidPanel = n;
                return false;
            }
            ++n;
        }
        return true;
    }

    public void setFocus() {
        String string = supportedEncrypSrv[this.invalidPanel];
        this.devTrc("NetEncryp: displayEncryp():");
        this.encrypCardLayout.show((Container)this.encrypDisplay, string);
        this.encrypSrvChoice.select(string);
        this.encrypService[this.invalidPanel].setFocus();
    }

    private void displayEncryp(String string) {
        this.devTrc("NetEncryp: displayEncryp():");
        this.encrypCardLayout.show((Container)this.encrypDisplay, string);
        this.encrypSrvChoice.select(string);
    }

    private NetEncrypParam createEncryp(String string) {
        this.devTrc("NetEncryp: createEncryp():");
        if (string.equalsIgnoreCase(srvEncrypType)) {
            return new NetEncrypParam(srvEncrypType, srvEncrypParamName, srvEncrypParam);
        }
        if (string.equalsIgnoreCase(cliEncrypType)) {
            return new NetEncrypParam(cliEncrypType, cliEncrypParamName, cliEncrypParam);
        }
        return null;
    }

    private int chooseEncryp(String string) {
        this.devTrc("NetEncryp: chooseEncryp(String):");
        int n = 0;
        while (n < supportedEncrypSrv.length) {
            if (string.equalsIgnoreCase(supportedEncrypSrv[n])) break;
            ++n;
        }
        return n;
    }

    private int chooseEncryp(NVPair nVPair) {
        NVNavigator nVNavigator = new NVNavigator();
        NVPair nVPair2 = nVNavigator.findNVPair(nVPair, "Encryp Service");
        String string = nVPair2.getAtom();
        int n = 0;
        while (n < supportedEncrypSrv.length) {
            if (string.equalsIgnoreCase(supportedEncrypSrv[n])) break;
            ++n;
        }
        return n;
    }

    static /* synthetic */ LWChoice access$0(NetEncryp netEncryp) {
        return netEncryp.encrypSrvChoice;
    }

    static /* synthetic */ void access$1(NetEncryp netEncryp, String string) {
        netEncryp.devTrc("NetEncryp: displayEncryp():");
        netEncryp.encrypCardLayout.show((Container)netEncryp.encrypDisplay, string);
        netEncryp.encrypSrvChoice.select(string);
    }

    private final class 1
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            NetEncryp netEncryp = NetEncryp.this;
            Object object = NetEncryp.this;
            object = ((NetEncryp)object).encrypSrvChoice.getSelectedItem();
            netEncryp.devTrc("NetEncryp: displayEncryp():");
            netEncryp.encrypCardLayout.show((Container)netEncryp.encrypDisplay, (String)object);
            netEncryp.encrypSrvChoice.select((String)object);
        }

        /* synthetic */ 1() {
        }
    }
}

