/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.security;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.net.asst.container.NetHelp;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.profile.NetButton;
import oracle.net.asst.profile.NetButtonListener;
import oracle.net.asst.profile.NetLayout;
import oracle.net.asst.profile.ProfileCache;
import oracle.net.asst.security.NetIntegrityParam;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public class NetIntegrity
extends NetLayout
implements ProfileCache,
NetButtonListener {
    private final NetStrings netStrings = new NetStrings();
    private static final String[] supportedLocation = new String[]{"SERVER", "CLIENT"};
    private static final String srvIntegrityLocation = "SERVER";
    private static final String[] srvIntegrityParamName = new String[]{"Integrity Server"};
    private static final String[] srvIntegrityParam = new String[]{"sqlnet.crypto_checksum_server", "sqlnet.crypto_checksum_types_server"};
    private static final String cliIntegrityLocation = "CLIENT";
    private static final String[] cliIntegrityParamName = new String[]{"Integrity Client"};
    private static final String[] cliIntegrityParam = new String[]{"sqlnet.crypto_checksum_client", "sqlnet.crypto_checksum_types_client"};
    private static final String NET_INTEGRITY_HELP_TOPIC = "TOPICanoIntegrity";
    private static final String NET_INTEGRITY_LABEL = "PFCchksumANO";
    private static final String[] NET_INTEGRITY_BUTTONS = new String[]{"PFChelp"};
    private EwtContainer tpanel;
    private LWChoice integrityLocationChoice;
    private CardLayout integrityCardLayout;
    private EwtContainer integrityDisplay;
    private NetIntegrityParam[] integrityLocation = new NetIntegrityParam[supportedLocation.length];
    private String[] netIntegrityButton = new String[NET_INTEGRITY_BUTTONS.length];
    private NLParamParser nlpa;
    NVPair integrity;
    private int invalidPanel;

    public NetIntegrity() {
        int n = 0;
        while (n < NET_INTEGRITY_BUTTONS.length) {
            this.netIntegrityButton[n] = this.netStrings.getString(NET_INTEGRITY_BUTTONS[n]);
            ++n;
        }
        this.integrityDisplay = new EwtContainer();
        this.integrityCardLayout = new CardLayout();
        this.integrityDisplay.setLayout(this.integrityCardLayout);
        this.integrityLocationChoice = new LWChoice();
        int n2 = 0;
        while (n2 < supportedLocation.length) {
            this.integrityLocationChoice.addItem(supportedLocation[n2]);
            this.integrityLocation[n2] = this.createIntegrity(supportedLocation[n2]);
            this.integrityDisplay.add(supportedLocation[n2], (Component)((Object)this.integrityLocation[n2]));
            ++n2;
        }
        this.integrityLocationChoice.addItemListener((ItemListener)new 1());
        this.setBorderPainter((BorderPainter)new FixedBorderPainter(10, 10, 10, 10));
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        ((Container)((Object)this)).add((Component)new LWLabel(this.netStrings.getString(NET_INTEGRITY_LABEL), 1), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.left = 3;
        ((Container)((Object)this)).add((Component)this.integrityLocationChoice, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        ((Container)((Object)this)).add((Component)this.integrityDisplay, gridBagConstraints);
        String string = supportedLocation[0];
        this.devTrc("NetIntegrity: displayIntegrity():");
        this.integrityCardLayout.show((Container)this.integrityDisplay, string);
        this.integrityLocationChoice.select(string);
    }

    public void setNLP(NLParamParser nLParamParser) {
        this.devTrc("setting NLPA");
        this.nlpa = nLParamParser;
        int n = 0;
        while (n < supportedLocation.length) {
            this.integrityLocation[n].setNLP(this.nlpa);
            ++n;
        }
    }

    public boolean hasChanged() {
        int n = 0;
        while (n < supportedLocation.length) {
            if (this.integrityLocation[n].hasChanged()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void cacheIt() {
        this.devTrc("NetIntegrity: cacheIt():");
        int n = 0;
        while (n < supportedLocation.length) {
            this.integrityLocation[n].cacheIt();
            ++n;
        }
    }

    public void refresh() {
        this.devTrc("NetIntegrity: refresh():");
        int n = 0;
        while (n < supportedLocation.length) {
            this.integrityLocation[n].refresh();
            ++n;
        }
    }

    public NetButton createNetButton() {
        this.devTrc("NetIntegrity: createNetButton()");
        NetButton netButton = new NetButton(this.netIntegrityButton);
        netButton.addNetButtonListener(this);
        return netButton;
    }

    public void buttonPushed(String string) {
        this.devTrc("NetIntegrity: buttonPushed()");
        if (string.equalsIgnoreCase(this.netIntegrityButton[0])) {
            NetHelp netHelp = NetUtils.getHelpContext();
            netHelp.showTopic(NET_INTEGRITY_HELP_TOPIC);
        }
    }

    public boolean areDataValid() {
        int n = 0;
        while (n < supportedLocation.length) {
            if (!this.integrityLocation[n].areDataValid()) {
                this.invalidPanel = n;
                return false;
            }
            ++n;
        }
        return true;
    }

    public void setFocus() {
        String string = supportedLocation[this.invalidPanel];
        this.devTrc("NetIntegrity: displayIntegrity():");
        this.integrityCardLayout.show((Container)this.integrityDisplay, string);
        this.integrityLocationChoice.select(string);
        this.integrityLocation[this.invalidPanel].setFocus();
    }

    private void displayIntegrity(String string) {
        this.devTrc("NetIntegrity: displayIntegrity():");
        this.integrityCardLayout.show((Container)this.integrityDisplay, string);
        this.integrityLocationChoice.select(string);
    }

    private NetIntegrityParam createIntegrity(String string) {
        this.devTrc("NetIntegrity: createIntegrityParam():");
        if (string.equalsIgnoreCase(srvIntegrityLocation)) {
            return new NetIntegrityParam(srvIntegrityLocation, srvIntegrityParamName, srvIntegrityParam);
        }
        if (string.equalsIgnoreCase(cliIntegrityLocation)) {
            return new NetIntegrityParam(cliIntegrityLocation, cliIntegrityParamName, cliIntegrityParam);
        }
        return null;
    }

    private int chooseIntegrity(String string) {
        this.devTrc("NetIntegrity: chooseIntegrity(String):");
        int n = 0;
        while (n < supportedLocation.length) {
            if (string.equalsIgnoreCase(supportedLocation[n])) break;
            ++n;
        }
        return n;
    }

    private int chooseIntegrity(NVPair nVPair) {
        NVNavigator nVNavigator = new NVNavigator();
        NVPair nVPair2 = nVNavigator.findNVPair(nVPair, "Integrity Service");
        String string = nVPair2.getAtom();
        int n = 0;
        while (n < supportedLocation.length) {
            if (string.equalsIgnoreCase(supportedLocation[n])) break;
            ++n;
        }
        return n;
    }

    static /* synthetic */ LWChoice access$0(NetIntegrity netIntegrity) {
        return netIntegrity.integrityLocationChoice;
    }

    static /* synthetic */ void access$1(NetIntegrity netIntegrity, String string) {
        netIntegrity.devTrc("NetIntegrity: displayIntegrity():");
        netIntegrity.integrityCardLayout.show((Container)netIntegrity.integrityDisplay, string);
        netIntegrity.integrityLocationChoice.select(string);
    }

    private final class 1
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            NetIntegrity netIntegrity = NetIntegrity.this;
            Object object = NetIntegrity.this;
            object = ((NetIntegrity)object).integrityLocationChoice.getSelectedItem();
            netIntegrity.devTrc("NetIntegrity: displayIntegrity():");
            netIntegrity.integrityCardLayout.show((Container)netIntegrity.integrityDisplay, (String)object);
            netIntegrity.integrityLocationChoice.select((String)object);
        }

        /* synthetic */ 1() {
        }
    }
}

