/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.servicename;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import oracle.ewt.EwtContainer;
import oracle.ewt.layout.GroupBoxContainer;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.container.NetValidate;
import oracle.net.common.netObject.ConnectData;
import oracle.net.common.netObject.Description;

public class AdvancedDialog
extends BufferedDialog
implements ActionListener,
KeyListener {
    private static final String DEFAULT_SDU = "2048";
    private static final int HEIGHT = 300;
    private static final int WIDTH = 400;
    public static final int SERVICE_DISPLAY_MODE = 0;
    public static final int DBSERVICE_DISPLAY_MODE = 1;
    public static final int NETSERVICE_DISPLAY_MODE = 2;
    private int m_currentMode;
    private LWLabel tosLabel;
    private LWLabel inLabel;
    private LWLabel ohLabel;
    private LWLabel rdbLabel;
    private LWLabel sduLabel;
    private LWLabel gdbLabel;
    private String tosString;
    private String inString;
    private String ohString;
    private String rdbString;
    private String gdbString;
    private String sduString;
    private LWTextField tosField;
    private LWTextField inField;
    private LWTextField ohField;
    private LWTextField rdbField;
    private LWTextField gdbField;
    private LWTextField sduField;
    private LWCheckbox hsBox;
    private String hsString;
    private LWButton okButton;
    private LWButton cancelButton;
    private LWButton helpButton;
    private String okString;
    private String cancelString;
    private String helpString;
    private String titleString;
    private String sduDefaultString;
    private String serviceGroupString;
    private String rdbGroupString;
    private BufferedFrame m_frame;
    private GridBagLayout gbl;
    private GridBagConstraints gbc;
    private GroupBoxContainer servicePanelGroup;
    private GroupBoxContainer rdbPanelGroup;
    private EwtContainer mainPanel;
    private EwtContainer servicePanel;
    private EwtContainer rdbPanel;
    private EwtContainer buttonPanel;
    private boolean response;
    private boolean backCompat;
    private NetStrings netStrings;
    private Description m_description;
    private ConnectData m_connectData;
    private static final String netSvcHelpTopicString = "TOPICsnAdvanced";
    private static final String svcHelpTopicString = "TOPICsnAdvanced";
    private String tmptos;
    private String tmpin;
    private String tmprdb;
    private String tmpgdb;
    private String tmpsdu;
    private boolean tmphs;

    public AdvancedDialog(BufferedFrame bufferedFrame) {
        super((Frame)bufferedFrame, true);
        this.m_frame = bufferedFrame;
        this.netStrings = new NetStrings();
        this.cancelString = this.netStrings.getString("SNCCancel");
        this.helpString = this.netStrings.getString("SNCHelp");
        this.okString = this.netStrings.getString("SNCOK");
        this.sduString = this.netStrings.getString("SNCSDU");
        this.titleString = this.netStrings.getString("SNCAdvancedOptions");
        this.serviceGroupString = this.netStrings.getString("SNCAdvancedServiceGroup");
        this.rdbGroupString = this.netStrings.getString("SNCRDBGroup");
        this.hsString = this.netStrings.getString("SNCHService");
        this.inString = this.netStrings.getString("SNCInstanceName");
        this.gdbString = this.netStrings.getString("SNCGDB");
        this.rdbString = this.netStrings.getString("SNCRdbDatabase");
        this.tosString = this.netStrings.getString("SNCTypeOfService");
        Object[] objectArray = new Object[]{DEFAULT_SDU};
        this.sduDefaultString = MessageFormat.format(this.netStrings.getString("SNCSDUDefault"), objectArray);
        this.okButton = new LWButton(this.okString);
        this.okButton.setLeftmost(true);
        this.okButton.addActionListener((ActionListener)this);
        this.cancelButton = new LWButton(this.cancelString);
        this.cancelButton.setRightmost(true);
        this.cancelButton.addActionListener((ActionListener)this);
        this.helpButton = new LWButton(this.helpString);
        this.helpButton.setLeftmost(true);
        this.helpButton.setRightmost(true);
        this.helpButton.addActionListener((ActionListener)this);
        this.tosLabel = new LWLabel(this.tosString, 1);
        this.inLabel = new LWLabel(this.inString, 1);
        this.gdbLabel = new LWLabel(this.gdbString, 1);
        this.rdbLabel = new LWLabel(this.rdbString, 1);
        this.sduLabel = new LWLabel(this.sduString, 1);
        this.tosField = new LWTextField(15);
        this.inField = new LWTextField(15);
        this.rdbField = new LWTextField(15);
        this.gdbField = new LWTextField(15);
        this.sduField = new LWTextField(15);
        this.tosField.addKeyListener(this);
        this.inField.addKeyListener(this);
        this.gdbField.addKeyListener(this);
        this.rdbField.addKeyListener(this);
        this.sduField.addKeyListener(this);
        this.hsBox = new LWCheckbox(this.hsString);
        ((Dialog)((Object)this)).setTitle(this.titleString);
        ((Component)((Object)this)).setSize(400, 300);
        this.layoutPanels();
        this.setDisplayMode();
        this.setLayout(new BorderLayout());
        ((Container)((Object)this)).add((Component)this.mainPanel, "Center");
        ((Window)((Object)this)).pack();
        ((Window)((Object)this)).addWindowListener(new 1());
        ((Dialog)((Object)this)).setResizable(false);
    }

    private void layoutPanels() {
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.servicePanel = new EwtContainer();
        this.servicePanel.setBorderPainter((BorderPainter)new FixedBorderPainter(5, 5, 5, 5));
        this.servicePanel.setLayout(this.gbl);
        this.gbc.fill = 0;
        this.gbc.anchor = 17;
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.gbc.insets = new Insets(3, 5, 3, 5);
        this.servicePanel.add((Component)this.inLabel, this.gbc);
        this.gbc.gridy = 4;
        this.servicePanel.add((Component)this.sduLabel, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.gridy = 0;
        this.gbc.weightx = 2.0;
        this.gbc.fill = 2;
        this.gbc.insets = new Insets(3, 0, 3, 5);
        this.servicePanel.add((Component)this.inField, this.gbc);
        this.gbc.gridy = 4;
        this.servicePanel.add((Component)this.sduField, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 5;
        this.gbc.gridwidth = 2;
        this.gbc.weightx = 2.0;
        this.gbc.insets = new Insets(5, 5, 3, 5);
        this.gbc.gridy = 6;
        this.gbc.insets = new Insets(3, 5, 3, 5);
        this.servicePanel.add((Component)this.hsBox, this.gbc);
        this.rdbPanel = new EwtContainer();
        this.rdbPanel.setBorderPainter((BorderPainter)new FixedBorderPainter(5, 5, 5, 5));
        this.rdbPanel.setLayout(this.gbl);
        this.gbc.fill = 0;
        this.gbc.anchor = 17;
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.gbc.gridwidth = 1;
        this.gbc.insets = new Insets(3, 5, 3, 5);
        this.rdbPanel.add((Component)this.rdbLabel, this.gbc);
        ++this.gbc.gridy;
        this.rdbPanel.add((Component)this.tosLabel, this.gbc);
        ++this.gbc.gridy;
        this.rdbPanel.add((Component)this.gdbLabel, this.gbc);
        ++this.gbc.gridx;
        this.gbc.gridy = 0;
        this.gbc.weightx = 2.0;
        this.gbc.fill = 2;
        this.gbc.insets = new Insets(3, 0, 3, 5);
        this.rdbPanel.add((Component)this.rdbField, this.gbc);
        ++this.gbc.gridy;
        this.rdbPanel.add((Component)this.tosField, this.gbc);
        ++this.gbc.gridy;
        this.rdbPanel.add((Component)this.gdbField, this.gbc);
        this.buttonPanel = new EwtContainer();
        this.buttonPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.buttonPanel.add((Component)this.helpButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.right = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        this.buttonPanel.add((Component)this.okButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.right = 0;
        this.buttonPanel.add((Component)this.cancelButton, gridBagConstraints);
        this.mainPanel = new EwtContainer();
        this.mainPanel.setBorderPainter((BorderPainter)new FixedBorderPainter(10, 10, 10, 10));
        this.mainPanel.setLayout(this.gbl);
        this.gbc.fill = 2;
        this.gbc.anchor = 18;
        this.gbc.gridx = 0;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.gbc.gridy = 0;
        this.gbc.insets = new Insets(0, 0, 0, 0);
        this.servicePanelGroup = new GroupBoxContainer((Component)new LWLabel(this.serviceGroupString), (Component)this.servicePanel);
        this.mainPanel.add((Component)this.servicePanelGroup, this.gbc);
        this.gbc.gridy = 1;
        this.gbc.insets.top = 10;
        this.rdbPanelGroup = new GroupBoxContainer((Component)new LWLabel(this.rdbGroupString), (Component)this.rdbPanel);
        this.mainPanel.add((Component)this.rdbPanelGroup, this.gbc);
        this.gbc.gridy = 2;
        this.gbc.insets.top = 10;
        this.mainPanel.add((Component)this.buttonPanel, this.gbc);
    }

    public boolean areDataValid() {
        NetValidate netValidate;
        if (this.sduField.isEnabled() && !this.sduField.getText().equals("") && !(netValidate = new NetValidate(this.m_frame)).validateNumber(this.sduField, 1, Short.MAX_VALUE)) {
            netValidate.showDialog("Session Data Unit", 1, Short.MAX_VALUE);
            this.sduField.requestFocus();
            return false;
        }
        return true;
    }

    public boolean isChanged() {
        if (this.inField.isEnabled() && !this._compare(this.inField.getText(), this.m_connectData.getINSTANCE_NAME())) {
            return true;
        }
        if (this.sduField.isEnabled() && !this._compare(this.sduField.getText(), this.m_description.getSDU())) {
            return true;
        }
        if (this.rdbField.isEnabled() && !this._compare(this.rdbField.getText(), this.m_connectData.getRDB_DATABASE())) {
            return true;
        }
        if (this.gdbField.isEnabled() && !this._compare(this.gdbField.getText(), this.m_connectData.getGLOBAL_NAME())) {
            return true;
        }
        if (this.tosField.isEnabled() && !this._compare(this.tosField.getText(), this.m_description.getTYPE_OF_SERVICE())) {
            return true;
        }
        return this.hsBox.isEnabled() && this.hsBox.getState() != this.isAttribEnabled(this.m_description.getHService());
    }

    private boolean _compare(String string, String string2) {
        if (string == null) {
            return string2 == null || string2.equals("");
        }
        if (string2 == null) {
            return string == null || string.equals("");
        }
        return string.equals(string2);
    }

    public Description getDescription() {
        return this.m_description;
    }

    public void setDescription(Description description, int n) {
        this.m_currentMode = n;
        this.m_description = description;
        this.m_connectData = description.getConnectData();
        this.revert();
    }

    public void apply() {
        if (this.isChanged() && this.areDataValid()) {
            try {
                boolean bl;
                String string = null;
                string = this.inField.getText();
                if (string != null) {
                    this.m_connectData.setINSTANCE_NAME(string);
                }
                if ((string = this.sduField.getText()) != null) {
                    this.m_description.setSDU(string);
                }
                if ((string = this.rdbField.getText()) != null) {
                    this.m_connectData.setRDB_DATABASE(string);
                }
                if ((string = this.gdbField.getText()) != null) {
                    this.m_connectData.setGLOBAL_NAME(string);
                }
                if ((string = this.tosField.getText()) != null) {
                    this.m_description.setTYPE_OF_SERVICE(string);
                }
                if (bl = this.hsBox.getState()) {
                    this.m_description.setHService("OK");
                } else {
                    this.m_description.setHService("");
                }
            }
            catch (Exception exception) {
                System.err.println("AdvancedDialog.saveAddressInfo(): AttributeException during save." + exception);
            }
            this.saveTempValues();
        }
    }

    public void revert() {
        this.tosField.setText(this.m_description.getTYPE_OF_SERVICE());
        this.inField.setText(this.m_connectData.getINSTANCE_NAME());
        this.rdbField.setText(this.m_connectData.getRDB_DATABASE());
        this.gdbField.setText(this.m_connectData.getGLOBAL_NAME());
        this.sduField.setText(this.m_description.getSDU());
        this.hsBox.setState(this.isAttribEnabled(this.m_description.getHService()));
        this.setDisplayMode();
        this.saveTempValues();
    }

    public void setBackCompat(boolean bl) {
        this.backCompat = bl;
    }

    public void setVisible(boolean bl) {
        this.setDisplayMode();
        super.setVisible(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(this.okString)) {
            if (this.areDataValid()) {
                this.response = true;
                this.setVisible(false);
                this.saveTempValues();
                return;
            }
        } else {
            if (string.equals(this.helpString)) {
                if (this.m_currentMode == 2) {
                    NetUtils.getHelpContext().showTopic("TOPICsnAdvanced");
                    return;
                }
                NetUtils.getHelpContext().showTopic("TOPICsnAdvanced");
                return;
            }
            this.cancelDialog();
        }
    }

    protected void cancelDialog() {
        this.response = false;
        this.setVisible(false);
        this.restoreTempValues();
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        Component component = keyEvent.getComponent();
        char c = keyEvent.getKeyChar();
        LWTextField lWTextField = (LWTextField)component;
        lWTextField.getText();
        if (c == '\b') {
            return;
        }
        if (component == this.sduField && !Character.isDigit(c)) {
            keyEvent.setKeyChar('\u0000');
        }
    }

    private void setDisplayMode() {
        if (this.m_currentMode != 2) {
            this.tosField.setEnabled(false);
            this.rdbField.setEnabled(false);
            this.gdbField.setEnabled(false);
            this.hsBox.setEnabled(false);
            this.inField.setEnabled(!this.backCompat);
            return;
        }
        this.tosField.setEnabled(true);
        this.rdbField.setEnabled(true);
        this.gdbField.setEnabled(true);
        this.hsBox.setEnabled(true);
        this.inField.setEnabled(!this.backCompat);
    }

    private boolean isAttribEnabled(String string) {
        if (string == null) {
            return false;
        }
        return (string = string.toUpperCase()).equals("ON") || string.equals("YES") || string.equals("TRUE") || string.equals("OK") || string.equals("USE");
    }

    private void restoreTempValues() {
        this.tosField.setText(this.tmptos);
        this.inField.setText(this.tmpin);
        this.rdbField.setText(this.tmprdb);
        this.gdbField.setText(this.tmpgdb);
        this.sduField.setText(this.tmpsdu);
        this.hsBox.setState(this.tmphs);
    }

    private void saveTempValues() {
        this.tmptos = this.tosField.getText();
        this.tmpin = this.inField.getText();
        this.tmprdb = this.rdbField.getText();
        this.tmpgdb = this.gdbField.getText();
        this.tmpsdu = this.sduField.getText();
        this.tmphs = this.hsBox.getState();
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            AdvancedDialog.this.cancelDialog();
        }

        /* synthetic */ 1() {
        }
    }
}

