/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.servicename;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.container.NetValidate;
import oracle.net.asst.servicename.AdvancedDialog;
import oracle.net.common.netObject.ConnectData;
import oracle.net.common.netObject.Description;

public class DBPanel
extends EwtContainer
implements ItemListener,
FocusListener {
    public static final int SERVICE_DISPLAY_MODE = 0;
    public static final int DBSERVICE_DISPLAY_MODE = 1;
    public static final int NETSERVICE_DISPLAY_MODE = 2;
    private int m_currentMode;
    private NetStrings netStrings;
    private LWButton advButton;
    private String advancedString;
    private LWCheckbox backCompatBox;
    private String backCompatString;
    private LWLabel sidLabel;
    private LWTextField sidField;
    private LWLabel svcNameLabel;
    private LWTextField svcNameField;
    private LWLabel connTypeLabel;
    private LWChoice connTypeChoice;
    private String sidString;
    private String sidInitialString;
    private String svcNameString;
    private String connTypeString;
    private Description m_description;
    private ConnectData m_connectData;
    private GridBagConstraints gbc = new GridBagConstraints();
    private AdvancedDialog m_advDialog;
    private String connTypeDefault;
    private String connTypeDedicated;
    private String connTypeShared;

    public DBPanel() {
        this.netStrings = new NetStrings();
        this.advancedString = this.netStrings.getString("SNCAdvanced");
        this.sidString = this.netStrings.getString("SNCSID");
        this.sidInitialString = this.netStrings.getString("SNCSIDField");
        this.svcNameString = this.netStrings.getString("SNCServiceName");
        this.connTypeString = this.netStrings.getString("SNCConnType");
        this.backCompatString = this.netStrings.getString("SNCBackCompatServer");
        this.connTypeDefault = this.netStrings.getString("SNWSidPanCType");
        this.connTypeShared = this.netStrings.getString("SNWSidPanCTypeS");
        this.connTypeDedicated = this.netStrings.getString("SNWSidPanCTypeD");
        this.svcNameLabel = new LWLabel(this.svcNameString);
        this.svcNameField = new LWTextField();
        this.svcNameField.addFocusListener(this);
        this.sidLabel = new LWLabel(this.sidString);
        this.sidField = new LWTextField();
        this.sidField.addFocusListener(this);
        this.connTypeLabel = new LWLabel(this.connTypeString);
        this.connTypeChoice = new LWChoice();
        this.connTypeChoice.addItem(this.connTypeDefault);
        this.connTypeChoice.addItem(this.connTypeDedicated);
        this.connTypeChoice.addItem(this.connTypeShared);
        this.connTypeChoice.addFocusListener(this);
        this.connTypeChoice.select(0);
        this.backCompatBox = new LWCheckbox(this.backCompatString);
        this.backCompatBox.addFocusListener(this);
        this.backCompatBox.addItemListener((ItemListener)this);
        this.advButton = new LWButton(this.advancedString);
        this.advButton.setLeftmost(true);
        this.advButton.setRightmost(true);
        this.advButton.addActionListener((ActionListener)new 1());
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.weightx = 0.0;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(3, 0, 3, 5);
        ((Container)((Object)this)).add((Component)this.svcNameLabel, this.gbc);
        this.gbc.gridy = 1;
        ((Container)((Object)this)).add((Component)this.sidLabel, this.gbc);
        this.gbc.gridy = 2;
        ((Container)((Object)this)).add((Component)this.connTypeLabel, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.gridy = 0;
        this.gbc.weightx = 0.5;
        this.gbc.fill = 2;
        this.gbc.anchor = 17;
        ((Container)((Object)this)).add((Component)this.svcNameField, this.gbc);
        this.gbc.gridy = 1;
        ((Container)((Object)this)).add((Component)this.sidField, this.gbc);
        this.gbc.gridy = 2;
        ((Container)((Object)this)).add((Component)this.connTypeChoice, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridy = 0;
        this.gbc.weightx = 0.0;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 2;
        this.gbc.anchor = 13;
        this.gbc.fill = 0;
        this.gbc.insets = new Insets(0, 15, 0, 0);
        ((Container)((Object)this)).add((Component)this.advButton, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 3;
        this.gbc.gridwidth = 3;
        this.gbc.anchor = 16;
        this.gbc.insets = new Insets(7, 0, 0, 0);
        ((Container)((Object)this)).add((Component)this.backCompatBox, this.gbc);
    }

    public void setDescription(Description description, int n) {
        this.m_currentMode = n;
        this.m_description = description;
        this.m_connectData = description.getConnectData();
        this.revert();
        if (this.m_advDialog != null) {
            this.m_advDialog.setDescription(this.m_description, this.m_currentMode);
        }
    }

    public Description getDescription() {
        return this.m_description;
    }

    public boolean isChanged() {
        if (this.backCompatBox.getState() != this.m_connectData.isBackCompat()) {
            return true;
        }
        if (this.sidField.isEnabled() && !this.sidField.getText().equals(this.m_connectData.getSID())) {
            return true;
        }
        if (this.svcNameField.isEnabled() && !this.svcNameField.getText().equals(this.m_connectData.getSERVICE_NAME())) {
            return true;
        }
        String string = this.m_connectData.getSRVR();
        if (string == null) {
            string = "";
        }
        if (!this.getConnectionType().equalsIgnoreCase(string)) {
            return true;
        }
        return this.m_advDialog != null && this.m_advDialog.isChanged();
    }

    public boolean areDataValid() {
        NetValidate netValidate = new NetValidate((BufferedFrame)NetUtils.getApplication().getFrame());
        if (this.m_currentMode == 2) {
            if (this.backCompatBox.getState()) {
                if (!NetValidate.validateSID(this.sidField.getText())) {
                    netValidate.showDialog(this.sidString);
                    this.sidField.requestFocus();
                    return false;
                }
            } else if (!NetValidate.validateServiceName(this.svcNameField.getText())) {
                netValidate.showDialog(this.svcNameString);
                this.svcNameField.requestFocus();
                return false;
            }
        }
        return this.m_advDialog == null || this.m_advDialog.areDataValid();
    }

    public void apply() {
        if (!this.areDataValid()) {
            return;
        }
        if (this.isChanged()) {
            if (this.m_currentMode == 2) {
                String string = null;
                boolean bl = this.backCompatBox.getState();
                this.m_connectData.setBackCompat(bl);
                try {
                    if (bl) {
                        string = this.sidField.getText();
                        if (string != null) {
                            this.m_connectData.setSID(string);
                        }
                    } else {
                        string = this.svcNameField.getText();
                        if (string != null) {
                            this.m_connectData.setSERVICE_NAME(string);
                        }
                    }
                    this.m_connectData.setSRVR(this.getConnectionType());
                }
                catch (Exception exception) {
                    System.err.println("DBPanel.saveAddressInfo(): exception during save." + exception);
                }
            }
            if (this.m_advDialog != null && this.m_advDialog.isChanged()) {
                this.m_advDialog.apply();
            }
        }
    }

    public void revert() {
        this.svcNameField.setText(this.m_connectData.getSERVICE_NAME());
        this.sidField.setText(this.m_connectData.getSID());
        this.setConnectionType(this.m_connectData.getSRVR());
        this.backCompatBox.setState(this.m_connectData.isBackCompat());
        this.setDisplayMode();
        if (this.m_advDialog != null) {
            this.m_advDialog.revert();
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        Component[] componentArray = ((Container)((Object)this)).getComponents();
        int n = 0;
        while (n < componentArray.length) {
            componentArray[n].setEnabled(bl);
            ++n;
        }
        if (bl) {
            this.setDisplayMode();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.m_advDialog != null) {
            this.m_advDialog.setBackCompat(this.backCompatBox.getState());
        }
        this.setDisplayMode();
    }

    public void focusGained(FocusEvent focusEvent) {
        Component component = focusEvent.getComponent();
        if (component.equals(this.sidField)) {
            NetUtils.getApplication().showStatus(this.netStrings.getString("SNCSIDHelp"));
            return;
        }
        if (component.equals(this.svcNameField)) {
            NetUtils.getApplication().showStatus(this.netStrings.getString("SNCServiceNameHelp"));
            return;
        }
        if (component.equals(this.connTypeChoice)) {
            NetUtils.getApplication().showStatus(this.netStrings.getString("SNCConnTypeHelp"));
            return;
        }
        component.equals(this.backCompatBox);
    }

    public void focusLost(FocusEvent focusEvent) {
        NetUtils.getApplication().showStatus("");
    }

    private String getConnectionType() {
        String string = this.connTypeChoice.getSelectedItem();
        if (string.equals(this.connTypeShared)) {
            return "SHARED";
        }
        if (string.equals(this.connTypeDedicated)) {
            return "DEDICATED";
        }
        return "";
    }

    private void setConnectionType(String string) {
        if (string == null || string.equals("")) {
            this.connTypeChoice.select(this.connTypeDefault);
            return;
        }
        if ((string = string.toUpperCase()).equals("SHARED")) {
            this.connTypeChoice.select(this.connTypeShared);
            return;
        }
        if (string.equals("DEDICATED")) {
            this.connTypeChoice.select(this.connTypeDedicated);
            return;
        }
        this.connTypeChoice.select(this.connTypeDefault);
    }

    private void setDisplayMode() {
        if (this.m_currentMode != 2) {
            this.sidField.setEnabled(false);
            this.sidLabel.setEnabled(true);
            this.svcNameField.setEnabled(false);
            this.svcNameLabel.setEnabled(true);
            this.backCompatBox.setEnabled(false);
            return;
        }
        boolean bl = this.backCompatBox.getState();
        this.backCompatBox.setEnabled(true);
        this.sidField.setEnabled(bl);
        this.sidLabel.setEnabled(bl);
        this.svcNameField.setEnabled(!bl);
        this.svcNameLabel.setEnabled(!bl);
    }

    private void showAdvancedDialog() {
        if (this.m_advDialog == null) {
            this.m_advDialog = new AdvancedDialog((BufferedFrame)NetUtils.getApplication().getFrame());
            this.m_advDialog.setDescription(this.m_description, this.m_currentMode);
        }
        ((Dialog)((Object)this.m_advDialog)).setModal(true);
        this.m_advDialog.setBackCompat(this.backCompatBox.getState());
        NetUtils.centerDialog((Dialog)((Object)this.m_advDialog), (Component)((Object)this));
        this.m_advDialog.setVisible(true);
        if (System.getProperty("os.name", "INVALID_OS").startsWith("Windows")) {
            NetUtils.getApplication().getFrame().toFront();
        }
    }

    static /* synthetic */ void access$0(DBPanel dBPanel) {
        dBPanel.showAdvancedDialog();
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            DBPanel dBPanel = DBPanel.this;
            dBPanel.showAdvancedDialog();
        }

        /* synthetic */ 1() {
        }
    }
}

