/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.servicename;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.net.asst.addr.Address;
import oracle.net.asst.addr.CreateAddressException;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NullFieldMessage;
import oracle.net.asst.container.RangeErrorMessage;
import oracle.net.common.NetProperties;
import oracle.net.common.netObject.AddressList;
import oracle.net.nl.NVPair;
import oracle.sysman.emSDK.client.appContainer.WebApplication;

public class NetClientAddressPage
extends EwtContainer
implements ItemListener,
KeyListener,
FocusListener {
    String protocolString;
    String tcpString;
    String tcpsString;
    String spxString;
    String nmpString;
    String ipcString;
    String beqString;
    String hostString;
    String portString;
    String serviceString;
    String machineString;
    String pipeString;
    String keyString;
    String hostfieldString;
    String portfieldString;
    String servicefieldString;
    String machinefieldString;
    String pipefieldString;
    String keyfieldString;
    String currentChoice;
    boolean addrChanged = false;
    LWLabel protocolLabel;
    LWChoice protocolChoice;
    LWLabel hostLabel;
    LWLabel hostLabelTCPS;
    LWTextField hostField;
    LWTextField hostFieldTCPS;
    LWLabel blankLabel;
    LWLabel blankLabel1;
    LWLabel portLabel;
    LWLabel portLabelTCPS;
    LWTextField portField;
    LWTextField portFieldTCPS;
    LWLabel blankLabel2;
    LWLabel serviceLabel;
    LWTextField serviceField;
    LWLabel machineLabel;
    LWTextField machineField;
    LWLabel pipeLabel;
    LWTextField pipeField;
    LWLabel blankLabel4;
    LWLabel keyLabel;
    LWTextField keyField;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints gbc = new GridBagConstraints();
    NetStrings netStrings = new NetStrings();
    WebApplication app;
    private boolean enabled = true;

    public NetClientAddressPage(WebApplication webApplication) {
        this.protocolString = this.netStrings.getString("SNCProtocol");
        this.tcpString = this.netStrings.getString("SNCTCP");
        this.tcpsString = this.netStrings.getString("SNCTCPS");
        this.spxString = this.netStrings.getString("SNCSPX");
        this.nmpString = this.netStrings.getString("SNCNMP");
        this.ipcString = this.netStrings.getString("SNCIPC");
        this.beqString = new String("BEQ");
        this.hostString = this.netStrings.getString("SNCHost");
        this.portString = this.netStrings.getString("SNCPort");
        this.serviceString = this.netStrings.getString("SNCService");
        this.machineString = this.netStrings.getString("SNCMachine");
        this.pipeString = this.netStrings.getString("SNCPipe");
        this.keyString = this.netStrings.getString("SNCKey");
        this.hostfieldString = this.netStrings.getString("SNCHostField");
        this.portfieldString = this.netStrings.getString("SNCPortField");
        this.servicefieldString = this.netStrings.getString("SNCServiceField");
        this.machinefieldString = this.netStrings.getString("SNCMachineField");
        this.pipefieldString = this.netStrings.getString("SNCPipeField");
        this.keyfieldString = this.netStrings.getString("SNCKeyField");
        this.currentChoice = this.tcpString;
        this.app = webApplication;
        this.onCreatePage();
        this.initializePage();
    }

    protected void onCreatePage() {
        this.setBorderPainter((BorderPainter)new FixedBorderPainter(10, 10, 10, 10));
        ((Container)((Object)this)).setLayout(this.gbl);
        this.protocolLabel = new LWLabel(this.protocolString, 1);
        this.gbc.fill = 3;
        this.gbc.anchor = 17;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.add((Component)this.protocolLabel, this.gbl, this.gbc, 0, 0, 1, 1);
        this.protocolChoice = new LWChoice();
        this.protocolChoice.addItemListener((ItemListener)this);
        this.gbc.anchor = 18;
        this.gbc.fill = 0;
        this.gbc.ipadx = 25;
        this.gbc.weighty = 0.0;
        this.add((Component)this.protocolChoice, this.gbl, this.gbc, 1, 0, 1, 1);
        this.gbc.ipadx = 0;
        this.hostLabel = new LWLabel(this.hostString, 1);
        this.hostField = new LWTextField(15);
        this.hostField.addKeyListener(this);
        this.hostField.addFocusListener(this);
        this.blankLabel1 = new LWLabel("", 1);
        this.portLabel = new LWLabel(this.portString, 1);
        this.portField = new LWTextField(15);
        this.portField.addKeyListener(this);
        this.portField.addFocusListener(this);
        this.blankLabel2 = new LWLabel("", 1);
        this.addTCPLayout();
        this.hostLabelTCPS = new LWLabel(this.hostString, 1);
        this.hostFieldTCPS = new LWTextField(15);
        this.hostFieldTCPS.addKeyListener(this);
        this.hostFieldTCPS.addFocusListener(this);
        this.portLabelTCPS = new LWLabel(this.portString, 1);
        this.portFieldTCPS = new LWTextField(15);
        this.portFieldTCPS.addKeyListener(this);
        this.portFieldTCPS.addFocusListener(this);
        this.serviceLabel = new LWLabel(this.serviceString, 1);
        this.serviceField = new LWTextField(15);
        this.serviceField.addKeyListener(this);
        this.serviceField.addFocusListener(this);
        this.machineLabel = new LWLabel(this.machineString, 1);
        this.machineField = new LWTextField(15);
        this.machineField.addKeyListener(this);
        this.machineField.addFocusListener(this);
        this.pipeLabel = new LWLabel(this.pipeString, 1);
        this.pipeField = new LWTextField(15);
        this.pipeField.addKeyListener(this);
        this.pipeField.addFocusListener(this);
        this.keyLabel = new LWLabel(this.keyString, 1);
        this.keyField = new LWTextField(15);
        this.keyField.addKeyListener(this);
        this.keyField.addFocusListener(this);
    }

    protected void initializePage() {
        try {
            try {
                NetProperties netProperties = NetProperties.getInstance();
                String string = netProperties.getProperty("TCP");
                String string2 = netProperties.getProperty("TCPS");
                String string3 = netProperties.getProperty("SPX");
                String string4 = netProperties.getProperty("NMP");
                String string5 = netProperties.getProperty("IPC");
                String string6 = netProperties.getProperty("BEQ");
                if (string != null && string.toUpperCase().equals("YES")) {
                    this.protocolChoice.addItem(this.tcpString);
                }
                if (string2 != null && string2.toUpperCase().equals("YES")) {
                    this.protocolChoice.addItem(this.tcpsString);
                }
                if (string3 != null && string3.toUpperCase().equals("YES")) {
                    this.protocolChoice.addItem(this.spxString);
                }
                if (string4 != null && string4.toUpperCase().equals("YES")) {
                    this.protocolChoice.addItem(this.nmpString);
                }
                if (string5 != null && string5.toUpperCase().equals("YES")) {
                    this.protocolChoice.addItem(this.ipcString);
                }
                if (string6 != null && string6.toUpperCase().equals("YES")) {
                    this.protocolChoice.addItem(this.beqString);
                }
            }
            catch (Exception exception) {
                System.err.println(exception);
                this.protocolChoice.addItem(this.tcpString);
            }
            Object var2_9 = null;
        }
        catch (Throwable throwable) {
            Object var2_10 = null;
            this.protocolChoice.select(0);
            throw throwable;
        }
        this.protocolChoice.select(0);
    }

    public void setAddressInfo(Address address) {
        String string = address._getParameter("PROTOCOL");
        if (string.equalsIgnoreCase("TCP")) {
            this.setProtocolChoice(this.tcpString);
            if (this.currentChoice.equals(this.tcpsString)) {
                this.removeTCPSLayout();
                this.addTCPLayout();
            } else if (this.currentChoice.equals(this.spxString)) {
                this.removeSPXLayout();
                this.addTCPLayout();
            } else if (this.currentChoice.equals(this.nmpString)) {
                this.removeNMPLayout();
                this.addTCPLayout();
            } else if (this.currentChoice.equals(this.ipcString)) {
                this.removeIPCLayout();
                this.addTCPLayout();
            } else if (this.currentChoice.equals(this.beqString)) {
                ((Container)((Object)this)).remove((Component)this.blankLabel1);
                ((Container)((Object)this)).remove((Component)this.blankLabel2);
                this.addTCPLayout();
            }
            this.currentChoice = this.tcpString;
            this.setHost(address._getParameter("HOST"));
            this.setPort(address._getParameter("PORT"));
            return;
        }
        if (string.equalsIgnoreCase("TCPS")) {
            this.setProtocolChoice(this.tcpsString);
            if (this.currentChoice.equals(this.tcpString)) {
                this.removeTCPLayout();
                this.addTCPSLayout();
            } else if (this.currentChoice.equals(this.spxString)) {
                this.removeSPXLayout();
                this.addTCPSLayout();
            } else if (this.currentChoice.equals(this.nmpString)) {
                this.removeNMPLayout();
                this.addTCPSLayout();
            } else if (this.currentChoice.equals(this.ipcString)) {
                this.removeIPCLayout();
                this.addTCPSLayout();
            } else if (this.currentChoice.equals(this.beqString)) {
                ((Container)((Object)this)).remove((Component)this.blankLabel1);
                ((Container)((Object)this)).remove((Component)this.blankLabel2);
                this.addTCPSLayout();
            }
            this.currentChoice = this.tcpsString;
            this.setTCPSHost(address._getParameter("HOST"));
            this.setTCPSPort(address._getParameter("PORT"));
            return;
        }
        if (string.equalsIgnoreCase("NMP")) {
            this.setProtocolChoice(this.nmpString);
            if (this.currentChoice.equals(this.spxString)) {
                this.removeSPXLayout();
                this.addNMPLayout();
            } else if (this.currentChoice.equals(this.tcpsString)) {
                this.removeTCPSLayout();
                this.addNMPLayout();
            } else if (this.currentChoice.equals(this.tcpString)) {
                this.removeTCPLayout();
                this.addNMPLayout();
            } else if (this.currentChoice.equals(this.ipcString)) {
                this.removeIPCLayout();
                this.addNMPLayout();
            } else if (this.currentChoice.equals(this.beqString)) {
                ((Container)((Object)this)).remove((Component)this.blankLabel1);
                ((Container)((Object)this)).remove((Component)this.blankLabel2);
                this.addNMPLayout();
            }
            this.currentChoice = this.nmpString;
            this.setMachine(address._getParameter("Server"));
            this.setPipe(address._getParameter("Pipe"));
            return;
        }
        if (string.equalsIgnoreCase("SPX")) {
            this.setProtocolChoice(this.spxString);
            if (this.currentChoice.equals(this.tcpString)) {
                this.removeTCPLayout();
                this.addSPXLayout();
            } else if (this.currentChoice.equals(this.tcpsString)) {
                this.removeTCPSLayout();
                this.addSPXLayout();
            } else if (this.currentChoice.equals(this.nmpString)) {
                this.removeNMPLayout();
                this.addSPXLayout();
            } else if (this.currentChoice.equals(this.ipcString)) {
                this.removeIPCLayout();
                this.addSPXLayout();
            } else if (this.currentChoice.equals(this.beqString)) {
                ((Container)((Object)this)).remove((Component)this.blankLabel1);
                ((Container)((Object)this)).remove((Component)this.blankLabel2);
                this.addSPXLayout();
            }
            this.setService(address._getParameter("Service"));
            this.currentChoice = this.spxString;
            return;
        }
        if (string.equalsIgnoreCase("IPC")) {
            this.setProtocolChoice(this.ipcString);
            if (this.currentChoice.equals(this.tcpString)) {
                this.removeTCPLayout();
                this.addIPCLayout();
            } else if (this.currentChoice.equals(this.tcpsString)) {
                this.removeTCPSLayout();
                this.addIPCLayout();
            } else if (this.currentChoice.equals(this.nmpString)) {
                this.removeNMPLayout();
                this.addIPCLayout();
            } else if (this.currentChoice.equals(this.spxString)) {
                this.removeSPXLayout();
                this.addIPCLayout();
            } else if (this.currentChoice.equals(this.beqString)) {
                ((Container)((Object)this)).remove((Component)this.blankLabel1);
                ((Container)((Object)this)).remove((Component)this.blankLabel2);
                this.addIPCLayout();
            }
            this.setKey(address._getParameter("Key"));
            this.currentChoice = this.ipcString;
            return;
        }
        if (string.equalsIgnoreCase("BEQ")) {
            this.setProtocolChoice(this.beqString);
            if (this.currentChoice.equals(this.tcpString)) {
                this.removeTCPLayout();
                this.addBEQLayout();
            } else if (this.currentChoice.equals(this.tcpsString)) {
                this.removeTCPSLayout();
                this.addIPCLayout();
            } else if (this.currentChoice.equals(this.nmpString)) {
                this.removeNMPLayout();
                this.addBEQLayout();
            } else if (this.currentChoice.equals(this.spxString)) {
                this.removeSPXLayout();
                this.addBEQLayout();
            } else if (this.currentChoice.equals(this.ipcString)) {
                this.removeIPCLayout();
                this.addBEQLayout();
            }
            this.currentChoice = this.beqString;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.addrChanged = true;
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        Component component = keyEvent.getComponent();
        this.addrChanged = true;
        char c = keyEvent.getKeyChar();
        LWTextField lWTextField = (LWTextField)component;
        String string = lWTextField.getText();
        if (component.equals(this.portField) || component.equals(this.portFieldTCPS)) {
            if (c == '\b') {
                return;
            }
            if (string.length() < 5 && Character.isDigit(c)) {
                return;
            }
            keyEvent.setKeyChar('\u0000');
        }
        if (component.equals(this.hostField) || component.equals(this.hostFieldTCPS) || component.equals(this.serviceField) || component.equals(this.machineField) || component.equals(this.pipeField) || component.equals(this.keyField)) {
            if (Character.isLetterOrDigit(c) || c == '-' || c == '_') {
                return;
            }
            if (component.equals(this.hostField) && c == '.') {
                return;
            }
            if (c == '\b') {
                return;
            }
            keyEvent.setKeyChar('\u0000');
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        Component component = focusEvent.getComponent();
        if (component.equals(this.hostFieldTCPS) || component.equals(this.hostField)) {
            this.app.showStatus(this.netStrings.getString("SNCHostHelp"));
            return;
        }
        if (component.equals(this.portFieldTCPS) || component.equals(this.portField)) {
            this.app.showStatus(this.netStrings.getString("SNCPortHelp"));
            return;
        }
        if (component.equals(this.serviceField)) {
            this.app.showStatus(this.netStrings.getString("SNCServiceHelp"));
            return;
        }
        if (component.equals(this.machineField)) {
            this.app.showStatus(this.netStrings.getString("SNCMachineHelp"));
            return;
        }
        if (component.equals(this.pipeField)) {
            this.app.showStatus(this.netStrings.getString("SNCPipeHelp"));
            return;
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        this.app.showStatus("");
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.addrChanged = true;
        String string = itemEvent.getItem().toString();
        if (string.equals(this.tcpString)) {
            if (this.currentChoice.equals(this.tcpString)) {
                return;
            }
            if (this.currentChoice.equals(this.spxString)) {
                this.removeSPXLayout();
            } else if (this.currentChoice.equals(this.tcpsString)) {
                this.removeTCPSLayout();
            } else if (this.currentChoice.equals(this.nmpString)) {
                this.removeNMPLayout();
            } else if (this.currentChoice.equals(this.ipcString)) {
                this.removeIPCLayout();
            } else {
                ((Container)((Object)this)).remove((Component)this.blankLabel1);
                ((Container)((Object)this)).remove((Component)this.blankLabel2);
            }
            this.addTCPLayout();
            this.currentChoice = this.tcpString;
        } else if (string.equals(this.tcpsString)) {
            if (this.currentChoice.equals(this.tcpsString)) {
                return;
            }
            if (this.currentChoice.equals(this.tcpString)) {
                this.removeTCPLayout();
            } else if (this.currentChoice.equals(this.spxString)) {
                this.removeSPXLayout();
            } else if (this.currentChoice.equals(this.tcpsString)) {
                this.removeTCPSLayout();
            } else if (this.currentChoice.equals(this.nmpString)) {
                this.removeNMPLayout();
            } else if (this.currentChoice.equals(this.ipcString)) {
                this.removeIPCLayout();
            } else {
                ((Container)((Object)this)).remove((Component)this.blankLabel1);
                ((Container)((Object)this)).remove((Component)this.blankLabel2);
            }
            this.addTCPSLayout();
            this.currentChoice = this.tcpsString;
        } else if (string.equals(this.spxString)) {
            if (this.currentChoice.equals(this.spxString)) {
                return;
            }
            if (this.currentChoice.equals(this.tcpString)) {
                this.removeTCPLayout();
            } else if (this.currentChoice.equals(this.tcpsString)) {
                this.removeTCPSLayout();
            } else if (this.currentChoice.equals(this.nmpString)) {
                this.removeNMPLayout();
            } else if (this.currentChoice.equals(this.ipcString)) {
                this.removeIPCLayout();
            } else {
                ((Container)((Object)this)).remove((Component)this.blankLabel1);
                ((Container)((Object)this)).remove((Component)this.blankLabel2);
            }
            this.addSPXLayout();
            this.currentChoice = this.spxString;
        } else if (string.equals(this.nmpString)) {
            if (this.currentChoice.equals(this.nmpString)) {
                return;
            }
            if (this.currentChoice.equals(this.tcpString)) {
                this.removeTCPLayout();
            } else if (this.currentChoice.equals(this.tcpsString)) {
                this.removeTCPSLayout();
            } else if (this.currentChoice.equals(this.spxString)) {
                this.removeSPXLayout();
            } else if (this.currentChoice.equals(this.ipcString)) {
                this.removeIPCLayout();
            } else {
                ((Container)((Object)this)).remove((Component)this.blankLabel1);
                ((Container)((Object)this)).remove((Component)this.blankLabel2);
            }
            this.addNMPLayout();
            this.currentChoice = this.nmpString;
        } else if (string.equals(this.ipcString)) {
            if (this.currentChoice.equals(this.ipcString)) {
                return;
            }
            if (this.currentChoice.equals(this.tcpString)) {
                this.removeTCPLayout();
            } else if (this.currentChoice.equals(this.tcpsString)) {
                this.removeTCPSLayout();
            } else if (this.currentChoice.equals(this.spxString)) {
                this.removeSPXLayout();
            } else if (this.currentChoice.equals(this.nmpString)) {
                this.removeNMPLayout();
            } else {
                ((Container)((Object)this)).remove((Component)this.blankLabel1);
                ((Container)((Object)this)).remove((Component)this.blankLabel2);
            }
            this.addIPCLayout();
            this.currentChoice = this.ipcString;
        } else {
            if (this.currentChoice.equals(this.beqString)) {
                return;
            }
            if (this.currentChoice.equals(this.tcpString)) {
                this.removeTCPLayout();
            } else if (this.currentChoice.equals(this.tcpsString)) {
                this.removeTCPSLayout();
            } else if (this.currentChoice.equals(this.spxString)) {
                this.removeSPXLayout();
            } else if (this.currentChoice.equals(this.nmpString)) {
                this.removeNMPLayout();
            } else {
                this.removeIPCLayout();
            }
            this.addBEQLayout();
            this.currentChoice = this.beqString;
        }
        this.doLayout();
    }

    public void saveAddressInfo(AddressList addressList) {
        String string = this.getProtocolChoice();
        NVPair nVPair = new NVPair("ADDRESS");
        try {
            Address address = new Address(nVPair);
            if (string.equals(this.tcpString)) {
                address._setParameter("PROTOCOL", "TCP");
                address._setParameter("HOST", this.getHost());
                address._setParameter("PORT", this.getPort());
            } else if (string.equals(this.tcpsString)) {
                address._setParameter("PROTOCOL", "TCPS");
                address._setParameter("HOST", this.getTCPSHost());
                address._setParameter("PORT", this.getTCPSPort());
            } else if (string.equals(this.spxString)) {
                address._setParameter("PROTOCOL", "SPX");
                address._setParameter("Service", this.getService());
            } else if (string.equals(this.nmpString)) {
                address._setParameter("PROTOCOL", "NMP");
                address._setParameter("Server", this.getMachine());
                address._setParameter("Pipe", this.getPipe());
            } else if (string.equals(this.ipcString)) {
                address._setParameter("PROTOCOL", "IPC");
                address._setParameter("Key", this.getKey());
            } else {
                address._setParameter("PROTOCOL", "BEQ");
                address._setParameter("PROGRAM", "oracle80");
                address._setParameter("ARGV0", "oracle80");
                address._setParameter("ARGS", "'(DESCRIPTION=(LOCAL=YES)(ADDRESS=(PROTOCOL=BEQ)))'");
            }
            addressList.addAddress(address);
            this.addrChanged = false;
            return;
        }
        catch (CreateAddressException createAddressException) {
            return;
        }
    }

    public String getProtocolChoice() {
        return this.currentChoice;
    }

    public void setProtocolChoice(String string) {
        this.protocolChoice.select(string);
    }

    public String getHost() {
        return this.hostField.getText();
    }

    public void setHost(String string) {
        this.hostField.setText(string);
    }

    public String getPort() {
        return this.portField.getText();
    }

    public void setPort(String string) {
        this.portField.setText(string);
    }

    public String getTCPSHost() {
        return this.hostFieldTCPS.getText();
    }

    public void setTCPSHost(String string) {
        this.hostFieldTCPS.setText(string);
    }

    public String getTCPSPort() {
        return this.portFieldTCPS.getText();
    }

    public void setTCPSPort(String string) {
        this.portFieldTCPS.setText(string);
    }

    public String getService() {
        return this.serviceField.getText();
    }

    public void setService(String string) {
        this.serviceField.setText(string);
    }

    public String getMachine() {
        return this.machineField.getText();
    }

    public void setMachine(String string) {
        this.machineField.setText(string);
    }

    public String getPipe() {
        return this.pipeField.getText();
    }

    public void setPipe(String string) {
        this.pipeField.setText(string);
    }

    public String getKey() {
        return this.keyField.getText();
    }

    public void setKey(String string) {
        this.keyField.setText(string);
    }

    public boolean getChanged() {
        return this.addrChanged;
    }

    public void setChanged(boolean bl) {
        this.addrChanged = bl;
    }

    private void add(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        ((Container)((Object)this)).add(component);
    }

    private void addTCPLayout() {
        this.gbc.fill = 3;
        this.gbc.anchor = 17;
        this.gbc.weightx = 100.0;
        this.gbc.weighty = 0.0;
        this.add((Component)this.hostLabel, this.gbl, this.gbc, 0, 2, 1, 1);
        this.gbc.fill = 3;
        this.gbc.anchor = 17;
        this.gbc.weightx = 100.0;
        this.add((Component)this.hostField, this.gbl, this.gbc, 1, 2, 1, 1);
        this.add((Component)this.blankLabel1, this.gbl, this.gbc, 0, 3, 1, 1);
        this.gbc.fill = 3;
        this.gbc.anchor = 17;
        this.gbc.weighty = 0.0;
        this.add((Component)this.portLabel, this.gbl, this.gbc, 0, 4, 1, 1);
        this.gbc.fill = 3;
        this.gbc.anchor = 17;
        this.gbc.weightx = 100.0;
        this.add((Component)this.portField, this.gbl, this.gbc, 1, 4, 1, 1);
        this.add((Component)this.blankLabel2, this.gbl, this.gbc, 0, 5, 1, 1);
    }

    private void addTCPSLayout() {
        this.gbc.fill = 3;
        this.gbc.anchor = 17;
        this.gbc.weightx = 100.0;
        this.gbc.weighty = 0.0;
        this.add((Component)this.hostLabelTCPS, this.gbl, this.gbc, 0, 2, 1, 1);
        this.gbc.fill = 3;
        this.gbc.anchor = 17;
        this.gbc.weightx = 100.0;
        this.add((Component)this.hostFieldTCPS, this.gbl, this.gbc, 1, 2, 1, 1);
        this.add((Component)this.blankLabel1, this.gbl, this.gbc, 0, 3, 1, 1);
        this.gbc.fill = 3;
        this.gbc.anchor = 17;
        this.gbc.weighty = 0.0;
        this.add((Component)this.portLabelTCPS, this.gbl, this.gbc, 0, 4, 1, 1);
        this.gbc.fill = 3;
        this.gbc.anchor = 17;
        this.gbc.weightx = 100.0;
        this.add((Component)this.portFieldTCPS, this.gbl, this.gbc, 1, 4, 1, 1);
        this.add((Component)this.blankLabel2, this.gbl, this.gbc, 0, 5, 1, 1);
    }

    private void addSPXLayout() {
        this.add((Component)this.blankLabel1, this.gbl, this.gbc, 0, 2, 1, 1);
        this.gbc.fill = 3;
        this.gbc.anchor = 17;
        this.gbc.weightx = 100.0;
        this.gbc.weighty = 0.0;
        this.add((Component)this.serviceLabel, this.gbl, this.gbc, 0, 3, 1, 1);
        this.gbc.fill = 3;
        this.gbc.anchor = 17;
        this.gbc.weightx = 100.0;
        this.add((Component)this.serviceField, this.gbl, this.gbc, 1, 3, 1, 1);
        this.add((Component)this.blankLabel2, this.gbl, this.gbc, 0, 4, 1, 1);
    }

    private void addNMPLayout() {
        this.gbc.fill = 3;
        this.gbc.anchor = 17;
        this.gbc.weightx = 100.0;
        this.gbc.weighty = 0.0;
        this.add((Component)this.machineLabel, this.gbl, this.gbc, 0, 2, 1, 1);
        this.gbc.fill = 3;
        this.gbc.anchor = 17;
        this.gbc.weightx = 100.0;
        this.add((Component)this.machineField, this.gbl, this.gbc, 1, 2, 1, 1);
        this.add((Component)this.blankLabel1, this.gbl, this.gbc, 0, 3, 1, 1);
        this.gbc.fill = 3;
        this.gbc.anchor = 17;
        this.gbc.weighty = 0.0;
        this.add((Component)this.pipeLabel, this.gbl, this.gbc, 0, 4, 1, 1);
        this.gbc.fill = 3;
        this.gbc.anchor = 17;
        this.gbc.weightx = 100.0;
        this.add((Component)this.pipeField, this.gbl, this.gbc, 1, 4, 1, 1);
        this.add((Component)this.blankLabel2, this.gbl, this.gbc, 0, 5, 1, 1);
    }

    private void addIPCLayout() {
        this.add((Component)this.blankLabel1, this.gbl, this.gbc, 0, 2, 1, 1);
        this.gbc.fill = 3;
        this.gbc.anchor = 17;
        this.gbc.weightx = 100.0;
        this.gbc.weighty = 0.0;
        this.add((Component)this.keyLabel, this.gbl, this.gbc, 0, 3, 1, 1);
        this.gbc.fill = 3;
        this.gbc.anchor = 17;
        this.gbc.weightx = 100.0;
        this.add((Component)this.keyField, this.gbl, this.gbc, 1, 3, 1, 1);
        this.add((Component)this.blankLabel2, this.gbl, this.gbc, 0, 4, 1, 1);
    }

    private void addBEQLayout() {
        this.gbc.fill = 3;
        this.gbc.anchor = 17;
        this.gbc.weightx = 100.0;
        this.add((Component)this.blankLabel1, this.gbl, this.gbc, 0, 2, 1, 1);
        this.add((Component)this.blankLabel2, this.gbl, this.gbc, 0, 4, 1, 1);
    }

    private void removeSPXLayout() {
        ((Container)((Object)this)).remove((Component)this.blankLabel1);
        ((Container)((Object)this)).remove((Component)this.serviceLabel);
        ((Container)((Object)this)).remove((Component)this.serviceField);
        ((Container)((Object)this)).remove((Component)this.blankLabel2);
    }

    private void removeNMPLayout() {
        ((Container)((Object)this)).remove((Component)this.machineLabel);
        ((Container)((Object)this)).remove((Component)this.machineField);
        ((Container)((Object)this)).remove((Component)this.blankLabel1);
        ((Container)((Object)this)).remove((Component)this.pipeLabel);
        ((Container)((Object)this)).remove((Component)this.pipeField);
        ((Container)((Object)this)).remove((Component)this.blankLabel2);
    }

    private void removeTCPLayout() {
        ((Container)((Object)this)).remove((Component)this.hostLabel);
        ((Container)((Object)this)).remove((Component)this.hostField);
        ((Container)((Object)this)).remove((Component)this.blankLabel1);
        ((Container)((Object)this)).remove((Component)this.portLabel);
        ((Container)((Object)this)).remove((Component)this.portField);
        ((Container)((Object)this)).remove((Component)this.blankLabel2);
    }

    private void removeTCPSLayout() {
        ((Container)((Object)this)).remove((Component)this.hostLabelTCPS);
        ((Container)((Object)this)).remove((Component)this.hostFieldTCPS);
        ((Container)((Object)this)).remove((Component)this.blankLabel1);
        ((Container)((Object)this)).remove((Component)this.portLabelTCPS);
        ((Container)((Object)this)).remove((Component)this.portFieldTCPS);
        ((Container)((Object)this)).remove((Component)this.blankLabel2);
    }

    private void removeIPCLayout() {
        ((Container)((Object)this)).remove((Component)this.blankLabel1);
        ((Container)((Object)this)).remove((Component)this.keyLabel);
        ((Container)((Object)this)).remove((Component)this.keyField);
        ((Container)((Object)this)).remove((Component)this.blankLabel2);
    }

    private void removeBEQLayout() {
        ((Container)((Object)this)).remove((Component)this.blankLabel1);
        ((Container)((Object)this)).remove((Component)this.blankLabel2);
    }

    public boolean checkFields() {
        if (this.currentChoice.equals(this.tcpString)) {
            if (this.hostField.getText().equals("")) {
                String string = this.hostfieldString;
                NullFieldMessage.display((Component)((Object)this), string);
                this.hostField.requestFocus();
                return false;
            }
            String string = this.portField.getText();
            if (string.equals("")) {
                String string2 = this.portfieldString;
                NullFieldMessage.display((Component)((Object)this), string2);
                this.portField.requestFocus();
                return false;
            }
            int n = Integer.parseInt(string, 10);
            if (n < 1 || n > 65535) {
                String string3 = this.portfieldString;
                RangeErrorMessage.display((Component)((Object)this), string3, 1, 65535);
                this.portField.requestFocus();
                return false;
            }
        } else if (this.currentChoice.equals(this.tcpsString)) {
            if (this.hostFieldTCPS.getText().equals("")) {
                String string = this.hostfieldString;
                NullFieldMessage.display((Component)((Object)this), string);
                this.hostFieldTCPS.requestFocus();
                return false;
            }
            String string = this.portFieldTCPS.getText();
            if (string.equals("")) {
                String string4 = this.portfieldString;
                NullFieldMessage.display((Component)((Object)this), string4);
                this.portFieldTCPS.requestFocus();
                return false;
            }
            int n = Integer.parseInt(string, 10);
            if (n < 1 || n > 65535) {
                String string5 = this.portfieldString;
                RangeErrorMessage.display((Component)((Object)this), string5, 1, 65535);
                this.portFieldTCPS.requestFocus();
                return false;
            }
        } else if (this.currentChoice.equals(this.spxString)) {
            if (this.serviceField.getText().equals("")) {
                String string = this.servicefieldString;
                NullFieldMessage.display((Component)((Object)this), string);
                this.serviceField.requestFocus();
                return false;
            }
        } else if (this.currentChoice.equals(this.nmpString)) {
            if (this.machineField.getText().equals("")) {
                String string = this.machinefieldString;
                NullFieldMessage.display((Component)((Object)this), string);
                this.machineField.requestFocus();
                return false;
            }
            if (this.pipeField.getText().equals("")) {
                String string = this.pipefieldString;
                NullFieldMessage.display((Component)((Object)this), string);
                this.pipeField.requestFocus();
                return false;
            }
        } else if (this.currentChoice.equals(this.ipcString) && this.keyField.getText().equals("")) {
            String string = this.keyfieldString;
            NullFieldMessage.display((Component)((Object)this), string);
            this.keyField.requestFocus();
            return false;
        }
        return true;
    }

    public void setEnabled(boolean bl) {
        if (this.enabled == bl) {
            return;
        }
        this.enabled = bl;
        super.setEnabled(bl);
        Component[] componentArray = ((Container)((Object)this)).getComponents();
        int n = 0;
        while (n < componentArray.length) {
            componentArray[n].setEnabled(bl);
            ++n;
        }
    }

    private void showNullDialog(String string) {
        NullFieldMessage.display((Component)((Object)this), string);
    }

    private void showRangeDialog(String string, int n, int n2) {
        RangeErrorMessage.display((Component)((Object)this), string, n, n2);
    }
}

