/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.servicewizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.textWrapper.TextWrapper;
import oracle.net.asst.addr.Address;
import oracle.net.asst.addr.AddressFactory;
import oracle.net.asst.addr.CreateAddressException;
import oracle.net.asst.addr.NMPAddress;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.servicewizard.EditTextField;
import oracle.net.asst.servicewizard.GenericWizardPanel;
import oracle.net.asst.uniword.UniWordWrapper;

public class NMPWizardPanel
extends GenericWizardPanel
implements KeyListener {
    public static final String DEFAULT_PIPE = new String("ORAPIPE");
    private EditTextField m_serverField;
    private EditTextField m_pipeField;

    public NMPWizardPanel(NetStrings netStrings) {
        super(netStrings);
        this.setImage("images/protocol.gif");
        this.m_contentPanel.setBorderPainter((BorderPainter)new FixedBorderPainter(10, 10, 10, 10));
        LWLabel lWLabel = new LWLabel(this.m_netStrings.getString("SNWNMPPanTitle"));
        TextWrapper textWrapper = UniWordWrapper.getTextWrapper();
        MultiLineLabel multiLineLabel = new MultiLineLabel(textWrapper, this.m_netStrings.getString("SNWNMPPanServerMsg"));
        multiLineLabel.setAlignment(1);
        MultiLineLabel multiLineLabel2 = new MultiLineLabel(textWrapper, this.m_netStrings.getString("SNWNMPPanPipeMsg"));
        multiLineLabel2.setAlignment(1);
        LWLabel lWLabel2 = new LWLabel(this.m_netStrings.getString("SNWNMPPanServerLbl"));
        LWLabel lWLabel3 = new LWLabel(this.m_netStrings.getString("SNWNMPPanPipeLbl"));
        this.m_serverField = new EditTextField("");
        this.m_pipeField = new EditTextField(DEFAULT_PIPE);
        ((Component)((Object)this.m_serverField)).addKeyListener(this);
        ((Component)((Object)this.m_pipeField)).addKeyListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.m_contentPanel.setLayout(gridBagLayout);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.m_contentPanel.add((Component)lWLabel);
        gridBagLayout.setConstraints((Component)lWLabel, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.m_contentPanel.add((Component)multiLineLabel);
        gridBagLayout.setConstraints((Component)multiLineLabel, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.m_contentPanel.add((Component)multiLineLabel2);
        gridBagLayout.setConstraints((Component)multiLineLabel2, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 2;
        this.m_contentPanel.add((Component)lWLabel2);
        gridBagLayout.setConstraints((Component)lWLabel2, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        this.m_contentPanel.add((Component)lWLabel3);
        gridBagLayout.setConstraints((Component)lWLabel3, gridBagConstraints);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.25;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.m_contentPanel.add((Component)((Object)this.m_serverField));
        gridBagLayout.setConstraints((Component)((Object)this.m_serverField), gridBagConstraints);
        gridBagConstraints.gridy = 4;
        this.m_contentPanel.add((Component)((Object)this.m_pipeField));
        gridBagLayout.setConstraints((Component)((Object)this.m_pipeField), gridBagConstraints);
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        Component component = keyEvent.getComponent();
        char c = keyEvent.getKeyChar();
        if (component.equals(this.m_serverField) || component.equals(this.m_pipeField)) {
            if (Character.isLetterOrDigit(c) || c == '-' || c == '_') {
                return;
            }
            if (c == '\b') {
                return;
            }
            keyEvent.setKeyChar('\u0000');
        }
    }

    public boolean areDataValid() {
        return !this.m_serverField.getText().equals("") && !this.m_pipeField.getText().equals("");
    }

    public void setParams(Address address) {
        if (address != null) {
            this.m_serverField.setText(address._getParameter("SERVER"));
            this.m_pipeField.setText(address._getParameter("PIPE"));
            return;
        }
        this.m_serverField.setText("");
        this.m_pipeField.setText(DEFAULT_PIPE);
    }

    public Component getFocusComponent() {
        return this.m_serverField;
    }

    public Address getAddress() throws CreateAddressException {
        AddressFactory addressFactory = AddressFactory.getFactory();
        String string = "(ADDRESS=(PROTOCOL=" + NMPAddress.NMP_PROTOCOL + ")" + "(SERVER=" + this.m_serverField.getText() + ")" + "(PIPE=" + this.m_pipeField.getText() + "))";
        return addressFactory.createAddress(string);
    }
}

