/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.servicewizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.servicewizard.GenericWizardPanel;
import oracle.net.asst.uniword.UniWordWrapper;
import oracle.net.common.netObject.ConnectData;
import oracle.net.common.netObject.NetService;

public class SIDWizardPanel
extends GenericWizardPanel
implements ItemListener {
    public static final String DEFAULT_SID = new String("ORCL");
    private LWTextField SIDField;
    private LWTextField serviceNameField;
    private LWCheckbox SIDBox;
    private LWCheckbox serviceNameBox;
    private LWCheckboxGroup radioGroup;
    private LWChoice connTypeChoice;
    private String defaultChoice;
    private String sharedChoice;
    private String dedicatedChoice;

    public SIDWizardPanel(NetStrings netStrings) {
        super(netStrings);
        MultiLineLabel multiLineLabel = new MultiLineLabel(UniWordWrapper.getTextWrapper(), netStrings.getString("SNWSidPanMsg"));
        multiLineLabel.setPreferredAspectRatio(6.0f);
        this.radioGroup = new LWCheckboxGroup();
        this.serviceNameBox = new LWCheckbox(netStrings.getString("SNWSidPan81Choice"), true, this.radioGroup);
        this.serviceNameBox.addItemListener((ItemListener)this);
        this.serviceNameField = new LWTextField();
        this.SIDBox = new LWCheckbox(netStrings.getString("SNWSidPan80Choice"), false, this.radioGroup);
        this.SIDBox.addItemListener((ItemListener)this);
        this.SIDField = new LWTextField(DEFAULT_SID);
        MultiLineLabel multiLineLabel2 = new MultiLineLabel(UniWordWrapper.getTextWrapper(), netStrings.getString("SNWSidPanCTypeMsg"));
        multiLineLabel2.setPreferredAspectRatio(8.0f);
        this.defaultChoice = netStrings.getString("SNWSidPanCType");
        this.sharedChoice = netStrings.getString("SNWSidPanCTypeS");
        this.dedicatedChoice = netStrings.getString("SNWSidPanCTypeD");
        this.connTypeChoice = new LWChoice();
        this.connTypeChoice.addItem(this.defaultChoice);
        this.connTypeChoice.addItem(this.sharedChoice);
        this.connTypeChoice.addItem(this.dedicatedChoice);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.m_contentPanel.setLayout(gridBagLayout);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        this.m_contentPanel.add((Component)multiLineLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.m_contentPanel.add((Component)this.serviceNameBox, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = 15;
        this.m_contentPanel.add((Component)this.serviceNameField, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.top = 10;
        this.m_contentPanel.add((Component)this.SIDBox, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = 15;
        this.m_contentPanel.add((Component)this.SIDField, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.left = 0;
        this.m_contentPanel.add((Component)multiLineLabel2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        this.m_contentPanel.add((Component)new LWLabel(netStrings.getString("SNWSidPanCTypeLbl")), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = 15;
        this.m_contentPanel.add((Component)this.connTypeChoice, gridBagConstraints);
        this.setImage("images/SID.gif");
        this.m_contentPanel.setBorderPainter((BorderPainter)new FixedBorderPainter(0, 5, 0, 10));
        this.updateBackCompatState(false);
    }

    public void setParams(NetService netService) {
        if (netService != null) {
            ConnectData connectData = netService.getFirstDescription().getConnectData();
            if (connectData.isBackCompat()) {
                this.SIDBox.setState(true);
                this.updateBackCompatState(true);
                this.SIDField.setText(connectData.getSID());
                return;
            }
            this.serviceNameBox.setState(true);
            this.updateBackCompatState(false);
            this.serviceNameField.setText(connectData.getSERVICE_NAME());
            return;
        }
        this.updateBackCompatState(false);
        this.SIDField.setText(DEFAULT_SID);
    }

    public boolean isBackCompat() {
        return this.SIDBox.getState();
    }

    public String getService() {
        if (this.SIDBox.getState()) {
            return this.SIDField.getText();
        }
        return this.serviceNameField.getText();
    }

    public String getSRVR() {
        String string = this.connTypeChoice.getSelectedItem();
        if (string.equals(this.sharedChoice)) {
            return "SHARED";
        }
        if (string.equals(this.dedicatedChoice)) {
            return "DEDICATED";
        }
        return null;
    }

    public Component getFocusComponent() {
        if (this.isBackCompat()) {
            return this.SIDField;
        }
        return this.serviceNameField;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.SIDBox) {
            this.updateBackCompatState(true);
            return;
        }
        this.updateBackCompatState(false);
    }

    private void updateBackCompatState(boolean bl) {
        if (bl) {
            this.SIDField.setEnabled(true);
            this.serviceNameField.setEnabled(false);
            return;
        }
        this.SIDField.setEnabled(false);
        this.serviceNameField.setEnabled(true);
    }
}

